/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import com.facebook.fbreact.specs.NativeDevSettingsSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="DevSettings")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/facebook/react/modules/debug/DevSettingsModule;", "Lcom/facebook/fbreact/specs/NativeDevSettingsSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "reload", "", "reloadWithReason", "reason", "", "onFastRefresh", "setHotLoadingEnabled", "isHotLoadingEnabled", "", "setIsDebuggingRemotely", "isDebugginRemotelyEnabled", "setProfilingEnabled", "isProfilingEnabled", "toggleElementInspector", "addMenuItem", "title", "openDebugger", "setIsShakeToShowDevMenuEnabled", "enabled", "addListener", "eventName", "removeListeners", "count", "", "ReactAndroid_release"})
public final class DevSettingsModule
extends NativeDevSettingsSpec {
    @NotNull
    private final DevSupportManager devSupportManager;

    public DevSettingsModule(@Nullable ReactApplicationContext reactContext, @NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        super(reactContext);
        this.devSupportManager = devSupportManager;
    }

    @Override
    public void reload() {
        if (this.devSupportManager.getDevSupportEnabled()) {
            UiThreadUtil.runOnUiThread(() -> DevSettingsModule.reload$lambda$0(this));
        }
    }

    @Override
    public void reloadWithReason(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.reload();
    }

    @Override
    public void onFastRefresh() {
    }

    @Override
    public void setHotLoadingEnabled(boolean isHotLoadingEnabled) {
        this.devSupportManager.setHotModuleReplacementEnabled(isHotLoadingEnabled);
    }

    @Override
    public void setIsDebuggingRemotely(boolean isDebugginRemotelyEnabled) {
        this.devSupportManager.setRemoteJSDebugEnabled(isDebugginRemotelyEnabled);
    }

    @Override
    public void setProfilingEnabled(boolean isProfilingEnabled) {
        this.devSupportManager.setFpsDebugEnabled(isProfilingEnabled);
    }

    @Override
    public void toggleElementInspector() {
        this.devSupportManager.toggleElementInspector();
    }

    @Override
    public void addMenuItem(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.devSupportManager.addCustomDevOption(title, () -> DevSettingsModule.addMenuItem$lambda$1(title, this));
    }

    @Override
    public void openDebugger() {
        this.devSupportManager.openDebugger();
    }

    @Override
    public void setIsShakeToShowDevMenuEnabled(boolean enabled) {
    }

    @Override
    public void addListener(@NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
    }

    @Override
    public void removeListeners(double count) {
    }

    private static final void reload$lambda$0(DevSettingsModule this$0) {
        this$0.devSupportManager.handleReloadJS();
    }

    private static final void addMenuItem$lambda$1(String $title, DevSettingsModule this$0) {
        block0: {
            ReactApplicationContext reactApplicationContext;
            WritableMap data = Arguments.createMap();
            data.putString("title", $title);
            ReactApplicationContext reactApplicationContext2 = reactApplicationContext = this$0.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext2 == null) break block0;
            reactApplicationContext2.emitDeviceEvent("didPressMenuItem", data);
        }
    }
}

