/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BlendModeHelper;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.FilterHelper;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.MatrixMathHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.TransformHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.PointerEventHelper;
import com.facebook.react.uimanager.style.OutlineStyle;
import com.facebook.react.uimanager.util.ReactFindViewUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class BaseViewManager<T extends View, C extends LayoutShadowNode>
extends ViewManager<T, C>
implements View.OnLayoutChangeListener {
    private static final int PERSPECTIVE_ARRAY_INVERTED_CAMERA_DISTANCE_INDEX = 2;
    private static final float CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER = (float)Math.sqrt(5.0);
    private static final MatrixMathHelper.MatrixDecompositionContext sMatrixDecompositionContext = new MatrixMathHelper.MatrixDecompositionContext();
    private static final double[] sTransformDecompositionArray = new double[16];
    private static final String STATE_CHECKED = "checked";
    private static final String STATE_BUSY = "busy";
    private static final String STATE_EXPANDED = "expanded";
    private static final String STATE_MIXED = "mixed";

    public BaseViewManager() {
        super(null);
    }

    public BaseViewManager(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @Nullable
    protected T prepareToRecycleView(@NonNull ThemedReactContext reactContext, T view) {
        view.setTag(null);
        view.setTag(R.id.pointer_events, null);
        view.setTag(R.id.react_test_id, null);
        view.setTag(R.id.view_tag_native_id, null);
        view.setTag(R.id.labelled_by, null);
        view.setTag(R.id.accessibility_label, null);
        view.setTag(R.id.accessibility_hint, null);
        view.setTag(R.id.accessibility_role, null);
        view.setTag(R.id.accessibility_state, null);
        view.setTag(R.id.accessibility_actions, null);
        view.setTag(R.id.accessibility_value, null);
        view.setTag(R.id.accessibility_state_expanded, null);
        view.setTag(R.id.view_clipped, null);
        this.setTransformProperty(view, null, null);
        if (Build.VERSION.SDK_INT < 28) {
            return null;
        }
        view.resetPivot();
        view.setTop(0);
        view.setBottom(0);
        view.setLeft(0);
        view.setRight(0);
        view.setElevation(0.0f);
        if (Build.VERSION.SDK_INT >= 29) {
            view.setAnimationMatrix(null);
        }
        view.setTag(R.id.transform, null);
        view.setTag(R.id.transform_origin, null);
        view.setTag(R.id.invalidate_transform, null);
        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        view.setTag(R.id.use_hardware_layer, null);
        view.setTag(R.id.filter, null);
        view.setTag(R.id.mix_blend_mode, null);
        LayerEffectsHelper.apply(view, null, null);
        if (Build.VERSION.SDK_INT >= 28) {
            view.setOutlineAmbientShadowColor(-16777216);
            view.setOutlineSpotShadowColor(-16777216);
        }
        view.setNextFocusDownId(-1);
        view.setNextFocusForwardId(-1);
        view.setNextFocusRightId(-1);
        view.setNextFocusUpId(-1);
        view.setFocusable(false);
        view.setFocusableInTouchMode(false);
        view.setElevation(0.0f);
        view.setAlpha(1.0f);
        this.setPadding(view, 0, 0, 0, 0);
        view.setForeground(null);
        return view;
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int oldWidth = oldRight - oldLeft;
        int oldHeight = oldBottom - oldTop;
        int currentWidth = right - left;
        int currentHeight = bottom - top;
        if (currentHeight != oldHeight || currentWidth != oldWidth) {
            ReadableArray transformOrigin = (ReadableArray)v.getTag(R.id.transform_origin);
            ReadableArray transforms = (ReadableArray)v.getTag(R.id.transform);
            if (transforms != null || transformOrigin != null) {
                this.setTransformProperty(v, transforms, transformOrigin);
            }
        }
    }

    @ReactProp(name="backgroundColor", defaultInt=0, customType="Color")
    public void setBackgroundColor(@NonNull T view, @ColorInt int backgroundColor) {
        BackgroundStyleApplicator.setBackgroundColor(view, backgroundColor);
    }

    @ReactProp(name="filter", customType="Filter")
    public void setFilter(@NonNull T view, @Nullable ReadableArray filter) {
        if (ViewUtil.getUIManagerType(view) == 2) {
            view.setTag(R.id.filter, (Object)filter);
        }
    }

    @ReactProp(name="mixBlendMode")
    public void setMixBlendMode(@NonNull T view, @Nullable String mixBlendMode) {
        if (ViewUtil.getUIManagerType(view) == 2) {
            view.setTag(R.id.mix_blend_mode, (Object)BlendModeHelper.parseMixBlendMode(mixBlendMode));
            if (view.getParent() instanceof View) {
                ((View)view.getParent()).invalidate();
            }
        }
    }

    @ReactProp(name="transform")
    public void setTransform(@NonNull T view, @Nullable ReadableArray matrix) {
        ReadableArray currentTransform = (ReadableArray)view.getTag(R.id.transform);
        if (!Objects.equals(currentTransform, matrix)) {
            view.setTag(R.id.transform, (Object)matrix);
            view.setTag(R.id.invalidate_transform, (Object)true);
        }
    }

    @ReactProp(name="transformOrigin")
    public void setTransformOrigin(@NonNull T view, @Nullable ReadableArray transformOrigin) {
        ReadableArray currentTransformOrigin = (ReadableArray)view.getTag(R.id.transform_origin);
        if (!Objects.equals(currentTransformOrigin, transformOrigin)) {
            view.setTag(R.id.transform_origin, (Object)transformOrigin);
            view.setTag(R.id.invalidate_transform, (Object)true);
        }
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(@NonNull T view, float opacity) {
        view.setAlpha(opacity);
    }

    @ReactProp(name="elevation")
    public void setElevation(@NonNull T view, float elevation) {
        ViewCompat.setElevation(view, (float)PixelUtil.toPixelFromDIP(elevation));
    }

    @ReactProp(name="shadowColor", defaultInt=-16777216, customType="Color")
    public void setShadowColor(@NonNull T view, int shadowColor) {
        if (Build.VERSION.SDK_INT >= 28) {
            view.setOutlineAmbientShadowColor(shadowColor);
            view.setOutlineSpotShadowColor(shadowColor);
        }
    }

    @ReactProp(name="zIndex")
    public void setZIndex(@NonNull T view, float zIndex) {
        int integerZIndex = Math.round(zIndex);
        ViewGroupManager.setViewZIndex(view, integerZIndex);
        ViewParent parent = view.getParent();
        if (parent instanceof ReactZIndexedViewGroup) {
            ((ReactZIndexedViewGroup)parent).updateDrawingOrder();
        }
    }

    @ReactProp(name="renderToHardwareTextureAndroid")
    public void setRenderToHardwareTexture(@NonNull T view, boolean useHWTexture) {
        view.setTag(R.id.use_hardware_layer, (Object)useHWTexture);
    }

    @ReactProp(name="testID")
    public void setTestId(@NonNull T view, @Nullable String testId) {
        view.setTag(R.id.react_test_id, (Object)testId);
        view.setTag((Object)testId);
    }

    @ReactProp(name="nativeID")
    public void setNativeId(@NonNull T view, @Nullable String nativeId) {
        view.setTag(R.id.view_tag_native_id, (Object)nativeId);
        ReactFindViewUtil.notifyViewRendered(view);
    }

    @ReactProp(name="accessibilityLabelledBy")
    public void setAccessibilityLabelledBy(@NonNull T view, @Nullable Dynamic nativeId) {
        if (nativeId.isNull()) {
            return;
        }
        if (nativeId.getType() == ReadableType.String) {
            view.setTag(R.id.labelled_by, (Object)nativeId.asString());
        } else if (nativeId.getType() == ReadableType.Array) {
            view.setTag(R.id.labelled_by, (Object)nativeId.asArray().getString(0));
        }
    }

    @ReactProp(name="accessibilityLabel")
    public void setAccessibilityLabel(@NonNull T view, @Nullable String accessibilityLabel) {
        view.setTag(R.id.accessibility_label, (Object)accessibilityLabel);
        this.updateViewContentDescription(view);
    }

    @ReactProp(name="accessibilityHint")
    public void setAccessibilityHint(@NonNull T view, @Nullable String accessibilityHint) {
        view.setTag(R.id.accessibility_hint, (Object)accessibilityHint);
        this.updateViewContentDescription(view);
    }

    @ReactProp(name="accessibilityRole")
    public void setAccessibilityRole(@NonNull T view, @Nullable String accessibilityRole) {
        if (accessibilityRole == null) {
            view.setTag(R.id.accessibility_role, null);
        } else {
            view.setTag(R.id.accessibility_role, (Object)ReactAccessibilityDelegate.AccessibilityRole.fromValue(accessibilityRole));
        }
    }

    @ReactProp(name="accessibilityCollection")
    public void setAccessibilityCollection(@NonNull T view, @Nullable ReadableMap accessibilityCollection) {
        view.setTag(R.id.accessibility_collection, (Object)accessibilityCollection);
    }

    @ReactProp(name="accessibilityCollectionItem")
    public void setAccessibilityCollectionItem(@NonNull T view, @Nullable ReadableMap accessibilityCollectionItem) {
        view.setTag(R.id.accessibility_collection_item, (Object)accessibilityCollectionItem);
    }

    @ReactProp(name="accessibilityState")
    public void setViewState(@NonNull T view, @Nullable ReadableMap accessibilityState) {
        if (accessibilityState == null) {
            return;
        }
        if (accessibilityState.hasKey(STATE_EXPANDED)) {
            view.setTag(R.id.accessibility_state_expanded, (Object)accessibilityState.getBoolean(STATE_EXPANDED));
        }
        if (accessibilityState.hasKey("selected")) {
            boolean prevSelected = view.isSelected();
            boolean nextSelected = accessibilityState.getBoolean("selected");
            view.setSelected(nextSelected);
            if (view.isAccessibilityFocused() && prevSelected && !nextSelected) {
                view.announceForAccessibility((CharSequence)view.getContext().getString(R.string.state_unselected_description));
            }
        } else {
            view.setSelected(false);
        }
        view.setTag(R.id.accessibility_state, (Object)accessibilityState);
        if (accessibilityState.hasKey("disabled") && !accessibilityState.getBoolean("disabled")) {
            view.setEnabled(true);
        }
        ReadableMapKeySetIterator i = accessibilityState.keySetIterator();
        while (i.hasNextKey()) {
            String state = i.nextKey();
            if (state.equals(STATE_BUSY) || state.equals(STATE_EXPANDED) || state.equals(STATE_CHECKED) && accessibilityState.getType(STATE_CHECKED) == ReadableType.String) {
                this.updateViewContentDescription(view);
                break;
            }
            if (!view.isAccessibilityFocused()) continue;
            view.sendAccessibilityEvent(1);
        }
    }

    private void updateViewContentDescription(@NonNull T view) {
        Dynamic text;
        String accessibilityLabel = (String)view.getTag(R.id.accessibility_label);
        ReadableMap accessibilityState = (ReadableMap)view.getTag(R.id.accessibility_state);
        ArrayList<String> contentDescription = new ArrayList<String>();
        ReadableMap accessibilityValue = (ReadableMap)view.getTag(R.id.accessibility_value);
        if (accessibilityLabel != null) {
            contentDescription.add(accessibilityLabel);
        }
        if (accessibilityState != null) {
            ReadableMapKeySetIterator i = accessibilityState.keySetIterator();
            while (i.hasNextKey()) {
                String state = i.nextKey();
                Dynamic value = accessibilityState.getDynamic(state);
                if (state.equals(STATE_CHECKED) && value.getType() == ReadableType.String && value.asString().equals(STATE_MIXED)) {
                    contentDescription.add(view.getContext().getString(R.string.state_mixed_description));
                    continue;
                }
                if (!state.equals(STATE_BUSY) || value.getType() != ReadableType.Boolean || !value.asBoolean()) continue;
                contentDescription.add(view.getContext().getString(R.string.state_busy_description));
            }
        }
        if (accessibilityValue != null && accessibilityValue.hasKey("text") && (text = accessibilityValue.getDynamic("text")) != null && text.getType() == ReadableType.String) {
            contentDescription.add(text.asString());
        }
        if (contentDescription.size() > 0) {
            view.setContentDescription((CharSequence)TextUtils.join((CharSequence)", ", contentDescription));
        }
    }

    @ReactProp(name="accessibilityActions")
    public void setAccessibilityActions(T view, ReadableArray accessibilityActions) {
        if (accessibilityActions == null) {
            return;
        }
        view.setTag(R.id.accessibility_actions, (Object)accessibilityActions);
    }

    @ReactProp(name="accessibilityValue")
    public void setAccessibilityValue(T view, ReadableMap accessibilityValue) {
        if (accessibilityValue == null) {
            view.setTag(R.id.accessibility_value, null);
            view.setContentDescription(null);
        } else {
            view.setTag(R.id.accessibility_value, (Object)accessibilityValue);
            if (accessibilityValue.hasKey("text")) {
                this.updateViewContentDescription(view);
            }
        }
    }

    @ReactProp(name="importantForAccessibility")
    public void setImportantForAccessibility(@NonNull T view, @Nullable String importantForAccessibility) {
        if (importantForAccessibility == null || importantForAccessibility.equals("auto")) {
            ViewCompat.setImportantForAccessibility(view, (int)0);
        } else if (importantForAccessibility.equals("yes")) {
            ViewCompat.setImportantForAccessibility(view, (int)1);
        } else if (importantForAccessibility.equals("no")) {
            ViewCompat.setImportantForAccessibility(view, (int)2);
        } else if (importantForAccessibility.equals("no-hide-descendants")) {
            ViewCompat.setImportantForAccessibility(view, (int)4);
        }
    }

    @ReactProp(name="role")
    public void setRole(@NonNull T view, @Nullable String role) {
        if (role == null) {
            view.setTag(R.id.role, null);
        } else {
            view.setTag(R.id.role, (Object)ReactAccessibilityDelegate.Role.fromValue(role));
        }
    }

    @Deprecated
    @ReactProp(name="rotation")
    public void setRotation(@NonNull T view, float rotation) {
        view.setRotation(rotation);
    }

    @Deprecated
    @ReactProp(name="scaleX", defaultFloat=1.0f)
    public void setScaleX(@NonNull T view, float scaleX) {
        view.setScaleX(scaleX);
    }

    @Deprecated
    @ReactProp(name="scaleY", defaultFloat=1.0f)
    public void setScaleY(@NonNull T view, float scaleY) {
        view.setScaleY(scaleY);
    }

    @Deprecated
    @ReactProp(name="translateX", defaultFloat=0.0f)
    public void setTranslateX(@NonNull T view, float translateX) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(translateX));
    }

    @Deprecated
    @ReactProp(name="translateY", defaultFloat=0.0f)
    public void setTranslateY(@NonNull T view, float translateY) {
        view.setTranslationY(PixelUtil.toPixelFromDIP(translateY));
    }

    @ReactProp(name="accessibilityLiveRegion")
    public void setAccessibilityLiveRegion(@NonNull T view, @Nullable String liveRegion) {
        if (liveRegion == null || liveRegion.equals("none")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)0);
        } else if (liveRegion.equals("polite")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)1);
        } else if (liveRegion.equals("assertive")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)2);
        }
    }

    protected void setTransformProperty(@NonNull T view, @Nullable ReadableArray transforms, @Nullable ReadableArray transformOrigin) {
        if (transforms == null) {
            view.setTranslationX(PixelUtil.toPixelFromDIP(0.0f));
            view.setTranslationY(PixelUtil.toPixelFromDIP(0.0f));
            view.setRotation(0.0f);
            view.setRotationX(0.0f);
            view.setRotationY(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
            view.setCameraDistance(0.0f);
            return;
        }
        boolean allowPercentageResolution = ViewUtil.getUIManagerType(view) == 2;
        sMatrixDecompositionContext.reset();
        TransformHelper.processTransform(transforms, sTransformDecompositionArray, PixelUtil.toDIPFromPixel(view.getWidth()), PixelUtil.toDIPFromPixel(view.getHeight()), transformOrigin, allowPercentageResolution);
        MatrixMathHelper.decomposeMatrix(sTransformDecompositionArray, sMatrixDecompositionContext);
        view.setTranslationX(PixelUtil.toPixelFromDIP(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.translation[0])));
        view.setTranslationY(PixelUtil.toPixelFromDIP(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.translation[1])));
        view.setRotation(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[2]));
        view.setRotationX(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[0]));
        view.setRotationY(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[1]));
        view.setScaleX(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.scale[0]));
        view.setScaleY(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.scale[1]));
        double[] perspectiveArray = BaseViewManager.sMatrixDecompositionContext.perspective;
        if (perspectiveArray.length > 2) {
            float invertedCameraDistance = (float)perspectiveArray[2];
            if (invertedCameraDistance == 0.0f) {
                invertedCameraDistance = 7.8125E-4f;
            }
            float cameraDistance = -1.0f / invertedCameraDistance;
            float scale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
            float normalizedCameraDistance = BaseViewManager.sanitizeFloatPropertyValue(scale * scale * cameraDistance * CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER);
            view.setCameraDistance(normalizedCameraDistance);
        }
    }

    private static float sanitizeFloatPropertyValue(float value) {
        if (value >= -3.4028235E38f && value <= Float.MAX_VALUE) {
            return value;
        }
        if (value < -3.4028235E38f || value == Float.NEGATIVE_INFINITY) {
            return -3.4028235E38f;
        }
        if (value > Float.MAX_VALUE || value == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        throw new IllegalStateException("Invalid float property value: " + value);
    }

    private void updateViewAccessibility(@NonNull T view) {
        ReactAccessibilityDelegate.setDelegate(view, view.isFocusable(), view.getImportantForAccessibility());
    }

    @Override
    protected void onAfterUpdateTransaction(@NonNull T view) {
        super.onAfterUpdateTransaction(view);
        this.updateViewAccessibility(view);
        Boolean invalidateTransform = (Boolean)view.getTag(R.id.invalidate_transform);
        if (invalidateTransform != null && invalidateTransform.booleanValue()) {
            view.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            ReadableArray transformOrigin = (ReadableArray)view.getTag(R.id.transform_origin);
            ReadableArray transforms = (ReadableArray)view.getTag(R.id.transform);
            this.setTransformProperty(view, transforms, transformOrigin);
            view.setTag(R.id.invalidate_transform, (Object)false);
        }
        ReadableArray filter = (ReadableArray)view.getTag(R.id.filter);
        Boolean useHWLayer = (Boolean)view.getTag(R.id.use_hardware_layer);
        LayerEffectsHelper.apply(view, filter, useHWLayer);
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        HashMap<String, Object> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Object> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Object>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.builder().put("topPointerCancel", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerCancel", "captured", "onPointerCancelCapture"))).put("topPointerDown", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerDown", "captured", "onPointerDownCapture"))).put("topPointerEnter", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerEnter", "captured", "onPointerEnterCapture", "skipBubbling", true))).put("topPointerLeave", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerLeave", "captured", "onPointerLeaveCapture", "skipBubbling", true))).put("topPointerMove", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerMove", "captured", "onPointerMoveCapture"))).put("topPointerUp", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerUp", "captured", "onPointerUpCapture"))).put("topPointerOut", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerOut", "captured", "onPointerOutCapture"))).put("topPointerOver", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onPointerOver", "captured", "onPointerOverCapture"))).put("topClick", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onClick", "captured", "onClickCapture"))).build());
        return eventTypeConstants;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        HashMap<String, Object> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Object> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Object>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.builder().put("topAccessibilityAction", MapBuilder.of("registrationName", "onAccessibilityAction")).build());
        return eventTypeConstants;
    }

    public void setBorderRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderRadius");
    }

    public void setBorderBottomLeftRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderBottomLeftRadius");
    }

    public void setBorderBottomRightRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderBottomRightRadius");
    }

    public void setBorderTopLeftRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderTopLeftRadius");
    }

    public void setBorderTopRightRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderTopRightRadius");
    }

    @ReactProp(name="outlineColor", customType="Color")
    public void setOutlineColor(T view, @Nullable Integer color) {
        BackgroundStyleApplicator.setOutlineColor(view, color);
    }

    @ReactProp(name="outlineOffset")
    public void setOutlineOffset(T view, float offset) {
        BackgroundStyleApplicator.setOutlineOffset(view, offset);
    }

    @ReactProp(name="outlineStyle")
    public void setOutlineStyle(T view, @Nullable String outlineStyle) {
        OutlineStyle parsedOutlineStyle = outlineStyle == null ? null : OutlineStyle.fromString(outlineStyle);
        BackgroundStyleApplicator.setOutlineStyle(view, parsedOutlineStyle);
    }

    @ReactProp(name="outlineWidth")
    public void setOutlineWidth(T view, float width) {
        BackgroundStyleApplicator.setOutlineWidth(view, width);
    }

    @ReactProp(name="boxShadow", customType="BoxShadow")
    public void setBoxShadow(T view, @Nullable ReadableArray shadows) {
        BackgroundStyleApplicator.setBoxShadow(view, shadows);
    }

    private void logUnsupportedPropertyWarning(String propName) {
        FLog.w((String)"ReactNative", (String)"%s doesn't support property '%s'", (Object[])new Object[]{this.getName(), propName});
    }

    private static void setPointerEventsFlag(@NonNull View view, PointerEventHelper.EVENT event, boolean isListening) {
        Integer tag = (Integer)view.getTag(R.id.pointer_events);
        int currentValue = tag != null ? tag : 0;
        int flag = 1 << event.ordinal();
        view.setTag(R.id.pointer_events, (Object)(isListening ? currentValue | flag : currentValue & ~flag));
    }

    @ReactProp(name="onPointerEnter")
    public void setPointerEnter(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.ENTER, value);
    }

    @ReactProp(name="onPointerEnterCapture")
    public void setPointerEnterCapture(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.ENTER_CAPTURE, value);
    }

    @ReactProp(name="onPointerOver")
    public void setPointerOver(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.OVER, value);
    }

    @ReactProp(name="onPointerOverCapture")
    public void setPointerOverCapture(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.OVER_CAPTURE, value);
    }

    @ReactProp(name="onPointerOut")
    public void setPointerOut(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.OUT, value);
    }

    @ReactProp(name="onPointerOutCapture")
    public void setPointerOutCapture(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.OUT_CAPTURE, value);
    }

    @ReactProp(name="onPointerLeave")
    public void setPointerLeave(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.LEAVE, value);
    }

    @ReactProp(name="onPointerLeaveCapture")
    public void setPointerLeaveCapture(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.LEAVE_CAPTURE, value);
    }

    @ReactProp(name="onPointerMove")
    public void setPointerMove(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.MOVE, value);
    }

    @ReactProp(name="onPointerMoveCapture")
    public void setPointerMoveCapture(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.MOVE_CAPTURE, value);
    }

    @ReactProp(name="onClick")
    public void setClick(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.CLICK, value);
    }

    @ReactProp(name="onClickCapture")
    public void setClickCapture(@NonNull T view, boolean value) {
        BaseViewManager.setPointerEventsFlag(view, PointerEventHelper.EVENT.CLICK_CAPTURE, value);
    }

    @ReactProp(name="onMoveShouldSetResponder")
    public void setMoveShouldSetResponder(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onMoveShouldSetResponderCapture")
    public void setMoveShouldSetResponderCapture(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onStartShouldSetResponder")
    public void setStartShouldSetResponder(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onStartShouldSetResponderCapture")
    public void setStartShouldSetResponderCapture(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderGrant")
    public void setResponderGrant(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderReject")
    public void setResponderReject(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderStart")
    public void setResponderStart(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderEnd")
    public void setResponderEnd(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderRelease")
    public void setResponderRelease(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderMove")
    public void setResponderMove(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderTerminate")
    public void setResponderTerminate(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onResponderTerminationRequest")
    public void setResponderTerminationRequest(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onShouldBlockNativeResponder")
    public void setShouldBlockNativeResponder(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onTouchStart")
    public void setTouchStart(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onTouchMove")
    public void setTouchMove(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onTouchEnd")
    public void setTouchEnd(@NonNull T view, boolean value) {
    }

    @ReactProp(name="onTouchCancel")
    public void setTouchCancel(@NonNull T view, boolean value) {
    }

    private static class LayerEffectsHelper {
        private LayerEffectsHelper() {
        }

        public static void apply(@NonNull View view, @Nullable ReadableArray filter, @Nullable Boolean useHWLayer) {
            if (Build.VERSION.SDK_INT >= 31) {
                view.setRenderEffect(null);
            }
            Paint p = null;
            if (filter != null) {
                if (FilterHelper.isOnlyColorMatrixFilters(filter)) {
                    p = new Paint();
                    p.setColorFilter((ColorFilter)FilterHelper.parseColorMatrixFilters(filter));
                } else if (Build.VERSION.SDK_INT >= 31) {
                    view.setRenderEffect(FilterHelper.parseFilters(filter));
                }
            }
            if (p == null) {
                int layerType = useHWLayer != null && useHWLayer != false ? 2 : 0;
                view.setLayerType(layerType, null);
            } else {
                view.setLayerType(2, p);
            }
        }
    }
}

