/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.deviceinfo;

import android.content.Context;
import android.content.res.Configuration;
import com.facebook.fbreact.specs.NativeDeviceInfoSpec;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="DeviceInfo")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/modules/deviceinfo/DeviceInfoModule;", "Lcom/facebook/fbreact/specs/NativeDeviceInfoSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "reactApplicationContext", "fontScale", "", "previousDisplayMetrics", "Lcom/facebook/react/bridge/ReadableMap;", "getTypedExportedConstants", "", "", "", "onHostResume", "", "onHostPause", "onHostDestroy", "emitUpdateDimensionsEvent", "invalidate", "ReactAndroid_debug"})
public final class DeviceInfoModule
extends NativeDeviceInfoSpec
implements LifecycleEventListener {
    @Nullable
    private ReactApplicationContext reactApplicationContext;
    private float fontScale;
    @Nullable
    private ReadableMap previousDisplayMetrics;

    public DeviceInfoModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.fontScale = reactContext.getResources().getConfiguration().fontScale;
        reactContext.addLifecycleEventListener(this);
        this.reactApplicationContext = reactContext;
    }

    public DeviceInfoModule(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(null);
        this.reactApplicationContext = null;
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(context);
        this.fontScale = context.getResources().getConfiguration().fontScale;
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        WritableMap displayMetrics = DisplayMetricsHolder.getDisplayMetricsWritableMap(this.fontScale);
        this.previousDisplayMetrics = displayMetrics.copy();
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Dimensions", displayMetrics.toHashMap()));
    }

    @Override
    public void onHostResume() {
        Float newFontScale;
        ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
        Float f = reactApplicationContext != null && (reactApplicationContext = reactApplicationContext.getResources()) != null && (reactApplicationContext = reactApplicationContext.getConfiguration()) != null ? Float.valueOf(((Configuration)reactApplicationContext).fontScale) : (newFontScale = null);
        if (newFontScale != null && !Intrinsics.areEqual((Float)newFontScale, (float)this.fontScale)) {
            this.fontScale = newFontScale.floatValue();
            this.emitUpdateDimensionsEvent();
        }
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
    }

    public final void emitUpdateDimensionsEvent() {
        block0: {
            block1: {
                WritableMap displayMetrics;
                ReactApplicationContext context;
                block2: {
                    ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
                    if (reactApplicationContext == null) break block0;
                    context = reactApplicationContext;
                    boolean bl = false;
                    if (!context.hasActiveReactInstance()) break block1;
                    displayMetrics = DisplayMetricsHolder.getDisplayMetricsWritableMap(this.fontScale);
                    if (this.previousDisplayMetrics != null) break block2;
                    this.previousDisplayMetrics = displayMetrics.copy();
                    break block0;
                }
                if (Intrinsics.areEqual((Object)displayMetrics, (Object)this.previousDisplayMetrics)) break block0;
                this.previousDisplayMetrics = displayMetrics.copy();
                context.emitDeviceEvent("didUpdateDimensions", displayMetrics);
                break block0;
            }
            ReactSoftExceptionLogger.logSoftException("DeviceInfo", new ReactNoCrashSoftException("No active CatalystInstance, cannot emitUpdateDimensionsEvent"));
        }
    }

    @Override
    public void invalidate() {
        block0: {
            super.invalidate();
            ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
            if (reactApplicationContext == null) break block0;
            reactApplicationContext.removeLifecycleEventListener(this);
        }
    }
}

