/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.annotation.TargetApi;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.RenderEffect;
import android.graphics.Shader;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J2\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eJ\u001a\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010!\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010#\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010%\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010'\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001a\u0010)\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001c\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00132\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0015\u0010-\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b.\u00a8\u0006/"}, d2={"Lcom/facebook/react/uimanager/FilterHelper;", "", "<init>", "()V", "parseFilters", "Landroid/graphics/RenderEffect;", "filters", "Lcom/facebook/react/bridge/ReadableArray;", "parseColorMatrixFilters", "Landroid/graphics/ColorMatrixColorFilter;", "isOnlyColorMatrixFilters", "", "createBlurEffect", "sigma", "", "chainedEffects", "createBrightnessEffect", "amount", "createBrightnessColorMatrix", "Landroid/graphics/ColorMatrix;", "createOpacityEffect", "createDropShadowEffect", "offsetX", "offsetY", "blurRadius", "color", "", "parseAndCreateDropShadowEffect", "filterValues", "Lcom/facebook/react/bridge/ReadableMap;", "createOpacityColorMatrix", "createContrastEffect", "createContrastColorMatrix", "createGrayscaleEffect", "createGrayscaleColorMatrix", "createSepiaEffect", "createSepiaColorMatrix", "createSaturateEffect", "createSaturateColorMatrix", "createHueRotateEffect", "createHueRotateColorMatrix", "createInvertEffect", "createInvertColorMatrix", "createColorMatrixEffect", "colorMatrix", "sigmaToRadius", "sigmaToRadius$ReactAndroid_release", "ReactAndroid_release"})
@TargetApi(value=31)
public final class FilterHelper {
    @NotNull
    public static final FilterHelper INSTANCE = new FilterHelper();

    private FilterHelper() {
    }

    @JvmStatic
    @Nullable
    public static final RenderEffect parseFilters(@Nullable ReadableArray filters) {
        if (filters == null) {
            return null;
        }
        RenderEffect chainedEffects = null;
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            String filterName;
            ReadableMap readableMap = filters.getMap(i);
            if (readableMap == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Map.Entry<String, Object> filter = readableMap.getEntryIterator().next();
            chainedEffects = switch (filterName = filter.getKey()) {
                case "brightness" -> {
                    Object v1 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createBrightnessEffect((float)((Double)v1).doubleValue(), chainedEffects);
                }
                case "contrast" -> {
                    Object v3 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createContrastEffect((float)((Double)v3).doubleValue(), chainedEffects);
                }
                case "grayscale" -> {
                    Object v4 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createGrayscaleEffect((float)((Double)v4).doubleValue(), chainedEffects);
                }
                case "sepia" -> {
                    Object v5 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createSepiaEffect((float)((Double)v5).doubleValue(), chainedEffects);
                }
                case "saturate" -> {
                    Object v6 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createSaturateEffect((float)((Double)v6).doubleValue(), chainedEffects);
                }
                case "hueRotate" -> {
                    Object v7 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createHueRotateEffect((float)((Double)v7).doubleValue(), chainedEffects);
                }
                case "invert" -> {
                    Object v8 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createInvertEffect((float)((Double)v8).doubleValue(), chainedEffects);
                }
                case "blur" -> {
                    Object v9 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createBlurEffect((float)((Double)v9).doubleValue(), chainedEffects);
                }
                case "opacity" -> {
                    Object v10 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v10, (String)"null cannot be cast to non-null type kotlin.Double");
                    yield INSTANCE.createOpacityEffect((float)((Double)v10).doubleValue(), chainedEffects);
                }
                case "dropShadow" -> {
                    Object v11 = filter.getValue();
                    Intrinsics.checkNotNull((Object)v11, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReadableMap");
                    yield INSTANCE.parseAndCreateDropShadowEffect((ReadableMap)v11, chainedEffects);
                }
                default -> throw new IllegalArgumentException("Invalid filter name: " + filterName);
            };
        }
        return chainedEffects;
    }

    @JvmStatic
    @Nullable
    public static final ColorMatrixColorFilter parseColorMatrixFilters(@Nullable ReadableArray filters) {
        if (filters == null) {
            return null;
        }
        ColorMatrix resultColorMatrix = new ColorMatrix();
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            ReadableMap readableMap = filters.getMap(i);
            if (readableMap == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Map.Entry<String, Object> filter = readableMap.getEntryIterator().next();
            String filterName = filter.getKey();
            Object object = filter.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            float amount = (float)((Double)object).doubleValue();
            ColorMatrix tempColorMatrix = switch (filterName) {
                case "brightness" -> INSTANCE.createBrightnessColorMatrix(amount);
                case "contrast" -> INSTANCE.createContrastColorMatrix(amount);
                case "grayscale" -> INSTANCE.createGrayscaleColorMatrix(amount);
                case "sepia" -> INSTANCE.createSepiaColorMatrix(amount);
                case "saturate" -> INSTANCE.createSaturateColorMatrix(amount);
                case "hueRotate" -> INSTANCE.createHueRotateColorMatrix(amount);
                case "invert" -> INSTANCE.createInvertColorMatrix(amount);
                case "opacity" -> INSTANCE.createOpacityColorMatrix(amount);
                default -> throw new IllegalArgumentException("Invalid color matrix filter: " + filterName);
            };
            resultColorMatrix.preConcat(tempColorMatrix);
        }
        return new ColorMatrixColorFilter(resultColorMatrix);
    }

    @JvmStatic
    public static final boolean isOnlyColorMatrixFilters(@Nullable ReadableArray filters) {
        if (filters == null || filters.size() == 0) {
            return false;
        }
        int n = filters.size();
        for (int i = 0; i < n; ++i) {
            ReadableMap readableMap = filters.getMap(i);
            Intrinsics.checkNotNull((Object)readableMap);
            Map.Entry<String, Object> filter = readableMap.getEntryIterator().next();
            String filterName = filter.getKey();
            if (!Intrinsics.areEqual((Object)filterName, (Object)"blur") && !Intrinsics.areEqual((Object)filterName, (Object)"dropShadow")) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final RenderEffect createBlurEffect(float sigma, @Nullable RenderEffect chainedEffects) {
        if ((double)sigma <= 0.5) {
            return null;
        }
        float radius = this.sigmaToRadius$ReactAndroid_release(sigma);
        return chainedEffects == null ? RenderEffect.createBlurEffect((float)radius, (float)radius, (Shader.TileMode)Shader.TileMode.DECAL) : RenderEffect.createBlurEffect((float)radius, (float)radius, (RenderEffect)chainedEffects, (Shader.TileMode)Shader.TileMode.DECAL);
    }

    public static /* synthetic */ RenderEffect createBlurEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createBlurEffect(f, renderEffect);
    }

    @NotNull
    public final RenderEffect createBrightnessEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createBrightnessColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createBrightnessEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createBrightnessEffect(f, renderEffect);
    }

    private final ColorMatrix createBrightnessColorMatrix(float amount) {
        ColorMatrix matrix = new ColorMatrix();
        matrix.setScale(amount, amount, amount, 1.0f);
        return matrix;
    }

    @NotNull
    public final RenderEffect createOpacityEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createOpacityColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createOpacityEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createOpacityEffect(f, renderEffect);
    }

    @NotNull
    public final RenderEffect createDropShadowEffect(float offsetX, float offsetY, float blurRadius, int color, @Nullable RenderEffect chainedEffects) {
        RenderEffect identity = null;
        RenderEffect offsetEffect = null;
        if (chainedEffects == null) {
            identity = RenderEffect.createOffsetEffect((float)0.0f, (float)0.0f);
            offsetEffect = RenderEffect.createOffsetEffect((float)offsetX, (float)offsetY);
        } else {
            identity = RenderEffect.createOffsetEffect((float)0.0f, (float)0.0f, (RenderEffect)chainedEffects);
            offsetEffect = RenderEffect.createOffsetEffect((float)offsetX, (float)offsetY, (RenderEffect)chainedEffects);
        }
        RenderEffect renderEffect = RenderEffect.createColorFilterEffect((ColorFilter)((ColorFilter)new BlendModeColorFilter(color, BlendMode.SRC_IN)), (RenderEffect)offsetEffect);
        Intrinsics.checkNotNullExpressionValue((Object)renderEffect, (String)"createColorFilterEffect(...)");
        RenderEffect colorEffect = renderEffect;
        RenderEffect renderEffect2 = RenderEffect.createBlurEffect((float)blurRadius, (float)blurRadius, (RenderEffect)colorEffect, (Shader.TileMode)Shader.TileMode.DECAL);
        Intrinsics.checkNotNullExpressionValue((Object)renderEffect2, (String)"createBlurEffect(...)");
        RenderEffect blurEffect = renderEffect2;
        RenderEffect renderEffect3 = RenderEffect.createBlendModeEffect((RenderEffect)blurEffect, (RenderEffect)identity, (BlendMode)BlendMode.SRC_OVER);
        Intrinsics.checkNotNullExpressionValue((Object)renderEffect3, (String)"createBlendModeEffect(...)");
        return renderEffect3;
    }

    public static /* synthetic */ RenderEffect createDropShadowEffect$default(FilterHelper filterHelper, float f, float f2, float f3, int n, RenderEffect renderEffect, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            renderEffect = null;
        }
        return filterHelper.createDropShadowEffect(f, f2, f3, n, renderEffect);
    }

    @NotNull
    public final RenderEffect parseAndCreateDropShadowEffect(@NotNull ReadableMap filterValues, @Nullable RenderEffect chainedEffects) {
        Intrinsics.checkNotNullParameter((Object)filterValues, (String)"filterValues");
        float offsetX = PixelUtil.INSTANCE.dpToPx(filterValues.getDouble("offsetX"));
        float offsetY = PixelUtil.INSTANCE.dpToPx(filterValues.getDouble("offsetY"));
        int color = filterValues.hasKey("color") ? filterValues.getInt("color") : -16777216;
        float radius = filterValues.hasKey("standardDeviation") ? this.sigmaToRadius$ReactAndroid_release((float)filterValues.getDouble("standardDeviation")) : 0.0f;
        return this.createDropShadowEffect(offsetX, offsetY, radius, color, chainedEffects);
    }

    public static /* synthetic */ RenderEffect parseAndCreateDropShadowEffect$default(FilterHelper filterHelper, ReadableMap readableMap, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.parseAndCreateDropShadowEffect(readableMap, renderEffect);
    }

    @NotNull
    public final ColorMatrix createOpacityColorMatrix(float amount) {
        ColorMatrix matrix = new ColorMatrix();
        matrix.setScale(1.0f, 1.0f, 1.0f, amount);
        return matrix;
    }

    @NotNull
    public final RenderEffect createContrastEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createContrastColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createContrastEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createContrastEffect(f, renderEffect);
    }

    private final ColorMatrix createContrastColorMatrix(float amount) {
        float intercept = (float)255 * (-(amount / 2.0f) + 0.5f);
        float[] fArray = new float[]{amount, 0.0f, 0.0f, 0.0f, intercept, 0.0f, amount, 0.0f, 0.0f, intercept, 0.0f, 0.0f, amount, 0.0f, intercept, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createGrayscaleEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createGrayscaleColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createGrayscaleEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createGrayscaleEffect(f, renderEffect);
    }

    private final ColorMatrix createGrayscaleColorMatrix(float amount) {
        float inverseAmount = 1.0f - amount;
        float[] fArray = new float[]{0.2126f + 0.7874f * inverseAmount, 0.7152f - 0.7152f * inverseAmount, 0.0722f - 0.0722f * inverseAmount, 0.0f, 0.0f, 0.2126f - 0.2126f * inverseAmount, 0.7152f + 0.2848f * inverseAmount, 0.0722f - 0.0722f * inverseAmount, 0.0f, 0.0f, 0.2126f - 0.2126f * inverseAmount, 0.7152f - 0.7152f * inverseAmount, 0.0722f + 0.9278f * inverseAmount, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createSepiaEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createSepiaColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createSepiaEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createSepiaEffect(f, renderEffect);
    }

    private final ColorMatrix createSepiaColorMatrix(float amount) {
        float inverseAmount = 1.0f - amount;
        float[] fArray = new float[]{0.393f + 0.607f * inverseAmount, 0.769f - 0.769f * inverseAmount, 0.189f - 0.189f * inverseAmount, 0.0f, 0.0f, 0.349f - 0.349f * inverseAmount, 0.686f + 0.314f * inverseAmount, 0.168f - 0.168f * inverseAmount, 0.0f, 0.0f, 0.272f - 0.272f * inverseAmount, 0.534f - 0.534f * inverseAmount, 0.131f + 0.869f * inverseAmount, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createSaturateEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createSaturateColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createSaturateEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createSaturateEffect(f, renderEffect);
    }

    private final ColorMatrix createSaturateColorMatrix(float amount) {
        ColorMatrix matrix = new ColorMatrix();
        matrix.setSaturation(amount);
        return matrix;
    }

    @NotNull
    public final RenderEffect createHueRotateEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createHueRotateColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createHueRotateEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createHueRotateEffect(f, renderEffect);
    }

    private final ColorMatrix createHueRotateColorMatrix(float amount) {
        double amountRads = Math.toRadians(amount);
        float cos = (float)Math.cos(amountRads);
        float sin = (float)Math.sin(amountRads);
        float[] fArray = new float[]{0.213f + 0.787f * cos - 0.213f * sin, 0.715f - 0.715f * cos - 0.715f * sin, 0.072f - 0.072f * cos + 0.928f * sin, 0.0f, 0.0f, 0.213f - 0.213f * cos + 0.143f * sin, 0.715f + 0.285f * cos + 0.14f * sin, 0.072f - 0.072f * cos - 0.283f * sin, 0.0f, 0.0f, 0.213f - 0.213f * cos - 0.787f * sin, 0.715f - 0.715f * cos + 0.715f * sin, 0.072f + 0.928f * cos + 0.072f * sin, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    @NotNull
    public final RenderEffect createInvertEffect(float amount, @Nullable RenderEffect chainedEffects) {
        return this.createColorMatrixEffect(this.createInvertColorMatrix(amount), chainedEffects);
    }

    public static /* synthetic */ RenderEffect createInvertEffect$default(FilterHelper filterHelper, float f, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createInvertEffect(f, renderEffect);
    }

    private final ColorMatrix createInvertColorMatrix(float amount) {
        float slope = 1.0f - (float)2 * amount;
        float intercept = amount * (float)255;
        float[] fArray = new float[]{slope, 0.0f, 0.0f, 0.0f, intercept, 0.0f, slope, 0.0f, 0.0f, intercept, 0.0f, 0.0f, slope, 0.0f, intercept, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        return new ColorMatrix(fArray);
    }

    private final RenderEffect createColorMatrixEffect(ColorMatrix colorMatrix, RenderEffect chainedEffects) {
        RenderEffect renderEffect;
        if (chainedEffects == null) {
            RenderEffect renderEffect2 = RenderEffect.createColorFilterEffect((ColorFilter)((ColorFilter)new ColorMatrixColorFilter(colorMatrix)));
            Intrinsics.checkNotNull((Object)renderEffect2);
            renderEffect = renderEffect2;
        } else {
            RenderEffect renderEffect3 = RenderEffect.createColorFilterEffect((ColorFilter)((ColorFilter)new ColorMatrixColorFilter(colorMatrix)), (RenderEffect)chainedEffects);
            Intrinsics.checkNotNull((Object)renderEffect3);
            renderEffect = renderEffect3;
        }
        return renderEffect;
    }

    static /* synthetic */ RenderEffect createColorMatrixEffect$default(FilterHelper filterHelper, ColorMatrix colorMatrix, RenderEffect renderEffect, int n, Object object) {
        if ((n & 2) != 0) {
            renderEffect = null;
        }
        return filterHelper.createColorMatrixEffect(colorMatrix, renderEffect);
    }

    public final float sigmaToRadius$ReactAndroid_release(float sigma) {
        float sigmaToRadiusRatio = 0.57735f;
        float pxSigma = PixelUtil.toPixelFromDIP(sigma);
        return pxSigma > 0.5f ? (pxSigma - 0.5f) / sigmaToRadiusRatio : 0.0f;
    }
}

