/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import com.facebook.react.uimanager.style.OutlineStyle;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007H\u0016J\u0012\u0010.\u001a\u00020,2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\b\u00101\u001a\u00020\u0007H\u0017J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020,H\u0002J\u001a\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010;\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010<\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "outlineColor", "", "outlineOffset", "", "outlineStyle", "Lcom/facebook/react/uimanager/style/OutlineStyle;", "outlineWidth", "<init>", "(Landroid/content/Context;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;IFLcom/facebook/react/uimanager/style/OutlineStyle;F)V", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "gapBetweenPaths", "value", "getOutlineOffset", "()F", "setOutlineOffset", "(F)V", "getOutlineStyle", "()Lcom/facebook/react/uimanager/style/OutlineStyle;", "setOutlineStyle", "(Lcom/facebook/react/uimanager/style/OutlineStyle;)V", "getOutlineColor", "()I", "setOutlineColor", "(I)V", "getOutlineWidth", "setOutlineWidth", "outlinePaint", "Landroid/graphics/Paint;", "computedBorderRadius", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "tempRectForOutline", "Landroid/graphics/RectF;", "pathForOutline", "Landroid/graphics/Path;", "setAlpha", "", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "updateOutlineRect", "getPathEffect", "Landroid/graphics/PathEffect;", "style", "calculateRadius", "radius", "drawRectangularOutline", "drawRoundedOutline", "ReactAndroid_release"})
public final class OutlineDrawable
extends Drawable {
    @NotNull
    private final Context context;
    @Nullable
    private BorderRadiusStyle borderRadius;
    private final float gapBetweenPaths;
    private float outlineOffset;
    @NotNull
    private OutlineStyle outlineStyle;
    private int outlineColor;
    private float outlineWidth;
    @NotNull
    private final Paint outlinePaint;
    @Nullable
    private ComputedBorderRadius computedBorderRadius;
    @NotNull
    private RectF tempRectForOutline;
    @NotNull
    private final Path pathForOutline;

    /*
     * WARNING - void declaration
     */
    public OutlineDrawable(@NotNull Context context, @Nullable BorderRadiusStyle borderRadius, int outlineColor, float outlineOffset, @NotNull OutlineStyle outlineStyle, float outlineWidth) {
        void $this$outlinePaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)outlineStyle), (String)"outlineStyle");
        this.context = context;
        this.borderRadius = borderRadius;
        this.gapBetweenPaths = 0.8f;
        this.outlineOffset = outlineOffset;
        this.outlineStyle = outlineStyle;
        this.outlineColor = outlineColor;
        this.outlineWidth = outlineWidth;
        Paint paint2 = paint = new Paint();
        OutlineDrawable outlineDrawable = this;
        boolean bl = false;
        $this$outlinePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$outlinePaint_u24lambda_u240.setColor(outlineColor);
        $this$outlinePaint_u24lambda_u240.setStrokeWidth(outlineWidth);
        $this$outlinePaint_u24lambda_u240.setPathEffect(this.getPathEffect(outlineStyle, outlineWidth));
        outlineDrawable.outlinePaint = paint;
        this.tempRectForOutline = new RectF();
        this.pathForOutline = new Path();
    }

    public /* synthetic */ OutlineDrawable(Context context, BorderRadiusStyle borderRadiusStyle, int n, float f, OutlineStyle outlineStyle, float f2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            borderRadiusStyle = null;
        }
        this(context, borderRadiusStyle, n, f, outlineStyle, f2);
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    public final float getOutlineOffset() {
        return this.outlineOffset;
    }

    public final void setOutlineOffset(float value) {
        if (!(value == this.outlineOffset)) {
            this.outlineOffset = value;
            this.invalidateSelf();
        }
    }

    @NotNull
    public final OutlineStyle getOutlineStyle() {
        return this.outlineStyle;
    }

    public final void setOutlineStyle(@NotNull OutlineStyle value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (value != this.outlineStyle) {
            this.outlineStyle = value;
            this.outlinePaint.setPathEffect(this.getPathEffect(value, this.outlineWidth));
            this.invalidateSelf();
        }
    }

    public final int getOutlineColor() {
        return this.outlineColor;
    }

    public final void setOutlineColor(int value) {
        if (value != this.outlineColor) {
            this.outlineColor = value;
            this.outlinePaint.setColor(value);
            this.invalidateSelf();
        }
    }

    public final float getOutlineWidth() {
        return this.outlineWidth;
    }

    public final void setOutlineWidth(float value) {
        if (!(value == this.outlineWidth)) {
            this.outlineWidth = value;
            this.outlinePaint.setStrokeWidth(value);
            this.outlinePaint.setPathEffect(this.getPathEffect(this.outlineStyle, value));
            this.invalidateSelf();
        }
    }

    public void setAlpha(int alpha) {
        this.outlinePaint.setAlpha(MathKt.roundToInt((float)((float)alpha / 255.0f * ((float)Color.alpha((int)this.outlineColor) / 255.0f) * 255.0f)));
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.outlinePaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int alpha = this.outlinePaint.getAlpha();
        int n = alpha;
        return n == 255 ? -1 : ((1 <= n ? n < 255 : false) ? -3 : -2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.outlineWidth == 0.0f) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        this.pathForOutline.reset();
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        this.computedBorderRadius = borderRadiusStyle != null ? borderRadiusStyle.resolve(this.getLayoutDirection(), this.context, PixelUtil.INSTANCE.pxToDp(this.getBounds().width()), PixelUtil.INSTANCE.pxToDp(this.getBounds().height())) : null;
        this.updateOutlineRect();
        if (this.computedBorderRadius != null) {
            ComputedBorderRadius computedBorderRadius = this.computedBorderRadius;
            boolean bl2 = computedBorderRadius != null ? computedBorderRadius.hasRoundedBorders() : false;
            if (bl2) {
                this.drawRoundedOutline(canvas);
                return;
            }
        }
        this.drawRectangularOutline(canvas);
    }

    private final void updateOutlineRect() {
        this.tempRectForOutline.set(this.getBounds());
        RectF rectF = this.tempRectForOutline;
        rectF.top -= this.outlineWidth * 0.5f + this.outlineOffset - this.gapBetweenPaths;
        rectF = this.tempRectForOutline;
        rectF.bottom += this.outlineWidth * 0.5f + this.outlineOffset - this.gapBetweenPaths;
        rectF = this.tempRectForOutline;
        rectF.left -= this.outlineWidth * 0.5f + this.outlineOffset - this.gapBetweenPaths;
        rectF = this.tempRectForOutline;
        rectF.right += this.outlineWidth * 0.5f + this.outlineOffset - this.gapBetweenPaths;
    }

    private final PathEffect getPathEffect(OutlineStyle style2, float outlineWidth) {
        return switch (WhenMappings.$EnumSwitchMapping$0[style2.ordinal()]) {
            case 1 -> null;
            case 2 -> {
                float[] var3_3 = new float[]{outlineWidth * (float)3, outlineWidth * (float)3, outlineWidth * (float)3, outlineWidth * (float)3};
                yield (PathEffect)new DashPathEffect(var3_3, 0.0f);
            }
            case 3 -> {
                float[] var3_4 = new float[]{outlineWidth, outlineWidth, outlineWidth, outlineWidth};
                yield (PathEffect)new DashPathEffect(var3_4, 0.0f);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final float calculateRadius(float radius, float outlineWidth) {
        return !(radius == 0.0f) ? radius + outlineWidth * 0.5f : 0.0f;
    }

    private final void drawRectangularOutline(Canvas canvas) {
        this.pathForOutline.addRect(this.tempRectForOutline, Path.Direction.CW);
        canvas.drawPath(this.pathForOutline, this.outlinePaint);
    }

    private final void drawRoundedOutline(Canvas canvas) {
        Object object;
        Object bottomLeftRadius;
        Object object2;
        Object topRightRadius;
        Object object3;
        Object topLeftRadius;
        Object object4 = this.computedBorderRadius;
        if (object4 == null || (object4 = ((ComputedBorderRadius)object4).getTopLeft()) == null || (object4 = ((CornerRadii)object4).toPixelFromDIP()) == null) {
            object4 = topLeftRadius = new CornerRadii(0.0f, 0.0f);
        }
        if ((object3 = this.computedBorderRadius) == null || (object3 = ((ComputedBorderRadius)object3).getTopRight()) == null || (object3 = ((CornerRadii)object3).toPixelFromDIP()) == null) {
            object3 = topRightRadius = new CornerRadii(0.0f, 0.0f);
        }
        if ((object2 = this.computedBorderRadius) == null || (object2 = ((ComputedBorderRadius)object2).getBottomLeft()) == null || (object2 = ((CornerRadii)object2).toPixelFromDIP()) == null) {
            object2 = bottomLeftRadius = new CornerRadii(0.0f, 0.0f);
        }
        if ((object = this.computedBorderRadius) == null || (object = ((ComputedBorderRadius)object).getBottomRight()) == null || (object = ((CornerRadii)object).toPixelFromDIP()) == null) {
            object = new CornerRadii(0.0f, 0.0f);
        }
        Object bottomRightRadius = object;
        float[] fArray = new float[]{this.calculateRadius(((CornerRadii)topLeftRadius).getHorizontal(), this.outlineWidth), this.calculateRadius(((CornerRadii)topLeftRadius).getVertical(), this.outlineWidth), this.calculateRadius(((CornerRadii)topRightRadius).getHorizontal(), this.outlineWidth), this.calculateRadius(((CornerRadii)topRightRadius).getVertical(), this.outlineWidth), this.calculateRadius(((CornerRadii)bottomRightRadius).getHorizontal(), this.outlineWidth), this.calculateRadius(((CornerRadii)bottomRightRadius).getVertical(), this.outlineWidth), this.calculateRadius(((CornerRadii)bottomLeftRadius).getHorizontal(), this.outlineWidth), this.calculateRadius(((CornerRadii)bottomLeftRadius).getVertical(), this.outlineWidth)};
        this.pathForOutline.addRoundRect(this.tempRectForOutline, fArray, Path.Direction.CW);
        canvas.drawPath(this.pathForOutline, this.outlinePaint);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutlineStyle.values().length];
            try {
                nArray[OutlineStyle.SOLID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutlineStyle.DASHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutlineStyle.DOTTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

