/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.request.Postprocessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/views/image/MultiPostprocessor;", "Lcom/facebook/imagepipeline/request/Postprocessor;", "postprocessors", "", "<init>", "(Ljava/util/List;)V", "getName", "", "getPostprocessorCacheKey", "Lcom/facebook/cache/common/CacheKey;", "process", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "sourceBitmap", "bitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nMultiPostprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPostprocessor.kt\ncom/facebook/react/views/image/MultiPostprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1557#2:63\n1628#2,3:64\n*S KotlinDebug\n*F\n+ 1 MultiPostprocessor.kt\ncom/facebook/react/views/image/MultiPostprocessor\n*L\n26#1:63\n26#1:64,3\n*E\n"})
public final class MultiPostprocessor
implements Postprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Postprocessor> postprocessors;

    private MultiPostprocessor(List<? extends Postprocessor> postprocessors) {
        this.postprocessors = new LinkedList(postprocessors);
    }

    @NotNull
    public String getName() {
        return "MultiPostProcessor (" + CollectionsKt.joinToString$default((Iterable)this.postprocessors, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CacheKey getPostprocessorCacheKey() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.postprocessors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Postprocessor postprocessor = (Postprocessor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPostprocessorCacheKey());
        }
        List list = (List)destination$iv$iv;
        return (CacheKey)new MultiCacheKey(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CloseableReference<Bitmap> process(@NotNull Bitmap sourceBitmap, @NotNull PlatformBitmapFactory bitmapFactory) {
        Intrinsics.checkNotNullParameter((Object)sourceBitmap, (String)"sourceBitmap");
        Intrinsics.checkNotNullParameter((Object)bitmapFactory, (String)"bitmapFactory");
        Bitmap prevBitmap = null;
        CloseableReference nextBitmap = null;
        try {
            for (Postprocessor p : this.postprocessors) {
                Bitmap bitmap = prevBitmap;
                if (bitmap == null || (bitmap = (Bitmap)bitmap.get()) == null) {
                    bitmap = sourceBitmap;
                }
                nextBitmap = p.process(bitmap, bitmapFactory);
                CloseableReference.closeSafely((CloseableReference)prevBitmap);
                prevBitmap = nextBitmap.clone();
            }
            if (nextBitmap == null) {
                boolean bl = false;
                String string2 = "MultiPostprocessor returned null bitmap - Number of Postprocessors: " + this.postprocessors.size();
                throw new IllegalStateException(string2.toString());
            }
            CloseableReference closeableReference = nextBitmap.clone();
            Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"clone(...)");
            CloseableReference closeableReference2 = closeableReference;
            return closeableReference2;
        }
        finally {
            CloseableReference.closeSafely(nextBitmap);
        }
    }

    @JvmStatic
    @Nullable
    public static final Postprocessor from(@NotNull List<? extends Postprocessor> postprocessors) {
        return Companion.from(postprocessors);
    }

    public /* synthetic */ MultiPostprocessor(List postprocessors, DefaultConstructorMarker $constructor_marker) {
        this(postprocessors);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/views/image/MultiPostprocessor$Companion;", "", "<init>", "()V", "from", "Lcom/facebook/imagepipeline/request/Postprocessor;", "postprocessors", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Postprocessor from(@NotNull List<? extends Postprocessor> postprocessors) {
            Intrinsics.checkNotNullParameter(postprocessors, (String)"postprocessors");
            return switch (postprocessors.size()) {
                case 0 -> null;
                case 1 -> postprocessors.get(0);
                default -> new MultiPostprocessor(postprocessors, null);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

