/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.BaseReactPackage;
import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageHelper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.ReactApplicationContext;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/NativeModuleRegistryBuilder;", "", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "reactInstanceManager", "Lcom/facebook/react/ReactInstanceManager;", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/ReactInstanceManager;)V", "modules", "Ljava/util/HashMap;", "", "Lcom/facebook/react/bridge/ModuleHolder;", "Lkotlin/collections/HashMap;", "processPackage", "", "reactPackage", "Lcom/facebook/react/ReactPackage;", "build", "Lcom/facebook/react/bridge/NativeModuleRegistry;", "ReactAndroid_debug"})
public final class NativeModuleRegistryBuilder {
    @NotNull
    private final ReactApplicationContext reactApplicationContext;
    @NotNull
    private final HashMap<String, ModuleHolder> modules;

    public NativeModuleRegistryBuilder(@NotNull ReactApplicationContext reactApplicationContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        this.reactApplicationContext = reactApplicationContext;
        this.modules = new HashMap();
    }

    @Deprecated(message="ReactInstanceManager is not used", replaceWith=@ReplaceWith(expression="NativeModuleRegistryBuilder(reactApplicationContext)", imports={}))
    public NativeModuleRegistryBuilder(@NotNull ReactApplicationContext reactApplicationContext, @NotNull ReactInstanceManager reactInstanceManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter((Object)reactInstanceManager, (String)"reactInstanceManager");
        this(reactApplicationContext);
    }

    public final void processPackage(@NotNull ReactPackage reactPackage) {
        Intrinsics.checkNotNullParameter((Object)reactPackage, (String)"reactPackage");
        Iterable<ModuleHolder> moduleHolders = reactPackage instanceof LazyReactPackage ? ((LazyReactPackage)reactPackage).getNativeModuleIterator(this.reactApplicationContext) : (reactPackage instanceof BaseReactPackage ? ((BaseReactPackage)reactPackage).getNativeModuleIterator$ReactAndroid_debug(this.reactApplicationContext) : ReactPackageHelper.INSTANCE.getNativeModuleIterator(reactPackage, this.reactApplicationContext));
        for (ModuleHolder moduleHolder : moduleHolders) {
            String name = moduleHolder.getName();
            ModuleHolder existingNativeModule = this.modules.get(name);
            if (existingNativeModule != null && !moduleHolder.getCanOverrideExistingModule()) {
                boolean bl = false;
                String string = "\nNative module " + name + " tried to override " + existingNativeModule.getClassName() + ".\n\nCheck the getPackages() method in MainApplication.java, it might be that module is being created twice. \nIf this was your intention, set canOverrideExistingModule=true. This error may also be present if the \npackage is present only once in getPackages() but is also automatically added later during build time \nby autolinking. Try removing the existing entry and rebuild.\n";
                throw new IllegalStateException(string.toString());
            }
            ((Map)this.modules).put(name, moduleHolder);
        }
    }

    @NotNull
    public final NativeModuleRegistry build() {
        return new NativeModuleRegistry(this.reactApplicationContext, (Map<String, ModuleHolder>)this.modules);
    }
}

