/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import android.widget.OverScroller;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.scroll.ReactScrollView;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\tZ[\\]^_`abB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u001f\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007\u00a2\u0006\u0002\u0010(J%\u0010)\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!H\u0007\u00a2\u0006\u0002\u0010*J5\u0010+\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007\u00a2\u0006\u0002\u0010(J5\u0010,\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010-J%\u0010.\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!H\u0007\u00a2\u0006\u0002\u0010*J-\u0010\u001f\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J=\u0010\u001f\u001a\u00020 \"\u000e\b\u0000\u0010!*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020 2\u0006\u0010$\u001a\u00020#H\u0007J\u0010\u00104\u001a\u00020 2\u0006\u0010$\u001a\u00020#H\u0007J\u0012\u00105\u001a\u00020\u00132\b\u00106\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u00107\u001a\u00020\u00132\b\u00108\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u00109\u001a\u00020\u00132\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u0010\u0010<\u001a\u00020 2\u0006\u0010=\u001a\u00020\u001aH\u0007J\u0010\u0010>\u001a\u00020 2\u0006\u0010=\u001a\u00020\u001aH\u0007J\u0010\u0010?\u001a\u00020 2\u0006\u0010=\u001a\u00020\u001cH\u0007J\u0010\u0010@\u001a\u00020 2\u0006\u0010=\u001a\u00020\u001cH\u0007JA\u0010A\u001a\u00020 \"\u001a\b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010C*\u0004\u0018\u00010D*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010E\u001a\u00020\u00132\u0006\u0010F\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010-JC\u0010G\u001a\u00020\u0013\"\u0014\b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010C*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010KJ1\u0010L\u001a\u00020 \"\u001a\b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010C*\u0004\u0018\u00010D*\u00020#2\u0006\u0010$\u001a\u0002H!H\u0007\u00a2\u0006\u0002\u0010*J9\u0010L\u001a\u00020 \"\u0014\b\u0000\u0010!*\u0004\u0018\u00010C*\u0004\u0018\u00010D*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010M\u001a\u00020\u00132\u0006\u0010N\u001a\u00020\u0013\u00a2\u0006\u0002\u0010-J+\u0010O\u001a\u00020 \"\u0014\b\u0000\u0010!*\u0004\u0018\u00010C*\u0004\u0018\u00010D*\u00020#2\u0006\u0010$\u001a\u0002H!H\u0007\u00a2\u0006\u0002\u0010*JG\u0010P\u001a\u00020 \" \b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010\"*\u0004\u0018\u00010C*\u0004\u0018\u00010D*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007\u00a2\u0006\u0002\u0010(J/\u0010Q\u001a\u00020 \"\u001a\b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010C*\u0004\u0018\u00010D*\u00020#2\u0006\u0010$\u001a\u0002H!\u00a2\u0006\u0002\u0010*J+\u0010R\u001a\u00020 \"\u0014\b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u0002H!H\u0007\u00a2\u0006\u0002\u0010*JK\u0010S\u001a\u00020T\"\u0014\b\u0000\u0010!*\u0004\u0018\u00010B*\u0004\u0018\u00010C*\u00020#2\u0006\u0010$\u001a\u0002H!2\u0006\u0010U\u001a\u00020\u00132\u0006\u0010V\u001a\u00020\u00132\u0006\u0010W\u001a\u00020\u00132\u0006\u0010X\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010YR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "DEBUG_MODE", "", "CONTENT_OFFSET_LEFT", "CONTENT_OFFSET_TOP", "SCROLL_AWAY_PADDING_TOP", "MOMENTUM_DELAY", "", "OVER_SCROLL_ALWAYS", "AUTO", "OVER_SCROLL_NEVER", "SNAP_ALIGNMENT_DISABLED", "", "SNAP_ALIGNMENT_START", "SNAP_ALIGNMENT_CENTER", "SNAP_ALIGNMENT_END", "scrollListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/ref/WeakReference;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ScrollListener;", "layoutChangeListeners", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$LayoutChangeListener;", "SMOOTH_SCROLL_DURATION", "smoothScrollDurationInitialized", "emitScrollEvent", "", "T", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollEventThrottle;", "Landroid/view/ViewGroup;", "scrollView", "xVelocity", "", "yVelocity", "(Landroid/view/ViewGroup;FF)V", "emitScrollBeginDragEvent", "(Landroid/view/ViewGroup;)V", "emitScrollEndDragEvent", "emitScrollMomentumBeginEvent", "(Landroid/view/ViewGroup;II)V", "emitScrollMomentumEndEvent", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "(Landroid/view/ViewGroup;Lcom/facebook/react/views/scroll/ScrollEventType;)V", "(Landroid/view/ViewGroup;Lcom/facebook/react/views/scroll/ScrollEventType;FF)V", "emitLayoutEvent", "emitLayoutChangeEvent", "parseOverScrollMode", "jsOverScrollMode", "parseSnapToAlignment", "alignment", "getDefaultScrollAnimationDuration", "context", "Landroid/content/Context;", "addScrollListener", "listener", "removeScrollListener", "addLayoutChangeListener", "removeLayoutChangeListener", "smoothScrollTo", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasFlingAnimator;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollState;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasStateWrapper;", "x", "y", "getNextFlingStartValue", "currentValue", "postAnimationValue", "velocity", "(Landroid/view/ViewGroup;III)I", "updateFabricScrollState", "scrollX", "scrollY", "forceUpdateState", "updateStateOnScrollChanged", "registerFlingAnimator", "dispatchMomentumEndOnAnimationEnd", "predictFinalScrollPosition", "Landroid/graphics/Point;", "velocityX", "velocityY", "maximumOffsetX", "maximumOffsetY", "(Landroid/view/ViewGroup;IIII)Landroid/graphics/Point;", "ScrollListener", "LayoutChangeListener", "HasStateWrapper", "OverScrollerDurationGetter", "ReactScrollViewScrollState", "HasScrollState", "HasFlingAnimator", "HasScrollEventThrottle", "HasSmoothScroll", "ReactAndroid_debug"})
public final class ReactScrollViewHelper {
    @NotNull
    public static final ReactScrollViewHelper INSTANCE = new ReactScrollViewHelper();
    private static final String TAG = ReactScrollView.class.getSimpleName();
    private static final boolean DEBUG_MODE;
    @NotNull
    private static final String CONTENT_OFFSET_LEFT = "contentOffsetLeft";
    @NotNull
    private static final String CONTENT_OFFSET_TOP = "contentOffsetTop";
    @NotNull
    private static final String SCROLL_AWAY_PADDING_TOP = "scrollAwayPaddingTop";
    public static final long MOMENTUM_DELAY = 20L;
    @NotNull
    public static final String OVER_SCROLL_ALWAYS = "always";
    @NotNull
    public static final String AUTO = "auto";
    @NotNull
    public static final String OVER_SCROLL_NEVER = "never";
    public static final int SNAP_ALIGNMENT_DISABLED = 0;
    public static final int SNAP_ALIGNMENT_START = 1;
    public static final int SNAP_ALIGNMENT_CENTER = 2;
    public static final int SNAP_ALIGNMENT_END = 3;
    @NotNull
    private static final CopyOnWriteArrayList<WeakReference<ScrollListener>> scrollListeners;
    @NotNull
    private static final CopyOnWriteArrayList<WeakReference<LayoutChangeListener>> layoutChangeListeners;
    private static int SMOOTH_SCROLL_DURATION;
    private static boolean smoothScrollDurationInitialized;

    private ReactScrollViewHelper() {
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollEvent(T scrollView, float xVelocity, float yVelocity) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.SCROLL, xVelocity, yVelocity);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollBeginDragEvent(T scrollView) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.BEGIN_DRAG);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollEndDragEvent(T scrollView, float xVelocity, float yVelocity) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.END_DRAG, xVelocity, yVelocity);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollMomentumBeginEvent(T scrollView, int xVelocity, int yVelocity) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_BEGIN, xVelocity, yVelocity);
    }

    @JvmStatic
    public static final <T extends ViewGroup> void emitScrollMomentumEndEvent(T scrollView) {
        INSTANCE.emitScrollEvent(scrollView, ScrollEventType.MOMENTUM_END);
    }

    private final <T extends ViewGroup> void emitScrollEvent(T scrollView, ScrollEventType scrollEventType) {
        this.emitScrollEvent(scrollView, scrollEventType, 0.0f, 0.0f);
    }

    private final <T extends ViewGroup> void emitScrollEvent(T scrollView, ScrollEventType scrollEventType, float xVelocity, float yVelocity) {
        long now = System.currentTimeMillis();
        if (scrollEventType == ScrollEventType.SCROLL && (long)((HasScrollEventThrottle)scrollView).getScrollEventThrottle() >= Math.max(17L, now - ((HasScrollEventThrottle)scrollView).getLastScrollDispatchTime())) {
            return;
        }
        View view = scrollView.getChildAt(0);
        if (view == null) {
            return;
        }
        View contentView = view;
        for (WeakReference scrollListener : CollectionsKt.toList((Iterable)scrollListeners)) {
            ScrollListener scrollListener2 = (ScrollListener)scrollListener.get();
            if (scrollListener2 == null) continue;
            scrollListener2.onScroll(scrollView, scrollEventType, xVelocity, yVelocity);
        }
        Context context = ((View)scrollView).getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
        ReactContext reactContext = (ReactContext)context;
        int surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, ((View)scrollView).getId());
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent(ScrollEvent.Companion.obtain(surfaceId, ((View)scrollView).getId(), scrollEventType, ((View)scrollView).getScrollX(), ((View)scrollView).getScrollY(), xVelocity, yVelocity, contentView.getWidth(), contentView.getHeight(), ((View)scrollView).getWidth(), ((View)scrollView).getHeight()));
            if (scrollEventType == ScrollEventType.SCROLL) {
                ((HasScrollEventThrottle)scrollView).setLastScrollDispatchTime(now);
            }
        }
    }

    @JvmStatic
    public static final void emitLayoutEvent(@NotNull ViewGroup scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Iterator<WeakReference<ScrollListener>> iterator2 = scrollListeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeakReference<ScrollListener>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            WeakReference<ScrollListener> scrollListener = iterator3.next();
            ScrollListener scrollListener2 = (ScrollListener)scrollListener.get();
            if (scrollListener2 == null) continue;
            scrollListener2.onLayout(scrollView);
        }
    }

    @JvmStatic
    public static final void emitLayoutChangeEvent(@NotNull ViewGroup scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Iterator<WeakReference<LayoutChangeListener>> iterator2 = layoutChangeListeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeakReference<LayoutChangeListener>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            WeakReference<LayoutChangeListener> listener = iterator3.next();
            LayoutChangeListener layoutChangeListener = (LayoutChangeListener)listener.get();
            if (layoutChangeListener == null) continue;
            layoutChangeListener.onLayoutChange(scrollView);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final int parseOverScrollMode(@Nullable String jsOverScrollMode) {
        if (jsOverScrollMode == null) return 1;
        switch (jsOverScrollMode.hashCode()) {
            case -1414557169: {
                if (jsOverScrollMode.equals(OVER_SCROLL_ALWAYS)) return 0;
                break;
            }
            case 104712844: {
                if (jsOverScrollMode.equals(OVER_SCROLL_NEVER)) return 2;
                break;
            }
            case 3005871: {
                if (!jsOverScrollMode.equals(AUTO)) break;
                return 1;
            }
        }
        FLog.w((String)"ReactNative", (String)("wrong overScrollMode: " + jsOverScrollMode));
        return 1;
    }

    @JvmStatic
    public static final int parseSnapToAlignment(@Nullable String alignment) {
        int n;
        if (alignment == null) {
            n = 0;
        } else if (StringsKt.equals((String)"start", (String)alignment, (boolean)true)) {
            n = 1;
        } else if (StringsKt.equals((String)"center", (String)alignment, (boolean)true)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)"end", (Object)alignment)) {
            n = 3;
        } else {
            FLog.w((String)"ReactNative", (String)("wrong snap alignment value: " + alignment));
            n = 0;
        }
        return n;
    }

    @JvmStatic
    public static final int getDefaultScrollAnimationDuration(@Nullable Context context) {
        if (!smoothScrollDurationInitialized) {
            smoothScrollDurationInitialized = true;
            try {
                OverScrollerDurationGetter overScrollerDurationGetter = new OverScrollerDurationGetter(context);
                SMOOTH_SCROLL_DURATION = overScrollerDurationGetter.getScrollAnimationDuration();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SMOOTH_SCROLL_DURATION;
    }

    @JvmStatic
    public static final void addScrollListener(@NotNull ScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        scrollListeners.add(new WeakReference<ScrollListener>(listener));
    }

    @JvmStatic
    public static final void removeScrollListener(@NotNull ScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        scrollListeners.remove(new WeakReference<ScrollListener>(listener));
    }

    @JvmStatic
    public static final void addLayoutChangeListener(@NotNull LayoutChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        layoutChangeListeners.add(new WeakReference<LayoutChangeListener>(listener));
    }

    @JvmStatic
    public static final void removeLayoutChangeListener(@NotNull LayoutChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        layoutChangeListeners.remove(new WeakReference<LayoutChangeListener>(listener));
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollState> void smoothScrollTo(T scrollView, int x, int y) {
        ValueAnimator flingAnimator;
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"smoothScrollTo[%d] x %d y %d", (Object)((View)scrollView).getId(), (Object)x, (Object)y);
        }
        if ((flingAnimator = ((HasFlingAnimator)scrollView).getFlingAnimator()).getListeners() == null || flingAnimator.getListeners().size() == 0) {
            INSTANCE.registerFlingAnimator(scrollView);
        }
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        scrollState.setFinalAnimatedPositionScroll(x, y);
        int scrollX = ((View)scrollView).getScrollX();
        int scrollY = ((View)scrollView).getScrollY();
        if (scrollX != x) {
            ((HasFlingAnimator)scrollView).startFlingAnimator(scrollX, x);
        }
        if (scrollY != y) {
            ((HasFlingAnimator)scrollView).startFlingAnimator(scrollY, y);
        }
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollState> int getNextFlingStartValue(T scrollView, int currentValue, int postAnimationValue, int velocity) {
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        int velocityDirectionMask = velocity != 0 ? velocity / Math.abs(velocity) : 0;
        boolean isMovingTowardsAnimatedValue = velocityDirectionMask * (postAnimationValue - currentValue) > 0;
        return !scrollState.isFinished() || scrollState.isCanceled() && isMovingTowardsAnimatedValue ? postAnimationValue : currentValue;
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollState> void updateFabricScrollState(T scrollView) {
        INSTANCE.updateFabricScrollState(scrollView, ((View)scrollView).getScrollX(), ((View)scrollView).getScrollY());
    }

    public final <T extends ViewGroup & HasStateWrapper> void updateFabricScrollState(T scrollView, int scrollX, int scrollY) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"updateFabricScrollState[%d] scrollX %d scrollY %d", (Object)((View)scrollView).getId(), (Object)scrollX, (Object)scrollY);
        }
        if (ViewUtil.getUIManagerType(((View)scrollView).getId()) == 1) {
            return;
        }
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        if (scrollState.getLastStateUpdateScroll().equals(scrollX, scrollY)) {
            return;
        }
        scrollState.setLastStateUpdateScroll(scrollX, scrollY);
        ReactScrollViewHelper.forceUpdateState(scrollView);
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasStateWrapper> void forceUpdateState(T scrollView) {
        StateWrapper stateWrapper;
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        int scrollAwayPaddingTop = scrollState.getScrollAwayPaddingTop();
        Point scrollPos = scrollState.getLastStateUpdateScroll();
        int scrollX = scrollPos.x;
        int scrollY = scrollPos.y;
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"updateFabricScrollState[%d] scrollX %d scrollY %d", (Object)((View)scrollView).getId(), (Object)scrollX, (Object)scrollY);
        }
        if ((stateWrapper = ((HasStateWrapper)scrollView).getStateWrapper()) != null) {
            WritableMap newStateData = new WritableNativeMap();
            newStateData.putDouble(CONTENT_OFFSET_LEFT, PixelUtil.toDIPFromPixel(scrollX));
            newStateData.putDouble(CONTENT_OFFSET_TOP, PixelUtil.toDIPFromPixel(scrollY));
            newStateData.putDouble(SCROLL_AWAY_PADDING_TOP, PixelUtil.toDIPFromPixel(scrollAwayPaddingTop));
            stateWrapper.updateState(newStateData);
        }
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollEventThrottle & HasStateWrapper> void updateStateOnScrollChanged(T scrollView, float xVelocity, float yVelocity) {
        INSTANCE.updateFabricScrollState(scrollView, ((View)scrollView).getScrollX(), ((View)scrollView).getScrollY());
        ReactScrollViewHelper.emitScrollEvent(scrollView, xVelocity, yVelocity);
    }

    public final <T extends ViewGroup & HasScrollState> void registerFlingAnimator(T scrollView) {
        ((HasFlingAnimator)scrollView).getFlingAnimator().addListener(new Animator.AnimatorListener(scrollView){
            final /* synthetic */ T $scrollView;
            {
                this.$scrollView = $scrollView;
            }

            public void onAnimationStart(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ReactScrollViewScrollState scrollState = ((HasScrollState)this.$scrollView).getReactScrollViewScrollState();
                scrollState.setCanceled(false);
                scrollState.setFinished(false);
            }

            public void onAnimationEnd(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ((HasScrollState)this.$scrollView).getReactScrollViewScrollState().setFinished(true);
                ReactScrollViewHelper.updateFabricScrollState(this.$scrollView);
            }

            public void onAnimationCancel(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ((HasScrollState)this.$scrollView).getReactScrollViewScrollState().setCanceled(true);
            }

            public void onAnimationRepeat(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            }
        });
    }

    @JvmStatic
    public static final <T extends ViewGroup & HasScrollEventThrottle> void dispatchMomentumEndOnAnimationEnd(T scrollView) {
        ((HasFlingAnimator)scrollView).getFlingAnimator().addListener(new Animator.AnimatorListener(scrollView){
            final /* synthetic */ T $scrollView;
            {
                this.$scrollView = $scrollView;
            }

            public void onAnimationStart(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            }

            public void onAnimationEnd(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ReactScrollViewHelper.emitScrollMomentumEndEvent(this.$scrollView);
                animator.removeListener((Animator.AnimatorListener)this);
            }

            public void onAnimationCancel(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                ReactScrollViewHelper.emitScrollMomentumEndEvent(this.$scrollView);
                animator.removeListener((Animator.AnimatorListener)this);
            }

            public void onAnimationRepeat(Animator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final <T extends ViewGroup & HasScrollState> Point predictFinalScrollPosition(T scrollView, int velocityX, int velocityY, int maximumOffsetX, int maximumOffsetY) {
        ReactScrollViewScrollState scrollState = ((HasScrollState)scrollView).getReactScrollViewScrollState();
        OverScroller scroller = new OverScroller(((View)scrollView).getContext());
        scroller.setFriction(1.0f - scrollState.getDecelerationRate());
        int width = ((View)scrollView).getWidth() - ((View)scrollView).getPaddingStart() - ((View)scrollView).getPaddingEnd();
        int height = ((View)scrollView).getHeight() - ((View)scrollView).getPaddingBottom() - ((View)scrollView).getPaddingTop();
        Point finalAnimatedPositionScroll = scrollState.getFinalAnimatedPositionScroll();
        scroller.fling(ReactScrollViewHelper.getNextFlingStartValue(scrollView, ((View)scrollView).getScrollX(), finalAnimatedPositionScroll.x, velocityX), ReactScrollViewHelper.getNextFlingStartValue(scrollView, ((View)scrollView).getScrollY(), finalAnimatedPositionScroll.y, velocityY), velocityX, velocityY, 0, maximumOffsetX, 0, maximumOffsetY, width / 2, height / 2);
        return new Point(scroller.getFinalX(), scroller.getFinalY());
    }

    static {
        scrollListeners = new CopyOnWriteArrayList();
        layoutChangeListeners = new CopyOnWriteArrayList();
        SMOOTH_SCROLL_DURATION = 250;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasFlingAnimator;", "", "startFlingAnimator", "", "start", "", "end", "getFlingAnimator", "Landroid/animation/ValueAnimator;", "getFlingExtrapolatedDistance", "velocity", "ReactAndroid_debug"})
    public static interface HasFlingAnimator {
        public void startFlingAnimator(int var1, int var2);

        @NotNull
        public ValueAnimator getFlingAnimator();

        public int getFlingExtrapolatedDistance(int var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollEventThrottle;", "", "scrollEventThrottle", "", "getScrollEventThrottle", "()I", "setScrollEventThrottle", "(I)V", "lastScrollDispatchTime", "", "getLastScrollDispatchTime", "()J", "setLastScrollDispatchTime", "(J)V", "ReactAndroid_debug"})
    public static interface HasScrollEventThrottle {
        public int getScrollEventThrottle();

        public void setScrollEventThrottle(int var1);

        public long getLastScrollDispatchTime();

        public void setLastScrollDispatchTime(long var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasScrollState;", "", "reactScrollViewScrollState", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ReactScrollViewScrollState;", "getReactScrollViewScrollState", "()Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ReactScrollViewScrollState;", "ReactAndroid_debug"})
    public static interface HasScrollState {
        @NotNull
        public ReactScrollViewScrollState getReactScrollViewScrollState();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasSmoothScroll;", "", "reactSmoothScrollTo", "", "x", "", "y", "scrollToPreservingMomentum", "ReactAndroid_debug"})
    public static interface HasSmoothScroll {
        public void reactSmoothScrollTo(int var1, int var2);

        public void scrollToPreservingMomentum(int var1, int var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$HasStateWrapper;", "", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper", "()Lcom/facebook/react/uimanager/StateWrapper;", "ReactAndroid_debug"})
    public static interface HasStateWrapper {
        @Nullable
        public StateWrapper getStateWrapper();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$LayoutChangeListener;", "", "onLayoutChange", "", "scrollView", "Landroid/view/ViewGroup;", "ReactAndroid_debug"})
    public static interface LayoutChangeListener {
        public void onLayoutChange(@NotNull ViewGroup var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$OverScrollerDurationGetter;", "Landroid/widget/OverScroller;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "currentScrollAnimationDuration", "", "scrollAnimationDuration", "getScrollAnimationDuration", "()I", "startScroll", "", "startX", "startY", "dx", "dy", "duration", "ReactAndroid_debug"})
    private static final class OverScrollerDurationGetter
    extends OverScroller {
        private int currentScrollAnimationDuration = 250;

        public OverScrollerDurationGetter(@Nullable Context context) {
            super(context);
        }

        public final int getScrollAnimationDuration() {
            super.startScroll(0, 0, 0, 0);
            return this.currentScrollAnimationDuration;
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            this.currentScrollAnimationDuration = duration;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tJ\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ReactScrollViewScrollState;", "", "<init>", "()V", "finalAnimatedPositionScroll", "Landroid/graphics/Point;", "getFinalAnimatedPositionScroll", "()Landroid/graphics/Point;", "scrollAwayPaddingTop", "", "getScrollAwayPaddingTop", "()I", "setScrollAwayPaddingTop", "(I)V", "lastStateUpdateScroll", "getLastStateUpdateScroll", "isCanceled", "", "()Z", "setCanceled", "(Z)V", "isFinished", "setFinished", "decelerationRate", "", "getDecelerationRate", "()F", "setDecelerationRate", "(F)V", "setFinalAnimatedPositionScroll", "finalAnimatedPositionScrollX", "finalAnimatedPositionScrollY", "setLastStateUpdateScroll", "lastStateUpdateScrollX", "lastStateUpdateScrollY", "ReactAndroid_debug"})
    public static final class ReactScrollViewScrollState {
        @NotNull
        private final Point finalAnimatedPositionScroll = new Point();
        private int scrollAwayPaddingTop;
        @NotNull
        private final Point lastStateUpdateScroll = new Point(-1, -1);
        private boolean isCanceled;
        private boolean isFinished = true;
        private float decelerationRate = 0.985f;

        @NotNull
        public final Point getFinalAnimatedPositionScroll() {
            return this.finalAnimatedPositionScroll;
        }

        public final int getScrollAwayPaddingTop() {
            return this.scrollAwayPaddingTop;
        }

        public final void setScrollAwayPaddingTop(int n) {
            this.scrollAwayPaddingTop = n;
        }

        @NotNull
        public final Point getLastStateUpdateScroll() {
            return this.lastStateUpdateScroll;
        }

        public final boolean isCanceled() {
            return this.isCanceled;
        }

        public final void setCanceled(boolean bl) {
            this.isCanceled = bl;
        }

        public final boolean isFinished() {
            return this.isFinished;
        }

        public final void setFinished(boolean bl) {
            this.isFinished = bl;
        }

        public final float getDecelerationRate() {
            return this.decelerationRate;
        }

        public final void setDecelerationRate(float f) {
            this.decelerationRate = f;
        }

        @NotNull
        public final ReactScrollViewScrollState setFinalAnimatedPositionScroll(int finalAnimatedPositionScrollX, int finalAnimatedPositionScrollY) {
            this.finalAnimatedPositionScroll.set(finalAnimatedPositionScrollX, finalAnimatedPositionScrollY);
            return this;
        }

        @NotNull
        public final ReactScrollViewScrollState setLastStateUpdateScroll(int lastStateUpdateScrollX, int lastStateUpdateScrollY) {
            this.lastStateUpdateScroll.set(lastStateUpdateScrollX, lastStateUpdateScrollY);
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\u0012\u0010\u000b\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ScrollListener;", "", "onScroll", "", "scrollView", "Landroid/view/ViewGroup;", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "xVelocity", "", "yVelocity", "onLayout", "ReactAndroid_debug"})
    public static interface ScrollListener {
        public void onScroll(@Nullable ViewGroup var1, @Nullable ScrollEventType var2, float var3, float var4);

        public void onLayout(@Nullable ViewGroup var1);
    }
}

