/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.systeminfo;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.modules.systeminfo.ReactNativeVersion;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0005H\u0007J \u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0007J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/modules/systeminfo/AndroidInfoHelpers;", "", "<init>", "()V", "EMULATOR_LOCALHOST", "", "GENYMOTION_LOCALHOST", "DEVICE_LOCALHOST", "METRO_HOST_PROP_NAME", "TAG", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "metroHostPropValue", "isRunningOnGenymotion", "", "isRunningOnStockEmulator", "getServerHost", "port", "", "context", "Landroid/content/Context;", "getAdbReverseTcpCommand", "getFriendlyDeviceName", "getInspectorHostMetadata", "", "applicationContext", "getReactNativeVersionString", "getDevServerPort", "getServerIpAddress", "getMetroHostPropValue", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nAndroidInfoHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidInfoHelpers.kt\ncom/facebook/react/modules/systeminfo/AndroidInfoHelpers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class AndroidInfoHelpers {
    @NotNull
    public static final AndroidInfoHelpers INSTANCE = new AndroidInfoHelpers();
    @NotNull
    public static final String EMULATOR_LOCALHOST = "10.0.2.2";
    @NotNull
    public static final String GENYMOTION_LOCALHOST = "10.0.3.2";
    @NotNull
    public static final String DEVICE_LOCALHOST = "localhost";
    @NotNull
    public static final String METRO_HOST_PROP_NAME = "metro.host";
    private static final String TAG = AndroidInfoHelpers.class.getSimpleName();
    @Nullable
    private static String metroHostPropValue;

    private AndroidInfoHelpers() {
    }

    private final boolean isRunningOnGenymotion() {
        String string2 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FINGERPRINT");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"vbox", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRunningOnStockEmulator() {
        String string2 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FINGERPRINT");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"generic", (boolean)false, (int)2, null)) return true;
        String string3 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FINGERPRINT");
        if (!StringsKt.startsWith$default((String)string3, (String)"google/sdk_gphone", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final String getServerHost(int port) {
        return INSTANCE.getServerIpAddress(port);
    }

    @JvmStatic
    @NotNull
    public static final String getServerHost(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return INSTANCE.getServerIpAddress(INSTANCE.getDevServerPort(context));
    }

    @JvmStatic
    @NotNull
    public static final String getAdbReverseTcpCommand(int port) {
        return "adb reverse tcp:" + port + " tcp:" + port;
    }

    @JvmStatic
    @NotNull
    public static final String getAdbReverseTcpCommand(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return AndroidInfoHelpers.getAdbReverseTcpCommand(INSTANCE.getDevServerPort(context));
    }

    @JvmStatic
    @NotNull
    public static final String getFriendlyDeviceName() {
        Object object;
        if (INSTANCE.isRunningOnGenymotion()) {
            String string2 = Build.MODEL;
            Intrinsics.checkNotNull((Object)string2);
            object = string2;
        } else {
            object = Build.MODEL + " - " + Build.VERSION.RELEASE + " - API " + Build.VERSION.SDK_INT;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getInspectorHostMetadata(@Nullable Context applicationContext) {
        String appIdentifier = null;
        String appDisplayName = null;
        if (applicationContext != null) {
            String string2;
            ApplicationInfo applicationInfo = applicationContext.getApplicationInfo();
            int labelResourceId = applicationInfo.labelRes;
            appIdentifier = applicationContext.getPackageName();
            if (labelResourceId == 0) {
                string2 = ((Object)applicationInfo.nonLocalizedLabel).toString();
            } else {
                String string3 = applicationContext.getString(labelResourceId);
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            }
            appDisplayName = string2;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appDisplayName", appDisplayName), TuplesKt.to((Object)"appIdentifier", (Object)appIdentifier), TuplesKt.to((Object)"platform", (Object)"android"), TuplesKt.to((Object)"deviceName", (Object)Build.MODEL), TuplesKt.to((Object)"reactNativeVersion", (Object)INSTANCE.getReactNativeVersionString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final String getReactNativeVersionString() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        block3: {
            block2: {
                void it;
                Map<String, Object> version = ReactNativeVersion.VERSION;
                object4 = version.get("major");
                object3 = version.get("minor");
                object2 = version.get("patch");
                object = version.get("prerelease");
                if (object == null) break block2;
                Object object5 = object;
                Object object6 = object2;
                Object object7 = object3;
                Object object8 = object4;
                boolean bl = false;
                String string2 = "-" + it;
                object4 = object8;
                object3 = object7;
                object2 = object6;
                String string3 = string2;
                object = string3;
                if (string3 != null) break block3;
            }
            object = "";
        }
        return object4 + "." + object3 + "." + object2 + (String)object;
    }

    private final int getDevServerPort(Context context) {
        return context.getResources().getInteger(R.integer.react_native_dev_server_port);
    }

    private final String getServerIpAddress(int port) {
        String ipAddress = ((CharSequence)this.getMetroHostPropValue()).length() > 0 ? this.getMetroHostPropValue() : (this.isRunningOnGenymotion() ? GENYMOTION_LOCALHOST : (this.isRunningOnStockEmulator() ? EMULATOR_LOCALHOST : DEVICE_LOCALHOST));
        Locale locale = Locale.US;
        String string2 = "%s:%d";
        Object[] objectArray = new Object[]{ipAddress, port};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized String getMetroHostPropValue() {
        String string2;
        block12: {
            Process process;
            if (metroHostPropValue != null) {
                String string3 = metroHostPropValue;
                Intrinsics.checkNotNull((Object)string3);
                return string3;
            }
            Process process2 = null;
            BufferedReader reader = null;
            try {
                String[] stringArray = new String[]{"/system/bin/getprop", METRO_HOST_PROP_NAME};
                process2 = Runtime.getRuntime().exec(stringArray);
                reader = new BufferedReader(new InputStreamReader(process2.getInputStream(), Charset.forName("UTF-8")));
                String lastLine = "";
                String line = null;
                while (true) {
                    String string4;
                    String it = string4 = reader.readLine();
                    boolean bl = false;
                    line = it;
                    if (string4 == null) break;
                    String string5 = line;
                    if (string5 == null) {
                        string5 = "";
                    }
                    lastLine = string5;
                }
                metroHostPropValue = lastLine;
                reader.close();
                process = process2;
            }
            catch (Exception e) {
                FLog.w((String)TAG, (String)"Failed to query for metro.host prop:", (Throwable)e);
                metroHostPropValue = "";
                break block12;
            }
            finally {
                BufferedReader bufferedReader = reader;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                Process process3 = process2;
                if (process3 != null) {
                    process3.destroy();
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
        if ((string2 = metroHostPropValue) == null) {
            string2 = "";
        }
        return string2;
    }
}

