/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import com.facebook.react.uimanager.FilterHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.drawable.BoxShadowBorderRadiusKt;
import com.facebook.react.uimanager.drawable.InsetBoxShadowDrawableKt;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0012\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0005H\u0017J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u001f\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/facebook/react/uimanager/drawable/InsetBoxShadowDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "shadowColor", "", "offsetX", "", "offsetY", "blurRadius", "spread", "borderInsets", "Lcom/facebook/react/uimanager/style/BorderInsets;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "<init>", "(Landroid/content/Context;IFFFFLcom/facebook/react/uimanager/style/BorderInsets;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "getBorderInsets", "()Lcom/facebook/react/uimanager/style/BorderInsets;", "setBorderInsets", "(Lcom/facebook/react/uimanager/style/BorderInsets;)V", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "shadowPaint", "Landroid/graphics/Paint;", "setAlpha", "", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "computeBorderRadii", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "computeBorderInsets", "Landroid/graphics/RectF;", "innerRadius", "radius", "borderInset", "(FLjava/lang/Float;)F", "ReactAndroid_release"})
@RequiresApi(value=29)
@SourceDebugExtension(value={"SMAP\nInsetBoxShadowDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsetBoxShadowDrawable.kt\ncom/facebook/react/uimanager/drawable/InsetBoxShadowDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,186:1\n1#2:187\n11215#3:188\n11550#3,3:189\n*S KotlinDebug\n*F\n+ 1 InsetBoxShadowDrawable.kt\ncom/facebook/react/uimanager/drawable/InsetBoxShadowDrawable\n*L\n134#1:188\n134#1:189,3\n*E\n"})
public final class InsetBoxShadowDrawable
extends Drawable {
    @NotNull
    private final Context context;
    private final int shadowColor;
    private final float offsetX;
    private final float offsetY;
    private final float blurRadius;
    private final float spread;
    @Nullable
    private BorderInsets borderInsets;
    @Nullable
    private BorderRadiusStyle borderRadius;
    @NotNull
    private final Paint shadowPaint;

    /*
     * WARNING - void declaration
     */
    public InsetBoxShadowDrawable(@NotNull Context context, int shadowColor, float offsetX, float offsetY, float blurRadius, float spread, @Nullable BorderInsets borderInsets, @Nullable BorderRadiusStyle borderRadius) {
        void $this$shadowPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.shadowColor = shadowColor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blurRadius = blurRadius;
        this.spread = spread;
        this.borderInsets = borderInsets;
        this.borderRadius = borderRadius;
        Paint paint2 = paint = new Paint();
        InsetBoxShadowDrawable insetBoxShadowDrawable = this;
        boolean bl = false;
        $this$shadowPaint_u24lambda_u240.setColor(this.shadowColor);
        float convertedBlurRadius = FilterHelper.INSTANCE.sigmaToRadius$ReactAndroid_release(this.blurRadius * 0.5f);
        if (convertedBlurRadius > 0.0f) {
            $this$shadowPaint_u24lambda_u240.setMaskFilter((MaskFilter)new BlurMaskFilter(convertedBlurRadius, BlurMaskFilter.Blur.NORMAL));
        }
        insetBoxShadowDrawable.shadowPaint = paint;
    }

    public /* synthetic */ InsetBoxShadowDrawable(Context context, int n, float f, float f2, float f3, float f4, BorderInsets borderInsets, BorderRadiusStyle borderRadiusStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            borderInsets = null;
        }
        if ((n2 & 0x80) != 0) {
            borderRadiusStyle = null;
        }
        this(context, n, f, f2, f3, f4, borderInsets, borderRadiusStyle);
    }

    @Nullable
    public final BorderInsets getBorderInsets() {
        return this.borderInsets;
    }

    public final void setBorderInsets(@Nullable BorderInsets borderInsets) {
        this.borderInsets = borderInsets;
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    public void setAlpha(int alpha) {
        this.shadowPaint.setAlpha(MathKt.roundToInt((float)((float)alpha / 255.0f * ((float)Color.alpha((int)this.shadowColor) / 255.0f) * 255.0f)));
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.shadowPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int alpha = this.shadowPaint.getAlpha();
        int n = alpha;
        return n == 255 ? -1 : ((1 <= n ? n < 255 : false) ? -3 : -2);
    }

    /*
     * WARNING - void declaration
     */
    public void draw(@NotNull Canvas canvas) {
        RectF $this$draw_u24lambda_u244_u24lambda_u243;
        RectF rectF;
        RectF rectF2;
        RectF rectF3;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ComputedBorderRadius computedBorderRadii = this.computeBorderRadii();
        RectF computedBorderInsets = this.computeBorderInsets();
        RectF rectF4 = computedBorderInsets;
        RectF rectF5 = computedBorderInsets;
        RectF rectF6 = computedBorderInsets;
        RectF rectF7 = computedBorderInsets;
        RectF paddingBoxRect = new RectF((float)this.getBounds().left + (rectF4 != null ? rectF4.left : 0.0f), (float)this.getBounds().top + (rectF5 != null ? rectF5.top : 0.0f), (float)this.getBounds().right - (rectF6 != null ? rectF6.right : 0.0f), (float)this.getBounds().bottom - (rectF7 != null ? rectF7.bottom : 0.0f));
        ComputedBorderRadius computedBorderRadius = computedBorderRadii;
        if (computedBorderRadius != null) {
            ComputedBorderRadius it = computedBorderRadius;
            boolean bl = false;
            float[] fArray2 = new float[8];
            RectF rectF8 = computedBorderInsets;
            fArray2[0] = this.innerRadius(it.getTopLeft().getHorizontal(), rectF8 != null ? Float.valueOf(rectF8.left) : null);
            RectF rectF9 = computedBorderInsets;
            fArray2[1] = this.innerRadius(it.getTopLeft().getVertical(), rectF9 != null ? Float.valueOf(rectF9.top) : null);
            RectF rectF10 = computedBorderInsets;
            fArray2[2] = this.innerRadius(it.getTopRight().getHorizontal(), rectF10 != null ? Float.valueOf(rectF10.right) : null);
            RectF rectF11 = computedBorderInsets;
            fArray2[3] = this.innerRadius(it.getTopRight().getVertical(), rectF11 != null ? Float.valueOf(rectF11.top) : null);
            RectF rectF12 = computedBorderInsets;
            fArray2[4] = this.innerRadius(it.getBottomRight().getHorizontal(), rectF12 != null ? Float.valueOf(rectF12.right) : null);
            RectF rectF13 = computedBorderInsets;
            fArray2[5] = this.innerRadius(it.getBottomRight().getVertical(), rectF13 != null ? Float.valueOf(rectF13.bottom) : null);
            RectF rectF14 = computedBorderInsets;
            fArray2[6] = this.innerRadius(it.getBottomLeft().getHorizontal(), rectF14 != null ? Float.valueOf(rectF14.left) : null);
            RectF rectF15 = computedBorderInsets;
            fArray2[7] = this.innerRadius(it.getBottomLeft().getVertical(), rectF15 != null ? Float.valueOf(rectF15.bottom) : null);
            fArray = fArray2;
        } else {
            fArray = null;
        }
        float[] paddingBoxRadii = fArray;
        float x = PixelUtil.INSTANCE.dpToPx(this.offsetX);
        float y = PixelUtil.INSTANCE.dpToPx(this.offsetY);
        float spreadExtent = PixelUtil.INSTANCE.dpToPx(this.spread);
        RectF $this$draw_u24lambda_u242 = rectF3 = new RectF(paddingBoxRect);
        boolean bl = false;
        $this$draw_u24lambda_u242.inset(spreadExtent, spreadExtent);
        $this$draw_u24lambda_u242.offset(x, y);
        RectF innerRect = rectF3;
        float blurExtent = FilterHelper.INSTANCE.sigmaToRadius$ReactAndroid_release(this.blurRadius);
        RectF $this$draw_u24lambda_u244 = rectF2 = new RectF(paddingBoxRect);
        boolean bl2 = false;
        $this$draw_u24lambda_u244.inset(-blurExtent, -blurExtent);
        if (spreadExtent < 0.0f) {
            $this$draw_u24lambda_u244.inset(spreadExtent, spreadExtent);
        }
        RectF rectF16 = rectF = new RectF($this$draw_u24lambda_u244);
        Object object = $this$draw_u24lambda_u244;
        boolean bl3 = false;
        $this$draw_u24lambda_u244_u24lambda_u243.offset(-x, -y);
        object.union(rectF);
        RectF outerRect = rectF2;
        int saveCount = canvas.save();
        boolean bl4 = false;
        if (paddingBoxRadii != null) {
            void $this$mapTo$iv$iv;
            void $this$draw_u24lambda_u247_u24lambda_u245;
            $this$draw_u24lambda_u244_u24lambda_u243 = rectF = new Path();
            object = canvas;
            boolean bl5 = false;
            $this$draw_u24lambda_u247_u24lambda_u245.addRoundRect(paddingBoxRect, paddingBoxRadii, Path.Direction.CW);
            object.clipPath((Path)rectF);
            float[] $this$map$iv = paddingBoxRadii;
            boolean $i$f$map = false;
            float[] fArray3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var25_30 = item$iv$iv = $this$mapTo$iv$iv[i];
                object = destination$iv$iv;
                boolean bl6 = false;
                object.add(Float.valueOf(BoxShadowBorderRadiusKt.adjustRadiusForSpread((float)it, -spreadExtent)));
            }
            float[] innerRadii = CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
            canvas.drawDoubleRoundRect(outerRect, InsetBoxShadowDrawableKt.access$getZERO_RADII$p(), innerRect, innerRadii, this.shadowPaint);
        } else {
            canvas.clipRect(paddingBoxRect);
            canvas.drawDoubleRoundRect(outerRect, InsetBoxShadowDrawableKt.access$getZERO_RADII$p(), innerRect, InsetBoxShadowDrawableKt.access$getZERO_RADII$p(), this.shadowPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    private final ComputedBorderRadius computeBorderRadii() {
        ComputedBorderRadius resolvedBorderRadii;
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        ComputedBorderRadius computedBorderRadius = resolvedBorderRadii = borderRadiusStyle != null ? borderRadiusStyle.resolve(this.getLayoutDirection(), this.context, PixelUtil.INSTANCE.pxToDp((float)this.getBounds().width()), PixelUtil.INSTANCE.pxToDp((float)this.getBounds().height())) : null;
        return (computedBorderRadius != null ? computedBorderRadius.hasRoundedBorders() : false) ? new ComputedBorderRadius(new CornerRadii(PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getTopLeft().getHorizontal()), PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getTopLeft().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getTopRight().getHorizontal()), PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getTopRight().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getBottomLeft().getHorizontal()), PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getBottomLeft().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getBottomRight().getHorizontal()), PixelUtil.INSTANCE.dpToPx(resolvedBorderRadii.getBottomRight().getVertical()))) : null;
    }

    private final RectF computeBorderInsets() {
        RectF rectF;
        BorderInsets borderInsets = this.borderInsets;
        if (borderInsets != null && (borderInsets = borderInsets.resolve(this.getLayoutDirection(), this.context)) != null) {
            BorderInsets it = borderInsets;
            boolean bl = false;
            rectF = new RectF(PixelUtil.INSTANCE.dpToPx(((RectF)it).left), PixelUtil.INSTANCE.dpToPx(((RectF)it).top), PixelUtil.INSTANCE.dpToPx(((RectF)it).right), PixelUtil.INSTANCE.dpToPx(((RectF)it).bottom));
        } else {
            rectF = null;
        }
        return rectF;
    }

    private final float innerRadius(float radius, Float borderInset) {
        Float f = borderInset;
        return RangesKt.coerceAtLeast((float)(radius - (f != null ? f.floatValue() : 0.0f)), (float)0.0f);
    }
}

