/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper;", "", "<init>", "()V", "Companion", "ScrollCommandHandler", "ScrollToCommandData", "ScrollToEndCommandData", "ReactAndroid_release"})
public final class ReactScrollViewCommandHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int COMMAND_SCROLL_TO = 1;
    public static final int COMMAND_SCROLL_TO_END = 2;
    public static final int COMMAND_FLASH_SCROLL_INDICATORS = 3;

    @JvmStatic
    @NotNull
    public static final Map<String, Integer> getCommandsMap() {
        return Companion.getCommandsMap();
    }

    @JvmStatic
    public static final <T> void receiveCommand(@NotNull ScrollCommandHandler<T> viewManager, T scrollView, int commandType, @Nullable ReadableArray args) {
        Companion.receiveCommand(viewManager, scrollView, commandType, args);
    }

    @JvmStatic
    public static final <T> void receiveCommand(@NotNull ScrollCommandHandler<T> viewManager, T scrollView, @NotNull String commandType, @Nullable ReadableArray args) {
        Companion.receiveCommand(viewManager, scrollView, commandType, args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tH\u0007J;\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\r2\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J;\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\r2\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0016\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0017J1\u0010\u0018\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$Companion;", "", "<init>", "()V", "COMMAND_SCROLL_TO", "", "COMMAND_SCROLL_TO_END", "COMMAND_FLASH_SCROLL_INDICATORS", "getCommandsMap", "", "", "receiveCommand", "", "T", "viewManager", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;", "scrollView", "commandType", "args", "Lcom/facebook/react/bridge/ReadableArray;", "(Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;Ljava/lang/Object;ILcom/facebook/react/bridge/ReadableArray;)V", "(Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;Ljava/lang/Object;Ljava/lang/String;Lcom/facebook/react/bridge/ReadableArray;)V", "scrollTo", "(Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;Ljava/lang/Object;Lcom/facebook/react/bridge/ReadableArray;)V", "scrollToEnd", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Map<String, Integer> getCommandsMap() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"scrollTo", (Object)1), TuplesKt.to((Object)"scrollToEnd", (Object)2), TuplesKt.to((Object)"flashScrollIndicators", (Object)3)};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }

        @JvmStatic
        public final <T> void receiveCommand(@NotNull ScrollCommandHandler<T> viewManager, T scrollView, int commandType, @Nullable ReadableArray args) {
            Intrinsics.checkNotNullParameter(viewManager, (String)"viewManager");
            if (scrollView == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            switch (commandType) {
                case 1: {
                    ReadableArray readableArray = args;
                    if (readableArray == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalStateException(string3.toString());
                    }
                    this.scrollTo(viewManager, scrollView, readableArray);
                    break;
                }
                case 2: {
                    ReadableArray readableArray = args;
                    if (readableArray == null) {
                        String string4 = "Required value was null.";
                        throw new IllegalStateException(string4.toString());
                    }
                    this.scrollToEnd(viewManager, scrollView, readableArray);
                    break;
                }
                case 3: {
                    viewManager.flashScrollIndicators(scrollView);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported command " + commandType + " received by " + viewManager.getClass().getSimpleName() + ".");
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final <T> void receiveCommand(@NotNull ScrollCommandHandler<T> viewManager, T scrollView, @NotNull String commandType, @Nullable ReadableArray args) {
            block9: {
                Intrinsics.checkNotNullParameter(viewManager, (String)"viewManager");
                Intrinsics.checkNotNullParameter((Object)commandType, (String)"commandType");
                if (scrollView == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                String string3 = commandType;
                switch (string3.hashCode()) {
                    case 28425985: {
                        if (!string3.equals("flashScrollIndicators")) {
                            throw new IllegalArgumentException("Unsupported command " + commandType + " received by " + viewManager.getClass().getSimpleName() + ".");
                        }
                        break block9;
                    }
                    case 2055114131: {
                        if (string3.equals("scrollToEnd")) break;
                        throw new IllegalArgumentException("Unsupported command " + commandType + " received by " + viewManager.getClass().getSimpleName() + ".");
                    }
                    case -402165208: {
                        if (!string3.equals("scrollTo")) throw new IllegalArgumentException("Unsupported command " + commandType + " received by " + viewManager.getClass().getSimpleName() + ".");
                        ReadableArray readableArray = args;
                        if (readableArray == null) {
                            String string4 = "Required value was null.";
                            throw new IllegalStateException(string4.toString());
                        }
                        this.scrollTo(viewManager, scrollView, readableArray);
                        return;
                    }
                }
                ReadableArray readableArray = args;
                if (readableArray == null) {
                    String string5 = "Required value was null.";
                    throw new IllegalStateException(string5.toString());
                }
                this.scrollToEnd(viewManager, scrollView, readableArray);
                return;
            }
            viewManager.flashScrollIndicators(scrollView);
            return;
            throw new IllegalArgumentException("Unsupported command " + commandType + " received by " + viewManager.getClass().getSimpleName() + ".");
        }

        private final <T> void scrollTo(ScrollCommandHandler<T> viewManager, T scrollView, ReadableArray args) {
            int destX = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(0)));
            int destY = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(1)));
            boolean animated = args.getBoolean(2);
            viewManager.scrollTo(scrollView, new ScrollToCommandData(destX, destY, animated));
        }

        private final <T> void scrollToEnd(ScrollCommandHandler<T> viewManager, T scrollView, ReadableArray args) {
            boolean animated = args.getBoolean(0);
            viewManager.scrollToEnd(scrollView, new ScrollToEndCommandData(animated));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\nH&\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;", "T", "", "scrollTo", "", "scrollView", "data", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToCommandData;", "(Ljava/lang/Object;Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToCommandData;)V", "scrollToEnd", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToEndCommandData;", "(Ljava/lang/Object;Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToEndCommandData;)V", "flashScrollIndicators", "(Ljava/lang/Object;)V", "ReactAndroid_release"})
    public static interface ScrollCommandHandler<T> {
        public void scrollTo(T var1, @NotNull ScrollToCommandData var2);

        public void scrollToEnd(T var1, @NotNull ScrollToEndCommandData var2);

        public void flashScrollIndicators(T var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToCommandData;", "", "mDestX", "", "mDestY", "mAnimated", "", "<init>", "(IIZ)V", "ReactAndroid_release"})
    public static final class ScrollToCommandData {
        @JvmField
        public final int mDestX;
        @JvmField
        public final int mDestY;
        @JvmField
        public final boolean mAnimated;

        public ScrollToCommandData(int mDestX, int mDestY, boolean mAnimated) {
            this.mDestX = mDestX;
            this.mDestY = mDestY;
            this.mAnimated = mAnimated;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToEndCommandData;", "", "mAnimated", "", "<init>", "(Z)V", "ReactAndroid_release"})
    public static final class ScrollToEndCommandData {
        @JvmField
        public final boolean mAnimated;

        public ScrollToEndCommandData(boolean mAnimated) {
            this.mAnimated = mAnimated;
        }
    }
}

