/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Shader;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.style.Gradient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "", "gradientMap", "Lcom/facebook/react/bridge/ReadableMap;", "context", "Landroid/content/Context;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Landroid/content/Context;)V", "gradient", "Lcom/facebook/react/uimanager/style/Gradient;", "getShader", "Landroid/graphics/Shader;", "bounds", "Landroid/graphics/Rect;", "ReactAndroid_debug"})
public final class BackgroundImageLayer {
    @Nullable
    private final Gradient gradient;

    public BackgroundImageLayer(@Nullable ReadableMap gradientMap, @NotNull Context context) {
        Gradient gradient;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BackgroundImageLayer backgroundImageLayer = this;
        if (gradientMap != null) {
            Gradient gradient2;
            BackgroundImageLayer backgroundImageLayer2 = backgroundImageLayer;
            try {
                backgroundImageLayer = backgroundImageLayer2;
                gradient2 = new Gradient(gradientMap, context);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                backgroundImageLayer = backgroundImageLayer2;
                gradient2 = null;
            }
            gradient = gradient2;
        } else {
            gradient = null;
        }
        backgroundImageLayer.gradient = gradient;
    }

    @Nullable
    public final Shader getShader(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Gradient gradient = this.gradient;
        return gradient != null ? gradient.getShader(bounds) : null;
    }
}

