/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.os.SystemClock;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.views.scroll.ScrollEventType;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016Jb\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/views/scroll/ScrollEvent;", "Lcom/facebook/react/uimanager/events/Event;", "<init>", "()V", "scrollX", "", "scrollY", "xVelocity", "yVelocity", "contentWidth", "", "contentHeight", "scrollViewWidth", "scrollViewHeight", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "timestamp", "", "onDispose", "", "init", "surfaceId", "viewTag", "getEventName", "", "canCoalesce", "", "getEventData", "Lcom/facebook/react/bridge/WritableMap;", "Companion", "ReactAndroid_debug"})
public final class ScrollEvent
extends Event<ScrollEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float scrollX;
    private float scrollY;
    private float xVelocity;
    private float yVelocity;
    private int contentWidth;
    private int contentHeight;
    private int scrollViewWidth;
    private int scrollViewHeight;
    @Nullable
    private ScrollEventType scrollEventType;
    private long timestamp;
    private static final String TAG = ScrollEvent.class.getSimpleName();
    @NotNull
    private static final Pools.SynchronizedPool<ScrollEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);

    private ScrollEvent() {
    }

    @Override
    public void onDispose() {
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            ReactSoftExceptionLogger.logSoftException(string2, e);
        }
    }

    private final void init(int surfaceId, int viewTag, ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        super.init(surfaceId, viewTag);
        this.scrollEventType = scrollEventType;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.xVelocity = xVelocity;
        this.yVelocity = yVelocity;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        this.scrollViewWidth = scrollViewWidth;
        this.scrollViewHeight = scrollViewHeight;
        this.timestamp = SystemClock.uptimeMillis();
    }

    @Override
    @NotNull
    public String getEventName() {
        Object object = Assertions.assertNotNull((Object)((Object)this.scrollEventType));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
        return ScrollEventType.Companion.getJSEventName((ScrollEventType)((Object)object));
    }

    @Override
    public boolean canCoalesce() {
        return this.scrollEventType == ScrollEventType.SCROLL;
    }

    @Override
    @NotNull
    protected WritableMap getEventData() {
        WritableMap contentInset = Arguments.createMap();
        contentInset.putDouble("top", 0.0);
        contentInset.putDouble("bottom", 0.0);
        contentInset.putDouble("left", 0.0);
        contentInset.putDouble("right", 0.0);
        WritableMap contentOffset = Arguments.createMap();
        contentOffset.putDouble("x", PixelUtil.toDIPFromPixel(this.scrollX));
        contentOffset.putDouble("y", PixelUtil.toDIPFromPixel(this.scrollY));
        WritableMap contentSize = Arguments.createMap();
        contentSize.putDouble("width", PixelUtil.toDIPFromPixel(this.contentWidth));
        contentSize.putDouble("height", PixelUtil.toDIPFromPixel(this.contentHeight));
        WritableMap layoutMeasurement = Arguments.createMap();
        layoutMeasurement.putDouble("width", PixelUtil.toDIPFromPixel(this.scrollViewWidth));
        layoutMeasurement.putDouble("height", PixelUtil.toDIPFromPixel(this.scrollViewHeight));
        WritableMap velocity = Arguments.createMap();
        velocity.putDouble("x", this.xVelocity);
        velocity.putDouble("y", this.yVelocity);
        WritableMap event = Arguments.createMap();
        event.putMap("contentInset", contentInset);
        event.putMap("contentOffset", contentOffset);
        event.putMap("contentSize", contentSize);
        event.putMap("layoutMeasurement", layoutMeasurement);
        event.putMap("velocity", velocity);
        event.putInt("target", this.getViewTag());
        event.putDouble("timestamp", this.timestamp);
        event.putBoolean("responderIgnoreScroll", true);
        Intrinsics.checkNotNull((Object)event);
        return event;
    }

    @JvmStatic
    @NotNull
    public static final ScrollEvent obtain(int surfaceId, int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        return Companion.obtain(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
    }

    @Deprecated(message="Use the obtain version that explicitly takes surfaceId as an argument", replaceWith=@ReplaceWith(expression="obtain(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight)", imports={}))
    @JvmStatic
    @NotNull
    public static final ScrollEvent obtain(int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        return Companion.obtain(viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
    }

    public /* synthetic */ ScrollEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jb\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0007JZ\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/views/scroll/ScrollEvent$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "EVENTS_POOL", "Landroidx/core/util/Pools$SynchronizedPool;", "Lcom/facebook/react/views/scroll/ScrollEvent;", "obtain", "surfaceId", "", "viewTag", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "scrollX", "", "scrollY", "xVelocity", "yVelocity", "contentWidth", "contentHeight", "scrollViewWidth", "scrollViewHeight", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ScrollEvent obtain(int surfaceId, int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
            ScrollEvent scrollEvent;
            ScrollEvent scrollEvent2 = (ScrollEvent)EVENTS_POOL.acquire();
            if (scrollEvent2 == null) {
                scrollEvent2 = new ScrollEvent(null);
            }
            ScrollEvent $this$obtain_u24lambda_u240 = scrollEvent = scrollEvent2;
            boolean bl = false;
            $this$obtain_u24lambda_u240.init(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
            return scrollEvent;
        }

        @Deprecated(message="Use the obtain version that explicitly takes surfaceId as an argument", replaceWith=@ReplaceWith(expression="obtain(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight)", imports={}))
        @JvmStatic
        @NotNull
        public final ScrollEvent obtain(int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
            return this.obtain(-1, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

