/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u000e\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/views/view/CanvasUtil;", "", "<init>", "()V", "reorderBarrierMethod", "Ljava/lang/reflect/Method;", "inorderBarrierMethod", "orderMethodsFetched", "", "enableZ", "", "canvas", "Landroid/graphics/Canvas;", "enable", "fetchOrderMethods", "ReactAndroid_release"})
public final class CanvasUtil {
    @NotNull
    public static final CanvasUtil INSTANCE = new CanvasUtil();
    @Nullable
    private static Method reorderBarrierMethod;
    @Nullable
    private static Method inorderBarrierMethod;
    private static boolean orderMethodsFetched;

    private CanvasUtil() {
    }

    @JvmStatic
    @SuppressLint(value={"SoonBlockedPrivateApi", "PrivateApi"})
    public static final void enableZ(@NotNull Canvas canvas, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (Build.VERSION.SDK_INT >= 29) {
            if (enable) {
                canvas.enableZ();
            } else {
                canvas.disableZ();
            }
        } else {
            INSTANCE.fetchOrderMethods();
            try {
                if (enable && reorderBarrierMethod != null) {
                    Method method = reorderBarrierMethod;
                    if (method == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalStateException(string2.toString());
                    }
                    method.invoke((Object)canvas, new Object[0]);
                }
                if (!enable && inorderBarrierMethod != null) {
                    Method method = inorderBarrierMethod;
                    if (method == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalStateException(string3.toString());
                    }
                    method.invoke((Object)canvas, new Object[0]);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private final void fetchOrderMethods() {
        if (!orderMethodsFetched) {
            try {
                Method method;
                if (Build.VERSION.SDK_INT == 28) {
                    Class[] classArray = new Class[]{String.class, Object[].class};
                    Method getDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", classArray);
                    Object[] objectArray = new Object[]{"insertReorderBarrier", new Class[0]};
                    Object object = getDeclaredMethod.invoke(Canvas.class, objectArray);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.reflect.Method");
                    reorderBarrierMethod = (Method)object;
                    objectArray = new Object[]{"insertInorderBarrier", new Class[0]};
                    Object object2 = getDeclaredMethod.invoke(Canvas.class, objectArray);
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.lang.reflect.Method");
                    inorderBarrierMethod = (Method)object2;
                } else {
                    reorderBarrierMethod = Canvas.class.getDeclaredMethod("insertReorderBarrier", new Class[0]);
                    inorderBarrierMethod = Canvas.class.getDeclaredMethod("insertInorderBarrier", new Class[0]);
                }
                if (reorderBarrierMethod == null || inorderBarrierMethod == null) {
                    return;
                }
                Method method2 = reorderBarrierMethod;
                if (method2 != null) {
                    method2.setAccessible(true);
                }
                Method method3 = method = inorderBarrierMethod;
                if (method3 != null) {
                    method3.setAccessible(true);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            orderMethodsFetched = true;
        }
    }
}

