/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import com.facebook.react.modules.network.CookieJarContainer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/modules/network/ReactCookieJarContainer;", "Lcom/facebook/react/modules/network/CookieJarContainer;", "<init>", "()V", "cookieJar", "Lokhttp3/CookieJar;", "setCookieJar", "", "removeCookieJar", "saveFromResponse", "url", "Lokhttp3/HttpUrl;", "cookies", "", "Lokhttp3/Cookie;", "loadForRequest", "ReactAndroid_debug"})
public final class ReactCookieJarContainer
implements CookieJarContainer {
    @Nullable
    private CookieJar cookieJar;

    @Override
    public void setCookieJar(@NotNull CookieJar cookieJar) {
        Intrinsics.checkNotNullParameter((Object)cookieJar, (String)"cookieJar");
        this.cookieJar = cookieJar;
    }

    @Override
    public void removeCookieJar() {
        this.cookieJar = null;
    }

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
            CookieJar cookieJar = this.cookieJar;
            if (cookieJar == null) break block0;
            cookieJar.saveFromResponse(url, cookies);
        }
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CookieJar cookieJar = this.cookieJar;
        if (cookieJar == null) {
            return CollectionsKt.emptyList();
        }
        CookieJar cookieJar2 = cookieJar;
        List cookies = cookieJar2.loadForRequest(url);
        ArrayList<Cookie> validatedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            try {
                Headers.Builder cookieChecker = new Headers.Builder();
                cookieChecker.add(cookie.-deprecated_name(), cookie.-deprecated_value());
                validatedCookies.add(cookie);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return validatedCookies;
    }
}

