/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.react.uimanager.events.TouchesHelper;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0007JJ\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0017J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010$\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020!H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006+"}, d2={"Lcom/facebook/react/uimanager/events/TouchEvent;", "Lcom/facebook/react/uimanager/events/Event;", "<init>", "()V", "motionEvent", "Landroid/view/MotionEvent;", "touchEventType", "Lcom/facebook/react/uimanager/events/TouchEventType;", "coalescingKey", "", "value", "", "viewX", "getViewX", "()F", "viewY", "getViewY", "getMotionEvent", "getTouchEventType", "init", "", "surfaceId", "", "viewTag", "motionEventToCopy", "gestureStartTime", "", "touchEventCoalescingKeyHelper", "Lcom/facebook/react/uimanager/events/TouchEventCoalescingKeyHelper;", "onDispose", "getEventName", "", "canCoalesce", "", "getCoalescingKey", "dispatch", "rctEventEmitter", "Lcom/facebook/react/uimanager/events/RCTEventEmitter;", "dispatchModern", "Lcom/facebook/react/uimanager/events/RCTModernEventEmitter;", "getEventCategory", "verifyMotionEvent", "Companion", "ReactAndroid_debug"})
public final class TouchEvent
extends Event<TouchEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private MotionEvent motionEvent;
    @Nullable
    private TouchEventType touchEventType;
    private short coalescingKey;
    private float viewX;
    private float viewY;
    private static final String TAG = TouchEvent.class.getSimpleName();
    private static final int TOUCH_EVENTS_POOL_SIZE = 3;
    @NotNull
    private static final Pools.SynchronizedPool<TouchEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);
    public static final long UNSET = Long.MIN_VALUE;

    private TouchEvent() {
    }

    public final float getViewX() {
        return this.viewX;
    }

    public final float getViewY() {
        return this.viewY;
    }

    @NotNull
    public final MotionEvent getMotionEvent() {
        Object object = Assertions.assertNotNull((Object)this.motionEvent);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
        return (MotionEvent)object;
    }

    @NotNull
    public final TouchEventType getTouchEventType() {
        Object object = Assertions.assertNotNull((Object)((Object)this.touchEventType));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
        return (TouchEventType)((Object)object);
    }

    private final void init(int surfaceId, int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        super.init(surfaceId, viewTag, motionEventToCopy.getEventTime());
        SoftAssertions.assertCondition(gestureStartTime != Long.MIN_VALUE, "Gesture start time must be initialized");
        short coalescingKey = 0;
        int action = motionEventToCopy.getAction() & 0xFF;
        switch (action) {
            case 0: {
                touchEventCoalescingKeyHelper.addCoalescingKey(gestureStartTime);
                break;
            }
            case 1: {
                touchEventCoalescingKeyHelper.removeCoalescingKey(gestureStartTime);
                break;
            }
            case 5: 
            case 6: {
                touchEventCoalescingKeyHelper.incrementCoalescingKey(gestureStartTime);
                break;
            }
            case 2: {
                coalescingKey = touchEventCoalescingKeyHelper.getCoalescingKey(gestureStartTime);
                break;
            }
            case 3: {
                touchEventCoalescingKeyHelper.removeCoalescingKey(gestureStartTime);
                break;
            }
        }
        this.motionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        this.touchEventType = touchEventType;
        this.coalescingKey = coalescingKey;
        this.viewX = viewX;
        this.viewY = viewY;
    }

    @Override
    public void onDispose() {
        MotionEvent motionEvent = this.motionEvent;
        if (motionEvent != null) {
            motionEvent.recycle();
        }
        this.motionEvent = null;
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            ReactSoftExceptionLogger.logSoftException(string2, e);
        }
    }

    @Override
    @NotNull
    public String getEventName() {
        Object object = Assertions.assertNotNull((Object)((Object)this.touchEventType));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
        return TouchEventType.Companion.getJSEventName((TouchEventType)((Object)object));
    }

    @Override
    public boolean canCoalesce() {
        TouchEventType touchEventType = (TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.touchEventType)));
        return switch (touchEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[touchEventType.ordinal()]) {
            case 1, 2, 3 -> false;
            case 4 -> true;
            default -> throw new RuntimeException("Unknown touch event type: " + this.touchEventType);
        };
    }

    @Override
    public short getCoalescingKey() {
        return this.coalescingKey;
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    public void dispatch(@NotNull RCTEventEmitter rctEventEmitter) {
        Intrinsics.checkNotNullParameter((Object)rctEventEmitter, (String)"rctEventEmitter");
        if (this.verifyMotionEvent()) {
            TouchesHelper.sendTouchesLegacy(rctEventEmitter, this);
        }
    }

    @Override
    public void dispatchModern(@NotNull RCTModernEventEmitter rctEventEmitter) {
        Intrinsics.checkNotNullParameter((Object)rctEventEmitter, (String)"rctEventEmitter");
        if (this.verifyMotionEvent()) {
            rctEventEmitter.receiveTouches(this);
        }
    }

    @Override
    public int getEventCategory() {
        TouchEventType touchEventType = this.touchEventType;
        if (touchEventType == null) {
            return 2;
        }
        TouchEventType type = touchEventType;
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> 0;
            case 2, 3 -> 1;
            case 4 -> 4;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean verifyMotionEvent() {
        if (this.motionEvent == null) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            ReactSoftExceptionLogger.logSoftException(string2, new IllegalStateException("Cannot dispatch a TouchEvent that has no MotionEvent; the TouchEvent has been recycled"));
            return false;
        }
        return true;
    }

    @Deprecated(message="Please use the other overload of the obtain method, which explicitly provides surfaceId", replaceWith=@ReplaceWith(expression="obtain(surfaceId, ...)", imports={}))
    @JvmStatic
    @NotNull
    public static final TouchEvent obtain(int viewTag, @Nullable TouchEventType touchEventType, @Nullable MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, @NotNull TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        return Companion.obtain(viewTag, touchEventType, motionEventToCopy, gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
    }

    @JvmStatic
    @NotNull
    public static final TouchEvent obtain(int surfaceId, int viewTag, @Nullable TouchEventType touchEventType, @Nullable MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, @NotNull TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        return Companion.obtain(surfaceId, viewTag, touchEventType, motionEventToCopy, gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
    }

    public /* synthetic */ TouchEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0007JL\u0010\u000f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/uimanager/events/TouchEvent$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "TOUCH_EVENTS_POOL_SIZE", "", "EVENTS_POOL", "Landroidx/core/util/Pools$SynchronizedPool;", "Lcom/facebook/react/uimanager/events/TouchEvent;", "UNSET", "", "obtain", "viewTag", "touchEventType", "Lcom/facebook/react/uimanager/events/TouchEventType;", "motionEventToCopy", "Landroid/view/MotionEvent;", "gestureStartTime", "viewX", "", "viewY", "touchEventCoalescingKeyHelper", "Lcom/facebook/react/uimanager/events/TouchEventCoalescingKeyHelper;", "surfaceId", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Please use the other overload of the obtain method, which explicitly provides surfaceId", replaceWith=@ReplaceWith(expression="obtain(surfaceId, ...)", imports={}))
        @JvmStatic
        @NotNull
        public final TouchEvent obtain(int viewTag, @Nullable TouchEventType touchEventType, @Nullable MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, @NotNull TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
            Intrinsics.checkNotNullParameter((Object)touchEventCoalescingKeyHelper, (String)"touchEventCoalescingKeyHelper");
            return this.obtain(-1, viewTag, touchEventType, (MotionEvent)Assertions.assertNotNull((Object)motionEventToCopy), gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
        }

        @JvmStatic
        @NotNull
        public final TouchEvent obtain(int surfaceId, int viewTag, @Nullable TouchEventType touchEventType, @Nullable MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, @NotNull TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
            Intrinsics.checkNotNullParameter((Object)touchEventCoalescingKeyHelper, (String)"touchEventCoalescingKeyHelper");
            TouchEvent event = (TouchEvent)EVENTS_POOL.acquire();
            if (event == null) {
                event = new TouchEvent(null);
            }
            Object object = Assertions.assertNotNull((Object)motionEventToCopy);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
            event.init(surfaceId, viewTag, touchEventType, (MotionEvent)object, gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
            return event;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TouchEventType.values().length];
            try {
                nArray[TouchEventType.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchEventType.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchEventType.CANCEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchEventType.MOVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

