/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.content.Context;
import android.graphics.Shader;
import androidx.core.graphics.ColorUtils;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.style.ColorStop;
import com.facebook.react.uimanager.style.ProcessedColorStop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0016H\u0002J,\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J3\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010 \u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u0004\u0018\u00010\u00132\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010 \u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient;", "", "directionMap", "Lcom/facebook/react/bridge/ReadableMap;", "colorStopsArray", "Lcom/facebook/react/bridge/ReadableArray;", "context", "Landroid/content/Context;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/bridge/ReadableArray;Landroid/content/Context;)V", "direction", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "colorStops", "Ljava/util/ArrayList;", "Lcom/facebook/react/uimanager/style/ColorStop;", "Lkotlin/collections/ArrayList;", "getShader", "Landroid/graphics/Shader;", "width", "", "height", "getAngleForKeyword", "", "keyword", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "endPointsFromAngle", "Lkotlin/Pair;", "", "angle", "getFixedColorStops", "", "Lcom/facebook/react/uimanager/style/ProcessedColorStop;", "gradientLineLength", "(Ljava/util/ArrayList;F)[Lcom/facebook/react/uimanager/style/ProcessedColorStop;", "processColorTransitionHints", "", "originalStops", "([Lcom/facebook/react/uimanager/style/ProcessedColorStop;)Ljava/util/List;", "resolveColorStopPosition", "position", "Lcom/facebook/react/uimanager/LengthPercentage;", "(Lcom/facebook/react/uimanager/LengthPercentage;F)Ljava/lang/Float;", "Direction", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nLinearGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearGradient.kt\ncom/facebook/react/uimanager/style/LinearGradient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1872#2,3:365\n1#3:368\n*S KotlinDebug\n*F\n+ 1 LinearGradient.kt\ncom/facebook/react/uimanager/style/LinearGradient\n*L\n111#1:365,3\n*E\n"})
public final class LinearGradient {
    @NotNull
    private final ReadableArray colorStopsArray;
    @NotNull
    private final Context context;
    @NotNull
    private final Direction direction;
    @NotNull
    private final ArrayList<ColorStop> colorStops;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LinearGradient(@NotNull ReadableMap directionMap, @NotNull ReadableArray colorStopsArray, @NotNull Context context) {
        void $this$colorStops_u24lambda_u240;
        Direction direction;
        block18: {
            String type;
            block17: {
                Intrinsics.checkNotNullParameter((Object)directionMap, (String)"directionMap");
                Intrinsics.checkNotNullParameter((Object)colorStopsArray, (String)"colorStopsArray");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.colorStopsArray = colorStopsArray;
                this.context = context;
                type = directionMap.getString("type");
                if (!Intrinsics.areEqual((Object)type, (Object)"angle")) break block17;
                double angle = directionMap.getDouble("value");
                direction = new Direction.Angle(angle);
                break block18;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"keyword")) throw new IllegalArgumentException("Invalid direction type: " + type);
            String string2 = directionMap.getString("value");
            if (string2 == null) throw new IllegalArgumentException("Invalid linear gradient direction keyword: " + directionMap.getString("value"));
            int n = -1;
            switch (string2.hashCode()) {
                case -1359525897: {
                    if (string2.equals("to top left")) {
                        n = 1;
                    }
                    break;
                }
                case 810031148: {
                    if (string2.equals("to top right")) {
                        n = 2;
                    }
                    break;
                }
                case -1507310228: {
                    if (string2.equals("to bottom right")) {
                        n = 3;
                    }
                    break;
                }
                case -1849920841: {
                    if (string2.equals("to bottom left")) {
                        n = 4;
                    }
                    break;
                }
            }
            Direction.Keywords keyword = switch (n) {
                case 2 -> Direction.Keywords.TO_TOP_RIGHT;
                case 3 -> Direction.Keywords.TO_BOTTOM_RIGHT;
                case 1 -> Direction.Keywords.TO_TOP_LEFT;
                case 4 -> Direction.Keywords.TO_BOTTOM_LEFT;
                default -> throw new IllegalArgumentException("Invalid linear gradient direction keyword: " + directionMap.getString("value"));
            };
            direction = new Direction.Keyword(keyword);
        }
        this.direction = direction;
        LinearGradient keyword = this;
        LinearGradient linearGradient = this;
        boolean bl = false;
        ArrayList<ColorStop> stops = new ArrayList<ColorStop>($this$colorStops_u24lambda_u240.colorStopsArray.size());
        int n = $this$colorStops_u24lambda_u240.colorStopsArray.size();
        for (int i = 0; i < n; ++i) {
            ReadableMap colorStop;
            if ($this$colorStops_u24lambda_u240.colorStopsArray.getMap(i) == null) continue;
            Integer color = !colorStop.hasKey("color") || colorStop.isNull("color") ? null : (colorStop.getType("color") == ReadableType.Map ? ColorPropConverter.getColor(colorStop.getMap("color"), $this$colorStops_u24lambda_u240.context) : Integer.valueOf(colorStop.getInt("color")));
            LengthPercentage position = LengthPercentage.Companion.setFromDynamic(colorStop.getDynamic("position"));
            stops.add(new ColorStop(color, position));
        }
        linearGradient.colorStops = stops;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shader getShader(float width, float height) {
        double d;
        Pair<float[], float[]> pair = this.direction;
        if (pair instanceof Direction.Angle) {
            d = ((Direction.Angle)this.direction).getValue();
        } else if (pair instanceof Direction.Keyword) {
            d = this.getAngleForKeyword(((Direction.Keyword)this.direction).getValue(), width, height);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double angle = d;
        pair = this.endPointsFromAngle(angle, height, width);
        float[] startPoint = (float[])pair.component1();
        float[] endPoint = (float[])pair.component2();
        float dx = endPoint[0] - startPoint[0];
        float dy = endPoint[1] - startPoint[1];
        float gradientLineLength = (float)Math.sqrt(dx * dx + dy * dy);
        ProcessedColorStop[] processedColorStops = this.getFixedColorStops(this.colorStops, gradientLineLength);
        List<ProcessedColorStop> finalStops = this.processColorTransitionHints(processedColorStops);
        int[] colors = new int[finalStops.size()];
        float[] positions = new float[finalStops.size()];
        Iterable $this$forEachIndexed$iv = finalStops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void colorStop;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProcessedColorStop processedColorStop = (ProcessedColorStop)item$iv;
            int i = n;
            boolean bl = false;
            Integer color = colorStop.getColor();
            if (color == null || colorStop.getPosition() == null) continue;
            colors[i] = color;
            positions[i] = colorStop.getPosition().floatValue();
        }
        return (Shader)new android.graphics.LinearGradient(startPoint[0], startPoint[1], endPoint[0], endPoint[1], colors, positions, Shader.TileMode.CLAMP);
    }

    private final double getAngleForKeyword(Direction.Keywords keyword, double width, double height) {
        return switch (WhenMappings.$EnumSwitchMapping$0[keyword.ordinal()]) {
            case 1 -> {
                double angleDeg = Math.toDegrees(Math.atan(width / height));
                yield (double)90 - angleDeg;
            }
            case 2 -> Math.toDegrees(Math.atan(width / height)) + (double)90;
            case 3 -> Math.toDegrees(Math.atan(width / height)) + (double)270;
            case 4 -> Math.toDegrees(Math.atan(height / width)) + (double)180;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Pair<float[], float[]> endPointsFromAngle(double angle, float height, float width) {
        float[] fArray;
        double d;
        double adjustedAngle = angle % (double)360;
        if (adjustedAngle < 0.0) {
            adjustedAngle += (double)360;
        }
        if ((d = adjustedAngle) == 0.0) {
            float[] fArray2 = new float[]{0.0f, height};
            float[] fArray3 = fArray2;
            fArray2 = new float[]{0.0f, 0.0f};
            return new Pair((Object)fArray3, (Object)fArray2);
        }
        if (d == 90.0) {
            float[] fArray4 = new float[]{0.0f, 0.0f};
            float[] fArray5 = fArray4;
            fArray4 = new float[]{width, 0.0f};
            return new Pair((Object)fArray5, (Object)fArray4);
        }
        if (d == 180.0) {
            float[] fArray6 = new float[]{0.0f, 0.0f};
            float[] fArray7 = fArray6;
            fArray6 = new float[]{0.0f, height};
            return new Pair((Object)fArray7, (Object)fArray6);
        }
        if (d == 270.0) {
            float[] fArray8 = new float[]{width, 0.0f};
            float[] fArray9 = fArray8;
            fArray8 = new float[]{0.0f, 0.0f};
            return new Pair((Object)fArray9, (Object)fArray8);
        }
        float slope = (float)Math.tan(Math.toRadians((double)90 - adjustedAngle));
        float perpendicularSlope = (float)-1 / slope;
        float halfHeight = height / (float)2;
        float halfWidth = width / (float)2;
        if (adjustedAngle < 90.0) {
            var12_14 = new float[]{halfWidth, halfHeight};
            fArray = var12_14;
        } else if (adjustedAngle < 180.0) {
            var12_14 = new float[]{halfWidth, -halfHeight};
            fArray = var12_14;
        } else if (adjustedAngle < 270.0) {
            var12_14 = new float[]{-halfWidth, -halfHeight};
            fArray = var12_14;
        } else {
            var12_14 = new float[]{-halfWidth, halfHeight};
            fArray = var12_14;
        }
        float[] endCorner = fArray;
        float c = endCorner[1] - perpendicularSlope * endCorner[0];
        float endX = c / (slope - perpendicularSlope);
        float endY = perpendicularSlope * endX + c;
        float[] fArray10 = new float[]{halfWidth + endX, halfHeight - endY};
        float[] secondPoint = fArray10;
        float[] fArray11 = new float[]{halfWidth - endX, halfHeight + endY};
        float[] firstPoint = fArray11;
        return new Pair((Object)firstPoint, (Object)secondPoint);
    }

    private final ProcessedColorStop[] getFixedColorStops(ArrayList<ColorStop> colorStops, float gradientLineLength) {
        int n;
        int n2 = 0;
        int n3 = colorStops.size();
        ProcessedColorStop[] processedColorStopArray = new ProcessedColorStop[n3];
        while (n2 < n3) {
            n = n2++;
            processedColorStopArray[n] = new ProcessedColorStop(null, null, 3, null);
        }
        ProcessedColorStop[] fixedColorStops = processedColorStopArray;
        boolean hasNullPositions = false;
        Float f = this.resolveColorStopPosition(colorStops.get(0).getPosition(), gradientLineLength);
        float maxPositionSoFar = f != null ? f.floatValue() : 0.0f;
        n = ((Collection)colorStops).size();
        for (int i = 0; i < n; ++i) {
            ColorStop colorStop;
            Intrinsics.checkNotNullExpressionValue((Object)colorStops.get(i), (String)"get(...)");
            Float newPosition = this.resolveColorStopPosition(colorStop.getPosition(), gradientLineLength);
            Float f2 = newPosition;
            if (f2 == null) {
                int n4 = i;
                f2 = n4 == 0 ? Float.valueOf(0.0f) : (n4 == colorStops.size() - 1 ? Float.valueOf(1.0f) : null);
            }
            if ((newPosition = f2) != null) {
                newPosition = Float.valueOf(Math.max(newPosition.floatValue(), maxPositionSoFar));
                fixedColorStops[i] = new ProcessedColorStop(colorStop.getColor(), newPosition);
                maxPositionSoFar = newPosition.floatValue();
                continue;
            }
            hasNullPositions = true;
        }
        if (hasNullPositions) {
            int lastDefinedIndex = 0;
            int n5 = fixedColorStops.length;
            for (int i = 1; i < n5; ++i) {
                Float startPosition;
                Float endPosition = fixedColorStops[i].getPosition();
                if (endPosition == null) continue;
                int unpositionedStops = i - lastDefinedIndex - 1;
                if (unpositionedStops > 0 && (startPosition = fixedColorStops[lastDefinedIndex].getPosition()) != null) {
                    float increment = (endPosition.floatValue() - startPosition.floatValue()) / (float)(unpositionedStops + 1);
                    int j = 1;
                    if (j <= unpositionedStops) {
                        while (true) {
                            fixedColorStops[lastDefinedIndex + j] = new ProcessedColorStop(colorStops.get(lastDefinedIndex + j).getColor(), Float.valueOf(startPosition.floatValue() + increment * (float)j));
                            if (j == unpositionedStops) break;
                            ++j;
                        }
                    }
                }
                lastDefinedIndex = i;
            }
        }
        return fixedColorStops;
    }

    private final List<ProcessedColorStop> processColorTransitionHints(ProcessedColorStop[] originalStops) {
        List colorStops = ArraysKt.toMutableList((Object[])originalStops);
        int indexOffset = 0;
        int n = originalStops.length - 1;
        for (int i = 1; i < n; ++i) {
            Iterator iterator2;
            int x;
            if (originalStops[i].getColor() != null || (x = i + indexOffset) < 1) continue;
            Float offsetLeft = ((ProcessedColorStop)colorStops.get(x - 1)).getPosition();
            Float offsetRight = ((ProcessedColorStop)colorStops.get(x + 1)).getPosition();
            Float offset = ((ProcessedColorStop)colorStops.get(x)).getPosition();
            if (offsetLeft == null || offsetRight == null || offset == null) continue;
            float leftDist = offset.floatValue() - offsetLeft.floatValue();
            float rightDist = offsetRight.floatValue() - offset.floatValue();
            float totalDist = offsetRight.floatValue() - offsetLeft.floatValue();
            Integer leftColor = ((ProcessedColorStop)colorStops.get(x - 1)).getColor();
            Integer rightColor = ((ProcessedColorStop)colorStops.get(x + 1)).getColor();
            if (FloatUtil.floatsEqual(leftDist, rightDist)) {
                colorStops.remove(x);
                --indexOffset;
                continue;
            }
            if (FloatUtil.floatsEqual(leftDist, 0.0f)) {
                ((ProcessedColorStop)colorStops.get(x)).setColor(rightColor);
                continue;
            }
            if (FloatUtil.floatsEqual(rightDist, 0.0f)) {
                ((ProcessedColorStop)colorStops.get(x)).setColor(leftColor);
                continue;
            }
            ArrayList<ProcessedColorStop> newStops = new ArrayList<ProcessedColorStop>(9);
            if (leftDist > rightDist) {
                for (y = 0; y < 7; ++y) {
                    newStops.add(new ProcessedColorStop(null, Float.valueOf(offsetLeft.floatValue() + leftDist * ((7.0f + (float)y) / 13.0f))));
                }
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offset.floatValue() + rightDist * 0.33333334f)));
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offset.floatValue() + rightDist * 0.6666667f)));
            } else {
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offsetLeft.floatValue() + leftDist * 0.33333334f)));
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offsetLeft.floatValue() + leftDist * 0.6666667f)));
                for (y = 0; y < 7; ++y) {
                    newStops.add(new ProcessedColorStop(null, Float.valueOf(offset.floatValue() + rightDist * ((float)y / 13.0f))));
                }
            }
            float hintRelativeOffset = leftDist / totalDist;
            double logRatio = Math.log(0.5) / (double)((float)Math.log(hintRelativeOffset));
            Intrinsics.checkNotNullExpressionValue(newStops.iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                float pointRelativeOffset;
                float weighting;
                float f;
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                ProcessedColorStop newStop = (ProcessedColorStop)e;
                if (newStop.getPosition() == null || !(!Float.isInfinite(f = (weighting = (float)Math.pow(pointRelativeOffset = (newStop.getPosition().floatValue() - offsetLeft.floatValue()) / totalDist, logRatio))) && !Float.isNaN(f)) || Float.isNaN(weighting)) continue;
                Integer n2 = leftColor;
                if (n2 == null) continue;
                int left = ((Number)n2).intValue();
                boolean bl = false;
                Integer n3 = rightColor;
                if (n3 == null) continue;
                int right = ((Number)n3).intValue();
                boolean bl2 = false;
                newStop.setColor(ColorUtils.blendARGB((int)left, (int)right, (float)weighting));
            }
            colorStops.remove(x);
            colorStops.addAll(x, (Collection)newStops);
            indexOffset += 8;
        }
        return colorStops;
    }

    private final Float resolveColorStopPosition(LengthPercentage position, float gradientLineLength) {
        if (position == null) {
            return null;
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[position.getType().ordinal()]) {
            case 1 -> Float.valueOf(PixelUtil.toPixelFromDIP(position.resolve(0.0f)) / gradientLineLength);
            case 2 -> Float.valueOf(position.resolve(1.0f));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "", "<init>", "()V", "Angle", "Keywords", "Keyword", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Angle;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keyword;", "ReactAndroid_release"})
    private static abstract class Direction {
        private Direction() {
        }

        public /* synthetic */ Direction(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Angle;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "value", "", "<init>", "(D)V", "getValue", "()D", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ReactAndroid_release"})
        public static final class Angle
        extends Direction {
            private final double value;

            public Angle(double value) {
                super(null);
                this.value = value;
            }

            public final double getValue() {
                return this.value;
            }

            public final double component1() {
                return this.value;
            }

            @NotNull
            public final Angle copy(double value) {
                return new Angle(value);
            }

            public static /* synthetic */ Angle copy$default(Angle angle, double d, int n, Object object) {
                if ((n & 1) != 0) {
                    d = angle.value;
                }
                return angle.copy(d);
            }

            @NotNull
            public String toString() {
                return "Angle(value=" + this.value + ")";
            }

            public int hashCode() {
                return Double.hashCode(this.value);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Angle)) {
                    return false;
                }
                Angle angle = (Angle)other;
                return Double.compare(this.value, angle.value) == 0;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keyword;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "value", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "<init>", "(Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;)V", "getValue", "()Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ReactAndroid_release"})
        public static final class Keyword
        extends Direction {
            @NotNull
            private final Keywords value;

            public Keyword(@NotNull Keywords value) {
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final Keywords getValue() {
                return this.value;
            }

            @NotNull
            public final Keywords component1() {
                return this.value;
            }

            @NotNull
            public final Keyword copy(@NotNull Keywords value) {
                Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
                return new Keyword(value);
            }

            public static /* synthetic */ Keyword copy$default(Keyword keyword, Keywords keywords, int n, Object object) {
                if ((n & 1) != 0) {
                    keywords = keyword.value;
                }
                return keyword.copy(keywords);
            }

            @NotNull
            public String toString() {
                return "Keyword(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Keyword)) {
                    return false;
                }
                Keyword keyword = (Keyword)other;
                return this.value == keyword.value;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keywords;", "", "<init>", "(Ljava/lang/String;I)V", "TO_TOP_RIGHT", "TO_BOTTOM_RIGHT", "TO_TOP_LEFT", "TO_BOTTOM_LEFT", "ReactAndroid_release"})
        public static final class Keywords
        extends Enum<Keywords> {
            public static final /* enum */ Keywords TO_TOP_RIGHT = new Keywords();
            public static final /* enum */ Keywords TO_BOTTOM_RIGHT = new Keywords();
            public static final /* enum */ Keywords TO_TOP_LEFT = new Keywords();
            public static final /* enum */ Keywords TO_BOTTOM_LEFT = new Keywords();
            private static final /* synthetic */ Keywords[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Keywords[] values() {
                return (Keywords[])$VALUES.clone();
            }

            public static Keywords valueOf(String value) {
                return Enum.valueOf(Keywords.class, value);
            }

            @NotNull
            public static EnumEntries<Keywords> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = keywordsArray = new Keywords[]{Keywords.TO_TOP_RIGHT, Keywords.TO_BOTTOM_RIGHT, Keywords.TO_TOP_LEFT, Keywords.TO_BOTTOM_LEFT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.Keywords.values().length];
            try {
                nArray[Direction.Keywords.TO_TOP_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Keywords.TO_BOTTOM_RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Keywords.TO_TOP_LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Keywords.TO_BOTTOM_LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LengthPercentageType.values().length];
            try {
                nArray[LengthPercentageType.POINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LengthPercentageType.PERCENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

