/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.viewmanagers.ModalHostViewManagerDelegate;
import com.facebook.react.viewmanagers.ModalHostViewManagerInterface;
import com.facebook.react.views.modal.ReactModalHostView;
import com.facebook.react.views.modal.RequestCloseEvent;
import com.facebook.react.views.modal.ShowEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RCTModalHostView")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u00010B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u001a\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0017J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0014H\u0017J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0014H\u0017J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0014H\u0017J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0014H\u0017J\u001a\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0017J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0014H\u0017J\u001a\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010!H\u0017J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020#H\u0017J\u001a\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(0'H\u0016J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\"\u0010*\u001a\u0004\u0018\u00010(2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/facebook/react/views/modal/ReactModalHostView;", "Lcom/facebook/react/viewmanagers/ModalHostViewManagerInterface;", "<init>", "()V", "delegate", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "getName", "", "createViewInstance", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "onDropViewInstance", "", "view", "setAnimationType", "animationType", "setTransparent", "transparent", "", "setStatusBarTranslucent", "statusBarTranslucent", "setNavigationBarTranslucent", "navigationBarTranslucent", "setHardwareAccelerated", "hardwareAccelerated", "setVisible", "visible", "setPresentationStyle", "value", "setAnimated", "setSupportedOrientations", "Lcom/facebook/react/bridge/ReadableArray;", "setIdentifier", "", "setTestId", "addEventEmitters", "getExportedCustomDirectEventTypeConstants", "", "", "onAfterUpdateTransaction", "updateState", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getDelegate", "Companion", "ReactAndroid_release"})
public final class ReactModalHostManager
extends ViewGroupManager<ReactModalHostView>
implements ModalHostViewManagerInterface<ReactModalHostView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewManagerDelegate<ReactModalHostView> delegate = new ModalHostViewManagerDelegate(this);
    @NotNull
    public static final String REACT_CLASS = "RCTModalHostView";

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @NotNull
    protected ReactModalHostView createViewInstance(@NotNull ThemedReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return new ReactModalHostView(reactContext);
    }

    @Override
    public void onDropViewInstance(@NotNull ReactModalHostView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onDropViewInstance((View)view);
        view.onDropInstance();
    }

    @Override
    @ReactProp(name="animationType")
    public void setAnimationType(@NotNull ReactModalHostView view, @Nullable String animationType) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (animationType != null) {
            view.setAnimationType(animationType);
        }
    }

    @Override
    @ReactProp(name="transparent")
    public void setTransparent(@NotNull ReactModalHostView view, boolean transparent) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setTransparent(transparent);
    }

    @Override
    @ReactProp(name="statusBarTranslucent")
    public void setStatusBarTranslucent(@NotNull ReactModalHostView view, boolean statusBarTranslucent) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setStatusBarTranslucent(statusBarTranslucent);
    }

    @Override
    @ReactProp(name="navigationBarTranslucent")
    public void setNavigationBarTranslucent(@NotNull ReactModalHostView view, boolean navigationBarTranslucent) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNavigationBarTranslucent(navigationBarTranslucent);
    }

    @Override
    @ReactProp(name="hardwareAccelerated")
    public void setHardwareAccelerated(@NotNull ReactModalHostView view, boolean hardwareAccelerated) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setHardwareAccelerated(hardwareAccelerated);
    }

    @Override
    @ReactProp(name="visible")
    public void setVisible(@NotNull ReactModalHostView view, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @Override
    @ReactProp(name="presentationStyle")
    public void setPresentationStyle(@NotNull ReactModalHostView view, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @Override
    @ReactProp(name="animated")
    public void setAnimated(@NotNull ReactModalHostView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @Override
    @ReactProp(name="supportedOrientations")
    public void setSupportedOrientations(@NotNull ReactModalHostView view, @Nullable ReadableArray value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @Override
    @ReactProp(name="identifier")
    public void setIdentifier(@NotNull ReactModalHostView view, int value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @Override
    public void setTestId(@NotNull ReactModalHostView view, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.setTestId((View)view, value);
        view.setDialogRootViewGroupTestId(value);
    }

    @Override
    protected void addEventEmitters(@NotNull ThemedReactContext reactContext, @NotNull ReactModalHostView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        EventDispatcher dispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, view.getId());
        if (dispatcher != null) {
            view.setOnRequestCloseListener(arg_0 -> ReactModalHostManager.addEventEmitters$lambda$0(dispatcher, reactContext, view, arg_0));
            view.setOnShowListener(arg_0 -> ReactModalHostManager.addEventEmitters$lambda$1(dispatcher, reactContext, view, arg_0));
            view.setEventDispatcher(dispatcher);
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map map;
        Map map2 = super.getExportedCustomDirectEventTypeConstants();
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map $this$getExportedCustomDirectEventTypeConstants_u24lambda_u242 = map = map2;
        boolean bl = false;
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u242.put("topRequestClose", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onRequestClose")));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u242.put("topShow", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onShow")));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u242.put("topDismiss", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onDismiss")));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u242.put("topOrientationChange", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onOrientationChange")));
        return map;
    }

    @Override
    protected void onAfterUpdateTransaction(@NotNull ReactModalHostView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onAfterUpdateTransaction((View)view);
        view.showOrUpdate();
    }

    @Override
    @Nullable
    public Object updateState(@NotNull ReactModalHostView view, @NotNull ReactStylesDiffMap props, @NotNull StateWrapper stateWrapper) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)stateWrapper, (String)"stateWrapper");
        view.setStateWrapper(stateWrapper);
        return null;
    }

    @Override
    @NotNull
    public ViewManagerDelegate<ReactModalHostView> getDelegate() {
        return this.delegate;
    }

    private static final void addEventEmitters$lambda$0(EventDispatcher $dispatcher, ThemedReactContext $reactContext, ReactModalHostView $view, DialogInterface it) {
        $dispatcher.dispatchEvent(new RequestCloseEvent(UIManagerHelper.getSurfaceId((Context)$reactContext), $view.getId()));
    }

    private static final void addEventEmitters$lambda$1(EventDispatcher $dispatcher, ThemedReactContext $reactContext, ReactModalHostView $view, DialogInterface it) {
        $dispatcher.dispatchEvent(new ShowEvent(UIManagerHelper.getSurfaceId((Context)$reactContext), $view.getId()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

