/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.os.SystemClock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/views/scroll/OnScrollDispatchHelper;", "", "<init>", "()V", "prevX", "", "prevY", "value", "", "xFlingVelocity", "getXFlingVelocity", "()F", "yFlingVelocity", "getYFlingVelocity", "lastScrollEventTimeMs", "", "onScrollChanged", "", "x", "y", "Companion", "ReactAndroid_release"})
public final class OnScrollDispatchHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int prevX = Integer.MIN_VALUE;
    private int prevY = Integer.MIN_VALUE;
    private float xFlingVelocity;
    private float yFlingVelocity;
    private long lastScrollEventTimeMs = -11L;
    private static final int MIN_EVENT_SEPARATION_MS = 10;

    public final float getXFlingVelocity() {
        return this.xFlingVelocity;
    }

    public final float getYFlingVelocity() {
        return this.yFlingVelocity;
    }

    public final boolean onScrollChanged(int x, int y) {
        boolean shouldDispatch;
        long eventTime = SystemClock.uptimeMillis();
        boolean bl = shouldDispatch = eventTime - this.lastScrollEventTimeMs > 10L || this.prevX != x || this.prevY != y;
        if (eventTime - this.lastScrollEventTimeMs != 0L) {
            this.xFlingVelocity = (float)(x - this.prevX) / (float)(eventTime - this.lastScrollEventTimeMs);
            this.yFlingVelocity = (float)(y - this.prevY) / (float)(eventTime - this.lastScrollEventTimeMs);
        }
        this.lastScrollEventTimeMs = eventTime;
        this.prevX = x;
        this.prevY = y;
        return shouldDispatch;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/scroll/OnScrollDispatchHelper$Companion;", "", "<init>", "()V", "MIN_EVENT_SEPARATION_MS", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

