/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B!\b\u0012\u0012\u0016\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0004\"\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0015\b\u0012\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u0006\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0012\u0010(\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010)\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010-\u001a\u00020#H\u0016J\u0010\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050/H\u0016J\b\u00100\u001a\u00020\u0019H\u0016J\u0013\u00101\u001a\u00020\u00112\b\u00102\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\b\u00103\u001a\u00020\u000fH\u0016R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/facebook/react/bridge/JavaOnlyArray;", "Lcom/facebook/react/bridge/ReadableArray;", "Lcom/facebook/react/bridge/WritableArray;", "values", "", "", "<init>", "([Ljava/lang/Object;)V", "list", "", "(Ljava/util/List;)V", "()V", "backingList", "", "size", "", "isNull", "", "index", "getDouble", "", "getInt", "getLong", "", "getString", "", "getArray", "getBoolean", "getMap", "Lcom/facebook/react/bridge/ReadableMap;", "getDynamic", "Lcom/facebook/react/bridge/Dynamic;", "getType", "Lcom/facebook/react/bridge/ReadableType;", "pushBoolean", "", "value", "pushDouble", "pushInt", "pushLong", "pushString", "pushArray", "array", "pushMap", "map", "pushNull", "toArrayList", "Ljava/util/ArrayList;", "toString", "equals", "other", "hashCode", "Companion", "ReactAndroid_debug"})
public final class JavaOnlyArray
implements ReadableArray,
WritableArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Object> backingList;

    private JavaOnlyArray(Object ... values) {
        this.backingList = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values, values.length));
    }

    private JavaOnlyArray(List<?> list) {
        this.backingList = new ArrayList(list);
    }

    public JavaOnlyArray() {
        this.backingList = new ArrayList();
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean isNull(int index) {
        return this.backingList.get(index) == null;
    }

    @Override
    public double getDouble(int index) {
        Object object = this.backingList.get(index);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        return ((Number)object).doubleValue();
    }

    @Override
    public int getInt(int index) {
        Object object = this.backingList.get(index);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        return ((Number)object).intValue();
    }

    @Override
    public long getLong(int index) {
        Object object = this.backingList.get(index);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        return ((Number)object).longValue();
    }

    @Override
    @Nullable
    public String getString(int index) {
        return (String)this.backingList.get(index);
    }

    @Override
    @Nullable
    public ReadableArray getArray(int index) {
        return (ReadableArray)this.backingList.get(index);
    }

    @Override
    public boolean getBoolean(int index) {
        Object object = this.backingList.get(index);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    @Override
    @Nullable
    public ReadableMap getMap(int index) {
        return (ReadableMap)this.backingList.get(index);
    }

    @Override
    @NotNull
    public Dynamic getDynamic(int index) {
        DynamicFromArray dynamicFromArray = DynamicFromArray.create(this, index);
        Intrinsics.checkNotNullExpressionValue((Object)dynamicFromArray, (String)"create(...)");
        return dynamicFromArray;
    }

    @Override
    @NotNull
    public ReadableType getType(int index) {
        ReadableType readableType;
        Object value = this.backingList.get(index);
        if (value == null) {
            readableType = ReadableType.Null;
        } else if (value instanceof Boolean) {
            readableType = ReadableType.Boolean;
        } else if (value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long) {
            readableType = ReadableType.Number;
        } else if (value instanceof String) {
            readableType = ReadableType.String;
        } else if (value instanceof ReadableArray) {
            readableType = ReadableType.Array;
        } else if (value instanceof ReadableMap) {
            readableType = ReadableType.Map;
        } else {
            throw new IllegalStateException("Invalid type " + value.getClass() + ")");
        }
        return readableType;
    }

    @Override
    public void pushBoolean(boolean value) {
        this.backingList.add(value);
    }

    @Override
    public void pushDouble(double value) {
        this.backingList.add(value);
    }

    @Override
    public void pushInt(int value) {
        this.backingList.add(value);
    }

    @Override
    public void pushLong(long value) {
        this.backingList.add(value);
    }

    @Override
    public void pushString(@Nullable String value) {
        this.backingList.add(value);
    }

    @Override
    public void pushArray(@Nullable ReadableArray array) {
        this.backingList.add(array);
    }

    @Override
    public void pushMap(@Nullable ReadableMap map) {
        this.backingList.add(map);
    }

    @Override
    public void pushNull() {
        this.backingList.add(null);
    }

    @Override
    @NotNull
    public ArrayList<Object> toArrayList() {
        return new ArrayList<Object>((Collection)this.backingList);
    }

    @NotNull
    public String toString() {
        return this.backingList.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        return Intrinsics.areEqual(this.backingList, ((JavaOnlyArray)other).backingList);
    }

    public int hashCode() {
        return ((Object)this.backingList).hashCode();
    }

    @JvmStatic
    @NotNull
    public static final JavaOnlyArray from(@NotNull List<?> list) {
        return Companion.from(list);
    }

    @JvmStatic
    @NotNull
    public static final JavaOnlyArray of(Object ... values) {
        return Companion.of(values);
    }

    @JvmStatic
    @NotNull
    public static final JavaOnlyArray deepClone(@Nullable ReadableArray array) {
        return Companion.deepClone(array);
    }

    public /* synthetic */ JavaOnlyArray(List list, DefaultConstructorMarker $constructor_marker) {
        this(list);
    }

    public /* synthetic */ JavaOnlyArray(Object[] values, DefaultConstructorMarker $constructor_marker) {
        this(values);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007J%\u0010\b\u001a\u00020\u00052\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\n\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/bridge/JavaOnlyArray$Companion;", "", "<init>", "()V", "from", "Lcom/facebook/react/bridge/JavaOnlyArray;", "list", "", "of", "values", "", "([Ljava/lang/Object;)Lcom/facebook/react/bridge/JavaOnlyArray;", "deepClone", "array", "Lcom/facebook/react/bridge/ReadableArray;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JavaOnlyArray from(@NotNull List<?> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            return new JavaOnlyArray(list, null);
        }

        @JvmStatic
        @NotNull
        public final JavaOnlyArray of(Object ... values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return new JavaOnlyArray(Arrays.copyOf(values, values.length), null);
        }

        @JvmStatic
        @NotNull
        public final JavaOnlyArray deepClone(@Nullable ReadableArray array) {
            JavaOnlyArray res = new JavaOnlyArray();
            if (array == null) {
                return res;
            }
            int n = array.size();
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                boolean bl = false;
                ReadableType type = array.getType(i2);
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        res.pushNull();
                        break;
                    }
                    case 2: {
                        res.pushBoolean(array.getBoolean(i2));
                        break;
                    }
                    case 3: {
                        res.pushDouble(array.getDouble(i2));
                        break;
                    }
                    case 4: {
                        res.pushString(array.getString(i2));
                        break;
                    }
                    case 5: {
                        res.pushMap(JavaOnlyMap.Companion.deepClone(array.getMap(i2)));
                        break;
                    }
                    case 6: {
                        res.pushArray(Companion.deepClone(array.getArray(i2)));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return res;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReadableType.values().length];
                try {
                    nArray[ReadableType.Null.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.Boolean.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.Number.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.String.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.Map.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.Array.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

