/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.statusbar;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsetsController;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeStatusBarManagerAndroidSpec;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.statusbar.StatusBarModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.views.view.WindowUtilKt;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="StatusBarManager")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0012\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/modules/statusbar/StatusBarModule;", "Lcom/facebook/fbreact/specs/NativeStatusBarManagerAndroidSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "getTypedExportedConstants", "", "", "", "setColor", "", "colorDouble", "", "animated", "", "setTranslucent", "translucent", "setHidden", "hidden", "setStyle", "style", "Companion", "ReactAndroid_debug"})
public final class StatusBarModule
extends NativeStatusBarManagerAndroidSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HEIGHT_KEY = "HEIGHT";
    @NotNull
    private static final String DEFAULT_BACKGROUND_COLOR_KEY = "DEFAULT_BACKGROUND_COLOR";
    @NotNull
    public static final String NAME = "StatusBarManager";

    public StatusBarModule(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @NotNull
    protected Map<String, Object> getTypedExportedConstants() {
        Object object;
        Activity currentActivity;
        block3: {
            block2: {
                currentActivity = this.getReactApplicationContext().getCurrentActivity();
                object = currentActivity;
                if (object == null || (object = object.getWindow()) == null) break block2;
                int color = object.getStatusBarColor();
                boolean bl = false;
                String string2 = "#%06X";
                Object[] objectArray = new Object[]{0xFFFFFF & color};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                object = string3;
                if (string3 != null) break block3;
            }
            object = "black";
        }
        Object statusBarColor = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)HEIGHT_KEY, (Object)Float.valueOf(PixelUtil.toDIPFromPixel(DisplayMetricsHolder.INSTANCE.getStatusBarHeightPx$ReactAndroid_debug(currentActivity)))), TuplesKt.to((Object)DEFAULT_BACKGROUND_COLOR_KEY, (Object)statusBarColor)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void setColor(double colorDouble, boolean animated) {
        int color = (int)colorDouble;
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        UiThreadUtil.runOnUiThread(new GuardedRunnable(activity, animated, color, reactApplicationContext){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ boolean $animated;
            final /* synthetic */ int $color;
            {
                this.$activity = $activity;
                this.$animated = $animated;
                this.$color = $color;
                super($super_call_param$1);
            }

            public void runGuarded() {
                Window window = this.$activity.getWindow();
                if (window == null) {
                    return;
                }
                Window window2 = window;
                window2.addFlags(Integer.MIN_VALUE);
                if (this.$animated) {
                    int curColor = window2.getStatusBarColor();
                    Object[] objectArray = new Object[]{curColor, this.$color};
                    ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])objectArray);
                    colorAnimation.addUpdateListener(arg_0 -> setColor.1.runGuarded$lambda$0(this.$activity, arg_0));
                    colorAnimation.setDuration(300L).setStartDelay(0L);
                    colorAnimation.start();
                } else {
                    window2.setStatusBarColor(this.$color);
                }
            }

            private static final void runGuarded$lambda$0(Activity $activity, ValueAnimator animator) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                    Window window = $activity.getWindow();
                    if (window == null) break block0;
                    Object object = animator.getAnimatedValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    window.setStatusBarColor(((Integer)object).intValue());
                }
            }
        });
    }

    @Override
    public void setTranslucent(boolean translucent) {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        UiThreadUtil.runOnUiThread(new GuardedRunnable(activity, translucent, reactApplicationContext){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ boolean $translucent;
            {
                this.$activity = $activity;
                this.$translucent = $translucent;
                super($super_call_param$1);
            }

            public void runGuarded() {
                block0: {
                    Window window = this.$activity.getWindow();
                    if (window == null) break block0;
                    WindowUtilKt.setStatusBarTranslucency(window, this.$translucent);
                }
            }
        });
    }

    @Override
    public void setHidden(boolean hidden) {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        UiThreadUtil.runOnUiThread(() -> StatusBarModule.setHidden$lambda$1(activity, hidden));
    }

    @Override
    public void setStyle(@Nullable String style2) {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        UiThreadUtil.runOnUiThread(() -> StatusBarModule.setStyle$lambda$2(activity, style2));
    }

    private static final void setHidden$lambda$1(Activity $activity, boolean $hidden) {
        block0: {
            Window window = $activity.getWindow();
            if (window == null) break block0;
            WindowUtilKt.setStatusBarVisibility(window, $hidden);
        }
    }

    private static final void setStyle$lambda$2(Activity $activity, String $style) {
        Window window = $activity.getWindow();
        if (window == null) {
            return;
        }
        Window window2 = window;
        if (Build.VERSION.SDK_INT > 30) {
            WindowInsetsController windowInsetsController = window2.getInsetsController();
            if (windowInsetsController == null) {
                return;
            }
            WindowInsetsController insetsController = windowInsetsController;
            if (Intrinsics.areEqual((Object)"dark-content", (Object)$style)) {
                insetsController.setSystemBarsAppearance(8, 8);
            } else {
                insetsController.setSystemBarsAppearance(0, 8);
            }
        } else {
            View view = window2.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
            View decorView = view;
            int systemUiVisibilityFlags = decorView.getSystemUiVisibility();
            systemUiVisibilityFlags = Intrinsics.areEqual((Object)"dark-content", (Object)$style) ? systemUiVisibilityFlags | 0x2000 : systemUiVisibilityFlags & 0xFFFFDFFF;
            decorView.setSystemUiVisibility(systemUiVisibilityFlags);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/statusbar/StatusBarModule$Companion;", "", "<init>", "()V", "HEIGHT_KEY", "", "DEFAULT_BACKGROUND_COLOR_KEY", "NAME", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

