/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/animated/MultiplicationAnimatedNode;", "Lcom/facebook/react/animated/ValueAnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "inputNodes", "", "update", "", "prettyPrint", "", "ReactAndroid_release"})
public final class MultiplicationAnimatedNode
extends ValueAnimatedNode {
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    @NotNull
    private int[] inputNodes;

    public MultiplicationAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        super(null, 1, null);
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        ReadableArray input = config.getArray("input");
        MultiplicationAnimatedNode multiplicationAnimatedNode = this;
        if (input == null) {
            nArray = new int[]{};
        } else {
            int n = 0;
            int n2 = input.size();
            int[] nArray2 = new int[n2];
            MultiplicationAnimatedNode multiplicationAnimatedNode2 = multiplicationAnimatedNode;
            while (n < n2) {
                int n3 = n++;
                nArray2[n3] = input.getInt(n3);
            }
            multiplicationAnimatedNode = multiplicationAnimatedNode2;
            nArray = nArray2;
        }
        multiplicationAnimatedNode.inputNodes = nArray;
    }

    @Override
    public void update() {
        this.nodeValue = 1.0;
        int n = this.inputNodes.length;
        for (int i = 0; i < n; ++i) {
            AnimatedNode animatedNode = this.nativeAnimatedNodesManager.getNodeById(this.inputNodes[i]);
            if (animatedNode == null || !(animatedNode instanceof ValueAnimatedNode)) {
                throw new JSApplicationCausedNativeException("Illegal node ID set as an input for Animated.multiply node");
            }
            double multiplier = ((ValueAnimatedNode)animatedNode).getValue();
            this.nodeValue *= multiplier;
        }
    }

    @Override
    @NotNull
    public String prettyPrint() {
        return "MultiplicationAnimatedNode[" + this.tag + "]: input nodes: " + this.inputNodes + " - super: " + super.prettyPrint();
    }
}

