/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u0013\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/animated/ObjectAnimatedNode;", "Lcom/facebook/react/animated/AnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "configClone", "Lcom/facebook/react/bridge/JavaOnlyMap;", "collectViewUpdates", "", "propKey", "", "propsMap", "collectViewUpdatesHelper", "Lcom/facebook/react/bridge/JavaOnlyArray;", "source", "Lcom/facebook/react/bridge/ReadableArray;", "prettyPrint", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nObjectAnimatedNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectAnimatedNode.kt\ncom/facebook/react/animated/ObjectAnimatedNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class ObjectAnimatedNode
extends AnimatedNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    @NotNull
    private final JavaOnlyMap configClone;
    @NotNull
    private static final String VALUE_KEY = "value";
    @NotNull
    private static final String NODE_TAG_KEY = "nodeTag";

    public ObjectAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.configClone = JavaOnlyMap.Companion.deepClone(config);
    }

    public final void collectViewUpdates(@NotNull String propKey, @NotNull JavaOnlyMap propsMap) {
        Intrinsics.checkNotNullParameter((Object)propKey, (String)"propKey");
        Intrinsics.checkNotNullParameter((Object)propsMap, (String)"propsMap");
        ReadableType valueType = this.configClone.getType(VALUE_KEY);
        if (valueType == ReadableType.Map) {
            propsMap.putMap(propKey, this.collectViewUpdatesHelper(this.configClone.getMap(VALUE_KEY)));
        } else if (valueType == ReadableType.Array) {
            propsMap.putArray(propKey, this.collectViewUpdatesHelper(this.configClone.getArray(VALUE_KEY)));
        } else {
            throw new IllegalArgumentException("Invalid value type for ObjectAnimatedNode");
        }
    }

    private final JavaOnlyArray collectViewUpdatesHelper(ReadableArray source) {
        if (source == null) {
            return null;
        }
        JavaOnlyArray result = new JavaOnlyArray();
        int n = source.size();
        block8: for (int i = 0; i < n; ++i) {
            switch (WhenMappings.$EnumSwitchMapping$0[source.getType(i).ordinal()]) {
                case 1: {
                    result.pushNull();
                    continue block8;
                }
                case 2: {
                    result.pushBoolean(source.getBoolean(i));
                    continue block8;
                }
                case 3: {
                    result.pushDouble(source.getDouble(i));
                    continue block8;
                }
                case 4: {
                    result.pushString(source.getString(i));
                    continue block8;
                }
                case 5: {
                    ReadableMap map = source.getMap(i);
                    if (map != null && map.hasKey(NODE_TAG_KEY) && map.getType(NODE_TAG_KEY) == ReadableType.Number) {
                        AnimatedNode node = this.nativeAnimatedNodesManager.getNodeById(map.getInt(NODE_TAG_KEY));
                        if (node == null) {
                            boolean $i$a$-requireNotNull-ObjectAnimatedNode$collectViewUpdatesHelper$22 = false;
                            String $i$a$-requireNotNull-ObjectAnimatedNode$collectViewUpdatesHelper$22 = "Mapped value node does not exist";
                            throw new IllegalArgumentException($i$a$-requireNotNull-ObjectAnimatedNode$collectViewUpdatesHelper$22.toString());
                        }
                        if (node instanceof ValueAnimatedNode) {
                            Object animatedObject = ((ValueAnimatedNode)node).getAnimatedObject();
                            if (animatedObject instanceof Integer) {
                                result.pushInt(((Number)animatedObject).intValue());
                                continue block8;
                            }
                            if (animatedObject instanceof String) {
                                result.pushString((String)animatedObject);
                                continue block8;
                            }
                            result.pushDouble(((ValueAnimatedNode)node).getValue());
                            continue block8;
                        }
                        if (!(node instanceof ColorAnimatedNode)) continue block8;
                        result.pushInt(((ColorAnimatedNode)node).getColor());
                        continue block8;
                    }
                    result.pushMap(this.collectViewUpdatesHelper(source.getMap(i)));
                    continue block8;
                }
                case 6: {
                    result.pushArray(this.collectViewUpdatesHelper(source.getArray(i)));
                    continue block8;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return result;
    }

    private final JavaOnlyMap collectViewUpdatesHelper(ReadableMap source) {
        if (source == null) {
            return null;
        }
        JavaOnlyMap result = new JavaOnlyMap();
        ReadableMapKeySetIterator iter = source.keySetIterator();
        block8: while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            switch (WhenMappings.$EnumSwitchMapping$0[source.getType(propKey).ordinal()]) {
                case 1: {
                    result.putNull(propKey);
                    continue block8;
                }
                case 2: {
                    result.putBoolean(propKey, source.getBoolean(propKey));
                    continue block8;
                }
                case 3: {
                    result.putDouble(propKey, source.getDouble(propKey));
                    continue block8;
                }
                case 4: {
                    result.putString(propKey, source.getString(propKey));
                    continue block8;
                }
                case 5: {
                    ReadableMap map = source.getMap(propKey);
                    if (map != null && map.hasKey(NODE_TAG_KEY) && map.getType(NODE_TAG_KEY) == ReadableType.Number) {
                        AnimatedNode node = this.nativeAnimatedNodesManager.getNodeById(map.getInt(NODE_TAG_KEY));
                        if (node == null) {
                            boolean $i$a$-requireNotNull-ObjectAnimatedNode$collectViewUpdatesHelper$32 = false;
                            String $i$a$-requireNotNull-ObjectAnimatedNode$collectViewUpdatesHelper$32 = "Mapped value node does not exist";
                            throw new IllegalArgumentException($i$a$-requireNotNull-ObjectAnimatedNode$collectViewUpdatesHelper$32.toString());
                        }
                        if (node instanceof ValueAnimatedNode) {
                            Object animatedObject = ((ValueAnimatedNode)node).getAnimatedObject();
                            if (animatedObject instanceof Integer) {
                                result.putInt(propKey, ((Number)animatedObject).intValue());
                                continue block8;
                            }
                            if (animatedObject instanceof String) {
                                result.putString(propKey, (String)animatedObject);
                                continue block8;
                            }
                            result.putDouble(propKey, ((ValueAnimatedNode)node).getValue());
                            continue block8;
                        }
                        if (!(node instanceof ColorAnimatedNode)) continue block8;
                        result.putInt(propKey, ((ColorAnimatedNode)node).getColor());
                        continue block8;
                    }
                    result.putMap(propKey, this.collectViewUpdatesHelper(map));
                    continue block8;
                }
                case 6: {
                    result.putArray(propKey, this.collectViewUpdatesHelper(source.getArray(propKey)));
                    continue block8;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    @Override
    @NotNull
    public String prettyPrint() {
        return "ObjectAnimatedNode[" + this.tag + "]: mConfig: " + this.configClone;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/animated/ObjectAnimatedNode$Companion;", "", "<init>", "()V", "VALUE_KEY", "", "NODE_TAG_KEY", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.Null.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Boolean.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Number.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Map.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Array.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

