/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.swiperefresh;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nJ0\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/react/views/swiperefresh/ReactSwipeRefreshLayout;", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "<init>", "(Lcom/facebook/react/bridge/ReactContext;)V", "didLayout", "", "refreshing", "progressViewOffset", "", "touchSlop", "", "prevTouchX", "intercepted", "nativeGestureStarted", "setRefreshing", "", "setProgressViewOffset", "offset", "onLayout", "changed", "left", "top", "right", "bottom", "canChildScrollUp", "requestDisallowInterceptTouchEvent", "disallowIntercept", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onTouchEvent", "shouldInterceptTouchEvent", "Companion", "ReactAndroid_release"})
public final class ReactSwipeRefreshLayout
extends SwipeRefreshLayout {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean didLayout;
    private boolean refreshing;
    private float progressViewOffset;
    private final int touchSlop;
    private float prevTouchX;
    private boolean intercepted;
    private boolean nativeGestureStarted;
    private static final float DEFAULT_CIRCLE_TARGET = 64.0f;

    public ReactSwipeRefreshLayout(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super((Context)reactContext);
        this.touchSlop = ViewConfiguration.get((Context)((Context)reactContext)).getScaledTouchSlop();
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
        if (this.didLayout) {
            super.setRefreshing(refreshing);
        }
    }

    public final void setProgressViewOffset(float offset) {
        this.progressViewOffset = offset;
        if (this.didLayout) {
            int diameter = this.getProgressCircleDiameter();
            int start = Math.round(PixelUtil.toPixelFromDIP(offset)) - diameter;
            int end = Math.round(PixelUtil.toPixelFromDIP(offset + 64.0f)) - diameter;
            this.setProgressViewOffset(false, start, end);
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.didLayout) {
            this.didLayout = true;
            this.setProgressViewOffset(this.progressViewOffset);
            this.setRefreshing(this.refreshing);
        }
    }

    public boolean canChildScrollUp() {
        View firstChild;
        View view = firstChild = this.getChildAt(0);
        return view != null ? view.canScrollVertically(-1) : super.canChildScrollUp();
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        block0: {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) break block0;
            viewParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (this.shouldInterceptTouchEvent(ev) && super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            this.nativeGestureStarted = true;
            ViewParent viewParent = this.getParent();
            if (viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(true);
            }
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (ev.getActionMasked() == 1 && this.nativeGestureStarted) {
            NativeGestureUtil.notifyNativeGestureEnded((View)this, ev);
            this.nativeGestureStarted = false;
        }
        return super.onTouchEvent(ev);
    }

    private final boolean shouldInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.prevTouchX = ev.getX();
                this.intercepted = false;
                break;
            }
            case 2: {
                float eventX = ev.getX();
                float xDiff = Math.abs(eventX - this.prevTouchX);
                if (!this.intercepted && !(xDiff > (float)this.touchSlop)) break;
                this.intercepted = true;
                return false;
            }
        }
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/swiperefresh/ReactSwipeRefreshLayout$Companion;", "", "<init>", "()V", "DEFAULT_CIRCLE_TARGET", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

