/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH&J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J&\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0000\u0012\u00020\u0014\u0012\u0006\b\u0000\u0012\u00020\u00140\u00130\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H&\u00a8\u0006\u0018"}, d2={"Lcom/facebook/react/BaseReactPackage;", "Lcom/facebook/react/ReactPackage;", "<init>", "()V", "createNativeModules", "", "Lcom/facebook/react/bridge/NativeModule;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "getModule", "name", "", "getNativeModuleIterator", "", "Lcom/facebook/react/bridge/ModuleHolder;", "getNativeModuleIterator$ReactAndroid_debug", "getViewManagers", "Lcom/facebook/react/bridge/ModuleSpec;", "createViewManagers", "Lcom/facebook/react/uimanager/ViewManager;", "", "getReactModuleInfoProvider", "Lcom/facebook/react/module/model/ReactModuleInfoProvider;", "ModuleHolderProvider", "ReactAndroid_debug"})
public abstract class BaseReactPackage
implements ReactPackage {
    @Override
    @NotNull
    public List<NativeModule> createNativeModules(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        throw new UnsupportedOperationException("createNativeModules method is not supported. Use getModule() method instead.");
    }

    @Override
    @Nullable
    public abstract NativeModule getModule(@NotNull String var1, @NotNull ReactApplicationContext var2);

    @NotNull
    public final Iterable<ModuleHolder> getNativeModuleIterator$ReactAndroid_debug(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Set<Map.Entry<String, ReactModuleInfo>> entrySet = this.getReactModuleInfoProvider().getReactModuleInfos().entrySet();
        Iterator<Map.Entry<String, ReactModuleInfo>> entrySetIterator = entrySet.iterator();
        return new Iterable<ModuleHolder>(entrySetIterator, this, reactContext){
            final /* synthetic */ Iterator $entrySetIterator$inlined;
            final /* synthetic */ BaseReactPackage this$0;
            final /* synthetic */ ReactApplicationContext $reactContext$inlined;
            {
                this.$entrySetIterator$inlined = iterator2;
                this.this$0 = baseReactPackage;
                this.$reactContext$inlined = reactApplicationContext;
            }

            public Iterator<ModuleHolder> iterator() {
                boolean bl = false;
                return new Iterator<ModuleHolder>((Iterator<? extends Map.Entry<String, ReactModuleInfo>>)this.$entrySetIterator$inlined, this.this$0, this.$reactContext$inlined){
                    private Map.Entry<String, ReactModuleInfo> nextEntry;
                    final /* synthetic */ Iterator<Map.Entry<String, ReactModuleInfo>> $entrySetIterator;
                    final /* synthetic */ BaseReactPackage this$0;
                    final /* synthetic */ ReactApplicationContext $reactContext;
                    {
                        this.$entrySetIterator = $entrySetIterator;
                        this.this$0 = $receiver;
                        this.$reactContext = $reactContext;
                    }

                    public final Map.Entry<String, ReactModuleInfo> getNextEntry() {
                        return this.nextEntry;
                    }

                    public final void setNextEntry(Map.Entry<String, ReactModuleInfo> entry) {
                        this.nextEntry = entry;
                    }

                    private final void findNext() {
                        while (this.$entrySetIterator.hasNext()) {
                            Map.Entry<String, ReactModuleInfo> entry = this.$entrySetIterator.next();
                            ReactModuleInfo reactModuleInfo = entry.getValue();
                            if (ReactNativeNewArchitectureFeatureFlags.useTurboModules() && reactModuleInfo.isTurboModule()) continue;
                            this.nextEntry = entry;
                            return;
                        }
                        this.nextEntry = null;
                    }

                    public boolean hasNext() {
                        if (this.nextEntry == null) {
                            this.findNext();
                        }
                        return this.nextEntry != null;
                    }

                    public ModuleHolder next() {
                        if (this.nextEntry == null) {
                            this.findNext();
                        }
                        Map.Entry<String, ReactModuleInfo> entry = this.nextEntry;
                        if (entry == null) {
                            throw new NoSuchElementException("ModuleHolder not found");
                        }
                        Map.Entry<String, ReactModuleInfo> entry2 = entry;
                        this.findNext();
                        return new ModuleHolder(entry2.getValue(), (Provider<? extends NativeModule>)((Provider)this.this$0.new ModuleHolderProvider(entry2.getKey(), this.$reactContext)));
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    protected List<ModuleSpec> getViewManagers(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<ViewManager> createViewManagers(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        List<ModuleSpec> viewManagerModuleSpecs = this.getViewManagers(reactContext);
        Collection collection = viewManagerModuleSpecs;
        if (collection == null || collection.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List viewManagers = new ArrayList();
        for (ModuleSpec moduleSpec : viewManagerModuleSpecs) {
            Object object = moduleSpec.getProvider().get();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ViewManager<*, *>");
            viewManagers.add((ViewManager)object);
        }
        return viewManagers;
    }

    @NotNull
    public abstract ReactModuleInfoProvider getReactModuleInfoProvider();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/BaseReactPackage$ModuleHolderProvider;", "Ljavax/inject/Provider;", "Lcom/facebook/react/bridge/NativeModule;", "name", "", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/BaseReactPackage;Ljava/lang/String;Lcom/facebook/react/bridge/ReactApplicationContext;)V", "get", "ReactAndroid_debug"})
    private final class ModuleHolderProvider
    implements Provider<NativeModule> {
        @NotNull
        private final String name;
        @NotNull
        private final ReactApplicationContext reactContext;

        public ModuleHolderProvider(@NotNull String name, ReactApplicationContext reactContext) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
            this.name = name;
            this.reactContext = reactContext;
        }

        @Nullable
        public NativeModule get() {
            return BaseReactPackage.this.getModule(this.name, this.reactContext);
        }
    }
}

