/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.DoubleTapReloadRecognizer;
import com.facebook.react.devsupport.ReleaseDevSupportManager;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;

public class ReactDelegate {
    private final Activity mActivity;
    @Nullable
    private ReactRootView mReactRootView;
    @Nullable
    private final String mMainComponentName;
    @Nullable
    private Bundle mLaunchOptions;
    @Nullable
    private DoubleTapReloadRecognizer mDoubleTapReloadRecognizer;
    @Nullable
    private ReactNativeHost mReactNativeHost;
    @Nullable
    private ReactHost mReactHost;
    @Nullable
    private ReactSurface mReactSurface;
    private boolean mFabricEnabled = ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer();

    @Deprecated
    public ReactDelegate(Activity activity, ReactNativeHost reactNativeHost, @Nullable String appKey, @Nullable Bundle launchOptions) {
        this.mActivity = activity;
        this.mMainComponentName = appKey;
        this.mLaunchOptions = launchOptions;
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
        this.mReactNativeHost = reactNativeHost;
    }

    public ReactDelegate(Activity activity, ReactHost reactHost, @Nullable String appKey, @Nullable Bundle launchOptions) {
        this.mActivity = activity;
        this.mMainComponentName = appKey;
        this.mLaunchOptions = launchOptions;
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
        this.mReactHost = reactHost;
    }

    public ReactDelegate(Activity activity, ReactNativeHost reactNativeHost, @Nullable String appKey, @Nullable Bundle launchOptions, boolean fabricEnabled) {
        this.mFabricEnabled = fabricEnabled;
        this.mActivity = activity;
        this.mMainComponentName = appKey;
        this.mLaunchOptions = launchOptions;
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
        this.mReactNativeHost = reactNativeHost;
    }

    @Nullable
    private DevSupportManager getDevSupportManager() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() && this.mReactHost != null && this.mReactHost.getDevSupportManager() != null) {
            return this.mReactHost.getDevSupportManager();
        }
        if (this.getReactNativeHost().hasInstance() && this.getReactNativeHost().getReactInstanceManager() != null) {
            return this.getReactNativeHost().getReactInstanceManager().getDevSupportManager();
        }
        return null;
    }

    public void onHostResume() {
        if (!(this.mActivity instanceof DefaultHardwareBackBtnHandler)) {
            throw new ClassCastException("Host Activity does not implement DefaultHardwareBackBtnHandler");
        }
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onHostResume(this.mActivity, (DefaultHardwareBackBtnHandler)this.mActivity);
        } else if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostResume(this.mActivity, (DefaultHardwareBackBtnHandler)this.mActivity);
        }
    }

    public void onUserLeaveHint() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onHostLeaveHint(this.mActivity);
        } else if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onUserLeaveHint(this.mActivity);
        }
    }

    public void onHostPause() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onHostPause(this.mActivity);
        } else if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostPause(this.mActivity);
        }
    }

    public void onHostDestroy() {
        this.unloadApp();
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onHostDestroy(this.mActivity);
        } else if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostDestroy(this.mActivity);
        }
    }

    public boolean onBackPressed() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onBackPressed();
            return true;
        }
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onBackPressed();
            return true;
        }
        return false;
    }

    public boolean onNewIntent(Intent intent) {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onNewIntent(intent);
            return true;
        }
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onNewIntent(intent);
            return true;
        }
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data, boolean shouldForwardToReactInstance) {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onActivityResult(this.mActivity, requestCode, resultCode, data);
        } else if (this.getReactNativeHost().hasInstance() && shouldForwardToReactInstance) {
            this.getReactNativeHost().getReactInstanceManager().onActivityResult(this.mActivity, requestCode, resultCode, data);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onWindowFocusChange(hasFocus);
        } else if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onWindowFocusChange(hasFocus);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            this.mReactHost.onConfigurationChanged((Context)Assertions.assertNotNull((Object)this.mActivity));
        } else if (this.getReactNativeHost().hasInstance()) {
            this.getReactInstanceManager().onConfigurationChanged((Context)Assertions.assertNotNull((Object)this.mActivity), newConfig);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 90 && (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() && this.mReactHost != null && this.mReactHost.getDevSupportManager() != null || this.getReactNativeHost().hasInstance() && this.getReactNativeHost().getUseDeveloperSupport())) {
            event.startTracking();
            return true;
        }
        return false;
    }

    public boolean onKeyLongPress(int keyCode) {
        if (keyCode == 90) {
            if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() && this.mReactHost != null) {
                DevSupportManager devSupportManager = this.mReactHost.getDevSupportManager();
                if (devSupportManager != null && !(devSupportManager instanceof ReleaseDevSupportManager)) {
                    devSupportManager.showDevOptionsDialog();
                    return true;
                }
            } else if (this.getReactNativeHost().hasInstance() && this.getReactNativeHost().getUseDeveloperSupport()) {
                this.getReactNativeHost().getReactInstanceManager().showDevOptionsDialog();
                return true;
            }
        }
        return false;
    }

    public void reload() {
        DevSupportManager devSupportManager = this.getDevSupportManager();
        if (devSupportManager == null) {
            return;
        }
        if (devSupportManager instanceof ReleaseDevSupportManager) {
            if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
                if (this.mReactHost != null) {
                    this.mReactHost.reload("ReactDelegate.reload()");
                }
            } else {
                UiThreadUtil.runOnUiThread(() -> {
                    if (this.mReactNativeHost.hasInstance() && this.mReactNativeHost.getReactInstanceManager() != null) {
                        this.mReactNativeHost.getReactInstanceManager().recreateReactContextInBackground();
                    }
                });
            }
            return;
        }
        devSupportManager.handleReloadJS();
    }

    public void loadApp() {
        this.loadApp(this.mMainComponentName);
    }

    public void loadApp(String appKey) {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            if (this.mReactSurface == null) {
                this.mReactSurface = this.mReactHost.createSurface((Context)this.mActivity, appKey, this.mLaunchOptions);
            }
            this.mReactSurface.start();
        } else {
            if (this.mReactRootView != null) {
                throw new IllegalStateException("Cannot loadApp while app is already running.");
            }
            this.mReactRootView = this.createRootView();
            this.mReactRootView.startReactApplication(this.getReactNativeHost().getReactInstanceManager(), appKey, this.mLaunchOptions);
        }
    }

    public void unloadApp() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            if (this.mReactSurface != null) {
                this.mReactSurface.stop();
                this.mReactSurface = null;
            }
        } else if (this.mReactRootView != null) {
            this.mReactRootView.unmountReactApplication();
            this.mReactRootView = null;
        }
    }

    public void setReactSurface(ReactSurface reactSurface) {
        this.mReactSurface = reactSurface;
    }

    public void setReactRootView(ReactRootView reactRootView) {
        this.mReactRootView = reactRootView;
    }

    @Nullable
    public ReactRootView getReactRootView() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            if (this.mReactSurface != null) {
                return (ReactRootView)this.mReactSurface.getView();
            }
            return null;
        }
        return this.mReactRootView;
    }

    protected ReactRootView createRootView() {
        ReactRootView reactRootView = new ReactRootView((Context)this.mActivity);
        reactRootView.setIsFabric(this.isFabricEnabled());
        return reactRootView;
    }

    public boolean shouldShowDevMenuOrReload(int keyCode, KeyEvent event) {
        DevSupportManager devSupportManager = this.getDevSupportManager();
        if (devSupportManager == null || devSupportManager instanceof ReleaseDevSupportManager) {
            return false;
        }
        if (keyCode == 82) {
            devSupportManager.showDevOptionsDialog();
            return true;
        }
        boolean didDoubleTapR = ((DoubleTapReloadRecognizer)Assertions.assertNotNull((Object)this.mDoubleTapReloadRecognizer)).didDoubleTapR(keyCode, this.mActivity.getCurrentFocus());
        if (didDoubleTapR) {
            devSupportManager.handleReloadJS();
            return true;
        }
        return false;
    }

    private ReactNativeHost getReactNativeHost() {
        return this.mReactNativeHost;
    }

    public ReactInstanceManager getReactInstanceManager() {
        return this.getReactNativeHost().getReactInstanceManager();
    }

    @Nullable
    public ReactHost getReactHost() {
        return this.mReactHost;
    }

    @Nullable
    public ReactContext getCurrentReactContext() {
        if (ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            if (this.mReactHost != null) {
                return this.mReactHost.getCurrentReactContext();
            }
            return null;
        }
        return this.getReactInstanceManager().getCurrentReactContext();
    }

    protected boolean isFabricEnabled() {
        return this.mFabricEnabled;
    }
}

