/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.util.SparseArray;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.react.animated.AdditionAnimatedNode;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.animated.AnimatedNodeWithUpdateableConfig;
import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.DecayAnimation;
import com.facebook.react.animated.DiffClampAnimatedNode;
import com.facebook.react.animated.DivisionAnimatedNode;
import com.facebook.react.animated.EventAnimationDriver;
import com.facebook.react.animated.FrameBasedAnimationDriver;
import com.facebook.react.animated.InterpolationAnimatedNode;
import com.facebook.react.animated.ModulusAnimatedNode;
import com.facebook.react.animated.MultiplicationAnimatedNode;
import com.facebook.react.animated.ObjectAnimatedNode;
import com.facebook.react.animated.PropsAnimatedNode;
import com.facebook.react.animated.SpringAnimation;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.SubtractionAnimatedNode;
import com.facebook.react.animated.TrackingAnimatedNode;
import com.facebook.react.animated.TransformAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 U2\u00020\u0001:\u0001UB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0007J\u001a\u0010\"\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0007J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010*\u001a\u00020(H\u0007J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0007J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0007J*\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u000102H\u0007J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\bH\u0003J\u0010\u00105\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0010H\u0007J\u0018\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0010H\u0007J\u0016\u00109\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0010J\u0018\u0010:\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0010H\u0007J\u0018\u0010<\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0010H\u0007J\u001a\u0010=\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010>\u001a\u0004\u0018\u000102H\u0007J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0010H\u0007J \u0010@\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00102\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u001fH\u0007J \u0010D\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00102\u0006\u0010A\u001a\u00020B2\u0006\u0010E\u001a\u00020\u0010H\u0007J\u0014\u0010F\u001a\u00020\u00172\n\u0010G\u001a\u0006\u0012\u0002\b\u00030HH\u0016J\u0014\u0010I\u001a\u00020\u00172\n\u0010G\u001a\u0006\u0012\u0002\b\u00030HH\u0003J\u0010\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020LH\u0007J#\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00100N2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010O\u001a\u00020BH\u0000\u00a2\u0006\u0002\bPJ\u0016\u0010Q\u001a\u00020\u00172\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\b0SH\u0003J\u0010\u0010T\u001a\u00020B2\u0006\u0010A\u001a\u00020BH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "Lcom/facebook/react/uimanager/events/EventDispatcherListener;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "animatedNodes", "Landroid/util/SparseArray;", "Lcom/facebook/react/animated/AnimatedNode;", "activeAnimations", "Lcom/facebook/react/animated/AnimationDriver;", "updatedNodes", "eventDrivers", "", "Lcom/facebook/react/animated/EventAnimationDriver;", "animatedGraphBFSColor", "", "runUpdateNodeList", "eventListenerInitializedForFabric", "", "eventListenerInitializedForNonFabric", "warnedAboutGraphTraversal", "initializeEventListenerForUIManagerType", "", "uiManagerType", "getNodeById", "id", "hasActiveAnimations", "createAnimatedNode", "tag", "config", "Lcom/facebook/react/bridge/ReadableMap;", "updateAnimatedNodeConfig", "dropAnimatedNode", "startListeningToAnimatedNodeValue", "listener", "Lcom/facebook/react/animated/AnimatedNodeValueListener;", "stopListeningToAnimatedNodeValue", "setAnimatedNodeValue", "value", "", "setAnimatedNodeOffset", "offset", "flattenAnimatedNodeOffset", "extractAnimatedNodeOffset", "startAnimatingNode", "animationId", "animatedNodeTag", "animationConfig", "endCallback", "Lcom/facebook/react/bridge/Callback;", "stopAnimationsForNode", "animatedNode", "stopAnimation", "connectAnimatedNodes", "parentNodeTag", "childNodeTag", "disconnectAnimatedNodes", "connectAnimatedNodeToView", "viewTag", "disconnectAnimatedNodeFromView", "getValue", "callback", "restoreDefaultValues", "addAnimatedEventToView", "eventHandlerName", "", "eventMapping", "removeAnimatedEventFromView", "animatedValueTag", "onEventDispatch", "event", "Lcom/facebook/react/uimanager/events/Event;", "handleEvent", "runUpdates", "frameTimeNanos", "", "getTagsOfConnectedNodes", "", "eventName", "getTagsOfConnectedNodes$ReactAndroid_debug", "updateNodes", "nodes", "", "normalizeEventName", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nNativeAnimatedNodesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeAnimatedNodesManager.kt\ncom/facebook/react/animated/NativeAnimatedNodesManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,775:1\n1#2:776\n1869#3:777\n1869#3,2:778\n1870#3:780\n1869#3,2:781\n1869#3,2:783\n*S KotlinDebug\n*F\n+ 1 NativeAnimatedNodesManager.kt\ncom/facebook/react/animated/NativeAnimatedNodesManager\n*L\n613#1:777\n616#1:778,2\n613#1:780\n650#1:781,2\n707#1:783,2\n*E\n"})
public final class NativeAnimatedNodesManager
implements EventDispatcherListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final ReactApplicationContext reactApplicationContext;
    @NotNull
    private final SparseArray<AnimatedNode> animatedNodes;
    @NotNull
    private final SparseArray<AnimationDriver> activeAnimations;
    @NotNull
    private final SparseArray<AnimatedNode> updatedNodes;
    @NotNull
    private final List<EventAnimationDriver> eventDrivers;
    private int animatedGraphBFSColor;
    @NotNull
    private final List<AnimatedNode> runUpdateNodeList;
    private boolean eventListenerInitializedForFabric;
    private boolean eventListenerInitializedForNonFabric;
    private boolean warnedAboutGraphTraversal;
    @NotNull
    private static final String TAG = "NativeAnimatedNodesManager";

    public NativeAnimatedNodesManager(@Nullable ReactApplicationContext reactApplicationContext) {
        this.reactApplicationContext = reactApplicationContext;
        this.animatedNodes = new SparseArray();
        this.activeAnimations = new SparseArray();
        this.updatedNodes = new SparseArray();
        this.eventDrivers = new ArrayList();
        this.runUpdateNodeList = new LinkedList();
    }

    public final void initializeEventListenerForUIManagerType(int uiManagerType) {
        boolean isEventListenerInitialized;
        boolean bl = isEventListenerInitialized = uiManagerType == 2 ? this.eventListenerInitializedForFabric : this.eventListenerInitializedForNonFabric;
        if (isEventListenerInitialized) {
            return;
        }
        ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
        if (reactApplicationContext == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        UIManager uiManager = UIManagerHelper.getUIManager(reactApplicationContext, uiManagerType);
        if (uiManager != null) {
            uiManager.getEventDispatcher().addListener(this);
            if (uiManagerType == 2) {
                this.eventListenerInitializedForFabric = true;
            } else {
                this.eventListenerInitializedForNonFabric = true;
            }
        }
    }

    @Nullable
    public final AnimatedNode getNodeById(int id2) {
        return (AnimatedNode)this.animatedNodes.get(id2);
    }

    public final boolean hasActiveAnimations() {
        return this.activeAnimations.size() > 0 || this.updatedNodes.size() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    public final void createAnimatedNode(int tag, @NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.animatedNodes.get(tag) != null) {
            throw new JSApplicationIllegalArgumentException("createAnimatedNode: Animated node [" + tag + "] already exists");
        }
        String type = config.getString("type");
        String string2 = type;
        if (string2 == null) throw new JSApplicationIllegalArgumentException("Unsupported node type: " + type);
        int n = -1;
        switch (string2.hashCode()) {
            case 94842723: {
                if (string2.equals("color")) {
                    n = 1;
                }
                break;
            }
            case -1774341004: {
                if (string2.equals("subtraction")) {
                    n = 2;
                }
                break;
            }
            case 1270488759: {
                if (string2.equals("tracking")) {
                    n = 3;
                }
                break;
            }
            case 106940784: {
                if (string2.equals("props")) {
                    n = 4;
                }
                break;
            }
            case 364720301: {
                if (string2.equals("division")) {
                    n = 5;
                }
                break;
            }
            case 1300649942: {
                if (string2.equals("diffclamp")) {
                    n = 6;
                }
                break;
            }
            case 559331748: {
                if (string2.equals("interpolation")) {
                    n = 7;
                }
                break;
            }
            case 1052666732: {
                if (string2.equals("transform")) {
                    n = 8;
                }
                break;
            }
            case 109780401: {
                if (string2.equals("style")) {
                    n = 9;
                }
                break;
            }
            case 668845958: {
                if (string2.equals("multiplication")) {
                    n = 10;
                }
                break;
            }
            case 111972721: {
                if (string2.equals("value")) {
                    n = 11;
                }
                break;
            }
            case 1227434359: {
                if (string2.equals("modulus")) {
                    n = 12;
                }
                break;
            }
            case -1226589444: {
                if (string2.equals("addition")) {
                    n = 13;
                }
                break;
            }
            case -1023368385: {
                if (string2.equals("object")) {
                    n = 14;
                }
                break;
            }
        }
        AnimatedNode node = switch (n) {
            case 9 -> new StyleAnimatedNode(config, this);
            case 11 -> new ValueAnimatedNode(config);
            case 1 -> {
                ReactApplicationContext v1 = this.reactApplicationContext;
                if (v1 == null) {
                    String var6_5 = "Required value was null.";
                    throw new IllegalStateException(var6_5.toString());
                }
                yield new ColorAnimatedNode(config, this, v1);
            }
            case 4 -> new PropsAnimatedNode(config, this);
            case 7 -> new InterpolationAnimatedNode(config);
            case 13 -> new AdditionAnimatedNode(config, this);
            case 2 -> new SubtractionAnimatedNode(config, this);
            case 5 -> new DivisionAnimatedNode(config, this);
            case 10 -> new MultiplicationAnimatedNode(config, this);
            case 12 -> new ModulusAnimatedNode(config, this);
            case 6 -> new DiffClampAnimatedNode(config, this);
            case 8 -> new TransformAnimatedNode(config, this);
            case 3 -> new TrackingAnimatedNode(config, this);
            case 14 -> new ObjectAnimatedNode(config, this);
            default -> throw new JSApplicationIllegalArgumentException("Unsupported node type: " + type);
        };
        node.tag = tag;
        this.animatedNodes.put(tag, (Object)node);
        this.updatedNodes.put(tag, (Object)node);
    }

    @UiThread
    public final void updateAnimatedNodeConfig(int tag, @Nullable ReadableMap config) {
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(tag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("updateAnimatedNode: Animated node [" + tag + "] does not exist");
        }
        AnimatedNode node = animatedNode;
        if (node instanceof AnimatedNodeWithUpdateableConfig) {
            this.stopAnimationsForNode(node);
            ((AnimatedNodeWithUpdateableConfig)((Object)node)).onUpdateConfig(config);
            this.updatedNodes.put(tag, (Object)node);
        }
    }

    @UiThread
    public final void dropAnimatedNode(int tag) {
        this.animatedNodes.remove(tag);
        this.updatedNodes.remove(tag);
    }

    @UiThread
    public final void startListeningToAnimatedNodeValue(int tag, @Nullable AnimatedNodeValueListener listener) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("startListeningToAnimatedNodeValue: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).setValueListener(listener);
    }

    @UiThread
    public final void stopListeningToAnimatedNodeValue(int tag) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("startListeningToAnimatedNodeValue: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).setValueListener(null);
    }

    @UiThread
    public final void setAnimatedNodeValue(int tag, double value) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("setAnimatedNodeValue: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        this.stopAnimationsForNode(node);
        ((ValueAnimatedNode)node).nodeValue = value;
        this.updatedNodes.put(tag, (Object)node);
    }

    @UiThread
    public final void setAnimatedNodeOffset(int tag, double offset) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("setAnimatedNodeOffset: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).offset = offset;
        this.updatedNodes.put(tag, (Object)node);
    }

    @UiThread
    public final void flattenAnimatedNodeOffset(int tag) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("flattenAnimatedNodeOffset: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).flattenOffset();
    }

    @UiThread
    public final void extractAnimatedNodeOffset(int tag) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("extractAnimatedNodeOffset: Animated node [" + tag + "] does not exist, or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).extractOffset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    public final void startAnimatingNode(int animationId, int animatedNodeTag, @NotNull ReadableMap animationConfig, @Nullable Callback endCallback) {
        Intrinsics.checkNotNullParameter((Object)animationConfig, (String)"animationConfig");
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(animatedNodeTag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("startAnimatingNode: Animated node [" + animatedNodeTag + "] does not exist");
        }
        AnimatedNode node = animatedNode;
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("startAnimatingNode: Animated node [" + animatedNodeTag + "] should be of type " + ValueAnimatedNode.class.getName());
        }
        AnimationDriver existingDriver = (AnimationDriver)this.activeAnimations.get(animationId);
        if (existingDriver != null) {
            existingDriver.resetConfig(animationConfig);
            return;
        }
        String type = animationConfig.getString("type");
        String string2 = type;
        if (string2 == null) throw new JSApplicationIllegalArgumentException("startAnimatingNode: Unsupported animation type [" + animatedNodeTag + "]: " + type);
        int n = -1;
        switch (string2.hashCode()) {
            case -895679987: {
                if (string2.equals("spring")) {
                    n = 1;
                }
                break;
            }
            case -1266514778: {
                if (string2.equals("frames")) {
                    n = 2;
                }
                break;
            }
            case 95459258: {
                if (string2.equals("decay")) {
                    n = 3;
                }
                break;
            }
        }
        AnimationDriver animation = switch (n) {
            case 2 -> new FrameBasedAnimationDriver(animationConfig);
            case 1 -> new SpringAnimation(animationConfig);
            case 3 -> new DecayAnimation(animationConfig);
            default -> throw new JSApplicationIllegalArgumentException("startAnimatingNode: Unsupported animation type [" + animatedNodeTag + "]: " + type);
        };
        animation.id = animationId;
        animation.endCallback = endCallback;
        animation.animatedValue = (ValueAnimatedNode)node;
        this.activeAnimations.put(animationId, (Object)animation);
    }

    @UiThread
    private final void stopAnimationsForNode(AnimatedNode animatedNode) {
        block8: {
            WritableArray events = null;
            for (int i = 0; i < this.activeAnimations.size(); ++i) {
                AnimationDriver animation = (AnimationDriver)this.activeAnimations.valueAt(i);
                if (!Intrinsics.areEqual((Object)animatedNode, (Object)animation.animatedValue)) continue;
                if (animation.animatedValue == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                if (animation.endCallback != null) {
                    WritableMap endCallbackResponse;
                    Intrinsics.checkNotNullExpressionValue((Object)Arguments.createMap(), (String)"createMap(...)");
                    endCallbackResponse.putBoolean("finished", false);
                    endCallbackResponse.putDouble("value", animatedValueNonnull.nodeValue);
                    endCallbackResponse.putDouble("offset", animatedValueNonnull.offset);
                    Callback callback = animation.endCallback;
                    if (callback != null) {
                        Object[] objectArray = new Object[]{endCallbackResponse};
                        callback.invoke(objectArray);
                    }
                } else if (this.reactApplicationContext != null) {
                    WritableMap params;
                    Intrinsics.checkNotNullExpressionValue((Object)Arguments.createMap(), (String)"createMap(...)");
                    params.putInt("animationId", animation.id);
                    params.putBoolean("finished", false);
                    params.putDouble("value", animatedValueNonnull.nodeValue);
                    params.putDouble("offset", animatedValueNonnull.offset);
                    WritableArray writableArray = events;
                    if (writableArray == null) {
                        WritableArray writableArray2 = Arguments.createArray();
                        writableArray = writableArray2;
                        Intrinsics.checkNotNullExpressionValue((Object)writableArray2, (String)"createArray(...)");
                    }
                    events = writableArray;
                    events.pushMap(params);
                }
                this.activeAnimations.removeAt(i);
                --i;
            }
            if (events == null) break block8;
            ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleAnimationFinished", events);
            }
        }
    }

    @UiThread
    public final void stopAnimation(int animationId) {
        block10: {
            WritableArray events = null;
            int n = this.activeAnimations.size();
            for (int i = 0; i < n; ++i) {
                AnimationDriver animation = (AnimationDriver)this.activeAnimations.valueAt(i);
                if (animation.id != animationId) continue;
                if (animation.endCallback != null) {
                    WritableMap writableMap = Arguments.createMap();
                    Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                    WritableMap endCallbackResponse = writableMap;
                    endCallbackResponse.putBoolean("finished", false);
                    ValueAnimatedNode valueAnimatedNode = animation.animatedValue;
                    if (valueAnimatedNode == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalStateException(string2.toString());
                    }
                    endCallbackResponse.putDouble("value", valueAnimatedNode.nodeValue);
                    ValueAnimatedNode valueAnimatedNode2 = animation.animatedValue;
                    if (valueAnimatedNode2 == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalStateException(string3.toString());
                    }
                    endCallbackResponse.putDouble("offset", valueAnimatedNode2.offset);
                    Callback callback = animation.endCallback;
                    if (callback == null) {
                        String string4 = "Required value was null.";
                        throw new IllegalStateException(string4.toString());
                    }
                    Object[] objectArray = new Object[]{endCallbackResponse};
                    callback.invoke(objectArray);
                } else if (this.reactApplicationContext != null) {
                    WritableMap writableMap = Arguments.createMap();
                    Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                    WritableMap params = writableMap;
                    params.putInt("animationId", animation.id);
                    params.putBoolean("finished", false);
                    ValueAnimatedNode valueAnimatedNode = animation.animatedValue;
                    if (valueAnimatedNode == null) {
                        String string5 = "Required value was null.";
                        throw new IllegalStateException(string5.toString());
                    }
                    params.putDouble("value", valueAnimatedNode.nodeValue);
                    ValueAnimatedNode valueAnimatedNode3 = animation.animatedValue;
                    if (valueAnimatedNode3 == null) {
                        String string6 = "Required value was null.";
                        throw new IllegalStateException(string6.toString());
                    }
                    params.putDouble("offset", valueAnimatedNode3.offset);
                    WritableArray writableArray = Arguments.createArray();
                    Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
                    events = writableArray;
                    events.pushMap(params);
                }
                this.activeAnimations.removeAt(i);
                break;
            }
            if (events == null) break block10;
            ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleAnimationFinished", events);
            }
        }
    }

    @UiThread
    public final void connectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(parentNodeTag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodes: Animated node with tag (parent) [" + parentNodeTag + "] does not exist");
        }
        AnimatedNode parentNode = animatedNode;
        AnimatedNode animatedNode2 = (AnimatedNode)this.animatedNodes.get(childNodeTag);
        if (animatedNode2 == null) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodes: Animated node with tag (child) [" + childNodeTag + "] does not exist");
        }
        AnimatedNode childNode = animatedNode2;
        parentNode.addChild$ReactAndroid_debug(childNode);
        this.updatedNodes.put(childNodeTag, (Object)childNode);
    }

    public final void disconnectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(parentNodeTag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodes: Animated node with tag (parent) [" + parentNodeTag + "] does not exist");
        }
        AnimatedNode parentNode = animatedNode;
        AnimatedNode animatedNode2 = (AnimatedNode)this.animatedNodes.get(childNodeTag);
        if (animatedNode2 == null) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodes: Animated node with tag (child) [" + childNodeTag + "] does not exist");
        }
        AnimatedNode childNode = animatedNode2;
        parentNode.removeChild$ReactAndroid_debug(childNode);
        this.updatedNodes.put(childNodeTag, (Object)childNode);
    }

    @UiThread
    public final void connectAnimatedNodeToView(int animatedNodeTag, int viewTag) {
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(animatedNodeTag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodeToView: Animated node with tag [" + animatedNodeTag + "] does not exist");
        }
        AnimatedNode node = animatedNode;
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("connectAnimatedNodeToView: Animated node connected to view [" + viewTag + "] should be of type " + PropsAnimatedNode.class.getName());
        }
        if (this.reactApplicationContext == null) {
            boolean bl = false;
            String string2 = "connectAnimatedNodeToView: Animated node could not be connected, no ReactApplicationContext: " + viewTag;
            throw new IllegalStateException(string2.toString());
        }
        UIManager uiManager = UIManagerHelper.getUIManagerForReactTag(this.reactApplicationContext, viewTag);
        if (uiManager == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("connectAnimatedNodeToView: Animated node could not be connected to UIManager - uiManager disappeared for tag: " + viewTag));
            return;
        }
        ((PropsAnimatedNode)node).connectToView(viewTag, uiManager);
        this.updatedNodes.put(animatedNodeTag, (Object)node);
    }

    @UiThread
    public final void disconnectAnimatedNodeFromView(int animatedNodeTag, int viewTag) {
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(animatedNodeTag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodeFromView: Animated node with tag [" + animatedNodeTag + "] does not exist");
        }
        AnimatedNode node = animatedNode;
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("disconnectAnimatedNodeFromView: Animated node connected to view [" + viewTag + "] should be of type " + PropsAnimatedNode.class.getName());
        }
        ((PropsAnimatedNode)node).disconnectFromView(viewTag);
    }

    @UiThread
    public final void getValue(int tag, @Nullable Callback callback) {
        AnimatedNode node = (AnimatedNode)this.animatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("getValue: Animated node with tag [" + tag + "] does not exist or is not a 'value' node");
        }
        double value = ((ValueAnimatedNode)node).getValue();
        if (callback != null) {
            Object[] objectArray = new Object[]{value};
            callback.invoke(objectArray);
            return;
        }
        if (this.reactApplicationContext == null) {
            return;
        }
        WritableMap writableMap = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
        WritableMap params = writableMap;
        params.putInt("tag", tag);
        params.putDouble("value", value);
        this.reactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleGetValue", params);
    }

    @UiThread
    public final void restoreDefaultValues(int animatedNodeTag) {
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(animatedNodeTag);
        if (animatedNode == null) {
            return;
        }
        AnimatedNode node = animatedNode;
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view [?] should be of type " + PropsAnimatedNode.class.getName());
        }
        ((PropsAnimatedNode)node).restoreDefaultValues();
    }

    @UiThread
    public final void addAnimatedEventToView(int viewTag, @NotNull String eventHandlerName, @NotNull ReadableMap eventMapping) {
        Intrinsics.checkNotNullParameter((Object)eventHandlerName, (String)"eventHandlerName");
        Intrinsics.checkNotNullParameter((Object)eventMapping, (String)"eventMapping");
        int nodeTag = eventMapping.getInt("animatedValueTag");
        AnimatedNode animatedNode = (AnimatedNode)this.animatedNodes.get(nodeTag);
        if (animatedNode == null) {
            throw new JSApplicationIllegalArgumentException("addAnimatedEventToView: Animated node with tag [" + nodeTag + "] does not exist");
        }
        AnimatedNode node = animatedNode;
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("addAnimatedEventToView: Animated node on view [" + viewTag + "] connected to event handler (" + eventHandlerName + ") should be of type " + ValueAnimatedNode.class.getName());
        }
        ReadableArray readableArray = eventMapping.getArray("nativeEventPath");
        if (readableArray == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        ReadableArray path = readableArray;
        List pathList = new ArrayList(path.size());
        int n = path.size();
        for (int i = 0; i < n; ++i) {
            String string3 = path.getString(i);
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalStateException(string4.toString());
            }
            pathList.add(string3);
        }
        String eventName = this.normalizeEventName(eventHandlerName);
        EventAnimationDriver eventDriver = new EventAnimationDriver(eventName, viewTag, pathList, (ValueAnimatedNode)node);
        this.eventDrivers.add(eventDriver);
        if (Intrinsics.areEqual((Object)eventName, (Object)"topScroll")) {
            this.addAnimatedEventToView(viewTag, "topScrollEnded", eventMapping);
        }
    }

    @UiThread
    public final void removeAnimatedEventFromView(int viewTag, @NotNull String eventHandlerName, int animatedValueTag) {
        Object v0;
        String eventName;
        block3: {
            Intrinsics.checkNotNullParameter((Object)eventHandlerName, (String)"eventHandlerName");
            eventName = this.normalizeEventName(eventHandlerName);
            Iterable iterable = this.eventDrivers;
            for (Object t : iterable) {
                EventAnimationDriver driver = (EventAnimationDriver)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)eventName, (Object)driver.eventName) && viewTag == driver.viewTag && animatedValueTag == driver.valueNode.tag)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        EventAnimationDriver eventAnimationDriver = v0;
        if (eventAnimationDriver != null) {
            EventAnimationDriver driver = eventAnimationDriver;
            boolean bl = false;
            this.eventDrivers.remove(driver);
        }
        if (Intrinsics.areEqual((Object)eventName, (Object)"topScroll")) {
            this.removeAnimatedEventFromView(viewTag, "topScrollEnded", animatedValueTag);
        }
    }

    @Override
    public void onEventDispatch(@NotNull Event<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (UiThreadUtil.isOnUiThread()) {
            this.handleEvent(event);
        } else {
            UiThreadUtil.runOnUiThread(() -> NativeAnimatedNodesManager.onEventDispatch$lambda$3(this, event));
        }
    }

    @UiThread
    private final void handleEvent(Event<?> event) {
        if (this.eventDrivers.isEmpty()) {
            return;
        }
        boolean foundAtLeastOneDriver = false;
        Event.EventAnimationDriverMatchSpec matchSpec = event.getEventAnimationDriverMatchSpec();
        for (EventAnimationDriver driver : this.eventDrivers) {
            if (matchSpec == null || !matchSpec.match(driver.viewTag, driver.eventName)) continue;
            foundAtLeastOneDriver = true;
            this.stopAnimationsForNode(driver.valueNode);
            event.dispatchModern(driver);
            this.runUpdateNodeList.add(driver.valueNode);
        }
        if (foundAtLeastOneDriver) {
            this.updateNodes(this.runUpdateNodeList);
            this.runUpdateNodeList.clear();
        }
    }

    @UiThread
    public final void runUpdates(long frameTimeNanos) {
        block12: {
            AnimationDriver animation;
            int i;
            UiThreadUtil.assertOnUiThread();
            boolean hasFinishedAnimations = false;
            int n = this.updatedNodes.size();
            for (i = 0; i < n; ++i) {
                AnimatedNode node = (AnimatedNode)this.updatedNodes.valueAt(i);
                Intrinsics.checkNotNull((Object)node);
                this.runUpdateNodeList.add(node);
            }
            this.updatedNodes.clear();
            n = this.activeAnimations.size();
            for (i = 0; i < n; ++i) {
                animation = (AnimationDriver)this.activeAnimations.valueAt(i);
                animation.runAnimationStep(frameTimeNanos);
                if (animation.animatedValue != null) {
                    ValueAnimatedNode valueNode;
                    boolean bl = false;
                    this.runUpdateNodeList.add(valueNode);
                }
                if (!animation.hasFinished) continue;
                hasFinishedAnimations = true;
            }
            this.updateNodes(this.runUpdateNodeList);
            this.runUpdateNodeList.clear();
            if (!hasFinishedAnimations) break block12;
            WritableArray events = null;
            for (int i2 = this.activeAnimations.size() - 1; -1 < i2; --i2) {
                animation = (AnimationDriver)this.activeAnimations.valueAt(i2);
                if (!animation.hasFinished) continue;
                if (animation.animatedValue == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                if (animation.endCallback != null) {
                    WritableMap endCallbackResponse;
                    Intrinsics.checkNotNullExpressionValue((Object)Arguments.createMap(), (String)"createMap(...)");
                    endCallbackResponse.putBoolean("finished", true);
                    endCallbackResponse.putDouble("value", animatedValueNonnull.nodeValue);
                    endCallbackResponse.putDouble("offset", animatedValueNonnull.offset);
                    Callback callback = animation.endCallback;
                    if (callback != null) {
                        Object[] objectArray = new Object[]{endCallbackResponse};
                        callback.invoke(objectArray);
                    }
                } else if (this.reactApplicationContext != null) {
                    WritableMap params;
                    Intrinsics.checkNotNullExpressionValue((Object)Arguments.createMap(), (String)"createMap(...)");
                    params.putInt("animationId", animation.id);
                    params.putBoolean("finished", true);
                    params.putDouble("value", animatedValueNonnull.nodeValue);
                    params.putDouble("offset", animatedValueNonnull.offset);
                    WritableArray writableArray = events;
                    if (writableArray == null) {
                        WritableArray writableArray2 = Arguments.createArray();
                        writableArray = writableArray2;
                        Intrinsics.checkNotNullExpressionValue((Object)writableArray2, (String)"createArray(...)");
                    }
                    events = writableArray;
                    events.pushMap(params);
                }
                this.activeAnimations.removeAt(i2);
            }
            if (events != null) {
                ReactApplicationContext reactApplicationContext = this.reactApplicationContext;
                if (reactApplicationContext != null) {
                    reactApplicationContext.emitDeviceEvent("onNativeAnimatedModuleAnimationFinished", events);
                }
            }
        }
    }

    @NotNull
    public final Set<Integer> getTagsOfConnectedNodes$ReactAndroid_debug(int tag, @NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Set tags = new HashSet();
        Iterable $this$forEach$iv = this.eventDrivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventAnimationDriver driver = (EventAnimationDriver)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)eventName, (Object)driver.eventName) || tag != driver.viewTag) continue;
            tags.add(driver.viewTag);
            List list = driver.valueNode.children;
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AnimatedNode node = (AnimatedNode)element$iv2;
                boolean bl2 = false;
                tags.add(node.tag);
            }
        }
        return tags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    private final void updateNodes(List<? extends AnimatedNode> nodes) {
        int activeNodesCount = 0;
        int updatedNodesCount = 0;
        int n = this.animatedGraphBFSColor;
        this.animatedGraphBFSColor = n + 1;
        if (this.animatedGraphBFSColor == 0) {
            n = this.animatedGraphBFSColor;
            this.animatedGraphBFSColor = n + 1;
        }
        Queue nodesQueue = new ArrayDeque();
        for (AnimatedNode animatedNode : nodes) {
            if (animatedNode.BFSColor == this.animatedGraphBFSColor) continue;
            animatedNode.BFSColor = this.animatedGraphBFSColor;
            int n2 = activeNodesCount;
            activeNodesCount = n2 + 1;
            nodesQueue.add(animatedNode);
        }
        while (!((Collection)nodesQueue).isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            Object object = nextNode;
            if (object == null || (object = ((AnimatedNode)object).children) == null) continue;
            Iterable iterable = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                AnimatedNode child = (AnimatedNode)element$iv;
                boolean bl = false;
                int n3 = child.activeIncomingNodes;
                child.activeIncomingNodes = n3 + 1;
                if (child.BFSColor == this.animatedGraphBFSColor) continue;
                child.BFSColor = this.animatedGraphBFSColor;
                ++activeNodesCount;
                nodesQueue.add(child);
            }
        }
        int nextNode = this.animatedGraphBFSColor;
        this.animatedGraphBFSColor = nextNode + 1;
        if (this.animatedGraphBFSColor == 0) {
            nextNode = this.animatedGraphBFSColor;
            this.animatedGraphBFSColor = nextNode + 1;
        }
        for (AnimatedNode animatedNode : nodes) {
            if (animatedNode.activeIncomingNodes != 0 || animatedNode.BFSColor == this.animatedGraphBFSColor) continue;
            animatedNode.BFSColor = this.animatedGraphBFSColor;
            int n4 = updatedNodesCount;
            updatedNodesCount = n4 + 1;
            nodesQueue.add(animatedNode);
        }
        int cyclesDetected = 0;
        while (!nodesQueue.isEmpty()) {
            Object object;
            AnimatedNode animatedNode = (AnimatedNode)nodesQueue.poll();
            try {
                AnimatedNode animatedNode2 = animatedNode;
                if (animatedNode2 != null) {
                    animatedNode2.update$ReactAndroid_debug();
                }
                if (animatedNode instanceof PropsAnimatedNode) {
                    ((PropsAnimatedNode)animatedNode).updateView();
                }
            }
            catch (JSApplicationCausedNativeException jSApplicationCausedNativeException) {
                FLog.e((String)TAG, (String)"Native animation workaround, frame lost as result of race condition", (Throwable)jSApplicationCausedNativeException);
            }
            if (animatedNode instanceof ValueAnimatedNode) {
                ((ValueAnimatedNode)animatedNode).onValueUpdate();
            }
            if ((object = animatedNode) == null || (object = ((AnimatedNode)object).children) == null) continue;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnimatedNode child = (AnimatedNode)element$iv;
                boolean bl = false;
                int n5 = child.activeIncomingNodes;
                child.activeIncomingNodes = n5 + -1;
                if (child.BFSColor != this.animatedGraphBFSColor && child.activeIncomingNodes == 0) {
                    child.BFSColor = this.animatedGraphBFSColor;
                    ++updatedNodesCount;
                    nodesQueue.add(child);
                    continue;
                }
                if (child.BFSColor != this.animatedGraphBFSColor) continue;
                ++cyclesDetected;
            }
        }
        if (activeNodesCount != updatedNodesCount) {
            if (this.warnedAboutGraphTraversal) {
                return;
            }
            this.warnedAboutGraphTraversal = true;
            FLog.e((String)TAG, (String)"Detected animation cycle or disconnected graph. ");
            for (AnimatedNode animatedNode : nodes) {
                FLog.e((String)TAG, (String)animatedNode.prettyPrintWithChildren$ReactAndroid_debug());
            }
            Object object = cyclesDetected > 0 ? "cycles (" + cyclesDetected + ")" : "disconnected regions";
            IllegalStateException illegalStateException = new IllegalStateException("Looks like animated nodes graph has " + (String)object + ", there are " + activeNodesCount + " but toposort visited only " + updatedNodesCount);
            if (this.eventListenerInitializedForFabric && cyclesDetected == 0) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(illegalStateException));
                return;
            } else {
                if (!this.eventListenerInitializedForFabric) throw illegalStateException;
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(illegalStateException));
            }
            return;
        } else {
            this.warnedAboutGraphTraversal = false;
        }
    }

    private final String normalizeEventName(String eventHandlerName) {
        Object object;
        if (StringsKt.startsWith$default((String)eventHandlerName, (String)"on", (boolean)false, (int)2, null)) {
            String string2 = eventHandlerName.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = "top" + string2;
        } else {
            object = eventHandlerName;
        }
        return object;
    }

    private static final void onEventDispatch$lambda$3(NativeAnimatedNodesManager this$0, Event $event) {
        this$0.handleEvent($event);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/animated/NativeAnimatedNodesManager$Companion;", "", "<init>", "()V", "TAG", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

