/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ObjectAnimatedNode;
import com.facebook.react.animated.TransformAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\r\u0010\u0010\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/animated/StyleAnimatedNode;", "Lcom/facebook/react/animated/AnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "propMapping", "", "", "", "collectViewUpdates", "", "propsMap", "Lcom/facebook/react/bridge/JavaOnlyMap;", "prettyPrint", "prettyPrint$ReactAndroid_debug", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nStyleAnimatedNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleAnimatedNode.kt\ncom/facebook/react/animated/StyleAnimatedNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class StyleAnimatedNode
extends AnimatedNode {
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    @NotNull
    private final Map<String, Integer> propMapping;

    /*
     * WARNING - void declaration
     */
    public StyleAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        Map map;
        ReadableMap style;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        ReadableMap readableMap = style = config.getMap("style");
        ReadableMapKeySetIterator iter = readableMap != null ? readableMap.keySetIterator() : null;
        Map map2 = map = MapsKt.createMapBuilder();
        StyleAnimatedNode styleAnimatedNode = this;
        boolean bl = false;
        while (iter != null && iter.hasNextKey()) {
            void $this$_init__u24lambda_u240;
            String propKey = iter.nextKey();
            $this$_init__u24lambda_u240.put(propKey, style.getInt(propKey));
        }
        styleAnimatedNode.propMapping = MapsKt.build((Map)map);
    }

    public final void collectViewUpdates(@NotNull JavaOnlyMap propsMap) {
        Intrinsics.checkNotNullParameter((Object)propsMap, (String)"propsMap");
        for (Map.Entry<String, Integer> entry : this.propMapping.entrySet()) {
            String key = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            AnimatedNode node = this.nativeAnimatedNodesManager.getNodeById(value);
            if (node == null) {
                boolean $i$a$-requireNotNull-StyleAnimatedNode$collectViewUpdates$22 = false;
                String $i$a$-requireNotNull-StyleAnimatedNode$collectViewUpdates$22 = "Mapped style node does not exist";
                throw new IllegalArgumentException($i$a$-requireNotNull-StyleAnimatedNode$collectViewUpdates$22.toString());
            }
            if (node instanceof TransformAnimatedNode) {
                ((TransformAnimatedNode)node).collectViewUpdates(propsMap);
                continue;
            }
            if (node instanceof ValueAnimatedNode) {
                Object animatedObject = ((ValueAnimatedNode)node).getAnimatedObject();
                if (animatedObject instanceof Integer) {
                    propsMap.putInt(key, ((Number)animatedObject).intValue());
                    continue;
                }
                if (animatedObject instanceof String) {
                    propsMap.putString(key, (String)animatedObject);
                    continue;
                }
                propsMap.putDouble(key, ((ValueAnimatedNode)node).getValue());
                continue;
            }
            if (node instanceof ColorAnimatedNode) {
                propsMap.putInt(key, ((ColorAnimatedNode)node).getColor());
                continue;
            }
            if (node instanceof ObjectAnimatedNode) {
                ((ObjectAnimatedNode)node).collectViewUpdates(key, propsMap);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of node used in property node " + node.getClass());
        }
    }

    @Override
    @NotNull
    public String prettyPrint$ReactAndroid_debug() {
        return "StyleAnimatedNode[" + this.tag + "] mPropMapping: " + this.propMapping;
    }
}

