/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.ReadableType;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0082 \u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0082 \u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\u0013\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\u0010\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070*H\u0016R#\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lcom/facebook/react/bridge/ReadableNativeArray;", "Lcom/facebook/react/bridge/NativeArray;", "Lcom/facebook/react/bridge/ReadableArray;", "<init>", "()V", "localArray", "", "", "getLocalArray", "()[Ljava/lang/Object;", "localArray$delegate", "Lkotlin/Lazy;", "importArray", "localTypeArray", "Lcom/facebook/react/bridge/ReadableType;", "getLocalTypeArray", "()[Lcom/facebook/react/bridge/ReadableType;", "localTypeArray$delegate", "importTypeArray", "size", "", "isNull", "", "index", "getBoolean", "getDouble", "", "getInt", "getLong", "", "getString", "", "getArray", "getMap", "Lcom/facebook/react/bridge/ReadableNativeMap;", "getType", "getDynamic", "Lcom/facebook/react/bridge/Dynamic;", "hashCode", "equals", "other", "toArrayList", "Ljava/util/ArrayList;", "Companion", "ReactAndroid_debug"})
@DoNotStrip
public class ReadableNativeArray
extends NativeArray
implements ReadableArray {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy localArray$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> ReadableNativeArray.localArray_delegate$lambda$0(this));
    @NotNull
    private final Lazy localTypeArray$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> ReadableNativeArray.localTypeArray_delegate$lambda$1(this));
    private static int jniPassCounter;

    protected ReadableNativeArray() {
    }

    private final Object[] getLocalArray() {
        Lazy lazy = this.localArray$delegate;
        return (Object[])lazy.getValue();
    }

    private final native Object[] importArray();

    private final ReadableType[] getLocalTypeArray() {
        Lazy lazy = this.localTypeArray$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ReadableType[])object;
    }

    private final native Object[] importTypeArray();

    @Override
    public int size() {
        return this.getLocalArray().length;
    }

    @Override
    public boolean isNull(int index) {
        return this.getLocalArray()[index] == null;
    }

    @Override
    public boolean getBoolean(int index) {
        Object object = this.getLocalArray()[index];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    @Override
    public double getDouble(int index) {
        Object object = this.getLocalArray()[index];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        return (Double)object;
    }

    @Override
    public int getInt(int index) {
        Object object = this.getLocalArray()[index];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        return (int)((Double)object).doubleValue();
    }

    @Override
    public long getLong(int index) {
        Object object = this.getLocalArray()[index];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    @Override
    @Nullable
    public String getString(int index) {
        return (String)this.getLocalArray()[index];
    }

    @Override
    @Nullable
    public ReadableNativeArray getArray(int index) {
        return (ReadableNativeArray)this.getLocalArray()[index];
    }

    @Override
    @Nullable
    public ReadableNativeMap getMap(int index) {
        return (ReadableNativeMap)this.getLocalArray()[index];
    }

    @Override
    @NotNull
    public ReadableType getType(int index) {
        return this.getLocalTypeArray()[index];
    }

    @Override
    @NotNull
    public Dynamic getDynamic(int index) {
        return DynamicFromArray.Companion.create(this, index);
    }

    public int hashCode() {
        return this.getLocalArray().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ReadableNativeArray)) {
            return false;
        }
        return ArraysKt.contentDeepEquals((Object[])this.getLocalArray(), (Object[])((ReadableNativeArray)other).getLocalArray());
    }

    @Override
    @NotNull
    public ArrayList<Object> toArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getType(i2).ordinal()]) {
                case 1: {
                    boolean bl2 = arrayList.add(null);
                    break;
                }
                case 2: {
                    boolean bl2 = arrayList.add(this.getBoolean(i2));
                    break;
                }
                case 3: {
                    boolean bl2 = arrayList.add(this.getDouble(i2));
                    break;
                }
                case 4: {
                    boolean bl2 = arrayList.add(this.getString(i2));
                    break;
                }
                case 5: {
                    ReadableNativeMap readableNativeMap = this.getMap(i2);
                    boolean bl2 = arrayList.add(readableNativeMap != null ? readableNativeMap.toHashMap() : null);
                    break;
                }
                case 6: {
                    ReadableNativeArray readableNativeArray = this.getArray(i2);
                    boolean bl2 = arrayList.add(readableNativeArray != null ? readableNativeArray.toArrayList() : null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return arrayList;
    }

    private static final Object[] localArray_delegate$lambda$0(ReadableNativeArray this$0) {
        int n = jniPassCounter;
        jniPassCounter = n + 1;
        return this$0.importArray();
    }

    private static final ReadableType[] localTypeArray_delegate$lambda$1(ReadableNativeArray this$0) {
        int n = jniPassCounter;
        jniPassCounter = n + 1;
        Object[] tempArray = this$0.importTypeArray();
        return (ReadableType[])Arrays.copyOf(tempArray, tempArray.length, ReadableType[].class);
    }

    @JvmStatic
    @JvmName(name="getJNIPassCounter")
    public static final int getJNIPassCounter() {
        return Companion.getJNIPassCounter();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/bridge/ReadableNativeArray$Companion;", "", "<init>", "()V", "value", "", "jniPassCounter", "getJNIPassCounter", "()I", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="getJNIPassCounter")
        public final int getJNIPassCounter() {
            return jniPassCounter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.Null.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Boolean.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Number.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Map.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Array.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

