/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.facebook.react.R;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lcom/facebook/react/devsupport/ChangeBundleLocationDialog;", "", "<init>", "()V", "show", "", "context", "Landroid/content/Context;", "devSettings", "Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "onClickListener", "Lcom/facebook/react/devsupport/ChangeBundleLocationDialog$ChangeBundleLocationDialogListener;", "ChangeBundleLocationDialogListener", "ReactAndroid_debug"})
public final class ChangeBundleLocationDialog {
    @NotNull
    public static final ChangeBundleLocationDialog INSTANCE = new ChangeBundleLocationDialog();

    private ChangeBundleLocationDialog() {
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void show(@NotNull Context context, @NotNull DeveloperSettings devSettings2, @NotNull ChangeBundleLocationDialogListener onClickListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)devSettings2, (String)"devSettings");
        Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
        PackagerConnectionSettings settings = devSettings2.getPackagerConnectionSettings();
        String currentHost = settings.getDebugServerHost();
        settings.setDebugServerHost("");
        String defaultHost = settings.getDebugServerHost();
        settings.setDebugServerHost(currentHost);
        LinearLayout layout = new LinearLayout(context);
        layout.setOrientation(1);
        int paddingSmall = (int)((float)4 * context.getResources().getDisplayMetrics().density);
        int paddingLarge = (int)((float)16 * context.getResources().getDisplayMetrics().density);
        layout.setPadding(paddingLarge, paddingLarge, paddingLarge, paddingLarge);
        TextView label = new TextView(context);
        label.setText((CharSequence)context.getString(R.string.catalyst_change_bundle_location_input_label));
        label.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        EditText input = new EditText(context);
        input.setInputType(1);
        input.setHint((CharSequence)context.getString(R.string.catalyst_change_bundle_location_input_hint));
        input.setBackgroundResource(17301526);
        input.setHintTextColor(-3355444);
        input.setTextColor(-16777216);
        input.setText((CharSequence)currentHost);
        Button defaultHostSuggestion = new Button(context);
        defaultHostSuggestion.setText((CharSequence)defaultHost);
        defaultHostSuggestion.setTextSize(12.0f);
        defaultHostSuggestion.setAllCaps(false);
        defaultHostSuggestion.setOnClickListener(arg_0 -> ChangeBundleLocationDialog.show$lambda$0(input, defaultHost, arg_0));
        String networkHost = AndroidInfoHelpers.INSTANCE.getDevServerNetworkIpAndPort$ReactAndroid_debug(context);
        Button networkHostSuggestion = new Button(context);
        networkHostSuggestion.setText((CharSequence)networkHost);
        networkHostSuggestion.setTextSize(12.0f);
        networkHostSuggestion.setAllCaps(false);
        networkHostSuggestion.setOnClickListener(arg_0 -> ChangeBundleLocationDialog.show$lambda$1(input, networkHost, arg_0));
        LinearLayout suggestionRow = new LinearLayout(context);
        suggestionRow.setOrientation(0);
        suggestionRow.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        suggestionRow.addView((View)defaultHostSuggestion);
        suggestionRow.addView((View)networkHostSuggestion);
        TextView instructions = new TextView(context);
        Object[] objectArray = new Object[]{AndroidInfoHelpers.getAdbReverseTcpCommand(context)};
        instructions.setText((CharSequence)context.getString(R.string.catalyst_change_bundle_location_instructions, objectArray));
        LinearLayout.LayoutParams instructionsParams = new LinearLayout.LayoutParams(-1, -2);
        instructionsParams.setMargins(0, paddingSmall, 0, paddingLarge);
        instructions.setLayoutParams((ViewGroup.LayoutParams)instructionsParams);
        Button applyChangesButton = new Button(context);
        applyChangesButton.setText((CharSequence)context.getString(R.string.catalyst_change_bundle_location_apply));
        Button cancelButton = new Button(context);
        cancelButton.setText((CharSequence)context.getString(R.string.catalyst_change_bundle_location_cancel));
        layout.addView((View)label);
        layout.addView((View)input);
        layout.addView((View)suggestionRow);
        layout.addView((View)instructions);
        layout.addView((View)applyChangesButton);
        layout.addView((View)cancelButton);
        AlertDialog dialog = new AlertDialog.Builder(context).setTitle((CharSequence)context.getString(R.string.catalyst_change_bundle_location)).setView((View)layout).create();
        applyChangesButton.setOnClickListener(arg_0 -> ChangeBundleLocationDialog.show$lambda$2(onClickListener, input, dialog, arg_0));
        cancelButton.setOnClickListener(arg_0 -> ChangeBundleLocationDialog.show$lambda$3(dialog, arg_0));
        dialog.show();
    }

    private static final void show$lambda$0(EditText $input, String $defaultHost, View it) {
        $input.setText((CharSequence)$defaultHost);
    }

    private static final void show$lambda$1(EditText $input, String $networkHost, View it) {
        $input.setText((CharSequence)$networkHost);
    }

    private static final void show$lambda$2(ChangeBundleLocationDialogListener $onClickListener, EditText $input, AlertDialog $dialog, View it) {
        $onClickListener.onClick($input.getText().toString());
        $dialog.dismiss();
    }

    private static final void show$lambda$3(AlertDialog $dialog, View it) {
        $dialog.dismiss();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/devsupport/ChangeBundleLocationDialog$ChangeBundleLocationDialogListener;", "", "onClick", "", "newHostAndPort", "", "ReactAndroid_debug"})
    public static interface ChangeBundleLocationDialogListener {
        public void onClick(@NotNull String var1);
    }
}

