/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.runtime.internal.bolts.Continuation;
import com.facebook.react.runtime.internal.bolts.ExecutorException;
import com.facebook.react.runtime.internal.bolts.Executors;
import com.facebook.react.runtime.internal.bolts.TaskCompletionSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 2*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00012B\t\b\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0013\b\u0012\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\tJ\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u000f\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0000J2\u0010\"\u001a\b\u0012\u0004\u0012\u0002H#0\u0000\"\u0004\b\u0001\u0010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H#0\u00132\b\b\u0002\u0010%\u001a\u00020&H\u0007J8\u0010'\u001a\b\u0012\u0004\u0012\u0002H#0\u0000\"\u0004\b\u0001\u0010#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u00000\u00132\b\b\u0002\u0010%\u001a\u00020&H\u0007J0\u0010(\u001a\b\u0012\u0004\u0012\u0002H#0\u0000\"\u0004\b\u0001\u0010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H#0\u00132\b\b\u0002\u0010%\u001a\u00020&J6\u0010)\u001a\b\u0012\u0004\u0012\u0002H#0\u0000\"\u0004\b\u0001\u0010#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0\u00000\u00132\b\b\u0002\u0010%\u001a\u00020&J\b\u0010*\u001a\u00020\u0014H\u0002J\r\u0010+\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b,J\u0019\u0010-\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000H\u0000\u00a2\u0006\u0004\b.\u0010/J\u001d\u00100\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u0000\u00a2\u0006\u0002\b1R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/facebook/react/runtime/internal/bolts/Task;", "TResult", "Lcom/facebook/react/interfaces/TaskInterface;", "<init>", "()V", "result", "(Ljava/lang/Object;)V", "cancelled", "", "(Z)V", "lock", "Ljava/lang/Object;", "complete", "Ljava/lang/Object;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "continuations", "", "Lcom/facebook/react/runtime/internal/bolts/Continuation;", "", "isCompleted", "isCancelled", "isFaulted", "getResult", "()Ljava/lang/Object;", "getError", "waitForCompletion", "duration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "makeVoid", "Ljava/lang/Void;", "continueWith", "TContinuationResult", "continuation", "executor", "Ljava/util/concurrent/Executor;", "continueWithTask", "onSuccess", "onSuccessTask", "runContinuations", "trySetCancelled", "trySetCancelled$ReactAndroid_debug", "trySetResult", "trySetResult$ReactAndroid_debug", "(Ljava/lang/Object;)Z", "trySetError", "trySetError$ReactAndroid_debug", "Companion", "ReactAndroid_debug"})
public final class Task<TResult>
implements TaskInterface<TResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    private boolean complete;
    private boolean cancelled;
    @Nullable
    private TResult result;
    @Nullable
    private Exception error;
    @NotNull
    private final List<Continuation<TResult, Unit>> continuations = new ArrayList();
    @JvmField
    @NotNull
    public static final Executor IMMEDIATE_EXECUTOR = Executors.IMMEDIATE;
    @JvmField
    @NotNull
    public static final Executor UI_THREAD_EXECUTOR = Executors.UI_THREAD;
    @NotNull
    private static final Task<Void> TASK_NULL = new Task<Object>(null);
    @NotNull
    private static final Task<Boolean> TASK_TRUE = new Task<Boolean>(Boolean.valueOf(true));
    @NotNull
    private static final Task<Boolean> TASK_FALSE = new Task<Boolean>(Boolean.valueOf(false));
    @NotNull
    private static final Task<Object> TASK_CANCELLED = new Task(true);

    public Task() {
    }

    private Task(TResult result) {
        this.trySetResult$ReactAndroid_debug(result);
    }

    private Task(boolean cancelled) {
        boolean bl = cancelled ? this.trySetCancelled$ReactAndroid_debug() : this.trySetResult$ReactAndroid_debug(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.complete;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.cancelled;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFaulted() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.getError() != null;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TResult getResult() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            TResult TResult = this.result;
            return TResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Exception getError() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Exception exception = this.error;
            return exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.isCompleted()) {
                this.lock.wait();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForCompletion(long duration, @NotNull TimeUnit timeUnit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.isCompleted()) {
                this.lock.wait(timeUnit.toMillis(duration));
            }
            boolean bl2 = this.isCompleted();
            return bl2;
        }
    }

    @NotNull
    public final Task<Void> makeVoid() {
        return Task.continueWithTask$default(this, Task::makeVoid$lambda$7, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NotNull Continuation<TResult, TContinuationResult> continuation, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        boolean completed2 = false;
        TaskCompletionSource tcs = new TaskCompletionSource();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            completed2 = this.isCompleted();
            if (!completed2) {
                this.continuations.add(arg_0 -> Task.continueWith$lambda$9$lambda$8(tcs, continuation, executor, arg_0));
            }
            Unit unit = Unit.INSTANCE;
        }
        if (completed2) {
            Task.Companion.completeImmediately(tcs, continuation, this, executor);
        }
        return tcs.getTask();
    }

    public static /* synthetic */ Task continueWith$default(Task task, Continuation continuation, Executor executor, int n, Object object) {
        if ((n & 2) != 0) {
            executor = IMMEDIATE_EXECUTOR;
        }
        return task.continueWith(continuation, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NotNull Continuation<TResult, Task<TContinuationResult>> continuation, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        boolean completed2 = false;
        TaskCompletionSource tcs = new TaskCompletionSource();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            completed2 = this.isCompleted();
            if (!completed2) {
                this.continuations.add(arg_0 -> Task.continueWithTask$lambda$11$lambda$10(tcs, continuation, executor, arg_0));
            }
            Unit unit = Unit.INSTANCE;
        }
        if (completed2) {
            Task.Companion.completeAfterTask(tcs, continuation, this, executor);
        }
        return tcs.getTask();
    }

    public static /* synthetic */ Task continueWithTask$default(Task task, Continuation continuation, Executor executor, int n, Object object) {
        if ((n & 2) != 0) {
            executor = IMMEDIATE_EXECUTOR;
        }
        return task.continueWithTask(continuation, executor);
    }

    @NotNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccess(@NotNull Continuation<TResult, TContinuationResult> continuation, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return this.continueWithTask(arg_0 -> Task.onSuccess$lambda$12(continuation, arg_0), executor);
    }

    public static /* synthetic */ Task onSuccess$default(Task task, Continuation continuation, Executor executor, int n, Object object) {
        if ((n & 2) != 0) {
            executor = IMMEDIATE_EXECUTOR;
        }
        return task.onSuccess(continuation, executor);
    }

    @NotNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NotNull Continuation<TResult, Task<TContinuationResult>> continuation, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return this.continueWithTask(arg_0 -> Task.onSuccessTask$lambda$13(continuation, arg_0), executor);
    }

    public static /* synthetic */ Task onSuccessTask$default(Task task, Continuation continuation, Executor executor, int n, Object object) {
        if ((n & 2) != 0) {
            executor = IMMEDIATE_EXECUTOR;
        }
        return task.onSuccessTask(continuation, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runContinuations() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            for (Continuation<TResult, Unit> continuation : this.continuations) {
                try {
                    Unit unit = continuation.then(this);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.continuations.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetCancelled$ReactAndroid_debug() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (!this.complete) break block4;
                boolean bl2 = false;
                return bl2;
            }
            this.complete = true;
            this.cancelled = true;
            this.lock.notifyAll();
            this.runContinuations();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetResult$ReactAndroid_debug(@Nullable TResult result) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (!this.complete) break block4;
                boolean bl2 = false;
                return bl2;
            }
            this.complete = true;
            this.result = result;
            this.lock.notifyAll();
            this.runContinuations();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetError$ReactAndroid_debug(@Nullable Exception error) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (!this.complete) break block4;
                boolean bl2 = false;
                return bl2;
            }
            this.complete = true;
            this.error = error;
            this.lock.notifyAll();
            this.runContinuations();
            boolean bl = true;
            return bl;
        }
    }

    @JvmOverloads
    @NotNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NotNull Continuation<TResult, TContinuationResult> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        return Task.continueWith$default(this, continuation, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NotNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        return Task.continueWithTask$default(this, continuation, null, 2, null);
    }

    private static final Task makeVoid$lambda$7(Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return task.isCancelled() ? Companion.cancelled() : (task.isFaulted() ? Companion.forError(task.getError()) : TASK_NULL);
    }

    private static final Unit continueWith$lambda$9$lambda$8(TaskCompletionSource $tcs, Continuation $continuation, Executor $executor, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Task.Companion.completeImmediately($tcs, $continuation, task, $executor);
        return Unit.INSTANCE;
    }

    private static final Unit continueWithTask$lambda$11$lambda$10(TaskCompletionSource $tcs, Continuation $continuation, Executor $executor, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Task.Companion.completeAfterTask($tcs, $continuation, task, $executor);
        return Unit.INSTANCE;
    }

    private static final Task onSuccess$lambda$12(Continuation $continuation, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return task.isCancelled() ? Companion.cancelled() : (task.isFaulted() ? Companion.forError(task.getError()) : Task.continueWith$default(task, $continuation, null, 2, null));
    }

    private static final Task onSuccessTask$lambda$13(Continuation $continuation, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return task.isCancelled() ? Companion.cancelled() : (task.isFaulted() ? Companion.forError(task.getError()) : Task.continueWithTask$default(task, $continuation, null, 2, null));
    }

    @JvmStatic
    @NotNull
    public static final <TResult> TaskCompletionSource<TResult> create$ReactAndroid_debug() {
        return Companion.create$ReactAndroid_debug();
    }

    @JvmStatic
    @NotNull
    public static final <TResult> Task<TResult> forResult(@Nullable TResult value) {
        return Companion.forResult(value);
    }

    @JvmStatic
    @NotNull
    public static final <TResult> Task<TResult> forError(@Nullable Exception error) {
        return Companion.forError(error);
    }

    @JvmStatic
    @NotNull
    public static final <TResult> Task<TResult> cancelled() {
        return Companion.cancelled();
    }

    @JvmStatic
    @NotNull
    public static final <TResult> Task<TResult> call(@NotNull Callable<Task<TResult>> callable, @NotNull Executor executor) {
        return Companion.call(callable, executor);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0001\u0010\tH\u0001\u00a2\u0006\u0002\b\nJ#\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\"\u0004\b\u0001\u0010\t2\b\u0010\r\u001a\u0004\u0018\u0001H\tH\u0007\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\f\"\u0004\b\u0001\u0010\t2\u000e\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012H\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\t0\f\"\u0004\b\u0001\u0010\tH\u0007J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\f\"\u0004\b\u0001\u0010\t2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\f0\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0007JL\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u001a0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002JR\u0010\u001f\u001a\u00020\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\f0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/runtime/internal/bolts/Task$Companion;", "", "<init>", "()V", "IMMEDIATE_EXECUTOR", "Ljava/util/concurrent/Executor;", "UI_THREAD_EXECUTOR", "create", "Lcom/facebook/react/runtime/internal/bolts/TaskCompletionSource;", "TResult", "create$ReactAndroid_debug", "forResult", "Lcom/facebook/react/runtime/internal/bolts/Task;", "value", "(Ljava/lang/Object;)Lcom/facebook/react/runtime/internal/bolts/Task;", "forError", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cancelled", "call", "callable", "Ljava/util/concurrent/Callable;", "executor", "completeImmediately", "", "TContinuationResult", "tcs", "continuation", "Lcom/facebook/react/runtime/internal/bolts/Continuation;", "task", "completeAfterTask", "TASK_NULL", "Ljava/lang/Void;", "TASK_TRUE", "", "TASK_FALSE", "TASK_CANCELLED", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <TResult> TaskCompletionSource<TResult> create$ReactAndroid_debug() {
            return new TaskCompletionSource();
        }

        @JvmStatic
        @NotNull
        public final <TResult> Task<TResult> forResult(@Nullable TResult value) {
            if (value == null) {
                Task task = TASK_NULL;
                Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type com.facebook.react.runtime.internal.bolts.Task<TResult of com.facebook.react.runtime.internal.bolts.Task.Companion.forResult>");
                return task;
            }
            if (value instanceof Boolean) {
                Task task = (Boolean)value != false ? TASK_TRUE : TASK_FALSE;
                Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type com.facebook.react.runtime.internal.bolts.Task<TResult of com.facebook.react.runtime.internal.bolts.Task.Companion.forResult>");
                return task;
            }
            TaskCompletionSource<TResult> tcs = new TaskCompletionSource<TResult>();
            tcs.setResult(value);
            return tcs.getTask();
        }

        @JvmStatic
        @NotNull
        public final <TResult> Task<TResult> forError(@Nullable Exception error) {
            TaskCompletionSource tcs = new TaskCompletionSource();
            tcs.setError(error);
            return tcs.getTask();
        }

        @JvmStatic
        @NotNull
        public final <TResult> Task<TResult> cancelled() {
            Task task = TASK_CANCELLED;
            Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type com.facebook.react.runtime.internal.bolts.Task<TResult of com.facebook.react.runtime.internal.bolts.Task.Companion.cancelled>");
            return task;
        }

        @JvmStatic
        @NotNull
        public final <TResult> Task<TResult> call(@NotNull Callable<Task<TResult>> callable, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            TaskCompletionSource tcs = new TaskCompletionSource();
            try {
                executor.execute(() -> Companion.call$lambda$2(callable, tcs));
            }
            catch (Exception e) {
                tcs.setError(new ExecutorException(e));
            }
            return tcs.getTask();
        }

        private final <TContinuationResult, TResult> void completeImmediately(TaskCompletionSource<TContinuationResult> tcs, Continuation<TResult, TContinuationResult> continuation, Task<TResult> task, Executor executor) {
            try {
                executor.execute(() -> Companion.completeImmediately$lambda$3(continuation, task, tcs));
            }
            catch (Exception e) {
                tcs.setError(new ExecutorException(e));
            }
        }

        private final <TContinuationResult, TResult> void completeAfterTask(TaskCompletionSource<TContinuationResult> tcs, Continuation<TResult, Task<TContinuationResult>> continuation, Task<TResult> task, Executor executor) {
            try {
                executor.execute(() -> Companion.completeAfterTask$lambda$5(continuation, task, tcs));
            }
            catch (Exception e) {
                tcs.setError(new ExecutorException(e));
            }
        }

        private static final Unit call$lambda$2$lambda$0(TaskCompletionSource $tcs, Task task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            if (task.isCancelled()) {
                $tcs.setCancelled();
            } else if (task.isFaulted()) {
                $tcs.setError(task.getError());
            } else {
                $tcs.setResult(task.getResult());
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void call$lambda$2(Callable $callable, TaskCompletionSource $tcs) {
            Continuation continuation = arg_0 -> Companion.call$lambda$2$lambda$0($tcs, arg_0);
            try {
                Task task = (Task)$callable.call();
                Object object = task.lock;
                synchronized (object) {
                    Object object2;
                    boolean bl = false;
                    if (task.isCompleted()) {
                        Intrinsics.checkNotNull((Object)task);
                        object2 = continuation.then(task);
                    } else {
                        object2 = task.continuations.add(continuation);
                    }
                    Object object3 = object2;
                }
            }
            catch (CancellationException e) {
                $tcs.setCancelled();
            }
            catch (Exception e) {
                $tcs.setError(e);
            }
        }

        private static final void completeImmediately$lambda$3(Continuation $continuation, Task $task, TaskCompletionSource $tcs) {
            try {
                Object result = $continuation.then($task);
                $tcs.setResult(result);
            }
            catch (CancellationException e) {
                $tcs.setCancelled();
            }
            catch (Exception e) {
                $tcs.setError(e);
            }
        }

        private static final Unit completeAfterTask$lambda$5$lambda$4(TaskCompletionSource $tcs, Task task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            if (task.isCancelled()) {
                $tcs.setCancelled();
            } else if (task.isFaulted()) {
                $tcs.setError(task.getError());
            } else {
                $tcs.setResult(task.getResult());
            }
            return Unit.INSTANCE;
        }

        private static final void completeAfterTask$lambda$5(Continuation $continuation, Task $task, TaskCompletionSource $tcs) {
            try {
                Task result = (Task)$continuation.then($task);
                if (result == null) {
                    $tcs.setResult(null);
                } else {
                    Task.continueWith$default(result, arg_0 -> Companion.completeAfterTask$lambda$5$lambda$4($tcs, arg_0), null, 2, null);
                }
            }
            catch (CancellationException e) {
                $tcs.setCancelled();
            }
            catch (Exception e) {
                $tcs.setError(e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

