/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.debuggingoverlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.UiThread;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.views.debuggingoverlay.TraceUpdate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0007J\u0016\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007J\b\u0010\u0019\u001a\u00020\u0014H\u0007J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlay;", "Landroid/view/View;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "traceUpdatePaint", "Landroid/graphics/Paint;", "traceUpdatesToDisplayMap", "Ljava/util/HashMap;", "", "Lcom/facebook/react/views/debuggingoverlay/TraceUpdate;", "Lkotlin/collections/HashMap;", "traceUpdateIdToCleanupRunnableMap", "Ljava/lang/Runnable;", "highlightedElementsPaint", "highlightedElementsRectangles", "", "Landroid/graphics/RectF;", "setTraceUpdates", "", "traceUpdates", "", "setHighlightedElementsRectangles", "elementsRectangles", "clearElementsHighlights", "onDraw", "canvas", "Landroid/graphics/Canvas;", "ReactAndroid_debug"})
public final class DebuggingOverlay
extends View {
    @NotNull
    private final Paint traceUpdatePaint;
    @NotNull
    private final HashMap<Integer, TraceUpdate> traceUpdatesToDisplayMap;
    @NotNull
    private final HashMap<Integer, Runnable> traceUpdateIdToCleanupRunnableMap;
    @NotNull
    private final Paint highlightedElementsPaint;
    @NotNull
    private List<RectF> highlightedElementsRectangles;

    public DebuggingOverlay(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.traceUpdatePaint = new Paint();
        this.traceUpdatesToDisplayMap = new HashMap();
        this.traceUpdateIdToCleanupRunnableMap = new HashMap();
        this.highlightedElementsPaint = new Paint();
        this.highlightedElementsRectangles = new ArrayList();
        this.traceUpdatePaint.setStyle(Paint.Style.STROKE);
        this.traceUpdatePaint.setStrokeWidth(6.0f);
        this.highlightedElementsPaint.setStyle(Paint.Style.FILL);
        this.highlightedElementsPaint.setColor(-859248897);
    }

    @UiThread
    public final void setTraceUpdates(@NotNull List<TraceUpdate> traceUpdates) {
        Intrinsics.checkNotNullParameter(traceUpdates, (String)"traceUpdates");
        for (TraceUpdate traceUpdate : traceUpdates) {
            int traceUpdateId = traceUpdate.getId();
            if (this.traceUpdateIdToCleanupRunnableMap.containsKey(traceUpdateId)) {
                if (this.traceUpdateIdToCleanupRunnableMap.get(traceUpdateId) != null) {
                    Runnable runnable;
                    boolean bl = false;
                    UiThreadUtil.removeOnUiThread(runnable);
                }
                this.traceUpdateIdToCleanupRunnableMap.remove(traceUpdateId);
            }
            Integer n = traceUpdateId;
            ((Map)this.traceUpdatesToDisplayMap).put(n, traceUpdate);
        }
        this.invalidate();
    }

    @UiThread
    public final void setHighlightedElementsRectangles(@NotNull List<RectF> elementsRectangles) {
        Intrinsics.checkNotNullParameter(elementsRectangles, (String)"elementsRectangles");
        this.highlightedElementsRectangles = elementsRectangles;
        this.invalidate();
    }

    @UiThread
    public final void clearElementsHighlights() {
        this.highlightedElementsRectangles.clear();
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Iterator<TraceUpdate> iterator2 = this.traceUpdatesToDisplayMap.values().iterator();
        while (iterator2.hasNext()) {
            TraceUpdate traceUpdate;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            this.traceUpdatePaint.setColor(traceUpdate.getColor());
            canvas.drawRect(traceUpdate.getRectangle(), this.traceUpdatePaint);
            int traceUpdateId = traceUpdate.getId();
            Runnable block = () -> DebuggingOverlay.onDraw$lambda$1(this, traceUpdateId);
            if (this.traceUpdateIdToCleanupRunnableMap.containsKey(traceUpdateId)) continue;
            Integer n = traceUpdateId;
            ((Map)this.traceUpdateIdToCleanupRunnableMap).put(n, block);
            UiThreadUtil.runOnUiThread(block, 2000L);
        }
        for (RectF elementRectangle : this.highlightedElementsRectangles) {
            canvas.drawRect(elementRectangle, this.highlightedElementsPaint);
        }
    }

    private static final void onDraw$lambda$1(DebuggingOverlay this$0, int $traceUpdateId) {
        this$0.traceUpdatesToDisplayMap.remove($traceUpdateId);
        this$0.traceUpdateIdToCleanupRunnableMap.remove($traceUpdateId);
        this$0.invalidate();
    }
}

