/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.os.Build;
import android.text.Spannable;
import android.text.Spanned;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.R;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.internal.SystraceSection;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.IViewManagerWithChildren;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactTextAnchorViewManager;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextView;
import com.facebook.react.views.text.ReactTextViewAccessibilityDelegate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import com.facebook.yoga.YogaMeasureMode;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="RCTText")
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactTextViewManager
extends ReactTextAnchorViewManager<ReactTextShadowNode>
implements IViewManagerWithChildren {
    private static final String TAG = "ReactTextViewManager";
    private static final short TX_STATE_KEY_ATTRIBUTED_STRING = 0;
    private static final short TX_STATE_KEY_PARAGRAPH_ATTRIBUTES = 1;
    private static final short TX_STATE_KEY_HASH = 2;
    private static final short TX_STATE_KEY_MOST_RECENT_EVENT_COUNT = 3;
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTText";
    @Nullable
    protected ReactTextViewManagerCallback mReactTextViewManagerCallback;

    public ReactTextViewManager() {
        this((ReactTextViewManagerCallback)null);
    }

    public ReactTextViewManager(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.mReactTextViewManagerCallback = reactTextViewManagerCallback;
        if (ReactNativeFeatureFlags.enableViewRecyclingForText()) {
            this.setupViewRecycling();
        }
    }

    @Override
    @Nullable
    protected ReactTextView prepareToRecycleView(@NonNull ThemedReactContext reactContext, ReactTextView view) {
        ReactTextView preparedView = super.prepareToRecycleView(reactContext, view);
        if (preparedView != null) {
            preparedView.recycleView();
            this.setSelectionColor(preparedView, null);
        }
        return preparedView;
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void updateViewAccessibility(@NonNull ReactTextView view) {
        ReactTextViewAccessibilityDelegate.Companion.setDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
    }

    @Override
    public ReactTextView createViewInstance(ThemedReactContext context) {
        return new ReactTextView((Context)context);
    }

    @Override
    public void updateExtraData(ReactTextView view, Object extraData) {
        try (SystraceSection s = new SystraceSection("ReactTextViewManager.updateExtraData");){
            ReactTextUpdate update = (ReactTextUpdate)extraData;
            Spannable spannable = update.getText();
            if (update.containsImages()) {
                TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            view.setText(update);
            ReactTextViewAccessibilityDelegate.AccessibilityLinks accessibilityLinks = new ReactTextViewAccessibilityDelegate.AccessibilityLinks((Spanned)spannable);
            view.setTag(R.id.accessibility_links, accessibilityLinks.size() > 0 ? accessibilityLinks : null);
            ReactTextViewAccessibilityDelegate.Companion.resetDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
        }
    }

    @Override
    public ReactTextShadowNode createShadowNodeInstance() {
        return new ReactTextShadowNode(this.mReactTextViewManagerCallback);
    }

    public ReactTextShadowNode createShadowNodeInstance(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        return new ReactTextShadowNode(reactTextViewManagerCallback);
    }

    @Override
    public Class<ReactTextShadowNode> getShadowNodeClass() {
        return ReactTextShadowNode.class;
    }

    @Override
    protected void onAfterUpdateTransaction(ReactTextView view) {
        super.onAfterUpdateTransaction(view);
        view.updateView();
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    @Nullable
    public Object updateState(ReactTextView view, ReactStylesDiffMap props, StateWrapper stateWrapper) {
        try (SystraceSection s = new SystraceSection("ReactTextViewManager.updateState");){
            ReadableMapBuffer stateMapBuffer = stateWrapper.getStateDataMapBuffer();
            if (stateMapBuffer != null) {
                Object object = this.getReactTextUpdate(view, props, stateMapBuffer);
                return object;
            }
            Object var6_8 = null;
            return var6_8;
        }
    }

    private Object getReactTextUpdate(ReactTextView view, ReactStylesDiffMap props, MapBuffer state) {
        MapBuffer attributedString = state.getMapBuffer(0);
        MapBuffer paragraphAttributes = state.getMapBuffer(1);
        Spannable spanned = TextLayoutManager.getOrCreateSpannableForText(view.getContext(), attributedString, this.mReactTextViewManagerCallback);
        view.setSpanned(spanned);
        try {
            float minimumFontSize = (float)paragraphAttributes.getDouble(6);
            view.setMinimumFontSize(minimumFontSize);
        }
        catch (IllegalArgumentException e) {
            FLog.e((String)TAG, (String)"Paragraph Attributes: %s", (Object[])new Object[]{paragraphAttributes != null ? paragraphAttributes.toString() : "<empty>"});
            throw e;
        }
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        int currentJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : view.getJustificationMode();
        return new ReactTextUpdate(spanned, -1, false, TextLayoutManager.getTextGravity(attributedString, spanned, view.getGravityHorizontal()), textBreakStrategy, TextAttributeProps.getJustificationMode(props, currentJustificationMode));
    }

    @Override
    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        HashMap<String, Map<String, String>> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Map<String, String>> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Map<String, String>>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.of("topTextLayout", MapBuilder.of("registrationName", "onTextLayout")));
        return eventTypeConstants;
    }

    @Override
    public long measure(Context context, MapBuffer localData, MapBuffer props, @Nullable MapBuffer state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return TextLayoutManager.measureText(context, localData, props, width, widthMode, height, heightMode, this.mReactTextViewManagerCallback, attachmentsPositions);
    }

    @Override
    public void setPadding(ReactTextView view, int left, int top, int right, int bottom) {
        view.setPadding(left, top, right, bottom);
    }

    @ReactProp(name="overflow")
    public void setOverflow(ReactTextView view, @Nullable String overflow) {
        view.setOverflow(overflow);
    }
}

