/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.text.FontMetricsUtil;
import com.facebook.react.views.text.PreparedLayout;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextTransform;
import com.facebook.react.views.text.internal.span.CustomLetterSpacingSpan;
import com.facebook.react.views.text.internal.span.CustomLineHeightSpan;
import com.facebook.react.views.text.internal.span.CustomStyleSpan;
import com.facebook.react.views.text.internal.span.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.internal.span.ReactBackgroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactClickableSpan;
import com.facebook.react.views.text.internal.span.ReactForegroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactOpacitySpan;
import com.facebook.react.views.text.internal.span.ReactStrikethroughSpan;
import com.facebook.react.views.text.internal.span.ReactTagSpan;
import com.facebook.react.views.text.internal.span.ReactTextPaintHolderSpan;
import com.facebook.react.views.text.internal.span.ReactUnderlineSpan;
import com.facebook.react.views.text.internal.span.SetSpanOperation;
import com.facebook.react.views.text.internal.span.ShadowStyleSpan;
import com.facebook.react.views.text.internal.span.TextInlineViewPlaceholderSpan;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class TextLayoutManager {
    public static final short AS_KEY_HASH = 0;
    public static final short AS_KEY_STRING = 1;
    public static final short AS_KEY_FRAGMENTS = 2;
    public static final short AS_KEY_CACHE_ID = 3;
    public static final short AS_KEY_BASE_ATTRIBUTES = 4;
    public static final short FR_KEY_STRING = 0;
    public static final short FR_KEY_REACT_TAG = 1;
    public static final short FR_KEY_IS_ATTACHMENT = 2;
    public static final short FR_KEY_WIDTH = 3;
    public static final short FR_KEY_HEIGHT = 4;
    public static final short FR_KEY_TEXT_ATTRIBUTES = 5;
    public static final short PA_KEY_MAX_NUMBER_OF_LINES = 0;
    public static final short PA_KEY_ELLIPSIZE_MODE = 1;
    public static final short PA_KEY_TEXT_BREAK_STRATEGY = 2;
    public static final short PA_KEY_ADJUST_FONT_SIZE_TO_FIT = 3;
    public static final short PA_KEY_INCLUDE_FONT_PADDING = 4;
    public static final short PA_KEY_HYPHENATION_FREQUENCY = 5;
    public static final short PA_KEY_MINIMUM_FONT_SIZE = 6;
    public static final short PA_KEY_MAXIMUM_FONT_SIZE = 7;
    private static final String TAG = TextLayoutManager.class.getSimpleName();
    private static final ThreadLocal<TextPaint> sTextPaintInstance = new ThreadLocal<TextPaint>(){

        @Override
        protected TextPaint initialValue() {
            return new TextPaint(1);
        }
    };
    private static final String INLINE_VIEW_PLACEHOLDER = "0";
    private static final boolean DEFAULT_INCLUDE_FONT_PADDING = true;
    private static final boolean DEFAULT_ADJUST_FONT_SIZE_TO_FIT = false;
    private static final ConcurrentHashMap<Integer, Spannable> sTagToSpannableCache = new ConcurrentHashMap();

    public static void setCachedSpannableForTag(int reactTag, @NonNull Spannable sp) {
        sTagToSpannableCache.put(reactTag, sp);
    }

    public static void deleteCachedSpannableForTag(int reactTag) {
        sTagToSpannableCache.remove(reactTag);
    }

    public static boolean isRTL(MapBuffer attributedString) {
        if (!attributedString.contains(2)) {
            return false;
        }
        MapBuffer fragments = attributedString.getMapBuffer(2);
        if (fragments.getCount() == 0) {
            return false;
        }
        MapBuffer fragment = fragments.getMapBuffer(0);
        MapBuffer textAttributes = fragment.getMapBuffer(5);
        if (!textAttributes.contains(23)) {
            return false;
        }
        return TextAttributeProps.getLayoutDirection(textAttributes.getString(23)) == 1;
    }

    @Nullable
    private static String getTextAlignmentAttr(MapBuffer attributedString) {
        MapBuffer fragment;
        MapBuffer textAttributes;
        if (!attributedString.contains(2)) {
            return null;
        }
        MapBuffer fragments = attributedString.getMapBuffer(2);
        if (fragments.getCount() != 0 && (textAttributes = (fragment = fragments.getMapBuffer(0)).getMapBuffer(5)).contains(12)) {
            return textAttributes.getString(12);
        }
        return null;
    }

    private static int getTextJustificationMode(@Nullable String alignmentAttr) {
        if (Build.VERSION.SDK_INT < 26) {
            return -1;
        }
        if (alignmentAttr != null && alignmentAttr.equals("justified")) {
            return 1;
        }
        return 0;
    }

    private static Layout.Alignment getTextAlignment(MapBuffer attributedString, Spannable spanned, @Nullable String alignmentAttr) {
        Layout.Alignment alignment;
        boolean isScriptRTL;
        boolean isParagraphRTL = TextLayoutManager.isRTL(attributedString);
        boolean swapNormalAndOpposite = isParagraphRTL != (isScriptRTL = TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl((CharSequence)spanned, 0, spanned.length()));
        Layout.Alignment alignment2 = alignment = swapNormalAndOpposite ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
        if (alignmentAttr == null) {
            return alignment;
        }
        if (alignmentAttr.equals("center")) {
            alignment = Layout.Alignment.ALIGN_CENTER;
        } else if (alignmentAttr.equals("right")) {
            alignment = swapNormalAndOpposite ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
        }
        return alignment;
    }

    public static int getTextGravity(MapBuffer attributedString, Spannable spanned, int defaultValue) {
        int gravity = defaultValue;
        String alignmentAttr = TextLayoutManager.getTextAlignmentAttr(attributedString);
        Layout.Alignment alignment = TextLayoutManager.getTextAlignment(attributedString, spanned, alignmentAttr);
        boolean swapLeftAndRight = TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl((CharSequence)spanned, 0, spanned.length());
        if (alignment == Layout.Alignment.ALIGN_NORMAL) {
            gravity = swapLeftAndRight ? 5 : 3;
        } else if (alignment == Layout.Alignment.ALIGN_OPPOSITE) {
            gravity = swapLeftAndRight ? 3 : 5;
        } else if (alignment == Layout.Alignment.ALIGN_CENTER) {
            gravity = 1;
        }
        return gravity;
    }

    private static void buildSpannableFromFragments(Context context, MapBuffer fragments, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int length = fragments.getCount();
        for (int i = 0; i < length; ++i) {
            boolean roleIsLink;
            int reactTag;
            MapBuffer fragment = fragments.getMapBuffer(i);
            int start = sb.length();
            TextAttributeProps textAttributes = TextAttributeProps.fromMapBuffer(fragment.getMapBuffer(5));
            sb.append((CharSequence)TextTransform.apply(fragment.getString(0), textAttributes.mTextTransform));
            int end = sb.length();
            int n = reactTag = fragment.contains(1) ? fragment.getInt(1) : -1;
            if (fragment.contains(2) && fragment.getBoolean(2)) {
                float width = PixelUtil.toPixelFromSP(fragment.getDouble(3));
                float height = PixelUtil.toPixelFromSP(fragment.getDouble(4));
                ops.add(new SetSpanOperation(sb.length() - INLINE_VIEW_PLACEHOLDER.length(), sb.length(), new TextInlineViewPlaceholderSpan(reactTag, (int)width, (int)height)));
                continue;
            }
            if (end < start) continue;
            boolean bl = textAttributes.mRole != null ? textAttributes.mRole == ReactAccessibilityDelegate.Role.LINK : (roleIsLink = textAttributes.mAccessibilityRole == ReactAccessibilityDelegate.AccessibilityRole.LINK);
            if (roleIsLink) {
                ops.add(new SetSpanOperation(start, end, new ReactClickableSpan(reactTag)));
            }
            if (textAttributes.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactForegroundColorSpan(textAttributes.mColor)));
            }
            if (textAttributes.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactBackgroundColorSpan(textAttributes.mBackgroundColor)));
            }
            if (!Float.isNaN(textAttributes.getOpacity())) {
                ops.add(new SetSpanOperation(start, end, new ReactOpacitySpan(textAttributes.getOpacity())));
            }
            if (!Float.isNaN(textAttributes.getLetterSpacing())) {
                ops.add(new SetSpanOperation(start, end, new CustomLetterSpacingSpan(textAttributes.getLetterSpacing())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactAbsoluteSizeSpan(textAttributes.mFontSize)));
            if (textAttributes.mFontStyle != -1 || textAttributes.mFontWeight != -1 || textAttributes.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, new CustomStyleSpan(textAttributes.mFontStyle, textAttributes.mFontWeight, textAttributes.mFontFeatureSettings, textAttributes.mFontFamily, context.getAssets())));
            }
            if (textAttributes.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactUnderlineSpan()));
            }
            if (textAttributes.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactStrikethroughSpan()));
            }
            if ((textAttributes.mTextShadowOffsetDx != 0.0f || textAttributes.mTextShadowOffsetDy != 0.0f || textAttributes.mTextShadowRadius != 0.0f) && Color.alpha((int)textAttributes.mTextShadowColor) != 0) {
                ops.add(new SetSpanOperation(start, end, new ShadowStyleSpan(textAttributes.mTextShadowOffsetDx, textAttributes.mTextShadowOffsetDy, textAttributes.mTextShadowRadius, textAttributes.mTextShadowColor)));
            }
            if (!Float.isNaN(textAttributes.getEffectiveLineHeight())) {
                ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(textAttributes.getEffectiveLineHeight())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(reactTag)));
        }
    }

    public static Spannable getOrCreateSpannableForText(Context context, MapBuffer attributedString, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        Spannable text = null;
        if (attributedString.contains(3)) {
            Integer cacheId = attributedString.getInt(3);
            text = sTagToSpannableCache.get(cacheId);
        } else {
            text = TextLayoutManager.createSpannableFromAttributedString(context, attributedString, reactTextViewManagerCallback);
        }
        return text;
    }

    private static Spannable createSpannableFromAttributedString(Context context, MapBuffer attributedString, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        TextLayoutManager.buildSpannableFromFragments(context, attributedString.getMapBuffer(2), sb, ops);
        for (int priorityIndex = 0; priorityIndex < ops.size(); ++priorityIndex) {
            SetSpanOperation op = (SetSpanOperation)ops.get(ops.size() - priorityIndex - 1);
            op.execute(sb, priorityIndex);
        }
        if (reactTextViewManagerCallback != null) {
            reactTextViewManagerCallback.onPostProcessSpannable((Spannable)sb);
        }
        return sb;
    }

    private static Layout createLayout(Spannable text, BoringLayout.Metrics boring, float width, YogaMeasureMode widthYogaMeasureMode, boolean includeFontPadding, int textBreakStrategy, int hyphenationFrequency, Layout.Alignment alignment, int justificationMode, @Nullable TextUtils.TruncateAt ellipsizeMode, int maxNumberOfLines, TextPaint paint) {
        BoringLayout layout2;
        int spanLength = text.length();
        boolean unconstrainedWidth = widthYogaMeasureMode == YogaMeasureMode.UNDEFINED || width < 0.0f;
        float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)paint) : Float.NaN;
        boolean isScriptRTL = TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl((CharSequence)text, 0, spanLength);
        if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width)) {
            if (widthYogaMeasureMode == YogaMeasureMode.EXACTLY) {
                desiredWidth = width;
            }
            int hintWidth = (int)Math.ceil(desiredWidth);
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)spanLength, (TextPaint)paint, (int)hintWidth).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(hyphenationFrequency).setTextDirection(isScriptRTL ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR);
            if (ReactNativeFeatureFlags.incorporateMaxLinesDuringAndroidLayout() && maxNumberOfLines != -1 && maxNumberOfLines != 0) {
                builder.setEllipsize(ellipsizeMode).setMaxLines(maxNumberOfLines);
            }
            if (Build.VERSION.SDK_INT >= 28) {
                builder.setUseLineSpacingFromFallbacks(true);
            }
            layout2 = builder.build();
        } else if (boring != null && (unconstrainedWidth || (float)boring.width <= width)) {
            int boringLayoutWidth = boring.width;
            if (widthYogaMeasureMode == YogaMeasureMode.EXACTLY) {
                boringLayoutWidth = (int)Math.ceil(width);
            }
            if (boring.width < 0) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Text width is invalid: " + boring.width));
                boringLayoutWidth = 0;
            }
            layout2 = BoringLayout.make((CharSequence)text, (TextPaint)paint, (int)boringLayoutWidth, (Layout.Alignment)alignment, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)includeFontPadding);
        } else {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)spanLength, (TextPaint)paint, (int)((int)Math.ceil(width))).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(hyphenationFrequency).setTextDirection(isScriptRTL ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR);
            if (ReactNativeFeatureFlags.incorporateMaxLinesDuringAndroidLayout() && maxNumberOfLines != -1 && maxNumberOfLines != 0) {
                builder.setEllipsize(ellipsizeMode).setMaxLines(maxNumberOfLines);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                builder.setJustificationMode(justificationMode);
            }
            if (Build.VERSION.SDK_INT >= 28) {
                builder.setUseLineSpacingFromFallbacks(true);
            }
            layout2 = builder.build();
        }
        return layout2;
    }

    private static void updateTextPaint(TextPaint paint, TextAttributeProps baseTextAttributes, Context context) {
        paint.reset();
        paint.setAntiAlias(true);
        if (baseTextAttributes.getEffectiveFontSize() != -1) {
            paint.setTextSize((float)baseTextAttributes.getEffectiveFontSize());
        }
        if (baseTextAttributes.getFontStyle() != -1 || baseTextAttributes.getFontWeight() != -1 || baseTextAttributes.getFontFamily() != null) {
            Typeface typeface = ReactTypefaceUtils.applyStyles(null, baseTextAttributes.getFontStyle(), baseTextAttributes.getFontWeight(), baseTextAttributes.getFontFamily(), context.getAssets());
            paint.setTypeface(typeface);
            if (baseTextAttributes.getFontStyle() != -1 && baseTextAttributes.getFontStyle() != typeface.getStyle()) {
                int missingStyle = baseTextAttributes.getFontStyle() & ~typeface.getStyle();
                paint.setFakeBoldText((missingStyle & 1) != 0);
                paint.setTextSkewX((missingStyle & 2) != 0 ? -0.25f : 0.0f);
            }
        } else {
            paint.setTypeface(null);
        }
    }

    @UnstableReactNativeAPI
    public static Layout createLayout(@NonNull Context context, MapBuffer attributedString, MapBuffer paragraphAttributes, float width, float height, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        TextPaint paint;
        Spannable text = TextLayoutManager.getOrCreateSpannableForText(context, attributedString, reactTextViewManagerCallback);
        if (attributedString.contains(3)) {
            paint = ((ReactTextPaintHolderSpan[])text.getSpans(0, 0, ReactTextPaintHolderSpan.class))[0].getTextPaint();
        } else {
            TextAttributeProps baseTextAttributes = TextAttributeProps.fromMapBuffer(attributedString.getMapBuffer(4));
            paint = (TextPaint)Preconditions.checkNotNull((Object)sTextPaintInstance.get());
            TextLayoutManager.updateTextPaint(paint, baseTextAttributes, context);
        }
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)paint);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        boolean includeFontPadding = paragraphAttributes.contains(4) ? paragraphAttributes.getBoolean(4) : true;
        int hyphenationFrequency = TextAttributeProps.getHyphenationFrequency(paragraphAttributes.getString(5));
        boolean adjustFontSizeToFit = paragraphAttributes.contains(3) ? paragraphAttributes.getBoolean(3) : false;
        int maximumNumberOfLines = paragraphAttributes.contains(0) ? paragraphAttributes.getInt(0) : -1;
        TextUtils.TruncateAt ellipsizeMode = paragraphAttributes.contains(1) ? TextAttributeProps.getEllipsizeMode(paragraphAttributes.getString(1)) : null;
        String alignmentAttr = TextLayoutManager.getTextAlignmentAttr(attributedString);
        Layout.Alignment alignment = TextLayoutManager.getTextAlignment(attributedString, text, alignmentAttr);
        int justificationMode = TextLayoutManager.getTextJustificationMode(alignmentAttr);
        if (adjustFontSizeToFit) {
            double minimumFontSize = paragraphAttributes.contains(6) ? paragraphAttributes.getDouble(6) : Double.NaN;
            TextLayoutManager.adjustSpannableFontToFit(text, width, YogaMeasureMode.EXACTLY, height, YogaMeasureMode.UNDEFINED, minimumFontSize, maximumNumberOfLines, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, paint);
        }
        return TextLayoutManager.createLayout(text, boring, width, YogaMeasureMode.EXACTLY, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, ellipsizeMode, maximumNumberOfLines, paint);
    }

    static void adjustSpannableFontToFit(Spannable text, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode, double minimumFontSizeAttr, int maximumNumberOfLines, boolean includeFontPadding, int textBreakStrategy, int hyphenationFrequency, Layout.Alignment alignment, int justificationMode, TextPaint paint) {
        ReactAbsoluteSizeSpan[] spans;
        int minimumFontSize;
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)paint);
        Layout layout2 = TextLayoutManager.createLayout(text, boring, width, widthYogaMeasureMode, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, null, -1, paint);
        int currentFontSize = minimumFontSize = (int)(Double.isNaN(minimumFontSizeAttr) ? (double)PixelUtil.toPixelFromDIP(4.0f) : minimumFontSizeAttr);
        for (ReactAbsoluteSizeSpan span : spans = (ReactAbsoluteSizeSpan[])text.getSpans(0, text.length(), ReactAbsoluteSizeSpan.class)) {
            currentFontSize = Math.max(currentFontSize, span.getSize());
        }
        int initialFontSize = currentFontSize;
        while (currentFontSize > minimumFontSize && (maximumNumberOfLines != -1 && maximumNumberOfLines != 0 && layout2.getLineCount() > maximumNumberOfLines || heightYogaMeasureMode != YogaMeasureMode.UNDEFINED && (float)layout2.getHeight() > height || text.length() == 1 && layout2.getLineWidth(0) > width)) {
            ReactAbsoluteSizeSpan[] sizeSpans;
            float ratio = (float)(currentFontSize -= Math.max(1, (int)PixelUtil.toPixelFromDIP(1.0f))) / (float)initialFontSize;
            paint.setTextSize(Math.max(paint.getTextSize() * ratio, (float)minimumFontSize));
            for (ReactAbsoluteSizeSpan span : sizeSpans = (ReactAbsoluteSizeSpan[])text.getSpans(0, text.length(), ReactAbsoluteSizeSpan.class)) {
                text.setSpan((Object)new ReactAbsoluteSizeSpan((int)Math.max((float)span.getSize() * ratio, (float)minimumFontSize)), text.getSpanStart((Object)span), text.getSpanEnd((Object)span), text.getSpanFlags((Object)span));
                text.removeSpan((Object)span);
            }
            if (boring != null) {
                boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)paint);
            }
            layout2 = TextLayoutManager.createLayout(text, boring, width, widthYogaMeasureMode, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, null, -1, paint);
        }
    }

    public static long measureText(Context context, MapBuffer attributedString, MapBuffer paragraphAttributes, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback, @Nullable float[] attachmentsPositions) {
        Layout layout2 = TextLayoutManager.createLayout(context, attributedString, paragraphAttributes, width, height, reactTextViewManagerCallback);
        int maximumNumberOfLines = paragraphAttributes.contains(0) ? paragraphAttributes.getInt(0) : -1;
        Spanned text = (Spanned)layout2.getText();
        int calculatedLineCount = TextLayoutManager.calculateLineCount(layout2, maximumNumberOfLines);
        float calculatedWidth = TextLayoutManager.calculateWidth(layout2, text, width, widthYogaMeasureMode, calculatedLineCount);
        float calculatedHeight = TextLayoutManager.calculateHeight(layout2, text, height, heightYogaMeasureMode, calculatedLineCount);
        if (attachmentsPositions != null) {
            int attachmentIndex = 0;
            AttachmentMetrics metrics = new AttachmentMetrics();
            int i = 0;
            while (i < text.length()) {
                int lastAttachmentFoundInSpan = TextLayoutManager.nextAttachmentMetrics(layout2, text, calculatedWidth, calculatedLineCount, i, metrics);
                if (metrics.wasFound) {
                    attachmentsPositions[attachmentIndex] = PixelUtil.toDIPFromPixel(metrics.top);
                    attachmentsPositions[attachmentIndex + 1] = PixelUtil.toDIPFromPixel(metrics.left);
                    attachmentIndex += 2;
                }
                i = lastAttachmentFoundInSpan;
            }
        }
        float widthInSP = PixelUtil.toDIPFromPixel(calculatedWidth);
        float heightInSP = PixelUtil.toDIPFromPixel(calculatedHeight);
        return YogaMeasureOutput.make(widthInSP, heightInSP);
    }

    @UnstableReactNativeAPI
    public static float[] measurePreparedLayout(PreparedLayout preparedLayout, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode) {
        Layout layout2 = preparedLayout.getLayout();
        Spanned text = (Spanned)layout2.getText();
        int maximumNumberOfLines = preparedLayout.getMaximumNumberOfLines();
        int calculatedLineCount = TextLayoutManager.calculateLineCount(layout2, maximumNumberOfLines);
        float calculatedWidth = TextLayoutManager.calculateWidth(layout2, text, width, widthYogaMeasureMode, calculatedLineCount);
        float calculatedHeight = TextLayoutManager.calculateHeight(layout2, text, height, heightYogaMeasureMode, calculatedLineCount);
        ArrayList<Float> retList = new ArrayList<Float>();
        retList.add(Float.valueOf(PixelUtil.toDIPFromPixel(calculatedWidth)));
        retList.add(Float.valueOf(PixelUtil.toDIPFromPixel(calculatedHeight)));
        AttachmentMetrics metrics = new AttachmentMetrics();
        int i = 0;
        while (i < text.length()) {
            int lastAttachmentFoundInSpan = TextLayoutManager.nextAttachmentMetrics(layout2, text, calculatedWidth, calculatedLineCount, i, metrics);
            if (metrics.wasFound) {
                retList.add(Float.valueOf(PixelUtil.toDIPFromPixel(metrics.top)));
                retList.add(Float.valueOf(PixelUtil.toDIPFromPixel(metrics.left)));
                retList.add(Float.valueOf(PixelUtil.toDIPFromPixel(metrics.width)));
                retList.add(Float.valueOf(PixelUtil.toDIPFromPixel(metrics.height)));
            }
            i = lastAttachmentFoundInSpan;
        }
        float[] ret = new float[retList.size()];
        for (int i2 = 0; i2 < retList.size(); ++i2) {
            ret[i2] = ((Float)retList.get(i2)).floatValue();
        }
        return ret;
    }

    private static int calculateLineCount(Layout layout2, int maximumNumberOfLines) {
        return maximumNumberOfLines == -1 || maximumNumberOfLines == 0 ? layout2.getLineCount() : Math.min(maximumNumberOfLines, layout2.getLineCount());
    }

    private static float calculateWidth(Layout layout2, Spanned text, float width, YogaMeasureMode widthYogaMeasureMode, int calculatedLineCount) {
        float calculatedWidth = 0.0f;
        if (widthYogaMeasureMode == YogaMeasureMode.EXACTLY) {
            calculatedWidth = width;
        } else {
            for (int lineIndex = 0; lineIndex < calculatedLineCount; ++lineIndex) {
                float lineWidth;
                boolean endsWithNewLine;
                boolean bl = endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(lineIndex) - 1) == '\n';
                if (ReactNativeFeatureFlags.incorporateMaxLinesDuringAndroidLayout()) {
                    if (!endsWithNewLine && lineIndex + 1 < layout2.getLineCount() || layout2.getEllipsisCount(lineIndex) > 0) {
                        calculatedWidth = width;
                        break;
                    }
                } else if (!endsWithNewLine && lineIndex + 1 < layout2.getLineCount()) {
                    calculatedWidth = width;
                    break;
                }
                float f = lineWidth = endsWithNewLine ? layout2.getLineMax(lineIndex) : layout2.getLineWidth(lineIndex);
                if (!(lineWidth > calculatedWidth)) continue;
                calculatedWidth = lineWidth;
            }
            if (widthYogaMeasureMode == YogaMeasureMode.AT_MOST && calculatedWidth > width) {
                calculatedWidth = width;
            }
        }
        if (Build.VERSION.SDK_INT > 29) {
            calculatedWidth = (float)Math.ceil(calculatedWidth);
        }
        return calculatedWidth;
    }

    private static float calculateHeight(Layout layout2, Spanned text, float height, YogaMeasureMode heightYogaMeasureMode, int calculatedLineCount) {
        float calculatedHeight = height;
        if (heightYogaMeasureMode != YogaMeasureMode.EXACTLY) {
            calculatedHeight = layout2.getLineBottom(calculatedLineCount - 1);
            if (heightYogaMeasureMode == YogaMeasureMode.AT_MOST && calculatedHeight > height) {
                calculatedHeight = height;
            }
        }
        return calculatedHeight;
    }

    private static int nextAttachmentMetrics(Layout layout2, Spanned text, float calculatedWidth, int calculatedLineCount, int i, AttachmentMetrics metrics) {
        boolean isAttachmentTruncated;
        int lastAttachmentFoundInSpan = text.nextSpanTransition(i, text.length(), TextInlineViewPlaceholderSpan.class);
        TextInlineViewPlaceholderSpan[] placeholders = (TextInlineViewPlaceholderSpan[])text.getSpans(i, lastAttachmentFoundInSpan, TextInlineViewPlaceholderSpan.class);
        if (placeholders.length == 0) {
            metrics.wasFound = false;
            return lastAttachmentFoundInSpan;
        }
        Assertions.assertCondition((placeholders.length == 1 ? 1 : 0) != 0);
        TextInlineViewPlaceholderSpan placeholder = placeholders[0];
        int start = text.getSpanStart((Object)placeholder);
        int line = layout2.getLineForOffset(start);
        boolean isLineTruncated = layout2.getEllipsisCount(line) > 0;
        boolean bl = isAttachmentTruncated = line > calculatedLineCount || isLineTruncated && start >= layout2.getLineStart(line) + layout2.getEllipsisStart(line);
        if (isAttachmentTruncated) {
            metrics.top = Float.NaN;
            metrics.left = Float.NaN;
        } else {
            float placeholderTopPosition;
            float placeholderLeftPosition;
            boolean isRtlParagraph;
            float placeholderWidth = placeholder.getWidth();
            float placeholderHeight = placeholder.getHeight();
            boolean isRtlChar = layout2.isRtlCharAt(start);
            boolean bl2 = isRtlParagraph = layout2.getParagraphDirection(line) == -1;
            if (start == text.length() - 1) {
                boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(line) - 1) == '\n';
                float lineWidth = endsWithNewLine ? layout2.getLineMax(line) : layout2.getLineWidth(line);
                placeholderLeftPosition = isRtlParagraph ? calculatedWidth - lineWidth : layout2.getLineRight(line) - placeholderWidth;
            } else {
                boolean characterAndParagraphDirectionMatch = isRtlParagraph == isRtlChar;
                float f = placeholderLeftPosition = characterAndParagraphDirectionMatch ? layout2.getPrimaryHorizontal(start) : layout2.getSecondaryHorizontal(start);
                if (isRtlParagraph && !isRtlChar) {
                    placeholderLeftPosition = calculatedWidth - (layout2.getLineRight(line) - placeholderLeftPosition);
                }
                if (isRtlChar) {
                    placeholderLeftPosition -= placeholderWidth;
                }
            }
            metrics.top = placeholderTopPosition = (float)layout2.getLineBaseline(line) - placeholderHeight;
            metrics.left = placeholderLeftPosition;
        }
        metrics.wasFound = true;
        metrics.width = placeholder.getWidth();
        metrics.height = placeholder.getHeight();
        return lastAttachmentFoundInSpan;
    }

    public static WritableArray measureLines(@NonNull Context context, MapBuffer attributedString, MapBuffer paragraphAttributes, float width, float height) {
        Layout layout2 = TextLayoutManager.createLayout(context, attributedString, paragraphAttributes, width, height, null);
        return FontMetricsUtil.getFontMetrics(layout2.getText(), layout2, (TextPaint)Preconditions.checkNotNull((Object)sTextPaintInstance.get()), context);
    }

    private static class AttachmentMetrics {
        boolean wasFound;
        float top;
        float left;
        float width;
        float height;

        private AttachmentMetrics() {
        }
    }
}

