/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.ReadableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/animated/DecayAnimation;", "Lcom/facebook/react/animated/AnimationDriver;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;)V", "velocity", "", "deceleration", "startFrameTimeMillis", "", "fromValue", "lastValue", "iterations", "", "currentLoop", "resetConfig", "", "runAnimationStep", "frameTimeNanos", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nDecayAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecayAnimation.kt\ncom/facebook/react/animated/DecayAnimation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class DecayAnimation
extends AnimationDriver {
    private double velocity;
    private double deceleration;
    private long startFrameTimeMillis;
    private double fromValue;
    private double lastValue;
    private int iterations;
    private int currentLoop;

    public DecayAnimation(@NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.startFrameTimeMillis = -1L;
        this.iterations = 1;
        this.currentLoop = 1;
        this.resetConfig(config);
    }

    @Override
    public void resetConfig(@NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.velocity = config.getDouble("velocity");
        this.deceleration = config.getDouble("deceleration");
        this.startFrameTimeMillis = -1L;
        this.fromValue = 0.0;
        this.lastValue = 0.0;
        this.iterations = config.hasKey("iterations") ? config.getInt("iterations") : 1;
        this.currentLoop = 1;
        this.hasFinished = this.iterations == 0;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        double value;
        ValueAnimatedNode valueAnimatedNode = this.animatedValue;
        if (valueAnimatedNode == null) {
            boolean bl = false;
            String string2 = "Animated value should not be null";
            throw new IllegalArgumentException(string2.toString());
        }
        ValueAnimatedNode animatedValue = valueAnimatedNode;
        long frameTimeMillis = frameTimeNanos / (long)1000000;
        if (this.startFrameTimeMillis == -1L) {
            this.startFrameTimeMillis = frameTimeMillis - (long)16;
            if (this.fromValue == this.lastValue) {
                this.fromValue = animatedValue.nodeValue;
            } else {
                animatedValue.nodeValue = this.fromValue;
            }
            this.lastValue = animatedValue.nodeValue;
        }
        if (Math.abs(this.lastValue - (value = this.fromValue + this.velocity / (1.0 - this.deceleration) * (1.0 - Math.exp(-(1.0 - this.deceleration) * (double)(frameTimeMillis - this.startFrameTimeMillis))))) < 0.1) {
            if (this.iterations == -1 || this.currentLoop < this.iterations) {
                this.startFrameTimeMillis = -1L;
                int n = this.currentLoop;
                this.currentLoop = n + 1;
            } else {
                this.hasFinished = true;
                return;
            }
        }
        this.lastValue = value;
        animatedValue.nodeValue = value;
    }
}

