/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.core.graphics.ColorUtils;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016J\r\u0010\u001b\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/react/animated/InterpolationAnimatedNode;", "Lcom/facebook/react/animated/ValueAnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;)V", "inputRange", "", "outputRange", "", "outputType", "Lcom/facebook/react/animated/InterpolationAnimatedNode$OutputType;", "pattern", "", "extrapolateLeft", "extrapolateRight", "parent", "objectValue", "onAttachedToNode", "", "Lcom/facebook/react/animated/AnimatedNode;", "onAttachedToNode$ReactAndroid_release", "onDetachedFromNode", "onDetachedFromNode$ReactAndroid_release", "update", "update$ReactAndroid_release", "getAnimatedObject", "prettyPrint", "prettyPrint$ReactAndroid_release", "OutputType", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nInterpolationAnimatedNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterpolationAnimatedNode.kt\ncom/facebook/react/animated/InterpolationAnimatedNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
public final class InterpolationAnimatedNode
extends ValueAnimatedNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] inputRange;
    @Nullable
    private Object outputRange;
    @Nullable
    private OutputType outputType;
    @Nullable
    private String pattern;
    @Nullable
    private final String extrapolateLeft;
    @Nullable
    private final String extrapolateRight;
    @Nullable
    private ValueAnimatedNode parent;
    @Nullable
    private Object objectValue;
    @NotNull
    public static final String EXTRAPOLATE_TYPE_IDENTITY = "identity";
    @NotNull
    public static final String EXTRAPOLATE_TYPE_CLAMP = "clamp";
    @NotNull
    public static final String EXTRAPOLATE_TYPE_EXTEND = "extend";
    @NotNull
    private static final Pattern numericPattern;
    @NotNull
    private static final String COLOR_OUTPUT_TYPE = "color";

    public InterpolationAnimatedNode(@NotNull ReadableMap config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(null, 1, null);
        this.inputRange = InterpolationAnimatedNode.Companion.fromDoubleArray(config.getArray("inputRange"));
        this.extrapolateLeft = config.getString("extrapolateLeft");
        this.extrapolateRight = config.getString("extrapolateRight");
        ReadableArray output = config.getArray("outputRange");
        if (Intrinsics.areEqual((Object)COLOR_OUTPUT_TYPE, (Object)config.getString("outputType"))) {
            this.outputType = OutputType.Color;
            this.outputRange = InterpolationAnimatedNode.Companion.fromIntArray(output);
        } else {
            ReadableArray readableArray = output;
            if ((readableArray != null ? readableArray.getType(0) : null) == ReadableType.String) {
                this.outputType = OutputType.String;
                this.outputRange = InterpolationAnimatedNode.Companion.fromStringPattern(output);
                this.pattern = output.getString(0);
            } else {
                this.outputType = OutputType.Number;
                this.outputRange = InterpolationAnimatedNode.Companion.fromDoubleArray(output);
            }
        }
    }

    @Override
    public void onAttachedToNode$ReactAndroid_release(@NotNull AnimatedNode parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!(this.parent == null)) {
            boolean $i$a$-check-InterpolationAnimatedNode$onAttachedToNode$22 = false;
            String $i$a$-check-InterpolationAnimatedNode$onAttachedToNode$22 = "Parent already attached";
            throw new IllegalStateException($i$a$-check-InterpolationAnimatedNode$onAttachedToNode$22.toString());
        }
        if (!(parent instanceof ValueAnimatedNode)) {
            boolean bl = false;
            String string2 = "Parent is of an invalid type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.parent = (ValueAnimatedNode)parent;
    }

    @Override
    public void onDetachedFromNode$ReactAndroid_release(@NotNull AnimatedNode parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!(parent == this.parent)) {
            boolean bl = false;
            String string2 = "Invalid parent node provided";
            throw new IllegalArgumentException(string2.toString());
        }
        this.parent = null;
    }

    @Override
    public void update$ReactAndroid_release() {
        ValueAnimatedNode valueAnimatedNode = this.parent;
        if (valueAnimatedNode == null) {
            return;
        }
        double parentValue = valueAnimatedNode.getValue();
        OutputType outputType = this.outputType;
        switch (outputType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[outputType.ordinal()]) {
            case 1: {
                Object object = this.outputRange;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.DoubleArray");
                this.nodeValue = Companion.interpolate(parentValue, this.inputRange, (double[])object, this.extrapolateLeft, this.extrapolateRight);
                break;
            }
            case 2: {
                Object object = this.outputRange;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.IntArray");
                this.objectValue = Companion.interpolateColor(parentValue, this.inputRange, (int[])object);
                break;
            }
            case 3: {
                String string2 = this.pattern;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    Object object = this.outputRange;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.DoubleArray>");
                    this.objectValue = Companion.interpolateString(it, parentValue, this.inputRange, (double[][])object, this.extrapolateLeft, this.extrapolateRight);
                }
                break;
            }
        }
    }

    @Override
    @Nullable
    public Object getAnimatedObject() {
        return this.objectValue;
    }

    @Override
    @NotNull
    public String prettyPrint$ReactAndroid_release() {
        return "InterpolationAnimatedNode[" + this.tag + "] super: {super.prettyPrint()}";
    }

    static {
        Pattern pattern = Pattern.compile("[+-]?(\\d+\\.?\\d*|\\.\\d+)([eE][+-]?\\d+)?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        numericPattern = pattern;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001d\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0013JB\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0010JE\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/animated/InterpolationAnimatedNode$Companion;", "", "<init>", "()V", "EXTRAPOLATE_TYPE_IDENTITY", "", "EXTRAPOLATE_TYPE_CLAMP", "EXTRAPOLATE_TYPE_EXTEND", "numericPattern", "Ljava/util/regex/Pattern;", "COLOR_OUTPUT_TYPE", "fromDoubleArray", "", "array", "Lcom/facebook/react/bridge/ReadableArray;", "fromIntArray", "", "fromStringPattern", "", "(Lcom/facebook/react/bridge/ReadableArray;)[[D", "interpolate", "", "value", "inputMin", "inputMax", "outputMin", "outputMax", "extrapolateLeft", "extrapolateRight", "inputRange", "outputRange", "interpolateColor", "", "interpolateString", "pattern", "(Ljava/lang/String;D[D[[DLjava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "findRangeIndex", "ranges", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        private final double[] fromDoubleArray(ReadableArray array) {
            ReadableArray readableArray = array;
            if (readableArray == null) {
                return new double[0];
            }
            int size = readableArray.size();
            double[] res = new double[size];
            int n = res.length;
            for (int i = 0; i < n; ++i) {
                res[i] = array.getDouble(i);
            }
            return res;
        }

        private final int[] fromIntArray(ReadableArray array) {
            ReadableArray readableArray = array;
            if (readableArray == null) {
                return new int[0];
            }
            int size = readableArray.size();
            int[] res = new int[size];
            int n = res.length;
            for (int i = 0; i < n; ++i) {
                res[i] = array.getInt(i);
            }
            return res;
        }

        private final double[][] fromStringPattern(ReadableArray array) {
            int i;
            int size = array.size();
            double[][] outputRange = new double[size][];
            Pattern pattern = numericPattern;
            String string2 = array.getString(0);
            if (string2 == null) {
                string2 = "";
            }
            Matcher m = pattern.matcher(string2);
            List firstOutputRange = new ArrayList();
            while (m.find()) {
                String string3 = m.group();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                firstOutputRange.add(Double.parseDouble(string3));
            }
            double[] firstOutputRangeArr = new double[firstOutputRange.size()];
            int n = ((Collection)firstOutputRange).size();
            for (i = 0; i < n; ++i) {
                firstOutputRangeArr[i] = ((Number)firstOutputRange.get(i)).doubleValue();
            }
            outputRange[0] = firstOutputRangeArr;
            for (i = 1; i < size; ++i) {
                double[] outputArr = new double[firstOutputRangeArr.length];
                int j = 0;
                Pattern pattern2 = numericPattern;
                String string4 = array.getString(i);
                if (string4 == null) {
                    string4 = "";
                }
                m = pattern2.matcher(string4);
                while (m.find() && j < firstOutputRangeArr.length) {
                    int n2 = j++;
                    String string5 = m.group();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group(...)");
                    outputArr[n2] = Double.parseDouble(string5);
                }
                outputRange[i] = outputArr;
            }
            return outputRange;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final double interpolate(double value, double inputMin, double inputMax, double outputMin, double outputMax, @Nullable String extrapolateLeft, @Nullable String extrapolateRight) {
            double result;
            block29: {
                int n;
                String string2;
                block27: {
                    result = value;
                    if (!(result < inputMin)) break block27;
                    string2 = extrapolateLeft;
                    if (string2 == null) throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateLeft + "for left extrapolation");
                    n = -1;
                    switch (string2.hashCode()) {
                        case -1289044198: {
                            if (string2.equals(InterpolationAnimatedNode.EXTRAPOLATE_TYPE_EXTEND)) {
                                n = 1;
                            }
                            break;
                        }
                        case -135761730: {
                            if (string2.equals(InterpolationAnimatedNode.EXTRAPOLATE_TYPE_IDENTITY)) {
                                n = 2;
                            }
                            break;
                        }
                        case 94742715: {
                            if (string2.equals(InterpolationAnimatedNode.EXTRAPOLATE_TYPE_CLAMP)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            return result;
                        }
                        case 3: {
                            result = inputMin;
                            break;
                        }
                        default: {
                            throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateLeft + "for left extrapolation");
                        }
                        case 1: 
                    }
                }
                if (!(result > inputMax)) break block29;
                string2 = extrapolateRight;
                if (string2 == null) throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateRight + "for right extrapolation");
                tmp = -1;
                switch (string2.hashCode()) {
                    case -1289044198: {
                        if (string2.equals(InterpolationAnimatedNode.EXTRAPOLATE_TYPE_EXTEND)) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -135761730: {
                        if (string2.equals(InterpolationAnimatedNode.EXTRAPOLATE_TYPE_IDENTITY)) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 94742715: {
                        if (string2.equals(InterpolationAnimatedNode.EXTRAPOLATE_TYPE_CLAMP)) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        return result;
                    }
                    case 3: {
                        result = inputMax;
                        break;
                    }
                    default: {
                        throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateRight + "for right extrapolation");
                    }
                    case 1: 
                }
            }
            if (outputMin == outputMax) {
                return outputMin;
            }
            return inputMin == inputMax ? (value <= inputMin ? outputMin : outputMax) : outputMin + (outputMax - outputMin) * (result - inputMin) / (inputMax - inputMin);
        }

        public final double interpolate(double value, @NotNull double[] inputRange, @NotNull double[] outputRange, @Nullable String extrapolateLeft, @Nullable String extrapolateRight) {
            Intrinsics.checkNotNullParameter((Object)inputRange, (String)"inputRange");
            Intrinsics.checkNotNullParameter((Object)outputRange, (String)"outputRange");
            int rangeIndex = this.findRangeIndex(value, inputRange);
            return this.interpolate(value, inputRange[rangeIndex], inputRange[rangeIndex + 1], outputRange[rangeIndex], outputRange[rangeIndex + 1], extrapolateLeft, extrapolateRight);
        }

        public final int interpolateColor(double value, @NotNull double[] inputRange, @NotNull int[] outputRange) {
            Intrinsics.checkNotNullParameter((Object)inputRange, (String)"inputRange");
            Intrinsics.checkNotNullParameter((Object)outputRange, (String)"outputRange");
            int rangeIndex = this.findRangeIndex(value, inputRange);
            int outputMin = outputRange[rangeIndex];
            int outputMax = outputRange[rangeIndex + 1];
            if (outputMin == outputMax) {
                return outputMin;
            }
            double inputMin = inputRange[rangeIndex];
            double inputMax = inputRange[rangeIndex + 1];
            if (inputMin == inputMax) {
                return value <= inputMin ? outputMin : outputMax;
            }
            double ratio = (value - inputMin) / (inputMax - inputMin);
            return ColorUtils.blendARGB((int)outputMin, (int)outputMax, (float)((float)ratio));
        }

        @NotNull
        public final String interpolateString(@NotNull String pattern, double value, @NotNull double[] inputRange, @NotNull double[][] outputRange, @Nullable String extrapolateLeft, @Nullable String extrapolateRight) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)inputRange, (String)"inputRange");
            Intrinsics.checkNotNullParameter((Object)outputRange, (String)"outputRange");
            int rangeIndex = this.findRangeIndex(value, inputRange);
            StringBuffer sb = new StringBuffer(pattern.length());
            Matcher m = numericPattern.matcher(pattern);
            for (int i = 0; m.find() && i < outputRange[rangeIndex].length; ++i) {
                double v = this.interpolate(value, inputRange[rangeIndex], inputRange[rangeIndex + 1], outputRange[rangeIndex][i], outputRange[rangeIndex + 1][i], extrapolateLeft, extrapolateRight);
                int intVal = (int)v;
                m.appendReplacement(sb, !((double)intVal == v) ? String.valueOf(v) : String.valueOf(intVal));
            }
            m.appendTail(sb);
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final int findRangeIndex(double value, double[] ranges) {
            int index;
            for (index = 1; index < ranges.length - 1 && !(ranges[index] >= value); ++index) {
            }
            return index - 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/animated/InterpolationAnimatedNode$OutputType;", "", "<init>", "(Ljava/lang/String;I)V", "Number", "Color", "String", "ReactAndroid_release"})
    private static final class OutputType
    extends Enum<OutputType> {
        public static final /* enum */ OutputType Number = new OutputType();
        public static final /* enum */ OutputType Color = new OutputType();
        public static final /* enum */ OutputType String = new OutputType();
        private static final /* synthetic */ OutputType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OutputType[] values() {
            return (OutputType[])$VALUES.clone();
        }

        public static OutputType valueOf(String value) {
            return Enum.valueOf(OutputType.class, value);
        }

        @NotNull
        public static EnumEntries<OutputType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = outputTypeArray = new OutputType[]{OutputType.Number, OutputType.Color, OutputType.String};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OutputType.values().length];
            try {
                nArray[OutputType.Number.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputType.Color.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutputType.String.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

