/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.mapbuffer;

import com.facebook.jni.HybridClassBase;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.common.mapbuffer.MapBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0003\b\u0007\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0002ABB\u0019\b\u0003\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0017\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000,2\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0010\u0010.\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00103\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00104\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00106\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00107\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u00108\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00000,2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u00020\u0006H\u0016J\u0013\u0010;\u001a\u00020&2\b\u0010<\u001a\u0004\u0018\u00010=H\u0096\u0002J\b\u0010>\u001a\u00020(H\u0016J\u000f\u0010?\u001a\b\u0012\u0004\u0012\u0002010@H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006C"}, d2={"Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer;", "Lcom/facebook/jni/HybridClassBase;", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "offsetToMapBuffer", "", "<init>", "(Ljava/nio/ByteBuffer;I)V", "value", "count", "getCount", "()I", "cloneWithOffset", "offset", "readHeader", "", "offsetForDynamicData", "getOffsetForDynamicData", "getBucketIndexForKey", "intKey", "readDataType", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "bucketIndex", "getTypedValueOffsetForKey", "key", "expected", "readUnsignedShort", "Lkotlin/UShort;", "bufferPosition", "readUnsignedShort-BwKQO78", "(I)S", "readDoubleValue", "", "readIntValue", "readLongValue", "", "readBooleanValue", "", "readStringValue", "", "readMapBufferValue", "position", "readMapBufferListValue", "", "getKeyOffsetForBucketIndex", "contains", "getKeyOffset", "entryAt", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "getType", "getInt", "getLong", "getDouble", "getString", "getBoolean", "getMapBuffer", "getMapBufferList", "hashCode", "equals", "other", "", "toString", "iterator", "", "MapBufferEntry", "Companion", "ReactAndroid_release"})
@NotThreadSafe
@DoNotStrip
@SourceDebugExtension(value={"SMAP\nReadableMapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/ReadableMapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1#2:324\n*E\n"})
public final class ReadableMapBuffer
extends HybridClassBase
implements MapBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    private final int offsetToMapBuffer;
    private int count;
    private static final int ALIGNMENT = 254;
    private static final int HEADER_SIZE = 8;
    private static final int BUCKET_SIZE = 12;
    private static final int TYPE_OFFSET = 2;
    private static final int VALUE_OFFSET = 4;

    @DoNotStrip
    private ReadableMapBuffer(ByteBuffer buffer, int offsetToMapBuffer) {
        this.buffer = buffer;
        this.offsetToMapBuffer = offsetToMapBuffer;
        this.readHeader();
    }

    @Override
    public int getCount() {
        return this.count;
    }

    private final ReadableMapBuffer cloneWithOffset(int offset) {
        ByteBuffer byteBuffer;
        ByteBuffer $this$cloneWithOffset_u24lambda_u240 = byteBuffer = this.buffer.duplicate();
        boolean bl = false;
        $this$cloneWithOffset_u24lambda_u240.position(offset);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"apply(...)");
        int n = offset;
        ByteBuffer byteBuffer3 = byteBuffer2;
        return new ReadableMapBuffer(byteBuffer3, n);
    }

    private final void readHeader() {
        short storedAlignment = this.buffer.getShort();
        if (storedAlignment != 254) {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.count = this.readUnsignedShort-BwKQO78(this.buffer.position()) & 0xFFFF;
    }

    private final int getOffsetForDynamicData() {
        return this.getKeyOffsetForBucketIndex(this.getCount());
    }

    private final int getBucketIndexForKey(int intKey) {
        IntRange intRange = MapBuffer.Companion.getKEY_RANGE$ReactAndroid_release();
        int n = intRange.getFirst();
        if (!(intKey <= intRange.getLast() ? n <= intKey : false)) {
            return -1;
        }
        short key = UShort.constructor-impl((short)((short)intKey));
        int lo = 0;
        int hi = this.getCount() - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            short midVal = this.readUnsignedShort-BwKQO78(this.getKeyOffsetForBucketIndex(mid));
            if (Intrinsics.compare((int)(midVal & 0xFFFF), (int)(key & 0xFFFF)) < 0) {
                lo = mid + 1;
                continue;
            }
            if (Intrinsics.compare((int)(midVal & 0xFFFF), (int)(key & 0xFFFF)) > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private final MapBuffer.DataType readDataType(int bucketIndex) {
        int value = this.readUnsignedShort-BwKQO78(this.getKeyOffsetForBucketIndex(bucketIndex) + 2) & 0xFFFF;
        return MapBuffer.DataType.values()[value];
    }

    private final int getTypedValueOffsetForKey(int key, MapBuffer.DataType expected) {
        int bucketIndex = this.getBucketIndexForKey(key);
        if (!(bucketIndex != -1)) {
            boolean bl = false;
            String string2 = "Key not found: " + key;
            throw new IllegalArgumentException(string2.toString());
        }
        MapBuffer.DataType dataType = this.readDataType(bucketIndex);
        if (!(dataType == expected)) {
            boolean bl = false;
            String string3 = "Expected " + expected + " for key: " + key + ", found " + dataType + " instead.";
            throw new IllegalStateException(string3.toString());
        }
        return this.getKeyOffsetForBucketIndex(bucketIndex) + 4;
    }

    private final short readUnsignedShort-BwKQO78(int bufferPosition) {
        return UShort.constructor-impl((short)this.buffer.getShort(bufferPosition));
    }

    private final double readDoubleValue(int bufferPosition) {
        return this.buffer.getDouble(bufferPosition);
    }

    private final int readIntValue(int bufferPosition) {
        return this.buffer.getInt(bufferPosition);
    }

    private final long readLongValue(int bufferPosition) {
        return this.buffer.getLong(bufferPosition);
    }

    private final boolean readBooleanValue(int bufferPosition) {
        return this.readIntValue(bufferPosition) == 1;
    }

    private final String readStringValue(int bufferPosition) {
        int offset = this.getOffsetForDynamicData() + this.buffer.getInt(bufferPosition);
        int sizeOfString = this.buffer.getInt(offset);
        byte[] result = new byte[sizeOfString];
        int stringOffset = offset + 4;
        this.buffer.position(stringOffset);
        this.buffer.get(result, 0, sizeOfString);
        return new String(result, Charsets.UTF_8);
    }

    private final ReadableMapBuffer readMapBufferValue(int position) {
        int offset = this.getOffsetForDynamicData() + this.buffer.getInt(position);
        return this.cloneWithOffset(offset + 4);
    }

    private final List<ReadableMapBuffer> readMapBufferListValue(int position) {
        int sizeMapBuffer;
        ArrayList<ReadableMapBuffer> readMapBufferList = new ArrayList<ReadableMapBuffer>();
        int offset = this.getOffsetForDynamicData() + this.buffer.getInt(position);
        int sizeMapBufferList = this.buffer.getInt(offset);
        offset += 4;
        for (int curLen = 0; curLen < sizeMapBufferList; curLen += sizeMapBuffer) {
            sizeMapBuffer = this.buffer.getInt(offset + curLen);
            readMapBufferList.add(this.cloneWithOffset(offset + (curLen += 4)));
        }
        return readMapBufferList;
    }

    private final int getKeyOffsetForBucketIndex(int bucketIndex) {
        return this.offsetToMapBuffer + 8 + 12 * bucketIndex;
    }

    @Override
    public boolean contains(int key) {
        return this.getBucketIndexForKey(key) != -1;
    }

    @Override
    public int getKeyOffset(int key) {
        return this.getBucketIndexForKey(key);
    }

    @Override
    @NotNull
    public MapBuffer.Entry entryAt(int offset) {
        return new MapBufferEntry(this.getKeyOffsetForBucketIndex(offset));
    }

    @Override
    @NotNull
    public MapBuffer.DataType getType(int key) {
        int bucketIndex = this.getBucketIndexForKey(key);
        if (!(bucketIndex != -1)) {
            boolean bl = false;
            String string2 = "Key not found: " + key;
            throw new IllegalArgumentException(string2.toString());
        }
        return this.readDataType(bucketIndex);
    }

    @Override
    public int getInt(int key) {
        return this.readIntValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.INT));
    }

    @Override
    public long getLong(int key) {
        return this.readLongValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.LONG));
    }

    @Override
    public double getDouble(int key) {
        return this.readDoubleValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.DOUBLE));
    }

    @Override
    @NotNull
    public String getString(int key) {
        return this.readStringValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.STRING));
    }

    @Override
    public boolean getBoolean(int key) {
        return this.readBooleanValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.BOOL));
    }

    @Override
    @NotNull
    public ReadableMapBuffer getMapBuffer(int key) {
        return this.readMapBufferValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.MAP));
    }

    @NotNull
    public List<ReadableMapBuffer> getMapBufferList(int key) {
        return this.readMapBufferListValue(this.getTypedValueOffsetForKey(key, MapBuffer.DataType.MAP));
    }

    public int hashCode() {
        this.buffer.rewind();
        return this.buffer.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ReadableMapBuffer)) {
            return false;
        }
        ByteBuffer thisByteBuffer = this.buffer;
        ByteBuffer otherByteBuffer = ((ReadableMapBuffer)other).buffer;
        if (thisByteBuffer == otherByteBuffer) {
            return true;
        }
        thisByteBuffer.rewind();
        otherByteBuffer.rewind();
        return Intrinsics.areEqual((Object)thisByteBuffer, (Object)otherByteBuffer);
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        CollectionsKt.joinTo$default((Iterable)this, (Appendable)builder, null, null, null, (int)0, null, ReadableMapBuffer::toString$lambda$5, (int)62, null);
        builder.append('}');
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public Iterator<MapBuffer.Entry> iterator() {
        return new Iterator<MapBuffer.Entry>(this){
            private int current;
            private final int last;
            final /* synthetic */ ReadableMapBuffer this$0;
            {
                this.this$0 = $receiver;
                this.last = $receiver.getCount() - 1;
            }

            public final int getCurrent() {
                return this.current;
            }

            public final void setCurrent(int n) {
                this.current = n;
            }

            public final int getLast() {
                return this.last;
            }

            public boolean hasNext() {
                return this.current <= this.last;
            }

            public MapBuffer.Entry next() {
                int n = this.current;
                this.current = n + 1;
                return this.this$0.new MapBufferEntry(ReadableMapBuffer.access$getKeyOffsetForBucketIndex(this.this$0, n));
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private static final CharSequence toString$lambda$5(MapBuffer.Entry entry) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        StringBuilder $this$toString_u24lambda_u245_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getKey());
        $this$toString_u24lambda_u245_u24lambda_u244.append('=');
        switch (WhenMappings.$EnumSwitchMapping$0[entry.getType().ordinal()]) {
            case 1: {
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getBooleanValue());
                break;
            }
            case 2: {
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getIntValue());
                break;
            }
            case 3: {
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getLongValue());
                break;
            }
            case 4: {
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getDoubleValue());
                break;
            }
            case 5: {
                $this$toString_u24lambda_u245_u24lambda_u244.append('\"');
                $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getStringValue());
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u245_u24lambda_u244.append('\"');
                break;
            }
            case 6: {
                StringBuilder stringBuilder2 = $this$toString_u24lambda_u245_u24lambda_u244.append(entry.getMapBufferValue().toString());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stringBuilder;
    }

    public static final /* synthetic */ int access$getKeyOffsetForBucketIndex(ReadableMapBuffer $this, int bucketIndex) {
        return $this.getKeyOffsetForBucketIndex(bucketIndex);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer$Companion;", "", "<init>", "()V", "ALIGNMENT", "", "HEADER_SIZE", "BUCKET_SIZE", "TYPE_OFFSET", "VALUE_OFFSET", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer$MapBufferEntry;", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "bucketOffset", "", "<init>", "(Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer;I)V", "assertType", "", "expected", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "key", "getKey", "()I", "type", "getType", "()Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "doubleValue", "", "getDoubleValue", "()D", "intValue", "getIntValue", "longValue", "", "getLongValue", "()J", "booleanValue", "", "getBooleanValue", "()Z", "stringValue", "", "getStringValue", "()Ljava/lang/String;", "mapBufferValue", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "getMapBufferValue", "()Lcom/facebook/react/common/mapbuffer/MapBuffer;", "ReactAndroid_release"})
    private final class MapBufferEntry
    implements MapBuffer.Entry {
        private final int bucketOffset;

        public MapBufferEntry(int bucketOffset) {
            this.bucketOffset = bucketOffset;
        }

        private final void assertType(MapBuffer.DataType expected) {
            MapBuffer.DataType dataType = this.getType();
            if (!(expected == dataType)) {
                boolean bl = false;
                String string2 = "Expected " + expected + " for key: " + this.getKey() + " found " + dataType + " instead.";
                throw new IllegalStateException(string2.toString());
            }
        }

        @Override
        public int getKey() {
            return ReadableMapBuffer.this.readUnsignedShort-BwKQO78(this.bucketOffset) & 0xFFFF;
        }

        @Override
        @NotNull
        public MapBuffer.DataType getType() {
            return MapBuffer.DataType.values()[ReadableMapBuffer.this.readUnsignedShort-BwKQO78(this.bucketOffset + 2) & 0xFFFF];
        }

        @Override
        public double getDoubleValue() {
            this.assertType(MapBuffer.DataType.DOUBLE);
            return ReadableMapBuffer.this.readDoubleValue(this.bucketOffset + 4);
        }

        @Override
        public int getIntValue() {
            this.assertType(MapBuffer.DataType.INT);
            return ReadableMapBuffer.this.readIntValue(this.bucketOffset + 4);
        }

        @Override
        public long getLongValue() {
            this.assertType(MapBuffer.DataType.LONG);
            return ReadableMapBuffer.this.readLongValue(this.bucketOffset + 4);
        }

        @Override
        public boolean getBooleanValue() {
            this.assertType(MapBuffer.DataType.BOOL);
            return ReadableMapBuffer.this.readBooleanValue(this.bucketOffset + 4);
        }

        @Override
        @NotNull
        public String getStringValue() {
            this.assertType(MapBuffer.DataType.STRING);
            return ReadableMapBuffer.this.readStringValue(this.bucketOffset + 4);
        }

        @Override
        @NotNull
        public MapBuffer getMapBufferValue() {
            this.assertType(MapBuffer.DataType.MAP);
            return ReadableMapBuffer.this.readMapBufferValue(this.bucketOffset + 4);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MapBuffer.DataType.values().length];
            try {
                nArray[MapBuffer.DataType.BOOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapBuffer.DataType.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapBuffer.DataType.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapBuffer.DataType.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapBuffer.DataType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapBuffer.DataType.MAP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

