/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J+\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/devsupport/DefaultDevLoadingViewImplementation;", "Lcom/facebook/react/devsupport/interfaces/DevLoadingViewManager;", "reactInstanceDevHelper", "Lcom/facebook/react/devsupport/ReactInstanceDevHelper;", "<init>", "(Lcom/facebook/react/devsupport/ReactInstanceDevHelper;)V", "devLoadingView", "Landroid/widget/TextView;", "devLoadingPopup", "Landroid/widget/PopupWindow;", "showMessage", "", "message", "", "updateProgress", "status", "done", "", "total", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "hide", "showInternal", "hideInternal", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "Companion", "ReactAndroid_release"})
public final class DefaultDevLoadingViewImplementation
implements DevLoadingViewManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactInstanceDevHelper reactInstanceDevHelper;
    @Nullable
    private TextView devLoadingView;
    @Nullable
    private PopupWindow devLoadingPopup;
    private static boolean isEnabled = true;

    public DefaultDevLoadingViewImplementation(@NotNull ReactInstanceDevHelper reactInstanceDevHelper) {
        Intrinsics.checkNotNullParameter((Object)reactInstanceDevHelper, (String)"reactInstanceDevHelper");
        this.reactInstanceDevHelper = reactInstanceDevHelper;
    }

    @Override
    public void showMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!isEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DefaultDevLoadingViewImplementation.showMessage$lambda$0(this, message));
    }

    @Override
    public void updateProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
        if (!isEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DefaultDevLoadingViewImplementation.updateProgress$lambda$1(done, total, this, status));
    }

    @Override
    public void hide() {
        if (isEnabled) {
            UiThreadUtil.runOnUiThread(() -> DefaultDevLoadingViewImplementation.hide$lambda$2(this));
        }
    }

    private final void showInternal(String message) {
        PopupWindow popupWindow = this.devLoadingPopup;
        boolean bl = popupWindow != null ? popupWindow.isShowing() : false;
        if (bl) {
            return;
        }
        Activity currentActivity = this.reactInstanceDevHelper.getCurrentActivity();
        if (currentActivity == null) {
            FLog.e((String)"ReactNative", (String)"Unable to display loading message because react activity isn't available");
            return;
        }
        try {
            Rect rectangle = new Rect();
            currentActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
            int topOffset = rectangle.top;
            Object object = currentActivity.getSystemService("layout_inflater");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.LayoutInflater");
            LayoutInflater inflater = (LayoutInflater)object;
            View view = inflater.inflate(R.layout.dev_loading_view, null);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
            TextView view2 = (TextView)view;
            view2.setText((CharSequence)message);
            PopupWindow popup = new PopupWindow((View)view2, -1, -2);
            popup.setTouchable(false);
            popup.showAtLocation(currentActivity.getWindow().getDecorView(), 0, 0, topOffset);
            this.devLoadingView = view2;
            this.devLoadingPopup = popup;
        }
        catch (WindowManager.BadTokenException e) {
            FLog.e((String)"ReactNative", (String)("Unable to display loading message because react activity isn't active, message: " + message));
        }
    }

    private final void hideInternal() {
        PopupWindow popupWindow = this.devLoadingPopup;
        if (popupWindow == null) {
            return;
        }
        PopupWindow popup = popupWindow;
        if (popup.isShowing()) {
            popup.dismiss();
            this.devLoadingPopup = null;
            this.devLoadingView = null;
        }
    }

    private final Context getContext() {
        return (Context)this.reactInstanceDevHelper.getCurrentActivity();
    }

    private static final void showMessage$lambda$0(DefaultDevLoadingViewImplementation this$0, String $message) {
        this$0.showInternal($message);
    }

    private static final void updateProgress$lambda$1(Integer $done, Integer $total, DefaultDevLoadingViewImplementation this$0, String $status) {
        block3: {
            String string2;
            if ($done != null && $total != null && $total > 0) {
                Locale locale = Locale.getDefault();
                String string3 = " %.1f%%";
                Object[] objectArray = new Object[]{Float.valueOf((float)$done.intValue() / (float)$total.intValue() * (float)100)};
                String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            } else {
                string2 = "";
            }
            String percentage = string2;
            TextView textView = this$0.devLoadingView;
            if (textView == null) break block3;
            String string5 = $status;
            if (string5 == null) {
                string5 = "Loading";
            }
            textView.setText((CharSequence)(string5 + percentage + "\u2026"));
        }
    }

    private static final void hide$lambda$2(DefaultDevLoadingViewImplementation this$0) {
        this$0.hideInternal();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/devsupport/DefaultDevLoadingViewImplementation$Companion;", "", "<init>", "()V", "isEnabled", "", "setDevLoadingEnabled", "", "enabled", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void setDevLoadingEnabled(boolean enabled) {
            isEnabled = enabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

