/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appearance;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import androidx.appcompat.app.AppCompatDelegate;
import com.facebook.fbreact.specs.NativeAppearanceSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="Appearance")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/modules/appearance/AppearanceModule;", "Lcom/facebook/fbreact/specs/NativeAppearanceSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "overrideColorScheme", "Lcom/facebook/react/modules/appearance/AppearanceModule$OverrideColorScheme;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/modules/appearance/AppearanceModule$OverrideColorScheme;)V", "lastEmittedColorScheme", "", "colorSchemeForCurrentConfiguration", "context", "Landroid/content/Context;", "getColorScheme", "setColorScheme", "", "style", "addListener", "eventName", "removeListeners", "count", "", "onConfigurationChanged", "currentContext", "emitAppearanceChanged", "colorScheme", "OverrideColorScheme", "Companion", "ReactAndroid_release"})
public final class AppearanceModule
extends NativeAppearanceSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OverrideColorScheme overrideColorScheme;
    @Nullable
    private String lastEmittedColorScheme;
    @NotNull
    public static final String NAME = "Appearance";
    @NotNull
    private static final String APPEARANCE_CHANGED_EVENT_NAME = "appearanceChanged";

    @JvmOverloads
    public AppearanceModule(@NotNull ReactApplicationContext reactContext, @Nullable OverrideColorScheme overrideColorScheme) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        this.overrideColorScheme = overrideColorScheme;
    }

    public /* synthetic */ AppearanceModule(ReactApplicationContext reactApplicationContext, OverrideColorScheme overrideColorScheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            overrideColorScheme = null;
        }
        this(reactApplicationContext, overrideColorScheme);
    }

    private final String colorSchemeForCurrentConfiguration(Context context) {
        if (this.overrideColorScheme != null) {
            return this.overrideColorScheme.getScheme();
        }
        int currentNightMode = context.getResources().getConfiguration().uiMode & 0x30;
        return switch (currentNightMode) {
            case 16 -> "light";
            case 32 -> "dark";
            default -> "light";
        };
    }

    @Override
    @NotNull
    public String getColorScheme() {
        ContextWrapper contextWrapper;
        Activity activity;
        Activity activity2 = activity = this.getReactApplicationContext().getCurrentActivity();
        if (activity2 != null) {
            contextWrapper = (ContextWrapper)activity2;
        } else {
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext), (String)"getReactApplicationContext(...)");
            contextWrapper = reactApplicationContext;
        }
        return this.colorSchemeForCurrentConfiguration((Context)contextWrapper);
    }

    @Override
    public void setColorScheme(@NotNull String style2) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        UiThreadUtil.runOnUiThread(() -> AppearanceModule.setColorScheme$lambda$0(style2));
    }

    @Override
    public void addListener(@NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
    }

    @Override
    public void removeListeners(double count) {
    }

    public final void onConfigurationChanged(@NotNull Context currentContext) {
        Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
        String newColorScheme = this.colorSchemeForCurrentConfiguration(currentContext);
        if (!Intrinsics.areEqual((Object)this.lastEmittedColorScheme, (Object)newColorScheme)) {
            this.lastEmittedColorScheme = newColorScheme;
            this.emitAppearanceChanged(newColorScheme);
        }
    }

    public final void emitAppearanceChanged(@NotNull String colorScheme) {
        block0: {
            ReactApplicationContext reactApplicationContext;
            Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap appearancePreferences = writableMap;
            appearancePreferences.putString("colorScheme", colorScheme);
            ReactApplicationContext reactApplicationContext2 = reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext2 == null) break block0;
            reactApplicationContext2.emitDeviceEvent(APPEARANCE_CHANGED_EVENT_NAME, appearancePreferences);
        }
    }

    @JvmOverloads
    public AppearanceModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this(reactContext, null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void setColorScheme$lambda$0(String $style) {
        block6: {
            String string2 = $style;
            switch (string2.hashCode()) {
                case 102970646: {
                    if (string2.equals("light")) break;
                    return;
                }
                case -1626174665: {
                    if (!string2.equals("unspecified")) {
                        return;
                    }
                    break block6;
                }
                case 3075958: {
                    if (!string2.equals("dark")) return;
                    AppCompatDelegate.setDefaultNightMode((int)2);
                    return;
                }
            }
            AppCompatDelegate.setDefaultNightMode((int)1);
            return;
        }
        AppCompatDelegate.setDefaultNightMode((int)-1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/appearance/AppearanceModule$Companion;", "", "<init>", "()V", "NAME", "", "APPEARANCE_CHANGED_EVENT_NAME", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/modules/appearance/AppearanceModule$OverrideColorScheme;", "", "getScheme", "", "ReactAndroid_release"})
    public static interface OverrideColorScheme {
        @NotNull
        public String getScheme();
    }
}

