/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import android.view.Choreographer;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.modules.debug.DidJSUpdateUiDuringFrameDetector;
import com.facebook.react.uimanager.UIManagerModule;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0019\u0018\u0000 22\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0012\u0010\u001c\u001a\u00020\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010+\u001a\u00020\u000eJ\u0010\u0010.\u001a\u0004\u0018\u00010\u00182\u0006\u0010/\u001a\u00020\u000bJ\u0006\u00100\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u0011\u0010,\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010&\u00a8\u00063"}, d2={"Lcom/facebook/react/modules/debug/FpsDebugFrameCallback;", "Landroid/view/Choreographer$FrameCallback;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "<init>", "(Lcom/facebook/react/bridge/ReactContext;)V", "choreographer", "Landroid/view/Choreographer;", "didJSUpdateUiDuringFrameDetector", "Lcom/facebook/react/modules/debug/DidJSUpdateUiDuringFrameDetector;", "firstFrameTime", "", "lastFrameTime", "numFrameCallbacks", "", "expectedNumFramesPrev", "fourPlusFrameStutters", "numFrameCallbacksWithBatchDispatches", "isRecordingFpsInfoAtEachFrame", "", "targetFps", "", "timeToFps", "Ljava/util/TreeMap;", "Lcom/facebook/react/modules/debug/FpsDebugFrameCallback$FpsInfo;", "doFrame", "", "l", "start", "startAndRecordFpsAtEachFrame", "stop", "fps", "getFps", "()D", "jsFPS", "getJsFPS", "numFrames", "getNumFrames", "()I", "numJSFrames", "getNumJSFrames", "expectedNumFrames", "getExpectedNumFrames", "get4PlusFrameStutters", "totalTimeMS", "getTotalTimeMS", "getFpsInfo", "upToTimeMs", "reset", "FpsInfo", "Companion", "ReactAndroid_release"})
public final class FpsDebugFrameCallback
implements Choreographer.FrameCallback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactContext reactContext;
    @Nullable
    private Choreographer choreographer;
    @NotNull
    private final DidJSUpdateUiDuringFrameDetector didJSUpdateUiDuringFrameDetector;
    private long firstFrameTime;
    private long lastFrameTime;
    private int numFrameCallbacks;
    private int expectedNumFramesPrev;
    private int fourPlusFrameStutters;
    private int numFrameCallbacksWithBatchDispatches;
    private boolean isRecordingFpsInfoAtEachFrame;
    private double targetFps;
    @Nullable
    private TreeMap<Long, FpsInfo> timeToFps;
    private static final double DEFAULT_FPS = 60.0;

    public FpsDebugFrameCallback(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this.reactContext = reactContext;
        this.didJSUpdateUiDuringFrameDetector = new DidJSUpdateUiDuringFrameDetector();
        this.firstFrameTime = -1L;
        this.lastFrameTime = -1L;
        this.targetFps = 60.0;
    }

    public void doFrame(long l) {
        block5: {
            int n;
            if (this.firstFrameTime == -1L) {
                this.firstFrameTime = l;
            }
            long lastFrameStartTime = this.lastFrameTime;
            this.lastFrameTime = l;
            if (this.didJSUpdateUiDuringFrameDetector.getDidJSHitFrameAndCleanup(lastFrameStartTime, l)) {
                n = this.numFrameCallbacksWithBatchDispatches;
                this.numFrameCallbacksWithBatchDispatches = n + 1;
            }
            n = this.numFrameCallbacks;
            this.numFrameCallbacks = n + 1;
            int expectedNumFrames = this.getExpectedNumFrames();
            int framesDropped = expectedNumFrames - this.expectedNumFramesPrev - 1;
            if (framesDropped >= 4) {
                int n2 = this.fourPlusFrameStutters;
                this.fourPlusFrameStutters = n2 + 1;
            }
            if (this.isRecordingFpsInfoAtEachFrame) {
                Assertions.assertNotNull(this.timeToFps);
                FpsInfo info = new FpsInfo(this.getNumFrames(), this.getNumJSFrames(), expectedNumFrames, this.fourPlusFrameStutters, this.getFps(), this.getJsFPS(), this.getTotalTimeMS());
                TreeMap<Long, FpsInfo> treeMap = this.timeToFps;
                if (treeMap != null) {
                    treeMap.put(System.currentTimeMillis(), info);
                }
            }
            this.expectedNumFramesPrev = expectedNumFrames;
            Choreographer choreographer = this.choreographer;
            if (choreographer == null) break block5;
            choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    @JvmOverloads
    public final void start(double targetFps) {
        if (!ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            UIManagerModule uiManagerModule = this.reactContext.getNativeModule(UIManagerModule.class);
            if (!this.reactContext.isBridgeless()) {
                this.reactContext.getCatalystInstance().addBridgeIdleDebugListener(this.didJSUpdateUiDuringFrameDetector);
            }
            UIManagerModule uIManagerModule = uiManagerModule;
            if (uIManagerModule != null) {
                uIManagerModule.setViewHierarchyUpdateDebugListener(this.didJSUpdateUiDuringFrameDetector);
            }
        }
        this.targetFps = targetFps;
        UiThreadUtil.runOnUiThread(() -> FpsDebugFrameCallback.start$lambda$0(this));
    }

    public static /* synthetic */ void start$default(FpsDebugFrameCallback fpsDebugFrameCallback, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = fpsDebugFrameCallback.targetFps;
        }
        fpsDebugFrameCallback.start(d);
    }

    public final void startAndRecordFpsAtEachFrame() {
        this.timeToFps = new TreeMap();
        this.isRecordingFpsInfoAtEachFrame = true;
        FpsDebugFrameCallback.start$default(this, 0.0, 1, null);
    }

    public final void stop() {
        if (!ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            UIManagerModule uiManagerModule = this.reactContext.getNativeModule(UIManagerModule.class);
            if (!this.reactContext.isBridgeless()) {
                this.reactContext.getCatalystInstance().removeBridgeIdleDebugListener(this.didJSUpdateUiDuringFrameDetector);
            }
            UIManagerModule uIManagerModule = uiManagerModule;
            if (uIManagerModule != null) {
                uIManagerModule.setViewHierarchyUpdateDebugListener(null);
            }
        }
        UiThreadUtil.runOnUiThread(() -> FpsDebugFrameCallback.stop$lambda$1(this));
    }

    public final double getFps() {
        return this.lastFrameTime == this.firstFrameTime ? 0.0 : (double)this.getNumFrames() * 1.0E9 / (double)(this.lastFrameTime - this.firstFrameTime);
    }

    public final double getJsFPS() {
        return this.lastFrameTime == this.firstFrameTime ? 0.0 : (double)this.getNumJSFrames() * 1.0E9 / (double)(this.lastFrameTime - this.firstFrameTime);
    }

    public final int getNumFrames() {
        return this.numFrameCallbacks - 1;
    }

    public final int getNumJSFrames() {
        return this.numFrameCallbacksWithBatchDispatches - 1;
    }

    public final int getExpectedNumFrames() {
        double totalTimeMS = this.getTotalTimeMS();
        return (int)(this.targetFps * totalTimeMS / (double)1000 + 1.0);
    }

    public final int get4PlusFrameStutters() {
        return this.fourPlusFrameStutters;
    }

    public final int getTotalTimeMS() {
        return (int)(((double)this.lastFrameTime - (double)this.firstFrameTime) / 1000000.0);
    }

    @Nullable
    public final FpsInfo getFpsInfo(long upToTimeMs) {
        Assertions.assertNotNull(this.timeToFps, (String)"FPS was not recorded at each frame!");
        TreeMap<Long, FpsInfo> treeMap = this.timeToFps;
        if (treeMap == null || (treeMap = treeMap.floorEntry(upToTimeMs)) == null) {
            return null;
        }
        FpsInfo value = (FpsInfo)treeMap.getValue();
        return value;
    }

    public final void reset() {
        this.firstFrameTime = -1L;
        this.lastFrameTime = -1L;
        this.numFrameCallbacks = 0;
        this.fourPlusFrameStutters = 0;
        this.numFrameCallbacksWithBatchDispatches = 0;
        this.isRecordingFpsInfoAtEachFrame = false;
        this.timeToFps = null;
    }

    @JvmOverloads
    public final void start() {
        FpsDebugFrameCallback.start$default(this, 0.0, 1, null);
    }

    private static final void start$lambda$0(FpsDebugFrameCallback this$0) {
        block0: {
            Choreographer choreographer = this$0.choreographer = Choreographer.getInstance();
            if (choreographer == null) break block0;
            choreographer.postFrameCallback((Choreographer.FrameCallback)this$0);
        }
    }

    private static final void stop$lambda$1(FpsDebugFrameCallback this$0) {
        block0: {
            Choreographer choreographer = this$0.choreographer = Choreographer.getInstance();
            if (choreographer == null) break block0;
            choreographer.removeFrameCallback((Choreographer.FrameCallback)this$0);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/debug/FpsDebugFrameCallback$Companion;", "", "<init>", "()V", "DEFAULT_FPS", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/modules/debug/FpsDebugFrameCallback$FpsInfo;", "", "totalFrames", "", "totalJsFrames", "totalExpectedFrames", "total4PlusFrameStutters", "fps", "", "jsFps", "totalTimeMs", "<init>", "(IIIIDDI)V", "getTotalFrames", "()I", "getTotalJsFrames", "getTotalExpectedFrames", "getTotal4PlusFrameStutters", "getFps", "()D", "getJsFps", "getTotalTimeMs", "ReactAndroid_release"})
    public static final class FpsInfo {
        private final int totalFrames;
        private final int totalJsFrames;
        private final int totalExpectedFrames;
        private final int total4PlusFrameStutters;
        private final double fps;
        private final double jsFps;
        private final int totalTimeMs;

        public FpsInfo(int totalFrames, int totalJsFrames, int totalExpectedFrames, int total4PlusFrameStutters, double fps, double jsFps, int totalTimeMs) {
            this.totalFrames = totalFrames;
            this.totalJsFrames = totalJsFrames;
            this.totalExpectedFrames = totalExpectedFrames;
            this.total4PlusFrameStutters = total4PlusFrameStutters;
            this.fps = fps;
            this.jsFps = jsFps;
            this.totalTimeMs = totalTimeMs;
        }

        public final int getTotalFrames() {
            return this.totalFrames;
        }

        public final int getTotalJsFrames() {
            return this.totalJsFrames;
        }

        public final int getTotalExpectedFrames() {
            return this.totalExpectedFrames;
        }

        public final int getTotal4PlusFrameStutters() {
            return this.total4PlusFrameStutters;
        }

        public final double getFps() {
            return this.fps;
        }

        public final double getJsFps() {
            return this.jsFps;
        }

        public final int getTotalTimeMs() {
            return this.totalTimeMs;
        }
    }
}

