/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.view.View;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromObject;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ViewManagerDelegate;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0016\b\u0001\u0010\u0003*\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0006B\u000f\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0012\u0010\u0007\u001a\u00028\u00018\u0004X\u0085\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/facebook/react/uimanager/BaseViewManagerDelegate;", "T", "Landroid/view/View;", "U", "Lcom/facebook/react/uimanager/BaseViewManager;", "Lcom/facebook/react/uimanager/LayoutShadowNode;", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "mViewManager", "<init>", "(Lcom/facebook/react/uimanager/BaseViewManager;)V", "Lcom/facebook/react/uimanager/BaseViewManager;", "setProperty", "", "view", "propName", "", "value", "", "(Landroid/view/View;Ljava/lang/String;Ljava/lang/Object;)V", "receiveCommand", "commandName", "args", "Lcom/facebook/react/bridge/ReadableArray;", "(Landroid/view/View;Ljava/lang/String;Lcom/facebook/react/bridge/ReadableArray;)V", "ReactAndroid_release"})
public abstract class BaseViewManagerDelegate<T extends View, U extends BaseViewManager<T, ? extends LayoutShadowNode>>
implements ViewManagerDelegate<T> {
    @JvmField
    @NotNull
    protected final U mViewManager;

    public BaseViewManagerDelegate(@NotNull U mViewManager) {
        Intrinsics.checkNotNullParameter(mViewManager, (String)"mViewManager");
        this.mViewManager = mViewManager;
    }

    @Override
    public void setProperty(@NotNull T view, @NotNull String propName, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        switch (propName) {
            case "accessibilityActions": {
                ((BaseViewManager)this.mViewManager).setAccessibilityActions(view, (ReadableArray)value);
                break;
            }
            case "accessibilityHint": {
                ((BaseViewManager)this.mViewManager).setAccessibilityHint(view, (String)value);
                break;
            }
            case "accessibilityLabel": {
                ((BaseViewManager)this.mViewManager).setAccessibilityLabel(view, (String)value);
                break;
            }
            case "accessibilityLiveRegion": {
                ((BaseViewManager)this.mViewManager).setAccessibilityLiveRegion(view, (String)value);
                break;
            }
            case "accessibilityRole": {
                ((BaseViewManager)this.mViewManager).setAccessibilityRole(view, (String)value);
                break;
            }
            case "accessibilityState": {
                ((BaseViewManager)this.mViewManager).setViewState(view, (ReadableMap)value);
                break;
            }
            case "accessibilityCollection": {
                ((BaseViewManager)this.mViewManager).setAccessibilityCollection(view, (ReadableMap)value);
                break;
            }
            case "accessibilityCollectionItem": {
                ((BaseViewManager)this.mViewManager).setAccessibilityCollectionItem(view, (ReadableMap)value);
                break;
            }
            case "accessibilityValue": {
                ((BaseViewManager)this.mViewManager).setAccessibilityValue(view, (ReadableMap)value);
                break;
            }
            case "backgroundColor": {
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                ((BaseViewManager)this.mViewManager).setBackgroundColor(view, ColorPropConverter.getColor(value, context, 0));
                break;
            }
            case "borderRadius": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setBorderRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "borderBottomLeftRadius": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setBorderBottomLeftRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "borderBottomRightRadius": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setBorderBottomRightRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "borderTopLeftRadius": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setBorderTopLeftRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "borderTopRightRadius": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setBorderTopRightRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "boxShadow": {
                ((BaseViewManager)this.mViewManager).setBoxShadow(view, (ReadableArray)value);
                break;
            }
            case "elevation": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setElevation(view, d != null ? (float)d.doubleValue() : 0.0f);
                break;
            }
            case "filter": {
                ((BaseViewManager)this.mViewManager).setFilter(view, (ReadableArray)value);
                break;
            }
            case "mixBlendMode": {
                ((BaseViewManager)this.mViewManager).setMixBlendMode(view, (String)value);
                break;
            }
            case "shadowColor": {
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                ((BaseViewManager)this.mViewManager).setShadowColor(view, ColorPropConverter.getColor(value, context, 0));
                break;
            }
            case "importantForAccessibility": {
                ((BaseViewManager)this.mViewManager).setImportantForAccessibility(view, (String)value);
                break;
            }
            case "screenReaderFocusable": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setScreenReaderFocusable(view, bl != null ? bl : false);
                break;
            }
            case "role": {
                ((BaseViewManager)this.mViewManager).setRole(view, (String)value);
                break;
            }
            case "nativeID": {
                ((BaseViewManager)this.mViewManager).setNativeId(view, (String)value);
                break;
            }
            case "accessibilityLabelledBy": {
                Dynamic dynamicFromObject = new DynamicFromObject(value);
                ((BaseViewManager)this.mViewManager).setAccessibilityLabelledBy(view, dynamicFromObject);
                break;
            }
            case "experimental_accessibilityOrder": {
                ((BaseViewManager)this.mViewManager).setAccessibilityOrder(view, (ReadableArray)value);
                break;
            }
            case "opacity": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setOpacity(view, d != null ? (float)d.doubleValue() : 1.0f);
                break;
            }
            case "outlineColor": {
                ((BaseViewManager)this.mViewManager).setOutlineColor(view, (Integer)value);
                break;
            }
            case "outlineOffset": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setOutlineOffset(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "outlineStyle": {
                ((BaseViewManager)this.mViewManager).setOutlineStyle(view, (String)value);
                break;
            }
            case "outlineWidth": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setOutlineWidth(view, d != null ? (float)d.doubleValue() : Float.NaN);
                break;
            }
            case "renderToHardwareTextureAndroid": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setRenderToHardwareTexture(view, bl != null ? bl : false);
                break;
            }
            case "rotation": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setRotation(view, d != null ? (float)d.doubleValue() : 0.0f);
                break;
            }
            case "scaleX": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setScaleX(view, d != null ? (float)d.doubleValue() : 1.0f);
                break;
            }
            case "scaleY": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setScaleY(view, d != null ? (float)d.doubleValue() : 1.0f);
                break;
            }
            case "testID": {
                ((BaseViewManager)this.mViewManager).setTestId(view, (String)value);
                break;
            }
            case "transform": {
                ((BaseViewManager)this.mViewManager).setTransform(view, (ReadableArray)value);
                break;
            }
            case "transformOrigin": {
                ((BaseViewManager)this.mViewManager).setTransformOrigin(view, (ReadableArray)value);
                break;
            }
            case "translateX": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setTranslateX(view, d != null ? (float)d.doubleValue() : 0.0f);
                break;
            }
            case "translateY": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setTranslateY(view, d != null ? (float)d.doubleValue() : 0.0f);
                break;
            }
            case "zIndex": {
                Double d = (Double)value;
                ((BaseViewManager)this.mViewManager).setZIndex(view, d != null ? (float)d.doubleValue() : 0.0f);
                break;
            }
            case "onPointerEnter": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerEnter(view, bl != null ? bl : false);
                break;
            }
            case "onPointerEnterCapture": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerEnterCapture(view, bl != null ? bl : false);
                break;
            }
            case "onPointerOver": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerOver(view, bl != null ? bl : false);
                break;
            }
            case "onPointerOverCapture": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerOverCapture(view, bl != null ? bl : false);
                break;
            }
            case "onPointerOut": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerOut(view, bl != null ? bl : false);
                break;
            }
            case "onPointerOutCapture": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerOutCapture(view, bl != null ? bl : false);
                break;
            }
            case "onPointerLeave": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerLeave(view, bl != null ? bl : false);
                break;
            }
            case "onPointerLeaveCapture": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerLeaveCapture(view, bl != null ? bl : false);
                break;
            }
            case "onPointerMove": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerMove(view, bl != null ? bl : false);
                break;
            }
            case "onPointerMoveCapture": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setPointerMoveCapture(view, bl != null ? bl : false);
                break;
            }
            case "onClick": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setClick(view, bl != null ? bl : false);
                break;
            }
            case "onClickCapture": {
                Boolean bl = (Boolean)value;
                ((BaseViewManager)this.mViewManager).setClickCapture(view, bl != null ? bl : false);
            }
        }
    }

    @Override
    public void receiveCommand(@NotNull T view, @NotNull String commandName, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
    }
}

