/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class UIManagerModuleConstantsHelper {
    private static final String TAG = "UIManagerModuleConstantsHelper";
    private static final String BUBBLING_EVENTS_KEY = "bubblingEventTypes";
    private static final String DIRECT_EVENTS_KEY = "directEventTypes";

    static Map<String, Object> createConstants(ViewManagerResolver resolver) {
        Map<String, Object> constants = UIManagerModuleConstants.constants;
        constants.put("ViewManagerNames", new ArrayList<String>(resolver.getViewManagerNames()));
        constants.put("LazyViewManagersEnabled", true);
        return constants;
    }

    public static Map<String, Object> getDefaultExportableEventTypes() {
        return MapBuilder.of(BUBBLING_EVENTS_KEY, UIManagerModuleConstants.bubblingEventTypeConstants, DIRECT_EVENTS_KEY, UIManagerModuleConstants.directEventTypeConstants);
    }

    private static void validateDirectEventNames(String viewManagerName, @Nullable Map<String, Object> directEvents) {
        if (!ReactBuildConfig.DEBUG || directEvents == null) {
            return;
        }
        for (String key : directEvents.keySet()) {
            String regName;
            Object value = directEvents.get(key);
            if (value == null || !(value instanceof Map) || (regName = (String)((Map)value).get("registrationName")) == null || !key.startsWith("top") || !regName.startsWith("on") || key.substring(3).equals(regName.substring(2))) continue;
            FLog.e((String)TAG, (String)String.format("Direct event name for '%s' doesn't correspond to the naming convention, expected 'topEventName'->'onEventName', got '%s'->'%s'", viewManagerName, key, regName));
        }
    }

    public static Map<String, Object> createConstants(List<ViewManager> viewManagers, @Nullable Map<String, Object> allBubblingEventTypes, @Nullable Map<String, Object> allDirectEventTypes) {
        Map<String, Object> constants = UIManagerModuleConstants.constants;
        Map<String, Object> genericBubblingEventTypes = UIManagerModuleConstants.bubblingEventTypeConstants;
        Map<String, Object> genericDirectEventTypes = UIManagerModuleConstants.directEventTypeConstants;
        if (allBubblingEventTypes != null) {
            allBubblingEventTypes.putAll(genericBubblingEventTypes);
        }
        if (allDirectEventTypes != null) {
            allDirectEventTypes.putAll(genericDirectEventTypes);
        }
        for (ViewManager viewManager : viewManagers) {
            String viewManagerName = viewManager.getName();
            Map<String, Object> viewManagerConstants = UIManagerModuleConstantsHelper.createConstantsForViewManager(viewManager, null, null, allBubblingEventTypes, allDirectEventTypes);
            if (viewManagerConstants.isEmpty()) continue;
            constants.put(viewManagerName, viewManagerConstants);
        }
        constants.put("genericBubblingEventTypes", genericBubblingEventTypes);
        constants.put("genericDirectEventTypes", genericDirectEventTypes);
        return constants;
    }

    public static Map<String, Object> createConstantsForViewManager(ViewManager viewManager, @Nullable Map defaultBubblingEvents, @Nullable Map defaultDirectEvents, @Nullable Map cumulativeBubblingEventTypes, @Nullable Map cumulativeDirectEventTypes) {
        Map<String, String> viewManagerNativeProps;
        Map<String, Integer> viewManagerCommands;
        HashMap<String, Object> viewManagerConstants = MapBuilder.newHashMap();
        Map viewManagerBubblingEvents = viewManager.getExportedCustomBubblingEventTypeConstants();
        if (viewManagerBubblingEvents != null) {
            if (ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer() && ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
                viewManagerBubblingEvents = UIManagerModuleConstantsHelper.normalizeEventTypes(viewManagerBubblingEvents);
            }
            UIManagerModuleConstantsHelper.recursiveMerge(cumulativeBubblingEventTypes, viewManagerBubblingEvents);
            UIManagerModuleConstantsHelper.recursiveMerge(viewManagerBubblingEvents, defaultBubblingEvents);
            viewManagerConstants.put(BUBBLING_EVENTS_KEY, viewManagerBubblingEvents);
        } else if (defaultBubblingEvents != null) {
            viewManagerConstants.put(BUBBLING_EVENTS_KEY, defaultBubblingEvents);
        }
        Map viewManagerDirectEvents = viewManager.getExportedCustomDirectEventTypeConstants();
        UIManagerModuleConstantsHelper.validateDirectEventNames(viewManager.getName(), viewManagerDirectEvents);
        if (viewManagerDirectEvents != null) {
            if (ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer() && ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
                viewManagerDirectEvents = UIManagerModuleConstantsHelper.normalizeEventTypes(viewManagerDirectEvents);
            }
            UIManagerModuleConstantsHelper.recursiveMerge(cumulativeDirectEventTypes, viewManagerDirectEvents);
            UIManagerModuleConstantsHelper.recursiveMerge(viewManagerDirectEvents, defaultDirectEvents);
            viewManagerConstants.put(DIRECT_EVENTS_KEY, viewManagerDirectEvents);
        } else if (defaultDirectEvents != null) {
            viewManagerConstants.put(DIRECT_EVENTS_KEY, defaultDirectEvents);
        }
        Map<String, Object> customViewConstants = viewManager.getExportedViewConstants();
        if (customViewConstants != null) {
            viewManagerConstants.put("Constants", customViewConstants);
        }
        if ((viewManagerCommands = viewManager.getCommandsMap()) != null) {
            viewManagerConstants.put("Commands", viewManagerCommands);
        }
        if (!(viewManagerNativeProps = viewManager.getNativeProps()).isEmpty()) {
            viewManagerConstants.put("NativeProps", viewManagerNativeProps);
        }
        return viewManagerConstants;
    }

    @VisibleForTesting
    @Nullable
    static Map normalizeEventTypes(@Nullable Map events) {
        if (events == null) {
            return null;
        }
        HashSet<String> keysToNormalize = new HashSet<String>();
        for (Object key : events.keySet()) {
            String keyString;
            if (!(key instanceof String) || (keyString = (String)key).startsWith("top")) continue;
            keysToNormalize.add(keyString);
        }
        if (!(events instanceof HashMap)) {
            events = new HashMap(events);
        }
        for (String oldKey : keysToNormalize) {
            Object value = events.get(oldKey);
            String baseKey = "";
            baseKey = oldKey.startsWith("on") ? oldKey.substring(2) : oldKey.substring(0, 1).toUpperCase() + oldKey.substring(1);
            String newKey = "top" + baseKey;
            events.put(newKey, value);
        }
        return events;
    }

    private static void recursiveMerge(@Nullable Map dest, @Nullable Map source2) {
        if (dest == null || source2 == null || source2.isEmpty()) {
            return;
        }
        for (Object key : source2.keySet()) {
            Object sourceValue = source2.get(key);
            Object destValue = dest.get(key);
            if (destValue != null && sourceValue instanceof Map && destValue instanceof Map) {
                if (!(destValue instanceof HashMap)) {
                    destValue = new HashMap((Map)destValue);
                    dest.replace(key, (Map)destValue);
                }
                UIManagerModuleConstantsHelper.recursiveMerge((Map)destValue, (Map)sourceValue);
                continue;
            }
            dest.put(key, sourceValue);
        }
    }
}

