/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.ViewManagersPropertyCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006*+,-./B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0007J?\u0010\u000e\u001a\u00020\r\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0001\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\u000f2\u0006\u0010\u0014\u001a\u0002H\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J9\u0010\u000e\u001a\u00020\r\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u00192\u0006\u0010\u0014\u001a\u0002H\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u000e\u001a\u00020\r\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u001b2\u0006\u0010\u001c\u001a\u0002H\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u001dJ@\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001f2\u0018\u0010 \u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00020!\u0012\u0002\b\u00030\u00190\b2\u0010\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020!\u0018\u00010\bH\u0007JB\u0010#\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u0002H\u00110\t\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0018\u0010$\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u0002H\u0011\u0012\u0002\b\u00030\u00190\bH\u0002J.\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000b\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u001b2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000f0\bH\u0002J!\u0010'\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater;", "", "<init>", "()V", "TAG", "", "VIEW_MANAGER_SETTER_MAP", "", "Ljava/lang/Class;", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ViewManagerSetter;", "SHADOW_NODE_SETTER_MAP", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ShadowNodeSetter;", "clear", "", "updateProps", "T", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "V", "Landroid/view/View;", "delegate", "view", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "(Lcom/facebook/react/uimanager/ViewManagerDelegate;Landroid/view/View;Lcom/facebook/react/uimanager/ReactStylesDiffMap;)V", "manager", "Lcom/facebook/react/uimanager/ViewManager;", "(Lcom/facebook/react/uimanager/ViewManager;Landroid/view/View;Lcom/facebook/react/uimanager/ReactStylesDiffMap;)V", "Lcom/facebook/react/uimanager/ReactShadowNode;", "node", "(Lcom/facebook/react/uimanager/ReactShadowNode;Lcom/facebook/react/uimanager/ReactStylesDiffMap;)V", "getNativeProps", "", "viewManagerTopClass", "", "shadowNodeTopClass", "findManagerSetter", "managerClass", "findNodeSetter", "nodeClass", "findGeneratedSetter", "cls", "(Ljava/lang/Class;)Ljava/lang/Object;", "Settable", "ViewManagerSetter", "ShadowNodeSetter", "FallbackViewManagerSetter", "FallbackShadowNodeSetter", "GenericViewManagerDelegate", "ReactAndroid_release"})
public final class ViewManagerPropertyUpdater {
    @NotNull
    public static final ViewManagerPropertyUpdater INSTANCE = new ViewManagerPropertyUpdater();
    @NotNull
    private static final String TAG = "ViewManagerPropertyUpdater";
    @NotNull
    private static final Map<Class<?>, ViewManagerSetter<?, ?>> VIEW_MANAGER_SETTER_MAP = new HashMap();
    @NotNull
    private static final Map<Class<?>, ShadowNodeSetter<?>> SHADOW_NODE_SETTER_MAP = new HashMap();

    private ViewManagerPropertyUpdater() {
    }

    @JvmStatic
    public static final void clear() {
        ViewManagersPropertyCache.clear();
        VIEW_MANAGER_SETTER_MAP.clear();
        SHADOW_NODE_SETTER_MAP.clear();
    }

    @JvmStatic
    @Deprecated(message="Use ViewManager#updateProperties to update a view's properties")
    public static final <T extends ViewManagerDelegate<V>, V extends View> void updateProps(@NotNull T delegate, @NotNull V view, @NotNull ReactStylesDiffMap props) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Iterator<Map.Entry<String, Object>> iterator2 = props.internal_backingMap().getEntryIterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> entry = iterator2.next();
            delegate.kotlinCompat$setProperty(view, entry.getKey(), entry.getValue());
        }
    }

    @JvmStatic
    @Deprecated(message="Use ViewManager#updateProperties to update a view's properties")
    public static final <V extends View> void updateProps(@NotNull ViewManager<V, ?> manager, @NotNull V view, @NotNull ReactStylesDiffMap props) {
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        ViewManagerSetter<ViewManager<V, ?>, V> setter = INSTANCE.findManagerSetter(manager.getClass());
        Iterator<Map.Entry<String, Object>> iterator2 = props.internal_backingMap().getEntryIterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> entry = iterator2.next();
            setter.setProperty(manager, view, entry.getKey(), entry.getValue());
        }
    }

    @JvmStatic
    public static final <T extends ReactShadowNode<T>> void updateProps(@NotNull T node, @NotNull ReactStylesDiffMap props) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        ShadowNodeSetter<?> setter = INSTANCE.findNodeSetter(node.getClass());
        Iterator<Map.Entry<String, Object>> iterator2 = props.internal_backingMap().getEntryIterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> entry = iterator2.next();
            setter.setProperty(node, entry.getKey(), entry.getValue());
        }
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getNativeProps(@NotNull Class<? extends ViewManager> viewManagerTopClass, @Nullable Class shadowNodeTopClass) {
        Intrinsics.checkNotNullParameter(viewManagerTopClass, (String)"viewManagerTopClass");
        Map props = new HashMap();
        INSTANCE.findManagerSetter(viewManagerTopClass).getProperties(props);
        if (shadowNodeTopClass != null) {
            INSTANCE.findNodeSetter(shadowNodeTopClass).getProperties(props);
        }
        return props;
    }

    private final <V extends View> ViewManagerSetter<ViewManager<V, ?>, V> findManagerSetter(Class<? extends ViewManager<V, ?>> managerClass) {
        ViewManagerSetter setter = VIEW_MANAGER_SETTER_MAP.get(managerClass);
        if (setter == null) {
            setter = (ViewManagerSetter)this.findGeneratedSetter(managerClass);
            if (setter == null) {
                setter = new FallbackViewManagerSetter(managerClass);
            }
            VIEW_MANAGER_SETTER_MAP.put(managerClass, setter);
        }
        return setter;
    }

    private final <T extends ReactShadowNode<T>> ShadowNodeSetter<T> findNodeSetter(Class<? extends T> nodeClass) {
        ShadowNodeSetter setter = SHADOW_NODE_SETTER_MAP.get(nodeClass);
        if (setter == null) {
            setter = (ShadowNodeSetter)this.findGeneratedSetter(nodeClass);
            if (setter == null) {
                Intrinsics.checkNotNull(nodeClass, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Nothing>");
                setter = new FallbackShadowNodeSetter(nodeClass);
            }
            SHADOW_NODE_SETTER_MAP.put(nodeClass, setter);
        }
        return setter;
    }

    private final <T> T findGeneratedSetter(Class<?> cls) {
        String clsName = cls.getName();
        try {
            Class<?> setterClass = Class.forName(clsName + "$$PropsSetter");
            return (T)setterClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            FLog.w((String)TAG, (String)("Could not find generated setter for " + cls));
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate methods getter for " + clsName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate methods getter for " + clsName, e);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0014H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$FallbackShadowNodeSetter;", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ShadowNodeSetter;", "Lcom/facebook/react/uimanager/ReactShadowNode;", "shadowNodeClass", "Ljava/lang/Class;", "", "<init>", "(Ljava/lang/Class;)V", "propSetters", "", "", "Lcom/facebook/react/uimanager/ViewManagersPropertyCache$PropSetter;", "setProperty", "", "node", "name", "value", "", "getProperties", "props", "", "ReactAndroid_release"})
    private static final class FallbackShadowNodeSetter
    implements ShadowNodeSetter<ReactShadowNode<?>> {
        @NotNull
        private final Map<String, ViewManagersPropertyCache.PropSetter> propSetters;

        public FallbackShadowNodeSetter(@NotNull Class shadowNodeClass) {
            Intrinsics.checkNotNullParameter((Object)shadowNodeClass, (String)"shadowNodeClass");
            Map<String, ViewManagersPropertyCache.PropSetter> map = ViewManagersPropertyCache.getNativePropSettersForShadowNodeClass(shadowNodeClass);
            Intrinsics.checkNotNullExpressionValue(map, (String)"getNativePropSettersForShadowNodeClass(...)");
            this.propSetters = map;
        }

        @Override
        public void setProperty(@NotNull ReactShadowNode<?> node, @NotNull String name, @Nullable Object value) {
            block0: {
                ViewManagersPropertyCache.PropSetter setter;
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                ViewManagersPropertyCache.PropSetter propSetter = setter = this.propSetters.get(name);
                if (propSetter == null) break block0;
                propSetter.updateShadowNodeProp(node, value);
            }
        }

        @Override
        public void getProperties(@NotNull Map<String, String> props) {
            Intrinsics.checkNotNullParameter(props, (String)"props");
            for (ViewManagersPropertyCache.PropSetter setter : this.propSetters.values()) {
                props.put(setter.getPropName(), setter.getPropType());
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ9\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00042\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$FallbackViewManagerSetter;", "V", "Landroid/view/View;", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ViewManagerSetter;", "Lcom/facebook/react/uimanager/ViewManager;", "viewManagerClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "mPropSetters", "", "", "Lcom/facebook/react/uimanager/ViewManagersPropertyCache$PropSetter;", "setProperty", "", "manager", "view", "name", "value", "", "(Lcom/facebook/react/uimanager/ViewManager;Landroid/view/View;Ljava/lang/String;Ljava/lang/Object;)V", "getProperties", "props", "", "ReactAndroid_release"})
    private static final class FallbackViewManagerSetter<V extends View>
    implements ViewManagerSetter<ViewManager<V, ?>, V> {
        @NotNull
        private final Map<String, ViewManagersPropertyCache.PropSetter> mPropSetters;

        public FallbackViewManagerSetter(@NotNull Class<? extends ViewManager<V, ?>> viewManagerClass) {
            Intrinsics.checkNotNullParameter(viewManagerClass, (String)"viewManagerClass");
            Map<String, ViewManagersPropertyCache.PropSetter> map = ViewManagersPropertyCache.getNativePropSettersForViewManagerClass(viewManagerClass);
            Intrinsics.checkNotNullExpressionValue(map, (String)"getNativePropSettersForViewManagerClass(...)");
            this.mPropSetters = map;
        }

        @Override
        public void setProperty(@NotNull ViewManager<V, ?> manager, @NotNull V view, @NotNull String name, @Nullable Object value) {
            block0: {
                ViewManagersPropertyCache.PropSetter setter;
                Intrinsics.checkNotNullParameter(manager, (String)"manager");
                Intrinsics.checkNotNullParameter(view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                ViewManagersPropertyCache.PropSetter propSetter = setter = this.mPropSetters.get(name);
                if (propSetter == null) break block0;
                propSetter.updateViewProp(manager, (View)view, value);
            }
        }

        @Override
        public void getProperties(@NotNull Map<String, String> props) {
            Intrinsics.checkNotNullParameter(props, (String)"props");
            for (ViewManagersPropertyCache.PropSetter setter : this.mPropSetters.values()) {
                props.put(setter.getPropName(), setter.getPropType());
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$GenericViewManagerDelegate;", "T", "Landroid/view/View;", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "manager", "Lcom/facebook/react/uimanager/ViewManager;", "<init>", "(Lcom/facebook/react/uimanager/ViewManager;)V", "setter", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ViewManagerSetter;", "setProperty", "", "view", "propName", "", "value", "", "(Landroid/view/View;Ljava/lang/String;Ljava/lang/Object;)V", "receiveCommand", "commandName", "args", "Lcom/facebook/react/bridge/ReadableArray;", "(Landroid/view/View;Ljava/lang/String;Lcom/facebook/react/bridge/ReadableArray;)V", "ReactAndroid_release"})
    public static final class GenericViewManagerDelegate<T extends View>
    implements ViewManagerDelegate<T> {
        @NotNull
        private final ViewManager<T, ?> manager;
        @NotNull
        private final ViewManagerSetter<ViewManager<T, ?>, T> setter;

        public GenericViewManagerDelegate(@NotNull ViewManager<T, ?> manager) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            this.manager = manager;
            this.setter = INSTANCE.findManagerSetter(this.manager.getClass());
        }

        @Override
        public void setProperty(@NotNull T view, @NotNull String propName, @Nullable Object value) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
            this.setter.setProperty((ViewManager<ViewManager<T, ?>, ?>)this.manager, (ViewManager<T, ?>)view, propName, value);
        }

        @Override
        public void receiveCommand(@NotNull T view, @NotNull String commandName, @Nullable ReadableArray args) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$Settable;", "", "getProperties", "", "props", "", "", "ReactAndroid_release"})
    public static interface Settable {
        public void getProperties(@NotNull Map<String, String> var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0000*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH&\u00a2\u0006\u0002\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ShadowNodeSetter;", "T", "Lcom/facebook/react/uimanager/ReactShadowNode;", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$Settable;", "setProperty", "", "node", "name", "", "value", "", "(Lcom/facebook/react/uimanager/ReactShadowNode;Ljava/lang/String;Ljava/lang/Object;)V", "ReactAndroid_release"})
    public static interface ShadowNodeSetter<T extends ReactShadowNode<?>>
    extends Settable {
        public void setProperty(@NotNull T var1, @NotNull String var2, @Nullable Object var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000*\u0012\b\u0000\u0010\u0001*\f\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005J/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00028\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$ViewManagerSetter;", "T", "Lcom/facebook/react/uimanager/ViewManager;", "V", "Landroid/view/View;", "Lcom/facebook/react/uimanager/ViewManagerPropertyUpdater$Settable;", "setProperty", "", "manager", "view", "name", "", "value", "", "(Lcom/facebook/react/uimanager/ViewManager;Landroid/view/View;Ljava/lang/String;Ljava/lang/Object;)V", "ReactAndroid_release"})
    public static interface ViewManagerSetter<T extends ViewManager<V, ?>, V extends View>
    extends Settable {
        public void setProperty(@NotNull T var1, @NotNull V var2, @NotNull String var3, @Nullable Object var4);
    }
}

