/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchesHelper;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\"\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0017J*\u0010\f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0002JB\u0010\f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/uimanager/events/EventEmitterImpl;", "Lcom/facebook/react/uimanager/events/RCTModernEventEmitter;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "legacyEventEmitter", "Lcom/facebook/react/uimanager/events/RCTEventEmitter;", "fabricEventEmitter", "registerFabricEventEmitter", "", "eventEmitter", "receiveEvent", "targetTag", "", "eventName", "", "params", "Lcom/facebook/react/bridge/WritableMap;", "surfaceId", "receiveTouches", "touches", "Lcom/facebook/react/bridge/WritableArray;", "changedIndices", "ensureLegacyEventEmitter", "canCoalesceEvent", "", "customCoalesceKey", "category", "Companion", "ReactAndroid_release"})
public final class EventEmitterImpl
implements RCTModernEventEmitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactContext;
    @Nullable
    private RCTEventEmitter legacyEventEmitter;
    @Nullable
    private RCTModernEventEmitter fabricEventEmitter;
    @NotNull
    private static final String TAG = "ReactEventEmitter";

    public EventEmitterImpl(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this.reactContext = reactContext;
    }

    public final void registerFabricEventEmitter(@Nullable RCTModernEventEmitter eventEmitter) {
        this.fabricEventEmitter = eventEmitter;
    }

    @Override
    @Deprecated(message="Please use RCTModernEventEmitter")
    public void receiveEvent(int targetTag, @NotNull String eventName, @Nullable WritableMap params) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        this.receiveEvent(-1, targetTag, eventName, params);
    }

    @Override
    public void receiveEvent(int surfaceId, int targetTag, @NotNull String eventName, @Nullable WritableMap params) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        this.receiveEvent(surfaceId, targetTag, eventName, false, 0, params, 2);
    }

    @Override
    @Deprecated(message="Dispatch the TouchEvent using [EventDispatcher] instead")
    public void receiveTouches(@NotNull String eventName, @NotNull WritableArray touches, @NotNull WritableArray changedIndices) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)touches, (String)"touches");
            Intrinsics.checkNotNullParameter((Object)changedIndices, (String)"changedIndices");
            if (!(touches.size() > 0)) {
                throw new IllegalStateException("Check failed.");
            }
            ReadableMap readableMap = touches.getMap(0);
            int reactTag = readableMap != null ? readableMap.getInt(TouchesHelper.TARGET_KEY) : 0;
            int uiManagerType = ViewUtil.getUIManagerType(reactTag);
            if (uiManagerType != 1) break block2;
            RCTEventEmitter rCTEventEmitter = this.ensureLegacyEventEmitter();
            if (rCTEventEmitter != null) {
                rCTEventEmitter.receiveTouches(eventName, touches, changedIndices);
            }
        }
    }

    private final RCTEventEmitter ensureLegacyEventEmitter() {
        if (this.legacyEventEmitter == null) {
            if (this.reactContext.hasActiveReactInstance()) {
                this.legacyEventEmitter = this.reactContext.getJSModule(RCTEventEmitter.class);
            } else {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get RCTEventEmitter without active Catalyst instance!"));
            }
        }
        return this.legacyEventEmitter;
    }

    @Override
    public void receiveEvent(int surfaceId, int targetTag, @NotNull String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap params, int category) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        int uiManagerType = ViewUtil.getUIManagerType(targetTag, surfaceId);
        switch (uiManagerType) {
            case 2: {
                RCTModernEventEmitter fabricEventEmitter = this.fabricEventEmitter;
                if (fabricEventEmitter == null) {
                    ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("No fabricEventEmitter registered, cannot dispatch event"));
                    break;
                }
                fabricEventEmitter.receiveEvent(surfaceId, targetTag, eventName, canCoalesceEvent, customCoalesceKey, params, category);
                break;
            }
            case 1: {
                RCTEventEmitter rCTEventEmitter = this.ensureLegacyEventEmitter();
                if (rCTEventEmitter == null) break;
                rCTEventEmitter.receiveEvent(targetTag, eventName, params);
                break;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/uimanager/events/EventEmitterImpl$Companion;", "", "<init>", "()V", "TAG", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

