/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.AnimatedPropertyType;
import com.facebook.react.uimanager.layoutanimation.OpacityAnimation;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b \u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\r\u0010\u0006\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0007J5\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/BaseLayoutAnimation;", "Lcom/facebook/react/uimanager/layoutanimation/AbstractLayoutAnimation;", "<init>", "()V", "isReverse", "", "isValid", "isValid$ReactAndroid_release", "createAnimationImpl", "Landroid/view/animation/Animation;", "view", "Landroid/view/View;", "x", "", "y", "width", "height", "createAnimationImpl$ReactAndroid_release", "Companion", "ReactAndroid_release"})
public abstract class BaseLayoutAnimation
extends AbstractLayoutAnimation {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public abstract boolean isReverse();

    @Override
    public boolean isValid$ReactAndroid_release() {
        return this.getDurationMs() > 0 && this.getAnimatedProperty() != null;
    }

    @Override
    @NotNull
    public Animation createAnimationImpl$ReactAndroid_release(@NotNull View view, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        AnimatedPropertyType animatedPropertyType = this.getAnimatedProperty();
        if (animatedPropertyType != null) {
            AnimatedPropertyType it = animatedPropertyType;
            boolean bl = false;
            return switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1 -> {
                    float fromValue = this.isReverse() ? view.getAlpha() : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : view.getAlpha();
                    yield new OpacityAnimation(view, fromValue, toValue);
                }
                case 2 -> {
                    float fromValue = this.isReverse() ? 1.0f : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : 1.0f;
                    yield (Animation)new ScaleAnimation(fromValue, toValue, fromValue, toValue, 1, 0.5f, 1, 0.5f);
                }
                case 3 -> {
                    float fromValue = this.isReverse() ? 1.0f : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : 1.0f;
                    yield (Animation)new ScaleAnimation(fromValue, toValue, 1.0f, 1.0f, 1, 0.5f, 1, 0.0f);
                }
                case 4 -> {
                    float fromValue = this.isReverse() ? 1.0f : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : 1.0f;
                    yield (Animation)new ScaleAnimation(1.0f, 1.0f, fromValue, toValue, 1, 0.0f, 1, 0.5f);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        throw new IllegalViewOperationException("Missing animated property from animation config");
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("BaseLayoutAnimation", LegacyArchitectureLogLevel.WARNING);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/BaseLayoutAnimation$Companion;", "", "<init>", "()V", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnimatedPropertyType.values().length];
            try {
                nArray[AnimatedPropertyType.OPACITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimatedPropertyType.SCALE_XY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimatedPropertyType.SCALE_X.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimatedPropertyType.SCALE_Y.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

