/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Shader;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.style.Gradient;
import com.facebook.react.uimanager.style.LinearGradient;
import com.facebook.react.uimanager.style.RadialGradient;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "", "<init>", "()V", "gradient", "Lcom/facebook/react/uimanager/style/Gradient;", "(Lcom/facebook/react/uimanager/style/Gradient;)V", "getShader", "Landroid/graphics/Shader;", "bounds", "Landroid/graphics/Rect;", "Companion", "ReactAndroid_release"})
public final class BackgroundImageLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Gradient gradient;

    public BackgroundImageLayer() {
    }

    private BackgroundImageLayer(Gradient gradient) {
        this();
        this.gradient = gradient;
    }

    @NotNull
    public final Shader getShader(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Gradient gradient = this.gradient;
        if (gradient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gradient");
            gradient = null;
        }
        return gradient.getShader(bounds.width(), bounds.height());
    }

    public /* synthetic */ BackgroundImageLayer(Gradient gradient, DefaultConstructorMarker $constructor_marker) {
        this(gradient);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/facebook/react/uimanager/style/BackgroundImageLayer$Companion;", "", "<init>", "()V", "parse", "Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "gradientMap", "Lcom/facebook/react/bridge/ReadableMap;", "context", "Landroid/content/Context;", "parseGradient", "Lcom/facebook/react/uimanager/style/Gradient;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BackgroundImageLayer parse(@Nullable ReadableMap gradientMap, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (gradientMap == null) {
                return null;
            }
            Gradient gradient = this.parseGradient(gradientMap, context);
            if (gradient == null) {
                return null;
            }
            Gradient gradient2 = gradient;
            return new BackgroundImageLayer(gradient2, null);
        }

        private final Gradient parseGradient(ReadableMap gradientMap, Context context) {
            if (!gradientMap.hasKey("type") || gradientMap.getType("type") != ReadableType.String) {
                return null;
            }
            String string2 = gradientMap.getString("type");
            return Intrinsics.areEqual((Object)string2, (Object)"linear-gradient") ? LinearGradient.Companion.parse(gradientMap, context) : (Intrinsics.areEqual((Object)string2, (Object)"radial-gradient") ? RadialGradient.Companion.parse(gradientMap, context) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

