/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.drawer;

import android.view.View;
import android.view.ViewGroup;
import androidx.drawerlayout.widget.DrawerLayout;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.viewmanagers.AndroidDrawerLayoutManagerDelegate;
import com.facebook.react.viewmanagers.AndroidDrawerLayoutManagerInterface;
import com.facebook.react.views.drawer.ReactDrawerLayout;
import com.facebook.react.views.drawer.events.DrawerClosedEvent;
import com.facebook.react.views.drawer.events.DrawerOpenedEvent;
import com.facebook.react.views.drawer.events.DrawerSlideEvent;
import com.facebook.react.views.drawer.events.DrawerStateChangedEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AndroidDrawerLayout")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u000278B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\rH\u0014J\u001a\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001f\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001a\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0017J\u001f\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010 H\u0017\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010 H\u0017\u00a2\u0006\u0002\u0010!J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020 0(H\u0016J\"\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020 2\b\u0010,\u001a\u0004\u0018\u00010-H\u0017J\"\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020/0(H\u0016J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020/0(H\u0016J \u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020 H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/facebook/react/views/drawer/ReactDrawerLayoutManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/facebook/react/views/drawer/ReactDrawerLayout;", "Lcom/facebook/react/viewmanagers/AndroidDrawerLayoutManagerInterface;", "<init>", "()V", "delegate", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "getName", "", "addEventEmitters", "", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "view", "createViewInstance", "context", "setDrawerPosition", "value", "drawerPosition", "Lcom/facebook/react/bridge/Dynamic;", "setDrawerPositionInternal", "setDrawerWidth", "width", "", "(Lcom/facebook/react/views/drawer/ReactDrawerLayout;Ljava/lang/Float;)V", "setDrawerLockMode", "drawerLockMode", "openDrawer", "closeDrawer", "setKeyboardDismissMode", "setDrawerBackgroundColor", "", "(Lcom/facebook/react/views/drawer/ReactDrawerLayout;Ljava/lang/Integer;)V", "setStatusBarBackgroundColor", "setElevation", "elevation", "needsCustomLayoutForChildren", "", "getCommandsMap", "", "receiveCommand", "root", "commandId", "args", "Lcom/facebook/react/bridge/ReadableArray;", "getExportedViewConstants", "", "getExportedCustomDirectEventTypeConstants", "addView", "parent", "child", "Landroid/view/View;", "index", "getDelegate", "DrawerEventEmitter", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactDrawerLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactDrawerLayoutManager.kt\ncom/facebook/react/views/drawer/ReactDrawerLayoutManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class ReactDrawerLayoutManager
extends ViewGroupManager<ReactDrawerLayout>
implements AndroidDrawerLayoutManagerInterface<ReactDrawerLayout> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewManagerDelegate<ReactDrawerLayout> delegate = new AndroidDrawerLayoutManagerDelegate(this);
    @NotNull
    public static final String REACT_CLASS = "AndroidDrawerLayout";
    public static final int OPEN_DRAWER = 1;
    public static final int CLOSE_DRAWER = 2;
    @NotNull
    public static final String COMMAND_OPEN_DRAWER = "openDrawer";
    @NotNull
    public static final String COMMAND_CLOSE_DRAWER = "closeDrawer";
    @NotNull
    private static final String DRAWER_POSITION = "DrawerPosition";
    @NotNull
    private static final String DRAWER_POSITION_LEFT = "Left";
    @NotNull
    private static final String DRAWER_POSITION_RIGHT = "Right";

    public ReactDrawerLayoutManager() {
        super(null, 1, null);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void addEventEmitters(@NotNull ThemedReactContext reactContext, @NotNull ReactDrawerLayout view) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, view.getId());
        if (eventDispatcher == null) {
            return;
        }
        EventDispatcher eventDispatcher2 = eventDispatcher;
        view.addDrawerListener(new DrawerEventEmitter(view, eventDispatcher2));
    }

    @Override
    @NotNull
    protected ReactDrawerLayout createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new ReactDrawerLayout(context);
    }

    @Override
    public void setDrawerPosition(@NotNull ReactDrawerLayout view, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (value == null) {
            view.setDrawerPosition$ReactAndroid_release(0x800003);
        } else {
            this.setDrawerPositionInternal(view, value);
        }
    }

    @ReactProp(name="drawerPosition")
    public final void setDrawerPosition(@NotNull ReactDrawerLayout view, @NotNull Dynamic drawerPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)drawerPosition, (String)"drawerPosition");
        if (drawerPosition.isNull()) {
            view.setDrawerPosition$ReactAndroid_release(0x800003);
        } else if (drawerPosition.getType() == ReadableType.Number) {
            int drawerPositionNum = drawerPosition.asInt();
            if (0x800003 == drawerPositionNum || 0x800005 == drawerPositionNum) {
                view.setDrawerPosition$ReactAndroid_release(drawerPositionNum);
            } else {
                FLog.w((String)"ReactNative", (String)("Unknown drawerPosition " + drawerPositionNum));
                view.setDrawerPosition$ReactAndroid_release(0x800003);
            }
        } else if (drawerPosition.getType() == ReadableType.String) {
            String string2 = drawerPosition.asString();
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            this.setDrawerPositionInternal(view, string2);
        } else {
            FLog.w((String)"ReactNative", (String)"drawerPosition must be a string or int");
            view.setDrawerPosition$ReactAndroid_release(0x800003);
        }
    }

    private final void setDrawerPositionInternal(ReactDrawerLayout view, String drawerPosition) {
        String string2 = drawerPosition;
        if (Intrinsics.areEqual((Object)string2, (Object)"left")) {
            view.setDrawerPosition$ReactAndroid_release(0x800003);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"right")) {
            view.setDrawerPosition$ReactAndroid_release(0x800005);
        } else {
            FLog.w((String)"ReactNative", (String)("drawerPosition must be 'left' or 'right', received" + drawerPosition));
            view.setDrawerPosition$ReactAndroid_release(0x800003);
        }
    }

    @ReactProp(name="drawerWidth", defaultFloat=NaNf)
    public final void setDrawerWidth(@NotNull ReactDrawerLayout view, float width) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        int widthInPx = Float.isNaN(width) ? -1 : Math.round(PixelUtil.INSTANCE.dpToPx(width));
        view.setDrawerWidth$ReactAndroid_release(widthInPx);
    }

    @Override
    public void setDrawerWidth(@NotNull ReactDrawerLayout view, @Nullable Float width) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Float f = width;
        if (f != null) {
            float it = ((Number)f).floatValue();
            boolean bl = false;
            n = Math.round(PixelUtil.INSTANCE.dpToPx(it));
        } else {
            n = -1;
        }
        int widthInPx = n;
        view.setDrawerWidth$ReactAndroid_release(widthInPx);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ReactProp(name="drawerLockMode")
    public void setDrawerLockMode(@NotNull ReactDrawerLayout view, @Nullable String drawerLockMode) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                var3_3 = drawerLockMode;
                if (var3_3 == null) ** GOTO lbl14
                switch (var3_3.hashCode()) {
                    case -1292600945: {
                        if (var3_3.equals("locked-closed")) break;
                        ** break;
                    }
                    case 168848173: {
                        if (!var3_3.equals("locked-open")) {
                            ** break;
                        }
                        break block6;
                    }
                    case -210949405: {
                        if (!var3_3.equals("unlocked")) ** break;
lbl14:
                        // 2 sources

                        view.setDrawerLockMode(0);
                        break block7;
                    }
                }
                view.setDrawerLockMode(1);
                break block7;
            }
            view.setDrawerLockMode(2);
            break block7;
lbl21:
            // 4 sources

            FLog.w((String)"ReactNative", (String)("Unknown drawerLockMode " + drawerLockMode));
            view.setDrawerLockMode(0);
        }
    }

    @Override
    public void openDrawer(@NotNull ReactDrawerLayout view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.openDrawer$ReactAndroid_release();
    }

    @Override
    public void closeDrawer(@NotNull ReactDrawerLayout view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.closeDrawer$ReactAndroid_release();
    }

    @Override
    @ReactProp(name="keyboardDismissMode")
    public void setKeyboardDismissMode(@NotNull ReactDrawerLayout view, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
    }

    @Override
    @ReactProp(name="drawerBackgroundColor", customType="Color")
    public void setDrawerBackgroundColor(@NotNull ReactDrawerLayout view, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
    }

    @Override
    @ReactProp(name="statusBarBackgroundColor", customType="Color")
    public void setStatusBarBackgroundColor(@NotNull ReactDrawerLayout view, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
    }

    @Override
    public void setElevation(@NotNull ReactDrawerLayout view, float elevation) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.setDrawerElevation(PixelUtil.INSTANCE.dpToPx(elevation));
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Integer> getCommandsMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)COMMAND_OPEN_DRAWER, (Object)1), TuplesKt.to((Object)COMMAND_CLOSE_DRAWER, (Object)2)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Deprecated(message="This method is deprecated. Use receiveCommand(ReactDrawerLayout, String, ReadableArray) instead", replaceWith=@ReplaceWith(expression="receiveCommand(ReactDrawerLayout, String, ReadableArray)", imports={}))
    public void receiveCommand(@NotNull ReactDrawerLayout root, int commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        switch (commandId) {
            case 1: {
                root.openDrawer$ReactAndroid_release();
                break;
            }
            case 2: {
                root.closeDrawer$ReactAndroid_release();
            }
        }
    }

    @Override
    public void receiveCommand(@NotNull ReactDrawerLayout root, @NotNull String commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        String string2 = commandId;
        if (Intrinsics.areEqual((Object)string2, (Object)COMMAND_OPEN_DRAWER)) {
            root.openDrawer$ReactAndroid_release();
        } else if (Intrinsics.areEqual((Object)string2, (Object)COMMAND_CLOSE_DRAWER)) {
            root.closeDrawer$ReactAndroid_release();
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedViewConstants() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DRAWER_POSITION_LEFT, (Object)0x800003), TuplesKt.to((Object)DRAWER_POSITION_RIGHT, (Object)0x800005)};
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)DRAWER_POSITION, (Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map eventTypeConstants;
        Map map;
        Map map2 = super.getExportedCustomDirectEventTypeConstants();
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map $this$getExportedCustomDirectEventTypeConstants_u24lambda_u241 = map = (eventTypeConstants = map2);
        boolean bl = false;
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u241.put("topDrawerSlide", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onDrawerSlide")));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u241.put("topDrawerOpen", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onDrawerOpen")));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u241.put("topDrawerClose", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onDrawerClose")));
        $this$getExportedCustomDirectEventTypeConstants_u24lambda_u241.put("topDrawerStateChanged", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onDrawerStateChanged")));
        return map;
    }

    @Override
    public void addView(@NotNull ReactDrawerLayout parent, @NotNull View child, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (this.getChildCount((ViewGroup)parent) >= 2) {
            throw new JSApplicationIllegalArgumentException("The Drawer cannot have more than two children");
        }
        if (index != 0 && index != 1) {
            throw new JSApplicationIllegalArgumentException("The only valid indices for drawer's child are 0 or 1. Got " + index + " instead.");
        }
        parent.addView(child, index);
        parent.setDrawerProperties$ReactAndroid_release();
    }

    @Override
    @NotNull
    public ViewManagerDelegate<ReactDrawerLayout> getDelegate() {
        return this.delegate;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/views/drawer/ReactDrawerLayoutManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "OPEN_DRAWER", "", "CLOSE_DRAWER", "COMMAND_OPEN_DRAWER", "COMMAND_CLOSE_DRAWER", "DRAWER_POSITION", "DRAWER_POSITION_LEFT", "DRAWER_POSITION_RIGHT", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/views/drawer/ReactDrawerLayoutManager$DrawerEventEmitter;", "Landroidx/drawerlayout/widget/DrawerLayout$DrawerListener;", "drawerLayout", "Landroidx/drawerlayout/widget/DrawerLayout;", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "<init>", "(Landroidx/drawerlayout/widget/DrawerLayout;Lcom/facebook/react/uimanager/events/EventDispatcher;)V", "onDrawerSlide", "", "view", "Landroid/view/View;", "v", "", "onDrawerOpened", "onDrawerClosed", "onDrawerStateChanged", "i", "", "ReactAndroid_release"})
    public static final class DrawerEventEmitter
    implements DrawerLayout.DrawerListener {
        @NotNull
        private final DrawerLayout drawerLayout;
        @NotNull
        private final EventDispatcher eventDispatcher;

        public DrawerEventEmitter(@NotNull DrawerLayout drawerLayout, @NotNull EventDispatcher eventDispatcher) {
            Intrinsics.checkNotNullParameter((Object)drawerLayout, (String)"drawerLayout");
            Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
            this.drawerLayout = drawerLayout;
            this.eventDispatcher = eventDispatcher;
        }

        public void onDrawerSlide(@NotNull View view, float v) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.eventDispatcher.dispatchEvent(new DrawerSlideEvent(UIManagerHelper.getSurfaceId((View)this.drawerLayout), this.drawerLayout.getId(), v));
        }

        public void onDrawerOpened(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.eventDispatcher.dispatchEvent(new DrawerOpenedEvent(UIManagerHelper.getSurfaceId((View)this.drawerLayout), this.drawerLayout.getId()));
        }

        public void onDrawerClosed(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.eventDispatcher.dispatchEvent(new DrawerClosedEvent(UIManagerHelper.getSurfaceId((View)this.drawerLayout), this.drawerLayout.getId()));
        }

        public void onDrawerStateChanged(int i) {
            this.eventDispatcher.dispatchEvent(new DrawerStateChangedEvent(UIManagerHelper.getSurfaceId((View)this.drawerLayout), this.drawerLayout.getId(), i));
        }
    }
}

