/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.RetryableMountingLayerException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.MaintainVisibleScrollPositionHelper;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AndroidHorizontalScrollView")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 V2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001VB\u0015\b\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0017H\u0007J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001bH\u0007J\u001a\u0010 \u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\tH\u0007J\u001a\u0010\"\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0017H\u0007J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0017H\u0007J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0017H\u0007J\u0018\u0010+\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0017H\u0007J\u001a\u0010-\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010.\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010/\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0017H\u0007J\u001a\u00101\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0017J\u001a\u00102\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\"\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010$H\u0017J\"\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\t2\b\u00107\u001a\u0004\u0018\u00010$H\u0016J\u0010\u00108\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0002H\u0016J\u0018\u00109\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00022\u0006\u0010:\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010?\u001a\u000206H\u0007J\"\u0010@\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020\u001bH\u0007J\u001c\u0010C\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010D\u001a\u0004\u0018\u00010\tH\u0007J\"\u0010E\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010A\u001a\u0002062\u0006\u0010F\u001a\u00020\u001bH\u0007J'\u0010G\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010A\u001a\u0002062\b\u0010?\u001a\u0004\u0018\u000106H\u0007\u00a2\u0006\u0002\u0010HJ\u001a\u0010I\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010J\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010K\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010L\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u000206H\u0007J\u001a\u0010M\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010NH\u0007J\u001a\u0010O\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010NH\u0007J\u001a\u0010P\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010Q\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010R\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010S\u001a\u000206H\u0007J\u001a\u0010T\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010U\u001a\u00020\u0017H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/facebook/react/views/scroll/ReactHorizontalScrollViewManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/facebook/react/views/scroll/ReactHorizontalScrollView;", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollCommandHandler;", "fpsListener", "Lcom/facebook/react/views/scroll/FpsListener;", "<init>", "(Lcom/facebook/react/views/scroll/FpsListener;)V", "getName", "", "createViewInstance", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "updateState", "", "view", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "setScrollEnabled", "", "value", "", "setShowsHorizontalScrollIndicator", "setDecelerationRate", "decelerationRate", "", "setDisableIntervalMomentum", "disableIntervalMomentum", "setSnapToInterval", "snapToInterval", "setSnapToAlignment", "alignment", "setSnapToOffsets", "snapToOffsets", "Lcom/facebook/react/bridge/ReadableArray;", "setSnapToStart", "snapToStart", "setSnapToEnd", "snapToEnd", "setRemoveClippedSubviews", "removeClippedSubviews", "setSendMomentumEvents", "sendMomentumEvents", "setScrollPerfTag", "scrollPerfTag", "setPagingEnabled", "pagingEnabled", "setOverScrollMode", "setNestedScrollEnabled", "receiveCommand", "scrollView", "commandId", "", "args", "flashScrollIndicators", "scrollTo", "data", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToCommandData;", "scrollToEnd", "Lcom/facebook/react/views/scroll/ReactScrollViewCommandHelper$ScrollToEndCommandData;", "setBottomFillColor", "color", "setBorderRadius", "index", "borderRadius", "setBorderStyle", "borderStyle", "setBorderWidth", "width", "setBorderColor", "(Lcom/facebook/react/views/scroll/ReactHorizontalScrollView;ILjava/lang/Integer;)V", "setOverflow", "overflow", "setPersistentScrollbar", "setFadingEdgeLength", "setContentOffset", "Lcom/facebook/react/bridge/ReadableMap;", "setMaintainVisibleContentPosition", "setPointerEvents", "pointerEventsStr", "setScrollEventThrottle", "scrollEventThrottle", "setHorizontal", "horizontal", "Companion", "ReactAndroid_release"})
public class ReactHorizontalScrollViewManager
extends ViewGroupManager<ReactHorizontalScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactHorizontalScrollView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FpsListener fpsListener;
    @NotNull
    public static final String REACT_CLASS = "AndroidHorizontalScrollView";

    @JvmOverloads
    public ReactHorizontalScrollViewManager(@Nullable FpsListener fpsListener) {
        super(null, 1, null);
        this.fpsListener = fpsListener;
    }

    public /* synthetic */ ReactHorizontalScrollViewManager(FpsListener fpsListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fpsListener = null;
        }
        this(fpsListener);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @NotNull
    public ReactHorizontalScrollView createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new ReactHorizontalScrollView((Context)context, this.fpsListener);
    }

    @Override
    @Nullable
    public Object updateState(@NotNull ReactHorizontalScrollView view, @NotNull ReactStylesDiffMap props, @NotNull StateWrapper stateWrapper) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)stateWrapper, (String)"stateWrapper");
        view.setStateWrapper(stateWrapper);
        return null;
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=true)
    public final void setScrollEnabled(@NotNull ReactHorizontalScrollView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollEnabled(value);
    }

    @ReactProp(name="showsHorizontalScrollIndicator", defaultBoolean=true)
    public final void setShowsHorizontalScrollIndicator(@NotNull ReactHorizontalScrollView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setHorizontalScrollBarEnabled(value);
    }

    @ReactProp(name="decelerationRate")
    public final void setDecelerationRate(@NotNull ReactHorizontalScrollView view, float decelerationRate) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setDecelerationRate(decelerationRate);
    }

    @ReactProp(name="disableIntervalMomentum")
    public final void setDisableIntervalMomentum(@NotNull ReactHorizontalScrollView view, boolean disableIntervalMomentum) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setDisableIntervalMomentum(disableIntervalMomentum);
    }

    @ReactProp(name="snapToInterval")
    public final void setSnapToInterval(@NotNull ReactHorizontalScrollView view, float snapToInterval) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float density = PixelUtil.getDisplayMetricDensity();
        view.setSnapInterval((int)(snapToInterval * density));
    }

    @ReactProp(name="snapToAlignment")
    public final void setSnapToAlignment(@NotNull ReactHorizontalScrollView view, @Nullable String alignment) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSnapToAlignment(ReactScrollViewHelper.parseSnapToAlignment(alignment));
    }

    @ReactProp(name="snapToOffsets")
    public final void setSnapToOffsets(@NotNull ReactHorizontalScrollView view, @Nullable ReadableArray snapToOffsets) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (snapToOffsets == null || snapToOffsets.size() == 0) {
            view.setSnapOffsets(null);
            return;
        }
        float density = PixelUtil.getDisplayMetricDensity();
        List offsets = new ArrayList();
        int n = snapToOffsets.size();
        for (int i = 0; i < n; ++i) {
            offsets.add((int)(snapToOffsets.getDouble(i) * (double)density));
        }
        view.setSnapOffsets(offsets);
    }

    @ReactProp(name="snapToStart")
    public final void setSnapToStart(@NotNull ReactHorizontalScrollView view, boolean snapToStart) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSnapToStart(snapToStart);
    }

    @ReactProp(name="snapToEnd")
    public final void setSnapToEnd(@NotNull ReactHorizontalScrollView view, boolean snapToEnd) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSnapToEnd(snapToEnd);
    }

    @ReactProp(name="removeClippedSubviews")
    public final void setRemoveClippedSubviews(@NotNull ReactHorizontalScrollView view, boolean removeClippedSubviews) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="sendMomentumEvents")
    public final void setSendMomentumEvents(@NotNull ReactHorizontalScrollView view, boolean sendMomentumEvents) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setSendMomentumEvents(sendMomentumEvents);
    }

    @ReactProp(name="scrollPerfTag")
    public final void setScrollPerfTag(@NotNull ReactHorizontalScrollView view, @Nullable String scrollPerfTag) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollPerfTag(scrollPerfTag);
    }

    @ReactProp(name="pagingEnabled")
    public final void setPagingEnabled(@NotNull ReactHorizontalScrollView view, boolean pagingEnabled) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPagingEnabled(pagingEnabled);
    }

    @ReactProp(name="overScrollMode")
    public void setOverScrollMode(@NotNull ReactHorizontalScrollView view, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOverScrollMode(ReactScrollViewHelper.parseOverScrollMode(value));
    }

    @ReactProp(name="nestedScrollEnabled")
    public final void setNestedScrollEnabled(@Nullable ReactHorizontalScrollView view, boolean value) {
        if (view != null) {
            ViewCompat.setNestedScrollingEnabled((View)((View)view), (boolean)value);
        }
    }

    @Override
    @Deprecated(message="Use different receiveCommand overloads")
    public void receiveCommand(@NotNull ReactHorizontalScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        ReactScrollViewCommandHelper.Companion.receiveCommand((ReactScrollViewCommandHelper.ScrollCommandHandler)this, scrollView, commandId, args);
    }

    @Override
    public void receiveCommand(@NotNull ReactHorizontalScrollView scrollView, @NotNull String commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        ReactScrollViewCommandHelper.Companion.receiveCommand((ReactScrollViewCommandHelper.ScrollCommandHandler)this, scrollView, commandId, args);
    }

    @Override
    public void flashScrollIndicators(@NotNull ReactHorizontalScrollView scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        scrollView.flashScrollIndicators();
    }

    @Override
    public void scrollTo(@NotNull ReactHorizontalScrollView scrollView, @NotNull ReactScrollViewCommandHelper.ScrollToCommandData data) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(data.mDestX, data.mDestY);
        } else {
            scrollView.scrollTo(data.mDestX, data.mDestY);
        }
    }

    @Override
    public void scrollToEnd(@NotNull ReactHorizontalScrollView scrollView, @NotNull ReactScrollViewCommandHelper.ScrollToEndCommandData data) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        View view = scrollView.getChildAt(0);
        if (view == null) {
            throw new RetryableMountingLayerException("scrollToEnd called on HorizontalScrollView without child");
        }
        View child = view;
        int right = child.getWidth() + scrollView.getPaddingRight();
        scrollView.abortAnimation();
        if (data.mAnimated) {
            scrollView.reactSmoothScrollTo(right, scrollView.getScrollY());
        } else {
            scrollView.scrollTo(right, scrollView.getScrollY());
        }
    }

    @ReactProp(name="endFillColor", customType="Color", defaultInt=0)
    public final void setBottomFillColor(@NotNull ReactHorizontalScrollView view, int color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setEndFillColor(color);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public final void setBorderRadius(@Nullable ReactHorizontalScrollView view, int index, float borderRadius) {
        if (view != null) {
            LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
            BackgroundStyleApplicator.setBorderRadius((View)view, (BorderRadiusProp)((Object)BorderRadiusProp.getEntries().get(index)), radius);
        }
    }

    @ReactProp(name="borderStyle")
    public final void setBorderStyle(@Nullable ReactHorizontalScrollView view, @Nullable String borderStyle) {
        if (view != null) {
            String string2 = borderStyle;
            BorderStyle parsedBorderStyle = string2 == null ? null : BorderStyle.Companion.fromString(string2);
            BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
        }
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public final void setBorderWidth(@Nullable ReactHorizontalScrollView view, int index, float width) {
        if (view != null) {
            BackgroundStyleApplicator.setBorderWidth((View)view, (LogicalEdge)((Object)LogicalEdge.getEntries().get(index)), Float.valueOf(width));
        }
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public final void setBorderColor(@NotNull ReactHorizontalScrollView view, int index, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.ALL, color);
    }

    @ReactProp(name="overflow")
    public final void setOverflow(@NotNull ReactHorizontalScrollView view, @Nullable String overflow) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOverflow(overflow);
    }

    @ReactProp(name="persistentScrollbar")
    public final void setPersistentScrollbar(@NotNull ReactHorizontalScrollView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollbarFadingEnabled(!value);
    }

    @ReactProp(name="fadingEdgeLength")
    public final void setFadingEdgeLength(@NotNull ReactHorizontalScrollView view, int value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (value > 0) {
            view.setHorizontalFadingEdgeEnabled(true);
            view.setFadingEdgeLength(value);
        } else {
            view.setHorizontalFadingEdgeEnabled(false);
            view.setFadingEdgeLength(0);
        }
    }

    @ReactProp(name="contentOffset")
    public final void setContentOffset(@NotNull ReactHorizontalScrollView view, @Nullable ReadableMap value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (value != null) {
            double x = value.hasKey("x") ? value.getDouble("x") : 0.0;
            double y = value.hasKey("y") ? value.getDouble("y") : 0.0;
            view.scrollTo((int)PixelUtil.toPixelFromDIP(x), (int)PixelUtil.toPixelFromDIP(y));
        } else {
            view.scrollTo(0, 0);
        }
    }

    @ReactProp(name="maintainVisibleContentPosition")
    public final void setMaintainVisibleContentPosition(@NotNull ReactHorizontalScrollView view, @Nullable ReadableMap value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (value != null) {
            view.setMaintainVisibleContentPosition(MaintainVisibleScrollPositionHelper.Config.Companion.fromReadableMap(value));
        } else {
            view.setMaintainVisibleContentPosition(null);
        }
    }

    @ReactProp(name="pointerEvents")
    public final void setPointerEvents(@NotNull ReactHorizontalScrollView view, @Nullable String pointerEventsStr) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPointerEvents(PointerEvents.Companion.parsePointerEvents(pointerEventsStr));
    }

    @ReactProp(name="scrollEventThrottle")
    public final void setScrollEventThrottle(@NotNull ReactHorizontalScrollView view, int scrollEventThrottle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setScrollEventThrottle(scrollEventThrottle);
    }

    @ReactProp(name="horizontal")
    public final void setHorizontal(@Nullable ReactHorizontalScrollView view, boolean horizontal) {
    }

    @JvmOverloads
    public ReactHorizontalScrollViewManager() {
        this((FpsListener)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/scroll/ReactHorizontalScrollViewManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

