/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/views/text/FontMetricsUtil;", "", "<init>", "()V", "CAP_HEIGHT_MEASUREMENT_TEXT", "", "X_HEIGHT_MEASUREMENT_TEXT", "AMPLIFICATION_FACTOR", "", "getFontMetrics", "Lcom/facebook/react/bridge/WritableArray;", "text", "", "layout", "Landroid/text/Layout;", "paint", "Landroid/text/TextPaint;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nFontMetricsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontMetricsUtil.kt\ncom/facebook/react/views/text/FontMetricsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class FontMetricsUtil {
    @NotNull
    public static final FontMetricsUtil INSTANCE = new FontMetricsUtil();
    @NotNull
    private static final String CAP_HEIGHT_MEASUREMENT_TEXT = "T";
    @NotNull
    private static final String X_HEIGHT_MEASUREMENT_TEXT = "x";
    private static final float AMPLIFICATION_FACTOR = 100.0f;

    private FontMetricsUtil() {
    }

    @JvmStatic
    @NotNull
    public static final WritableArray getFontMetrics(@NotNull CharSequence text, @NotNull Layout layout2, @NotNull TextPaint paint, @NotNull Context context) {
        TextPaint textPaint;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        WritableArray writableArray = Arguments.createArray();
        Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
        WritableArray lines = writableArray;
        TextPaint $this$getFontMetrics_u24lambda_u240 = textPaint = new TextPaint((Paint)paint);
        boolean bl = false;
        $this$getFontMetrics_u24lambda_u240.setTextSize($this$getFontMetrics_u24lambda_u240.getTextSize() * 100.0f);
        TextPaint paintCopy = textPaint;
        Rect capHeightBounds = new Rect();
        paintCopy.getTextBounds(CAP_HEIGHT_MEASUREMENT_TEXT, 0, 1, capHeightBounds);
        float capHeight = (float)capHeightBounds.height() / 100.0f / dm.density;
        Rect xHeightBounds = new Rect();
        paintCopy.getTextBounds(X_HEIGHT_MEASUREMENT_TEXT, 0, 1, xHeightBounds);
        float xHeight = (float)xHeightBounds.height() / 100.0f / dm.density;
        int n = layout2.getLineCount();
        for (int i = 0; i < n; ++i) {
            WritableMap line;
            WritableMap writableMap;
            boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(i) - 1) == '\n';
            float lineWidth = endsWithNewLine ? layout2.getLineMax(i) : layout2.getLineWidth(i);
            Rect bounds = new Rect();
            layout2.getLineBounds(i, bounds);
            WritableMap $this$getFontMetrics_u24lambda_u241 = writableMap = Arguments.createMap();
            boolean bl2 = false;
            $this$getFontMetrics_u24lambda_u241.putDouble(X_HEIGHT_MEASUREMENT_TEXT, layout2.getLineLeft(i) / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("y", (float)bounds.top / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("width", lineWidth / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("height", (float)bounds.height() / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("descender", (float)layout2.getLineDescent(i) / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("ascender", (float)(-layout2.getLineAscent(i)) / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("baseline", (float)layout2.getLineBaseline(i) / dm.density);
            $this$getFontMetrics_u24lambda_u241.putDouble("capHeight", capHeight);
            $this$getFontMetrics_u24lambda_u241.putDouble("xHeight", xHeight);
            $this$getFontMetrics_u24lambda_u241.putString("text", ((Object)text.subSequence(layout2.getLineStart(i), layout2.getLineEnd(i))).toString());
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"apply(...)");
            lines.pushMap(line);
        }
        return lines;
    }
}

