/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 H2\u00020\u0001:\u0003FGHB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020$J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0014J0\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019H\u0014J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020$H\u0002J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0016J\u001a\u00106\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019H\u0002J\u0018\u00109\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u0019H\u0002J\u0010\u0010:\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0016J\"\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020\u00192\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020+2\u0006\u00104\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u00020\u00192\u0006\u00104\u001a\u00020AH\u0016J\u0018\u0010D\u001a\u00020+2\u0006\u0010C\u001a\u00020\u00192\u0006\u00104\u001a\u00020AH\u0016J\b\u0010E\u001a\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006I"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "clickableSpans", "", "Landroid/text/style/ClickableSpan;", "selection", "Lcom/facebook/react/views/text/PreparedLayoutTextView$TextSelection;", "value", "Landroid/text/Layout;", "layout", "getLayout", "()Landroid/text/Layout;", "setLayout", "(Landroid/text/Layout;)V", "Lcom/facebook/react/uimanager/style/Overflow;", "overflow", "getOverflow", "()Lcom/facebook/react/uimanager/style/Overflow;", "setOverflow", "(Lcom/facebook/react/uimanager/style/Overflow;)V", "selectionColor", "", "getSelectionColor", "()Ljava/lang/Integer;", "setSelectionColor", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "text", "", "getText", "()Ljava/lang/CharSequence;", "initView", "", "recycleView", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "l", "t", "r", "b", "setSelection", "span", "clearSelection", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "getClickableSpanInCoords", "x", "y", "getTextOffsetAt", "dispatchHoverEvent", "onFocusChanged", "gainFocus", "direction", "previouslyFocusedRect", "Landroid/graphics/Rect;", "dispatchKeyEvent", "Landroid/view/KeyEvent;", "onKeyUp", "keyCode", "onKeyDown", "selectedSpanIndex", "Api34Utils", "TextSelection", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nPreparedLayoutTextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreparedLayoutTextView.kt\ncom/facebook/react/views/text/PreparedLayoutTextView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n1#2:420\n*E\n"})
public final class PreparedLayoutTextView
extends ViewGroup {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends ClickableSpan> clickableSpans;
    @Nullable
    private TextSelection selection;
    @Nullable
    private Layout layout;
    @NotNull
    private Overflow overflow;
    @ColorInt
    @Nullable
    private Integer selectionColor;
    @NotNull
    private static final Paint selectionPaint = new Paint();

    public PreparedLayoutTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.clickableSpans = CollectionsKt.emptyList();
        this.overflow = Overflow.HIDDEN;
        this.initView();
        this.setWillNotDraw(false);
    }

    @Nullable
    public final Layout getLayout() {
        return this.layout;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void setLayout(@Nullable Layout value) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (Intrinsics.areEqual((Object)this.layout, (Object)value)) break block5;
                        lastSelection = this.selection;
                        if (lastSelection == null) break block6;
                        if (value == null) ** GOTO lbl-1000
                        v0 = this.layout;
                        if (Intrinsics.areEqual((Object)String.valueOf(v0 != null ? v0.getText() : null), (Object)value.getText().toString())) {
                            value.getSelectionPath(lastSelection.getStart(), lastSelection.getEnd(), lastSelection.getPath());
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.clearSelection();
                        }
                    }
                    v1 = this;
                    v2 /* !! */  = value;
                    if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getText()) == null) break block7;
                    var3_3 /* !! */  = v2 /* !! */ ;
                    var5_4 = v1;
                    $i$a$-let-PreparedLayoutTextView$layout$1 = false;
                    v3 = com.facebook.react.views.text.PreparedLayoutTextView$Companion.access$filterClickableSpans(PreparedLayoutTextView.Companion, (CharSequence)it);
                    v1 = var5_4;
                    v2 /* !! */  = v3;
                    if (v3 != null) break block8;
                }
                v2 /* !! */  = CollectionsKt.emptyList();
            }
            v1.clickableSpans = v2 /* !! */ ;
            this.setFocusable(((Collection)this.clickableSpans).isEmpty() == false);
            this.layout = value;
            this.invalidate();
        }
    }

    @NotNull
    public final Overflow getOverflow() {
        return this.overflow;
    }

    public final void setOverflow(@NotNull Overflow value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.overflow != value) {
            this.overflow = value;
            this.invalidate();
        }
    }

    @Nullable
    public final Integer getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(@Nullable Integer n) {
        this.selectionColor = n;
    }

    @Nullable
    public final CharSequence getText() {
        Layout layout2 = this.layout;
        return layout2 != null ? layout2.getText() : null;
    }

    private final void initView() {
        this.clickableSpans = CollectionsKt.emptyList();
        this.selection = null;
        this.setLayout(null);
    }

    public final void recycleView() {
        this.initView();
        BackgroundStyleApplicator.reset((View)this);
        this.setFocusable(false);
        this.setOverflow(Overflow.HIDDEN);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.overflow != Overflow.VISIBLE) {
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
        }
        super.onDraw(canvas);
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        Layout textLayout = this.layout;
        if (textLayout != null) {
            if (this.selection != null) {
                int n;
                Integer n2 = this.selectionColor;
                if (n2 != null) {
                    n = n2;
                } else {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    n = DefaultStyleValuesUtil.getDefaultTextColorHighlight(context);
                }
                selectionPaint.setColor(n);
            }
            if (Build.VERSION.SDK_INT >= 34) {
                TextSelection textSelection = this.selection;
                Api34Utils.INSTANCE.draw(textLayout, canvas, (Path)(textSelection != null ? textSelection.getPath() : null), selectionPaint);
            } else {
                TextSelection textSelection = this.selection;
                textLayout.draw(canvas, (Path)(textSelection != null ? textSelection.getPath() : null), selectionPaint, 0);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    private final void setSelection(ClickableSpan span) {
        Layout layout2 = this.layout;
        if (layout2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Layout textLayout = layout2;
        CharSequence charSequence = textLayout.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        int start = ((Spanned)charSequence).getSpanStart((Object)span);
        CharSequence charSequence2 = textLayout.getText();
        Intrinsics.checkNotNull((Object)charSequence2, (String)"null cannot be cast to non-null type android.text.Spanned");
        int end = ((Spanned)charSequence2).getSpanEnd((Object)span);
        TextSelection textSelection = this.selection;
        if (textSelection == null) {
            Path selectionPath = new Path();
            textLayout.getSelectionPath(start, end, selectionPath);
            this.selection = new TextSelection(start, end, selectionPath);
        } else {
            textSelection.setStart(start);
            textSelection.setEnd(end);
            textLayout.getSelectionPath(start, end, textSelection.getPath());
        }
        this.invalidate();
    }

    private final void clearSelection() {
        this.selection = null;
        this.invalidate();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        int y;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled() || this.clickableSpans.isEmpty()) {
            return super.onTouchEvent(event);
        }
        int action = event.getActionMasked();
        if (action == 3) {
            this.clearSelection();
            return false;
        }
        int x = (int)event.getX();
        ClickableSpan clickedSpan = this.getClickableSpanInCoords(x, y = (int)event.getY());
        if (clickedSpan == null) {
            this.clearSelection();
            return super.onTouchEvent(event);
        }
        switch (action) {
            case 1: {
                this.clearSelection();
                clickedSpan.onClick((View)this);
                break;
            }
            case 0: {
                this.setSelection(clickedSpan);
            }
        }
        return true;
    }

    private final ClickableSpan getClickableSpanInCoords(int x, int y) {
        int offset = this.getTextOffsetAt(x, y);
        if (offset < 0) {
            return null;
        }
        CharSequence charSequence = this.getText();
        Spanned spanned = charSequence instanceof Spanned ? (Spanned)charSequence : null;
        if (spanned == null) {
            return null;
        }
        Spanned spanned2 = spanned;
        ClickableSpan[] clickableSpans = (ClickableSpan[])spanned2.getSpans(offset, offset, ClickableSpan.class);
        Intrinsics.checkNotNull((Object)clickableSpans);
        if (!(clickableSpans.length == 0)) {
            return clickableSpans[0];
        }
        return null;
    }

    private final int getTextOffsetAt(int x, int y) {
        int n;
        Layout layout2 = this.layout;
        if (layout2 == null) {
            return -1;
        }
        Layout textLayout = layout2;
        int line = textLayout.getLineForVertical(y);
        float left = 0.0f;
        float right = 0.0f;
        if (textLayout.getAlignment() == Layout.Alignment.ALIGN_CENTER) {
            left = textLayout.getLineLeft(line);
            right = textLayout.getLineRight(line);
        } else {
            boolean rtl = textLayout.getParagraphDirection(line) == -1;
            left = rtl ? (float)textLayout.getWidth() - textLayout.getLineMax(line) : (float)textLayout.getParagraphLeft(line);
            float f = right = rtl ? (float)textLayout.getParagraphRight(line) : textLayout.getLineMax(line);
        }
        if ((float)x < left || (float)x > right) {
            return -1;
        }
        try {
            n = textLayout.getOffsetForHorizontal(line, (float)x);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            n = -1;
        }
        return n;
    }

    public boolean dispatchHoverEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return super.dispatchHoverEvent(event);
    }

    public void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        if (!((Collection)this.clickableSpans).isEmpty() && !gainFocus) {
            this.clearSelection();
        }
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return super.dispatchKeyEvent(event);
    }

    public boolean onKeyUp(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled() && !((Collection)this.clickableSpans).isEmpty() && this.selection == null && (PreparedLayoutTextView.Companion.isDirectionKey(keyCode) || keyCode == 61)) {
            ClickableSpan targetSpan = null;
            if (PreparedLayoutTextView.Companion.isDirectionKey(keyCode) && event.hasNoModifiers()) {
                switch (keyCode) {
                    case 20: 
                    case 22: {
                        targetSpan = this.clickableSpans.get(0);
                        break;
                    }
                    case 19: 
                    case 21: {
                        targetSpan = this.clickableSpans.get(this.clickableSpans.size() - 1);
                    }
                }
            }
            if (keyCode == 61) {
                if (event.hasNoModifiers()) {
                    targetSpan = this.clickableSpans.get(0);
                } else if (event.hasModifiers(1)) {
                    targetSpan = this.clickableSpans.get(this.clickableSpans.size() - 1);
                }
            }
            if (targetSpan != null) {
                this.setSelection(targetSpan);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled() && !((Collection)this.clickableSpans).isEmpty() && (PreparedLayoutTextView.Companion.isDirectionKey(keyCode) || PreparedLayoutTextView.Companion.isConfirmKey(keyCode)) && event.hasNoModifiers()) {
            int selectedSpanIndex = this.selectedSpanIndex();
            if (selectedSpanIndex == -1) {
                return super.onKeyDown(keyCode, event);
            }
            if (PreparedLayoutTextView.Companion.isDirectionKey(keyCode)) {
                int direction = switch (keyCode) {
                    case 20, 22 -> 1;
                    default -> -1;
                };
                int repeatCount = 1 + event.getRepeatCount();
                int targetIndex = selectedSpanIndex + direction * repeatCount;
                if (targetIndex >= 0 && targetIndex < this.clickableSpans.size()) {
                    this.setSelection(this.clickableSpans.get(targetIndex));
                    return true;
                }
            }
            if (PreparedLayoutTextView.Companion.isConfirmKey(keyCode) && event.getRepeatCount() == 0) {
                this.clearSelection();
                this.clickableSpans.get(selectedSpanIndex).onClick((View)this);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private final int selectedSpanIndex() {
        CharSequence charSequence = this.getText();
        Spanned spanned = charSequence instanceof Spanned ? (Spanned)charSequence : null;
        if (spanned == null) {
            return -1;
        }
        Spanned spanned2 = spanned;
        TextSelection textSelection = this.selection;
        if (textSelection == null) {
            return -1;
        }
        TextSelection textSelection2 = textSelection;
        if (this.clickableSpans.isEmpty()) {
            return -1;
        }
        int n = ((Collection)this.clickableSpans).size();
        for (int i = 0; i < n; ++i) {
            ClickableSpan span = this.clickableSpans.get(i);
            int spanStart = spanned2.getSpanStart((Object)span);
            int spanEnd = spanned2.getSpanEnd((Object)span);
            if (spanStart != textSelection2.getStart() || spanEnd != textSelection2.getEnd()) continue;
            return i;
        }
        return -1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c3\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView$Api34Utils;", "", "<init>", "()V", "highlightPaths", "", "Landroid/graphics/Path;", "highlightPaints", "Landroid/graphics/Paint;", "draw", "", "layout", "Landroid/text/Layout;", "canvas", "Landroid/graphics/Canvas;", "selectionPath", "selectionPaint", "ReactAndroid_release"})
    @RequiresApi(api=34)
    private static final class Api34Utils {
        @NotNull
        public static final Api34Utils INSTANCE = new Api34Utils();
        @Nullable
        private static List<? extends Path> highlightPaths;
        @Nullable
        private static List<? extends Paint> highlightPaints;

        private Api34Utils() {
        }

        @DoNotInline
        public final void draw(@NotNull Layout layout2, @NotNull Canvas canvas, @Nullable Path selectionPath, @Nullable Paint selectionPaint) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (selectionPath != null) {
                if (highlightPaths == null) {
                    highlightPaths = new ArrayList();
                }
                if (highlightPaints == null) {
                    highlightPaints = new ArrayList();
                }
            }
            layout2.draw(canvas, highlightPaths, highlightPaints, selectionPath, selectionPaint, 0);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView$Companion;", "", "<init>", "()V", "selectionPaint", "Landroid/graphics/Paint;", "isDirectionKey", "", "keyCode", "", "isConfirmKey", "filterClickableSpans", "", "Landroid/text/style/ClickableSpan;", "text", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isDirectionKey(int keyCode) {
            return keyCode == 21 || keyCode == 22 || keyCode == 19 || keyCode == 20;
        }

        private final boolean isConfirmKey(int keyCode) {
            return keyCode == 23 || keyCode == 66 || keyCode == 62 || keyCode == 160;
        }

        private final List<ClickableSpan> filterClickableSpans(CharSequence text) {
            if (!(text instanceof Spanned) || ((Spanned)text).nextSpanTransition(0, text.length(), ClickableSpan.class) == text.length()) {
                return CollectionsKt.emptyList();
            }
            ArrayList spans = new ArrayList();
            int i = 0;
            while (i < text.length()) {
                int next2 = ((Spanned)text).nextSpanTransition(i, text.length(), ClickableSpan.class);
                Collection collection = spans;
                Object[] objectArray = ((Spanned)text).getSpans(i, next2, ClickableSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(...)");
                CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
                i = next2;
            }
            return spans;
        }

        public static final /* synthetic */ List access$filterClickableSpans(Companion $this, CharSequence text) {
            return $this.filterClickableSpans(text);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView$TextSelection;", "", "start", "", "end", "path", "Landroid/graphics/Path;", "<init>", "(IILandroid/graphics/Path;)V", "getStart", "()I", "setStart", "(I)V", "getEnd", "setEnd", "getPath", "()Landroid/graphics/Path;", "setPath", "(Landroid/graphics/Path;)V", "ReactAndroid_release"})
    private static final class TextSelection {
        private int start;
        private int end;
        @NotNull
        private Path path;

        public TextSelection(int start, int end, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.start = start;
            this.end = end;
            this.path = path;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final void setPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
            this.path = path;
        }
    }
}

